/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.EmulatorTestsHelper;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.ASCIITableConverter;
import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.BluetoothDiscovery;
import com.mathworks.toolbox.instrument.BluetoothEmulatorRunnable;
import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.InstrumentAsyncContinuous;
import com.mathworks.toolbox.instrument.LineInputStream;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.events.ICEvent;
import com.mathworks.toolbox.instrument.util.DefaultICProp;
import com.mathworks.toolbox.instrument.util.Displays;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public final class Bluetooth
extends InstrumentAsyncContinuous
implements ActionListener {
    protected static final ResourceBundle sResources = ResourceBundle.getBundle("com.mathworks.toolbox.instrument.browser.resources.RES_BROWSER");
    public static final int SPP = 0;
    protected static final String[] PROFILE = new String[]{"SPP"};
    private static final String[] ERROR_MSG = new String[]{sResources.getString("Bluetooth.WRITE_ERROR"), sResources.getString("Bluetooth.WRITE_CTRLC"), sResources.getString("Bluetooth.WRITE_TIMEOUT"), sResources.getString("Bluetooth.WRITE_CTRLC_TIMEOUT"), sResources.getString("Bluetooth.READ_TIMEOUT"), sResources.getString("Bluetooth.WRITE_ASYNC")};
    protected MLArrayRef breakInterruptFcn = ACTION;
    private LineInputStream lineInputStream;
    private InputStream inputStream;
    private DataInputStream dataInputStream;
    private OutputStream outputStream;
    private DataOutputStream dataOutputStream;
    private StreamConnection blueComm;
    private static final String EMU_NAME = "Emulator";
    private static final String EMU_ID = "00000000000";
    private static boolean emulatorInitialized = false;
    private static boolean emulationInUse = false;
    private static InputStream emulationInputStream;
    private static OutputStream emulationOutputStream;
    private static StreamConnection blueCommEmulator;
    private static BluetoothEmulatorRunnable echoThread;
    private String[] info = new String[1];
    private String constructorArgs = "";
    protected int Channel = 0;
    public String RemoteID = "";
    public String RemoteName = "";
    private int Profile = 0;
    private String lockedStack = "";
    protected static final Object[] TermVals;
    private static final Object[] AsciiVals;
    protected static final Object[] dChannels;
    protected static final String[] AsyncVals;
    protected static final String[] dModeVals;
    protected static final String[] ProfileVals;
    static ICProp[] objectICProps;

    public void startEmulator() {
        try {
            EmulatorTestsHelper.startInProcessServer();
            EmulatorTestsHelper.useThreadLocalEmulator();
            echoThread = new BluetoothEmulatorRunnable();
            EmulatorTestsHelper.runNewEmulatorStack((Runnable)echoThread);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopEmulator() {
        Bluetooth.echoThread.url = null;
        EmulatorTestsHelper.stopInProcessServer();
    }

    public boolean isEmulation() {
        return this.getName().equalsIgnoreCase(EMU_NAME) || this.getRemoteID().equalsIgnoreCase(EMU_ID);
    }

    void setNameAndID(String string) throws TMException {
        if (string.equalsIgnoreCase(EMU_ID) || string.equalsIgnoreCase(EMU_NAME)) {
            if (this.lockedStack.equals("Native")) {
                Instrument.displayError(sResources.getString("Bluetooth.STACK_ERROR"));
            }
            this.RemoteID = EMU_ID;
            this.RemoteName = EMU_NAME;
            this.lockedStack = EMU_NAME;
        } else {
            boolean bl;
            if (this.lockedStack.equals(EMU_NAME)) {
                Instrument.displayError(sResources.getString("Bluetooth.STACK_ERROR"));
            }
            if (bl = string.contains("btspp://")) {
                try {
                    Long.parseLong(string.substring(8), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    Instrument.displayError(sResources.getString("Bluetooth.InvalidRemoteID"));
                }
                this.RemoteID = string.substring(8);
            } else {
                this.RemoteName = string;
            }
            Vector<RemoteDevice> vector = BluetoothDiscovery.getRemoteDevices(false);
            for (int i = 0; i < vector.size(); ++i) {
                RemoteDevice remoteDevice = vector.elementAt(i);
                if (bl && this.RemoteID.equalsIgnoreCase(remoteDevice.getBluetoothAddress())) {
                    try {
                        this.RemoteName = remoteDevice.getFriendlyName(false);
                    }
                    catch (IOException iOException) {
                        this.RemoteName = "";
                    }
                    this.lockedStack = "Native";
                    return;
                }
                try {
                    if (!this.RemoteName.equalsIgnoreCase(remoteDevice.getFriendlyName(false))) continue;
                    this.RemoteID = remoteDevice.getBluetoothAddress();
                    this.lockedStack = "Native";
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public Bluetooth(String string, int n) throws TMException {
        Object[] objectArray;
        if (PlatformInfo.isLinux()) {
            Bluetooth.displayError(sInstrumentResources.getString("Instrument.noBluetoothSupportInLinux"));
        }
        this.constructorArgs = string + ":" + n;
        this.type = "bluetooth";
        this.name = "Bluetooth-" + this.constructorArgs;
        this.displayName = "Bluetooth connection";
        this.objectProps = DefaultICProp.addObjectProps(objectICProps);
        this.Channel = n;
        if (!string.equalsIgnoreCase(EMU_NAME) && !string.contains(EMU_ID)) {
            if (this.lockedStack.equals("Native")) {
                Instrument.displayError(sResources.getString("Bluetooth.STACK_ERROR"));
            }
            try {
                objectArray = new BluetoothDiscovery();
            }
            catch (BluetoothStateException bluetoothStateException) {
                Instrument.displayError(sResources.getString("Bluetooth.BluetoothAdaptorError"));
            }
            try {
                BlueCoveImpl.useThreadLocalBluetoothStack();
            }
            catch (Exception exception) {
                Instrument.displayError(sResources.getString("Bluetooth.STACK_ERROR"));
            }
        }
        this.setNameAndID(string);
        try {
            this.objectProps = DefaultICProp.addObjectProps(objectICProps);
        }
        catch (Exception exception) {
            this.deleteInstrumentObject(this);
            throw new TMException(exception.getMessage());
        }
        try {
            objectArray = new Object[]{new Integer(45), "LF"};
            this.terminatorObject = (MLArrayRef)MatlabMCR.mtFeval((String)"system_dependent", (Object[])objectArray, (int)1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.postPropertyChangedEvent("Channel", this.Channel);
        this.postPropertyChangedEvent("RemoteName", this.RemoteName);
        this.postPropertyChangedEvent("RemoteID", this.RemoteID);
    }

    public Bluetooth() {
        this.deleteInstrumentObject(this);
    }

    public String getInspectorToolbarObjectName() {
        return "bluetooth";
    }

    public void setBreakInterruptFcn(MLArrayRef mLArrayRef) throws TMException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("BreakInterruptFcn", 0, mLArrayRef);
        if (this.breakInterruptFcn != ACTION) {
            this.breakInterruptFcn.dispose();
        }
        this.breakInterruptFcn = mLArrayRef2;
        this.disabledCallbacks[0] = 0;
        this.postPropertyChangedEvent("BreakInterruptFcn", this.breakInterruptFcn);
    }

    public MLArrayRef getBreakInterruptFcn() {
        return this.breakInterruptFcn;
    }

    @Override
    protected void setHardwareTimeout(double d) {
        this.timeout = d;
    }

    @Override
    protected double getHardwareTimeout() {
        return this.timeout;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        if (this.timerFcn != ACTION) {
            this.executeEvent(6, "Timer", this.eventTime, new ICEvent("Timer", Bluetooth.constructClockVector(this.eventTime)));
        }
    }

    @Override
    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "BlueCommTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    @Override
    protected int getBlockSizeForWrite() {
        return 340;
    }

    public int getChannel() {
        return this.Channel;
    }

    public void setChannel(int n) throws TMException {
        if (this.status == 1) {
            Bluetooth.displayError("Channel cannot be set while OBJ is open.");
        }
        this.Channel = n;
    }

    public String getRemoteID() {
        return this.RemoteID;
    }

    public void setRemoteID(String string) throws TMException {
        if (this.status == 1) {
            Bluetooth.displayError("RemoteID cannot be set while OBJ is open.");
        }
        this.RemoteID = string;
    }

    public String getRemoteName() {
        return this.RemoteName;
    }

    public void setRemoteName(String string) throws TMException {
        if (this.status == 1) {
            Bluetooth.displayError("RemoteName cannot be set while OBJ is open.");
        }
        this.RemoteName = string;
    }

    public void setProfile(int n) {
        this.Profile = n;
        this.postPropertyChangedEvent("Profile", PROFILE[this.Profile]);
    }

    public int getProfile() {
        return this.Profile;
    }

    @Override
    public Object[] getNonDefaultPVPairs() {
        Vector<Comparable<?>> vector = this.getPVPairs();
        this.addPVPair(vector, "Profile", PROFILE[this.Profile]);
        this.addPVPair(vector, "ReadAsyncMode", RA_MODES[this.readAsyncMode]);
        this.addPVPair(vector, "Channel", this.Channel);
        if (this.terminator != 10) {
            vector.addElement((Comparable<?>)((Object)"Terminator"));
            vector.addElement(new Integer(this.terminator));
        }
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = vector.elementAt(i);
        }
        return objectArray;
    }

    @Override
    public String[] getBrowserInfo() {
        String[] stringArray = new String[]{"Device:", this.constructorArgs};
        return stringArray;
    }

    @Override
    public String getBrowserString() {
        return this.constructorArgs;
    }

    @Override
    protected void updatePropsOnOpen() throws TMException {
        this.setHardwareTerminator(this.terminator);
        this.setHardwareTimeout(this.timeout);
        this.timeout = this.getHardwareTimeout();
    }

    private void initializeEmulation() throws TMException {
        if (emulationInUse) {
            Bluetooth.displayError("Cannot connect to the device. Possible reasons are another application is connected" + LINESEP + "or the device is not available.");
            return;
        }
        emulationInUse = true;
        if (!emulatorInitialized) {
            BlueCoveImpl.setConfigProperty((String)"bluecove.stack", (String)"emulator");
        }
        this.startEmulator();
        emulatorInitialized = true;
        DiscoveryAgent discoveryAgent = null;
        UUID uUID = new UUID(8456L);
        if (blueCommEmulator == null) {
            try {
                discoveryAgent = LocalDevice.getLocalDevice().getDiscoveryAgent();
                blueCommEmulator = (StreamConnection)Connector.open((String)discoveryAgent.selectService(uUID, 0, false));
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
            }
            catch (BluetoothStateException bluetoothStateException) {
                bluetoothStateException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            if (emulationInputStream == null) {
                emulationInputStream = blueCommEmulator.openInputStream();
            }
            if (emulationOutputStream == null) {
                emulationOutputStream = blueCommEmulator.openOutputStream();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.inputStream = emulationInputStream;
        this.outputStream = emulationOutputStream;
        this.lineInputStream = new LineInputStream(this.inputStream);
        this.dataInputStream = new DataInputStream(this.inputStream);
        this.dataOutputStream = new DataOutputStream(this.outputStream);
    }

    private void finalizeEmulation() {
        try {
            this.outputStream.flush();
            this.dataOutputStream.flush();
            this.inputStream.skip(this.inputStream.available());
            this.lineInputStream.skip(this.lineInputStream.available());
            this.dataInputStream.skip(this.dataInputStream.available());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        emulationInUse = false;
    }

    @Override
    public void openHardware() throws Exception {
        if (this.isEmulation()) {
            this.initializeEmulation();
            return;
        }
        try {
            this.blueComm = (StreamConnection)Connector.open((String)("btspp://" + this.RemoteID + ":" + this.Channel + ";authenticate=false;encrypt=false;master=false"));
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Bluetooth.displayError("Cannot connect to the device. Possible reasons are another application is connected" + LINESEP + "or the device is not available.");
        }
        catch (BluetoothStateException bluetoothStateException) {
            Bluetooth.displayError("Cannot connect to the device. Possible reasons are another application is connected" + LINESEP + "or the device is not available.");
        }
        catch (Exception exception) {
            Bluetooth.displayError("Cannot connect to the device. Possible reasons are another application is connected" + LINESEP + "or the device is not available.");
        }
        this.inputStream = this.blueComm.openInputStream();
        this.lineInputStream = new LineInputStream(this.inputStream);
        this.dataInputStream = new DataInputStream(this.inputStream);
        this.outputStream = this.blueComm.openOutputStream();
        this.dataOutputStream = new DataOutputStream(this.outputStream);
    }

    @Override
    public void closeHardware() throws Exception {
        if (emulationInUse) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Instrument.displayError(sResources.getString("Bluetooth.Close_ERROR"));
            }
        }
        Poller.removeInstrument(this);
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        if (this.isEmulation()) {
            this.finalizeEmulation();
            return;
        }
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
        if (this.dataOutputStream != null) {
            this.dataOutputStream.close();
            this.dataOutputStream = null;
        }
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        if (this.lineInputStream != null) {
            this.lineInputStream.close();
            this.lineInputStream = null;
        }
        if (this.dataInputStream != null) {
            this.dataInputStream.close();
            this.dataInputStream = null;
        }
        this.blueComm.close();
        this.blueComm = null;
    }

    @Override
    protected void disposeMLArrayRefs() {
        this.superDisposeMLArrayRef();
        if (this.terminatorObject != null) {
            this.terminatorObject.dispose();
        }
        if (this.timer != null) {
            this.timer.removeActionListener((ActionListener)this);
        }
        if (this.breakInterruptFcn != ACTION) {
            this.breakInterruptFcn.dispose();
        }
    }

    private void updateBlueToothListeners(boolean bl) {
    }

    private boolean checkForCtrlC() {
        if (ctrlc_flag) {
            ctrlc_flag = false;
            return true;
        }
        return false;
    }

    @Override
    public final Object[] constructorargs() {
        Object[] objectArray = new Object[]{this.constructorArgs};
        return objectArray;
    }

    @Override
    public final String getConstructor() {
        return "Bluetooth('" + this.constructorArgs.split(":")[0] + "', " + this.Channel + ");";
    }

    @Override
    public String getConstructorDescription() {
        return "Device - " + this.constructorArgs;
    }

    @Override
    public String getInstrfindArgs() {
        return "('Type', '" + this.type + "', 'Name', '" + this.name + "', 'Tag', '" + this.tag + "');";
    }

    @Override
    protected void hardwareFlushInput() {
        if (this.lineInputStream != null) {
            this.lineInputStream.flush();
        }
    }

    @Override
    public int getSuccessValue() {
        return CommStatus.SUCCESS.value;
    }

    @Override
    public String getErrorMessageFromHardware(int n) {
        return ERROR_MSG[-1 * n - 1];
    }

    @Override
    protected int getReadTimeoutErrorCode() {
        return CommStatus.READ_TIMEOUT_EC.value;
    }

    @Override
    protected int writeAsciiToHardware(String string) {
        int n = string.length();
        int n2 = 384;
        long l = Bluetooth.currentNanoTicTime();
        int n3 = n2;
        this.localBytesToOutput = n;
        this.updateWriteTransferStatus(true);
        int n4 = 0;
        try {
            for (int i = 0; i < string.length(); i += n2) {
                if (this.checkForCtrlC()) {
                    this.valuesSent += (long)n4;
                    return this.returnWriteErrorCode(CommStatus.WRITE_CTRLC_EC.value);
                }
                if (Bluetooth.nanoTicTimeout(l, this.timeout)) {
                    this.valuesSent += (long)n4;
                    return this.returnWriteErrorCode(CommStatus.WRITE_TIMEOUT_EC.value);
                }
                n3 = i + n2;
                if (n3 > n) {
                    n3 = n;
                }
                byte[] byArray = string.substring(i, n3).getBytes();
                this.dataOutputStream.write(byArray, 0, byArray.length);
                this.localBytesToOutput -= n3 - i;
                n4 += n3 - i;
            }
            this.localBytesToOutput = 0;
            this.dataOutputStream.flush();
            if (Bluetooth.nanoTicTimeout(l, this.timeout)) {
                this.valuesSent += (long)n4;
                return this.returnWriteErrorCode(CommStatus.WRITE_TIMEOUT_EC.value);
            }
            this.updateWriteTransferStatus(false);
            return string.length();
        }
        catch (Exception exception) {
            this.valuesSent += (long)n4;
            return this.returnWriteErrorCode(CommStatus.WRITE_EC.value);
        }
    }

    @Override
    protected int writeBinaryToHardware(Object object, int n, int n2) {
        long l = Bluetooth.currentNanoTicTime();
        int n3 = 3;
        this.updateWriteTransferStatus(true);
        try {
            byte[] byArray = this.getBinaryDataToWrite(object, n2);
            this.localBytesToOutput = byArray.length;
            for (int i = 0; i < byArray.length; i += n3) {
                if (n3 > this.localBytesToOutput) {
                    n3 = this.localBytesToOutput;
                }
                this.outputStream.write(byArray, i, n3);
                this.outputStream.flush();
                this.localBytesToOutput -= n3;
                if (!this.checkForCtrlC() && !Bluetooth.nanoTicTimeout(l, this.timeout)) continue;
                return this.returnWriteErrorCode(CommStatus.WRITE_CTRLC_TIMEOUT_EC.value);
            }
            this.localBytesToOutput = 0;
            this.updateWriteTransferStatus(false);
            return byArray.length / DATASIZE[n2];
        }
        catch (Exception exception) {
            return this.returnWriteErrorCode(CommStatus.WRITE_EC.value);
        }
    }

    private byte[] getBinaryDataToWrite(Object object, int n) throws Exception {
        this.datatype = n;
        switch (this.byteOrder) {
            case 1: {
                return BinarySwapBytes.breakdownToBytesAndSwap(object, n);
            }
            case 0: {
                return BinarySwapBytes.breakdownToBytes(object, n);
            }
        }
        return null;
    }

    private int returnWriteErrorCode(int n) {
        this.bytesToOutput = 0;
        this.updateWriteTransferStatus(false);
        return n;
    }

    @Override
    protected Object convertBinaryData(byte[] byArray, int n, int n2) throws Exception {
        if (n2 == 0) {
            return null;
        }
        switch (this.byteOrder) {
            case 0: {
                return BinarySwapBytes.convertToLittlePrecision(byArray, n, n2);
            }
            case 1: {
                return BinarySwapBytes.convertToBigPrecision(byArray, n, n2);
            }
        }
        throw new TMException("Unsupported byte order specified.");
    }

    @Override
    protected byte[] breakDownToBytes(Object object, int n) throws Exception {
        byte[] byArray = null;
        switch (this.byteOrder) {
            case 0: {
                byArray = BinarySwapBytes.breakdownToBytes(object, n);
                break;
            }
            case 1: {
                byArray = BinarySwapBytes.breakdownToBytesAndSwap(object, n);
            }
        }
        return byArray;
    }

    @Override
    protected int writeAsyncDataToHardware(int n, int n2) {
        this.updateWriteTransferStatus(true);
        try {
            this.dataOutputStream.write(this.dataToWriteAsync, n, n2);
        }
        catch (Exception exception) {
            return CommStatus.WRITE_ASYNC_EC.value;
        }
        return CommStatus.SUCCESS.value;
    }

    @Override
    protected void cleanupWriteAsync() {
        this.updateWriteTransferStatus(false);
        if (this.asyncWriteFlag && !this.outputEmptyFcn.equals(ACTION)) {
            this.eventTime = Calendar.getInstance();
            this.executeEvent(4, "OutputEmpty", this.eventTime, new ICEvent("OutputEmpty", Bluetooth.constructClockVector(this.eventTime)));
        }
    }

    @Override
    protected int getBytesAvailableFromHardware() {
        int n = this.lineInputStream.getBytesAvailable();
        if (n > 0) {
            return n;
        }
        return n;
    }

    @Override
    protected byte[] readBytes(int n) {
        try {
            return this.lineInputStream.readByte(n);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected void stopHardwareDueToWriteTimeout() {
        try {
            this.hardwareFlushOutput();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] ObjectHardwareInfo() throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            throw new TMException("Undefined function or variable 'instrhwinfo'.");
        }
        this.info[0] = Bluetooth.jarVersion();
        return this.info;
    }

    @Override
    protected Object[] getHwInfoStruct() {
        try {
            this.ObjectHardwareInfo();
        }
        catch (TMException tMException) {
            // empty catch block
        }
        return this.info;
    }

    @Override
    protected String[] getHwInfoFields() {
        return new String[]{"JarFileVersion"};
    }

    @Override
    protected void updateObjectSpecificProperties(ICProp[] iCPropArray) {
        for (int i = 0; i < iCPropArray.length; ++i) {
            String string = iCPropArray[i].name;
            if (string.equals("Name")) {
                iCPropArray[i].setDefaultValue("Bluetooth-" + this.constructorArgs);
                continue;
            }
            if (string.equals("Device")) {
                iCPropArray[i].setDefaultValue(this.constructorArgs);
                continue;
            }
            if (string.equals("Channel")) {
                iCPropArray[i].setDefaultValue(this.Channel);
                continue;
            }
            if (string.equals("RemoteName")) {
                iCPropArray[i].setDefaultValue(this.RemoteName);
                continue;
            }
            if (!string.equals("RemoteID")) continue;
            iCPropArray[i].setDefaultValue(this.RemoteID);
        }
    }

    public static ICProp[] getProperties() {
        return DefaultICProp.addObjectProps(objectICProps);
    }

    @Override
    public String display() {
        if (!this.isvalid()) {
            return Displays.invalidDisplay();
        }
        return LINESEP + "   Bluetooth Object : " + this.name + LINESEP + LINESEP + "   Communication Settings " + LINESEP + "      RemoteName:         " + this.RemoteName + LINESEP + "      RemoteID:           " + "btspp://" + this.RemoteID + LINESEP + "      Channel:            " + this.Channel + LINESEP + "      Terminator:         " + this.displayTerminator + LINESEP + LINESEP + "   Communication State " + LINESEP + "      Status:             " + STATUS_ENUM[this.status] + LINESEP + "      RecordStatus:       " + RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + LINESEP + LINESEP + "   Read/Write State  " + LINESEP + "      TransferStatus:     " + TRANSFER_STATUS_ENUM[this.transferStatus] + LINESEP + "      BytesAvailable:     " + this.bytesAvailable + LINESEP + "      ValuesReceived:     " + this.valuesReceived + LINESEP + "      ValuesSent:         " + this.valuesSent + LINESEP + " " + LINESEP;
    }

    @Override
    public String setDisplay() {
        return Displays.getSetDisplay("terminator") + "    BLUETOOTH specific properties:" + LINESEP + "    Channel" + LINESEP + "    Profile" + LINESEP + "    ReadAsyncMode: [ {continuous} | manual ]" + LINESEP + "    RemoteID" + LINESEP + "    RemoteName" + LINESEP + "    Terminator" + LINESEP;
    }

    @Override
    protected void nameStandardFormat() {
    }

    @Override
    protected void setHardwareTerminator(int n) throws TMException {
    }

    @Override
    protected int[] getTerminatorInteger(MLArrayRef mLArrayRef) throws TMException {
        return ASCIITableConverter.convertTerminatorObjectToInt(mLArrayRef, true);
    }

    static {
        System.setProperty("bluecove.debug", "false");
        System.setProperty("bluecove.debug.log4j", "false");
        TermVals = new Object[]{new Double(0.0), new Double(127.0)};
        AsciiVals = new Object[]{TermVals, "CR/LF", "LF/CR"};
        dChannels = new Object[]{new Double(1.0), new Double(65535.0)};
        AsyncVals = new String[]{"continuous", "manual"};
        dModeVals = new String[]{"terminator", "byte"};
        ProfileVals = new String[]{"SPP"};
        objectICProps = new ICProp[]{new ICProp("BytesAvailableFcnMode", "string", "enum", dModeVals, "terminator", "whileOpen", 0, 0), new ICProp("ByteOrder", "string", "enum", byteOVals, "littleEndian", "never", 0, 0), new ICProp("Channel", "double", "bounded", dChannels, new Integer(0), "whileOpen", 1, 0), new ICProp("RemoteID", "string", "none", "", "", "whileOpen", 1, 0), new ICProp("RemoteName", "string", "none", "", "", "whileOpen", 1, 0), new ICProp("Terminator", "ASCII Value", "ASCII Value", AsciiVals, "LF", "never", 1, 0), new ICProp("ReadAsyncMode", "string", "enum", AsyncVals, "continuous", "never", 1, 0), new ICProp("Profile", "string", "enum", ProfileVals, "SPP", "always", 1, 0), new ICProp("Type", "string", "none", "", "bluetooth", "always", 0, 0)};
    }

    private static enum CommStatus {
        SUCCESS(0),
        WRITE_EC(-1),
        WRITE_CTRLC_EC(-2),
        WRITE_TIMEOUT_EC(-3),
        WRITE_CTRLC_TIMEOUT_EC(-4),
        READ_TIMEOUT_EC(-5),
        WRITE_ASYNC_EC(-6);

        private int value;

        private CommStatus(int n2) {
            this.value = n2;
        }
    }
}

