/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.fiddler;

import [Ljava.lang.String;;
import [Lnet.jini.core.discovery.LookupLocator;;
import [Lnet.jini.core.entry.Entry;;
import com.sun.jini.config.Config;
import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.fiddler.Fiddler;
import com.sun.jini.fiddler.FiddlerAdminProxy;
import com.sun.jini.fiddler.FiddlerLease;
import com.sun.jini.fiddler.FiddlerProxy;
import com.sun.jini.fiddler.FiddlerRegistration;
import com.sun.jini.fiddler.FiddlerRenewResults;
import com.sun.jini.fiddler.ProxyVerifier;
import com.sun.jini.logging.Levels;
import com.sun.jini.lookup.entry.BasicServiceType;
import com.sun.jini.lookup.entry.LookupAttributes;
import com.sun.jini.proxy.ThrowThis;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import com.sun.jini.start.LifeCycle;
import com.sun.jini.thread.ReadersWriter;
import com.sun.jini.thread.TaskManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.rmi.server.ExportException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.activation.ActivationExporter;
import net.jini.activation.ActivationGroup;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.NoSuchEntryException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryChangeListener;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.discovery.LookupDiscoveryRegistration;
import net.jini.discovery.RemoteDiscoveryEvent;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lookup.JoinManager;
import net.jini.lookup.entry.Comment;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.lookup.entry.Status;
import net.jini.lookup.entry.StatusType;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

class FiddlerImpl
implements ServerProxyTrust,
ProxyAccessor,
Fiddler {
    private static final String COMPONENT_NAME = "com.sun.jini.fiddler";
    static final Logger problemLogger = Logger.getLogger("com.sun.jini.fiddler.problem");
    static final Logger startupLogger = Logger.getLogger("com.sun.jini.fiddler.startup");
    static final Logger tasksLogger = Logger.getLogger("com.sun.jini.fiddler.tasks");
    static final Logger eventsLogger = Logger.getLogger("com.sun.jini.fiddler.events");
    static final Logger groupsLogger = Logger.getLogger("com.sun.jini.fiddler.groups");
    static final Logger locatorsLogger = Logger.getLogger("com.sun.jini.fiddler.locators");
    static final Logger discardLogger = Logger.getLogger("com.sun.jini.fiddler.discard");
    static final Logger leaseLogger = Logger.getLogger("com.sun.jini.fiddler.lease");
    static final Logger registrationLogger = Logger.getLogger("com.sun.jini.fiddler.registration");
    static final Logger persistLogger = Logger.getLogger("com.sun.jini.fiddler.persist");
    private static final String PRODUCT = "Lookup Discovery Service";
    private static final String MANUFACTURER = "Sun Microsystems, Inc.";
    private static final String VENDOR = "Sun Microsystems, Inc.";
    private static final String VERSION = "2.0_002";
    private static final long MAX_LEASE = 31536000000000L;
    private static final int LOG_VERSION = 2;
    private FiddlerProxy outerProxy;
    private Fiddler innerProxy;
    private FiddlerAdminProxy adminProxy;
    private ServiceID serviceID = null;
    private ActivationID activationID;
    private ActivationSystem activationSystem;
    private Uuid proxyID = null;
    private final HashMap allDiscoveredRegs = new HashMap(11);
    private final HashMap registrationByID = new HashMap(11);
    private final TreeMap registrationByTime = new TreeMap();
    private LookupDiscoveryManager discoveryMgr = null;
    private final LookupDiscoveryListener discoveryListener = new LookupDiscoveryListener();
    private long curEventID = 0L;
    private long minExpiration = Long.MAX_VALUE;
    private DiscoveryManagement joinMgrLDM;
    private JoinManager joinMgr;
    private TaskManager taskMgr;
    private Thread leaseExpireThread;
    private Thread snapshotThread;
    private final ReadersWriter concurrentObj = new ReadersWriter();
    private final Object leaseExpireThreadSyncObj = new Object();
    private final Object snapshotThreadSyncObj = new Object();
    private ReliableLog log = null;
    private boolean inRecovery;
    private int logFileSize = 0;
    private String persistDir;
    private long leaseBound = 1800000L;
    private float snapshotWt = 10.0f;
    private int snapshotThresh = 200;
    private String[] thisServicesGroups = new String[]{""};
    private LookupLocator[] thisServicesLocators = new LookupLocator[0];
    private Entry[] thisServicesAttrs = new Entry[]{new ServiceInfo("Lookup Discovery Service", "Sun Microsystems, Inc.", "Sun Microsystems, Inc.", "2.0_002", "", ""), new BasicServiceType("Lookup Discovery Service")};
    private Configuration config;
    private LoginContext loginContext = null;
    private Exporter serverExporter;
    private long leaseMax = 31536000000000L;
    private boolean initialStartup = true;
    private LifeCycle lifeCycle = null;
    private static ProxyPreparer listenerPreparer;
    private static ProxyPreparer recoveredListenerPreparer;
    private static ProxyPreparer locatorToJoinPreparer;
    private static ProxyPreparer recoveredLocatorToJoinPreparer;
    private static ProxyPreparer locatorToDiscoverPreparer;
    private static ProxyPreparer recoveredLocatorToDiscoverPreparer;

    FiddlerImpl(ActivationID activationID, MarshalledObject marshalledObject) throws IOException, ActivationException, ConfigurationException, LoginException, ClassNotFoundException {
        this.activationID = activationID;
        try {
            this.activationSystem = ActivationGroup.getSystem();
            this.init((String[])marshalledObject.get(), true);
        }
        catch (Throwable throwable) {
            this.cleanupInitFailure();
            this.handleActivatableInitThrowable(throwable);
        }
    }

    FiddlerImpl(String[] stringArray, LifeCycle lifeCycle, boolean bl) throws IOException, ConfigurationException, LoginException {
        try {
            this.lifeCycle = lifeCycle;
            this.init(stringArray, bl);
        }
        catch (Throwable throwable) {
            this.cleanupInitFailure();
            this.handleInitThrowable(throwable);
        }
    }

    public TrustVerifier getProxyVerifier() {
        return new ProxyVerifier(this.innerProxy, this.proxyID);
    }

    public Object getProxy() {
        return this.innerProxy;
    }

    public Object getAdmin() throws RemoteException {
        return this.adminProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry[] getLookupAttributes() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            Entry[] entryArray = this.thisServicesAttrs;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return entryArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLookupAttributes(Entry[] entryArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            this.joinMgr.addAttributes(entryArray, true);
            this.thisServicesAttrs = this.joinMgr.getAttributes();
            this.addLogRecord(new LookupAttrsAddedLogObj(this, entryArray));
            Object var3_2 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyLookupAttributes(Entry[] entryArray, Entry[] entryArray2) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            this.joinMgr.modifyAttributes(entryArray, entryArray2, true);
            this.thisServicesAttrs = this.joinMgr.getAttributes();
            this.addLogRecord(new LookupAttrsModifiedLogObj(this, entryArray, entryArray2));
            Object var4_3 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLookupGroups() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            String[] stringArray = this.thisServicesGroups;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLookupGroups(String[] stringArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            try {
                ((DiscoveryGroupManagement)((Object)this.joinMgrLDM)).addGroups(stringArray);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
            this.thisServicesGroups = ((DiscoveryGroupManagement)((Object)this.joinMgrLDM)).getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.thisServicesGroups));
            Object var4_3 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLookupGroups(String[] stringArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            ((DiscoveryGroupManagement)((Object)this.joinMgrLDM)).removeGroups(stringArray);
            this.thisServicesGroups = ((DiscoveryGroupManagement)((Object)this.joinMgrLDM)).getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.thisServicesGroups));
            Object var3_2 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLookupGroups(String[] stringArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            try {
                ((DiscoveryGroupManagement)((Object)this.joinMgrLDM)).setGroups(stringArray);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
            this.thisServicesGroups = ((DiscoveryGroupManagement)((Object)this.joinMgrLDM)).getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.thisServicesGroups));
            Object var4_3 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookupLocator[] getLookupLocators() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            LookupLocator[] lookupLocatorArray = this.thisServicesLocators;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return lookupLocatorArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        FiddlerImpl.prepareNewLocators(locatorToJoinPreparer, lookupLocatorArray);
        this.concurrentObj.writeLock();
        try {
            ((DiscoveryLocatorManagement)((Object)this.joinMgrLDM)).addLocators(lookupLocatorArray);
            this.thisServicesLocators = ((DiscoveryLocatorManagement)((Object)this.joinMgrLDM)).getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.thisServicesLocators));
            Object var3_2 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        FiddlerImpl.prepareNewLocators(locatorToJoinPreparer, lookupLocatorArray);
        this.concurrentObj.writeLock();
        try {
            ((DiscoveryLocatorManagement)((Object)this.joinMgrLDM)).removeLocators(lookupLocatorArray);
            this.thisServicesLocators = ((DiscoveryLocatorManagement)((Object)this.joinMgrLDM)).getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.thisServicesLocators));
            Object var3_2 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        FiddlerImpl.prepareNewLocators(locatorToJoinPreparer, lookupLocatorArray);
        this.concurrentObj.writeLock();
        try {
            ((DiscoveryLocatorManagement)((Object)this.joinMgrLDM)).setLocators(lookupLocatorArray);
            this.thisServicesLocators = ((DiscoveryLocatorManagement)((Object)this.joinMgrLDM)).getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.thisServicesLocators));
            Object var3_2 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    public void destroy() throws RemoteException {
        this.destroyDo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeaseBound(long l) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            if (l > this.leaseMax) {
                throw new IllegalArgumentException("max duration exceeded");
            }
            this.leaseBound = l;
            this.addLogRecord(new LeaseBoundSetLogObj(l));
            Object var4_2 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLeaseBound() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            long l = this.leaseBound;
            Object var4_2 = null;
            this.concurrentObj.readUnlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistenceSnapshotWeight(float f) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            this.snapshotWt = f;
            this.addLogRecord(new SnapshotWeightSetLogObj(f));
            Object var3_2 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getPersistenceSnapshotWeight() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            float f = this.snapshotWt;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return f;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistenceSnapshotThreshold(int n) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            this.snapshotThresh = n;
            this.addLogRecord(new SnapshotThresholdSetLogObj(n));
            Object var3_2 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPersistenceSnapshotThreshold() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            int n = this.snapshotThresh;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    public Object getServiceProxy() {
        return this.outerProxy;
    }

    public Uuid getProxyID() throws RemoteException {
        return this.proxyID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookupDiscoveryRegistration register(String[] stringArray, LookupLocator[] lookupLocatorArray, RemoteEventListener remoteEventListener, MarshalledObject marshalledObject, long l) throws RemoteException {
        if (lookupLocatorArray == null) {
            lookupLocatorArray = new LookupLocator[]{};
        }
        if (FiddlerImpl.containsNullElement(stringArray)) {
            throw new NullPointerException(" on call to register() method, at least one null element in groups");
        }
        if (FiddlerImpl.containsNullElement(lookupLocatorArray)) {
            throw new NullPointerException(" on call to register() method, at least one null element in locators");
        }
        if (remoteEventListener == null) {
            throw new NullPointerException(" null listener input to register() method");
        }
        FiddlerImpl.prepareNewLocators(locatorToDiscoverPreparer, lookupLocatorArray);
        LookupDiscoveryRegistration lookupDiscoveryRegistration = null;
        this.concurrentObj.writeLock();
        try {
            try {
                lookupDiscoveryRegistration = this.registerDo(stringArray, lookupLocatorArray, remoteEventListener, marshalledObject, l);
            }
            catch (RemoteException remoteException) {
                problemLogger.log(Level.INFO, "cannot grant registration request", remoteException);
                throw remoteException;
            }
            catch (IOException iOException) {
                problemLogger.log(Level.INFO, "cannot grant registration request - multicast problem", iOException);
                Entry[] entryArray = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment("Failure during registration")};
                this.joinMgr.addAttributes(entryArray, true);
                Object var11_8 = null;
                this.concurrentObj.writeUnlock();
            }
            Object var11_7 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        return lookupDiscoveryRegistration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarshalledObject[] getRegistrars(Uuid uuid) throws RemoteException, ThrowThis {
        this.concurrentObj.readLock();
        try {
            RegistrationInfo registrationInfo = (RegistrationInfo)this.registrationByID.get(uuid);
            if (registrationInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to getRegistrars() method"));
            }
            Collection collection = registrationInfo.discoveredRegsMap.values();
            MarshalledObject[] marshalledObjectArray = collection.toArray(new MarshalledObject[collection.size()]);
            Object var6_5 = null;
            this.concurrentObj.readUnlock();
            return marshalledObjectArray;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getGroups(Uuid uuid) throws RemoteException, ThrowThis {
        this.concurrentObj.readLock();
        try {
            RegistrationInfo registrationInfo = (RegistrationInfo)this.registrationByID.get(uuid);
            if (registrationInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to getGroups() method"));
            }
            String[] stringArray = null;
            stringArray = registrationInfo.groups == null ? DiscoveryGroupManagement.ALL_GROUPS : registrationInfo.groups.toArray(new String[registrationInfo.groups.size()]);
            String[] stringArray2 = stringArray;
            Object var6_5 = null;
            this.concurrentObj.readUnlock();
            return stringArray2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookupLocator[] getLocators(Uuid uuid) throws RemoteException, ThrowThis {
        this.concurrentObj.readLock();
        try {
            RegistrationInfo registrationInfo = (RegistrationInfo)this.registrationByID.get(uuid);
            if (registrationInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to getLocators() method"));
            }
            LookupLocator[] lookupLocatorArray = registrationInfo.locators.toArray(new LookupLocator[registrationInfo.locators.size()]);
            Object var5_4 = null;
            this.concurrentObj.readUnlock();
            return lookupLocatorArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroups(Uuid uuid, String[] stringArray) throws RemoteException, ThrowThis {
        this.concurrentObj.writeLock();
        try {
            RegistrationInfo registrationInfo = (RegistrationInfo)this.registrationByID.get(uuid);
            if (registrationInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to addGroups() method"));
            }
            if (stringArray == null) {
                throw new NullPointerException(" on call to addGroups() method, cannot add 'ALL_GROUPS' (the null set) to a registration's set of groups to discover");
            }
            if (FiddlerImpl.containsNullElement(stringArray)) {
                throw new NullPointerException(" on call to addGroups() method, at least one null element in groups parameter");
            }
            if (registrationInfo.groups == null) {
                throw new UnsupportedOperationException(" on call to addGroups() method, cannot add a set ofgroups to a set already configured for 'ALL_GROUPS' (the null set)");
            }
            this.addGroupsDo(registrationInfo, stringArray);
            this.addLogRecord(new GroupsAddedToRegistrationLogObj(registrationInfo.registrationID, stringArray));
            Object var5_4 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroups(Uuid uuid, String[] stringArray) throws RemoteException, ThrowThis {
        this.concurrentObj.writeLock();
        try {
            RegistrationInfo registrationInfo = (RegistrationInfo)this.registrationByID.get(uuid);
            if (registrationInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to setGroups() method"));
            }
            if (FiddlerImpl.containsNullElement(stringArray)) {
                throw new NullPointerException(" on call to setGroups() method, at least one null element in groups parameter");
            }
            if (stringArray == null && registrationInfo.groups == null) {
                Object var5_4 = null;
                this.concurrentObj.writeUnlock();
                return;
            }
            this.setGroupsDo(registrationInfo, stringArray);
            this.addLogRecord(new GroupsSetInRegistrationLogObj(registrationInfo.registrationID, stringArray));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        Object var5_5 = null;
        this.concurrentObj.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroups(Uuid uuid, String[] stringArray) throws RemoteException, ThrowThis {
        this.concurrentObj.writeLock();
        try {
            RegistrationInfo registrationInfo = (RegistrationInfo)this.registrationByID.get(uuid);
            if (registrationInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to removeGroups() method"));
            }
            if (stringArray == null) {
                throw new NullPointerException(" on call to removeGroups() method, cannot remove 'ALL_GROUPS' (the null set) from a registration's set of groups to discover");
            }
            if (FiddlerImpl.containsNullElement(stringArray)) {
                throw new NullPointerException(" on call to removeGroups() method, at least one null element in groups parameter");
            }
            if (registrationInfo.groups == null) {
                throw new UnsupportedOperationException(" on call to removeGroups() method, cannot remove a set ofgroups from a set already configured for 'ALL_GROUPS' (the null set)");
            }
            this.removeGroupsDo(registrationInfo, stringArray);
            this.logInfoGroups("\nAfter Group Removal --");
            this.addLogRecord(new GroupsRemovedFromRegistrationLogObj(registrationInfo.registrationID, stringArray));
            Object var5_4 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocators(Uuid uuid, LookupLocator[] lookupLocatorArray) throws RemoteException, ThrowThis {
        FiddlerImpl.prepareNewLocators(locatorToDiscoverPreparer, lookupLocatorArray);
        this.concurrentObj.writeLock();
        try {
            RegistrationInfo registrationInfo = (RegistrationInfo)this.registrationByID.get(uuid);
            if (registrationInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to addLocators() method"));
            }
            if (lookupLocatorArray == null) {
                throw new NullPointerException(" on call to addLocators() method, cannot add null to a registration's set of locators to discover");
            }
            if (FiddlerImpl.containsNullElement(lookupLocatorArray)) {
                throw new NullPointerException(" on call to addLocators() method, at least one null element in locators parameter");
            }
            this.addLocatorsDo(registrationInfo, lookupLocatorArray);
            this.addLogRecord(new LocsAddedToRegistrationLogObj(registrationInfo.registrationID, lookupLocatorArray));
            Object var5_4 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocators(Uuid uuid, LookupLocator[] lookupLocatorArray) throws RemoteException, ThrowThis {
        FiddlerImpl.prepareNewLocators(locatorToDiscoverPreparer, lookupLocatorArray);
        this.concurrentObj.writeLock();
        try {
            RegistrationInfo registrationInfo = (RegistrationInfo)this.registrationByID.get(uuid);
            if (registrationInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to setLocators() method"));
            }
            if (lookupLocatorArray == null) {
                throw new NullPointerException(" on call to setLocators() method, cannot replace a registration's current set of locators with null");
            }
            if (FiddlerImpl.containsNullElement(lookupLocatorArray)) {
                throw new NullPointerException(" on call to setLocators() method, at least one null element in locators parameter");
            }
            this.setLocatorsDo(registrationInfo, lookupLocatorArray);
            this.addLogRecord(new LocsSetInRegistrationLogObj(registrationInfo.registrationID, lookupLocatorArray));
            Object var5_4 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocators(Uuid uuid, LookupLocator[] lookupLocatorArray) throws RemoteException, ThrowThis {
        FiddlerImpl.prepareNewLocators(locatorToDiscoverPreparer, lookupLocatorArray);
        this.concurrentObj.writeLock();
        try {
            RegistrationInfo registrationInfo = (RegistrationInfo)this.registrationByID.get(uuid);
            if (registrationInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to removeLocators() method"));
            }
            if (lookupLocatorArray == null) {
                throw new NullPointerException(" on call to removeLocators() method, cannot remove null from a registration's set of locators to discover");
            }
            if (FiddlerImpl.containsNullElement(lookupLocatorArray)) {
                throw new NullPointerException(" on call to removeLocators() method, at least one null element in locators parameter");
            }
            this.removeLocatorsDo(registrationInfo, lookupLocatorArray);
            this.addLogRecord(new LocsRemovedFromRegistrationLogObj(registrationInfo.registrationID, lookupLocatorArray));
            Object var5_4 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard(Uuid uuid, ServiceRegistrar serviceRegistrar) throws RemoteException, ThrowThis {
        this.concurrentObj.writeLock();
        try {
            this.logInfoDiscard("\ndiscard: ", uuid);
            RegistrationInfo registrationInfo = (RegistrationInfo)this.registrationByID.get(uuid);
            if (registrationInfo == null) {
                throw new ThrowThis(new NoSuchObjectException("Invalid registration ID on call to discard() method"));
            }
            if (serviceRegistrar == null) {
                throw new NullPointerException(" on call to discard() method, null input for registrar to discard");
            }
            if (this.regIsElementOfRegSet(serviceRegistrar, this.discoveryMgr.getRegistrars())) {
                this.logInfoDiscard("  Registrar IS an element of Mgr's discovered registrars ... discarding from discovery manager");
                registrationInfo.discardFlag = true;
                this.discoveryMgr.discard(serviceRegistrar);
            } else {
                this.logInfoDiscard("  Registrar NOT an element of Mgr's discovered registrars ... queuing new DiscardRegistrarTask");
                this.taskMgr.add(new DiscardRegistrarTask(registrationInfo, serviceRegistrar));
            }
            Object var5_4 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long renewLease(Uuid uuid, Uuid uuid2, long l) throws UnknownLeaseException, RemoteException {
        this.concurrentObj.priorityWriteLock();
        try {
            RegistrationInfo registrationInfo = (RegistrationInfo)this.registrationByID.get(uuid);
            if (registrationInfo == null) {
                throw new UnknownLeaseException("\n    Invalid registration ID on call to cancelLease() method\n    The lease may have expired or been cancelled");
            }
            long l2 = 0L;
            l2 = this.renewLeaseDo(registrationInfo, uuid2, l);
            this.logInfoLease("Renewed lease: ", uuid, uuid2);
            long l3 = l2;
            Object var11_7 = null;
            this.concurrentObj.writeUnlock();
            return l3;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FiddlerRenewResults renewLeases(Uuid[] uuidArray, Uuid[] uuidArray2, long[] lArray) throws RemoteException {
        this.concurrentObj.priorityWriteLock();
        try {
            FiddlerRenewResults fiddlerRenewResults = this.renewLeasesDo(uuidArray, uuidArray2, lArray);
            Object var6_5 = null;
            this.concurrentObj.writeUnlock();
            return fiddlerRenewResults;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelLease(Uuid uuid, Uuid uuid2) throws UnknownLeaseException, RemoteException {
        this.concurrentObj.writeLock();
        try {
            RegistrationInfo registrationInfo = (RegistrationInfo)this.registrationByID.get(uuid);
            if (registrationInfo == null) {
                throw new UnknownLeaseException("\n    Invalid registration ID on call to cancelLease() method\n    The lease may have expired or been cancelled");
            }
            try {
                this.cancelLeaseDo(registrationInfo, uuid2);
                this.logInfoLease("Cancelled lease: ", uuid, uuid2);
            }
            catch (IOException iOException) {
                String string = "Failure while cancelling the lease on registration with ID = " + uuid;
                if (problemLogger.isLoggable(Level.INFO)) {
                    problemLogger.log(Level.INFO, string, iOException);
                }
                Entry[] entryArray = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment(string)};
                this.joinMgr.addAttributes(entryArray, true);
            }
            this.addLogRecord(new LeaseCancelledLogObj(registrationInfo.registrationID, uuid2));
            Object var8_7 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception[] cancelLeases(Uuid[] uuidArray, Uuid[] uuidArray2) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            this.addLogRecord(new LeasesCancelledLogObj(uuidArray, uuidArray2));
            Exception[] exceptionArray = this.cancelLeasesDo(uuidArray, uuidArray2);
            Object var5_4 = null;
            this.concurrentObj.writeUnlock();
            return exceptionArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    private static Object[] appendArray(Object[] objectArray, Object object) {
        int n = objectArray.length;
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n + 1);
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        objectArray2[n] = object;
        return objectArray2;
    }

    private static long applyBoundToLeaseDuration(long l, long l2) {
        long l3 = l;
        if (l == -1L || l > l2) {
            l3 = l2;
        } else if (l < 0L) {
            throw new IllegalArgumentException("negative lease duration");
        }
        return l3;
    }

    private static boolean containsNullElement(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            return true;
        }
        return false;
    }

    private static boolean interested(String[] stringArray, Set set) {
        if (set == null) {
            return true;
        }
        if (set.size() == 0) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!set.contains(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean interested(LookupLocator lookupLocator, String[] stringArray, Set set, Set set2) {
        if (set.contains(lookupLocator)) {
            return true;
        }
        return FiddlerImpl.interested(stringArray, set2);
    }

    private static HashMap getUndesiredRegsByGroup(Map map, RegistrationInfo registrationInfo) {
        HashSet hashSet = registrationInfo.groups;
        HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(map.size());
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String[] stringArray = ((LocatorGroupsStruct)entry.getValue()).groups;
            if (FiddlerImpl.interested(stringArray, hashSet)) continue;
            hashMap.put((ServiceRegistrar)entry.getKey(), stringArray);
        }
        return hashMap;
    }

    private static Map getUndesiredRegsByLocator(Map map, RegistrationInfo registrationInfo) {
        HashSet hashSet = registrationInfo.locators;
        HashMap<ServiceRegistrar, LookupLocator> hashMap = new HashMap<ServiceRegistrar, LookupLocator>(map.size());
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            LookupLocator lookupLocator = ((LocatorGroupsStruct)entry.getValue()).locator;
            if (hashSet.contains(lookupLocator)) continue;
            hashMap.put((ServiceRegistrar)entry.getKey(), lookupLocator);
        }
        return hashMap;
    }

    private static MarshalledObject[] marshalAttributes(FiddlerImpl fiddlerImpl, Entry[] entryArray) {
        if (entryArray == null) {
            return new MarshalledObject[0];
        }
        ArrayList<MarshalledObject<Entry>> arrayList = new ArrayList<MarshalledObject<Entry>>();
        for (int i = 0; i < entryArray.length; ++i) {
            try {
                arrayList.add(new MarshalledObject<Entry>(entryArray[i]));
                continue;
            }
            catch (Throwable throwable) {
                if (!problemLogger.isLoggable(Level.INFO)) continue;
                problemLogger.log(Level.INFO, "Error while marshalling attribute[" + i + "] (" + entryArray[i] + ")", throwable);
            }
        }
        return arrayList.toArray(new MarshalledObject[arrayList.size()]);
    }

    private static Entry[] unmarshalAttributes(FiddlerImpl fiddlerImpl, MarshalledObject[] marshalledObjectArray) {
        if (marshalledObjectArray == null) {
            return new Entry[0];
        }
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (int i = 0; i < marshalledObjectArray.length; ++i) {
            try {
                arrayList.add((Entry)marshalledObjectArray[i].get());
                continue;
            }
            catch (Throwable throwable) {
                if (!problemLogger.isLoggable(Level.INFO)) continue;
                problemLogger.log(Level.INFO, "Error while unmarshalling attribute[" + i + "]", throwable);
            }
        }
        return arrayList.toArray(new Entry[arrayList.size()]);
    }

    private static void prepareNewLocators(ProxyPreparer proxyPreparer, LookupLocator[] lookupLocatorArray) throws RemoteException {
        for (int i = 0; i < lookupLocatorArray.length; ++i) {
            lookupLocatorArray[i] = (LookupLocator)proxyPreparer.prepareProxy((Object)lookupLocatorArray[i]);
        }
    }

    private static LookupLocator[] prepareOldLocators(ProxyPreparer proxyPreparer, LookupLocator[] lookupLocatorArray) {
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>(lookupLocatorArray.length);
        for (n = 0; n < lookupLocatorArray.length; ++n) {
            try {
                arrayList.add(proxyPreparer.prepareProxy((Object)lookupLocatorArray[n]));
                continue;
            }
            catch (Throwable throwable) {
                if (!problemLogger.isLoggable(Level.INFO)) continue;
                problemLogger.log(Level.INFO, "failure preparing recovered lookup locator[" + n + "]", throwable);
            }
        }
        if (lookupLocatorArray.length != arrayList.size() && problemLogger.isLoggable(Levels.HANDLED)) {
            problemLogger.log(Levels.HANDLED, "number of requested recovered lookup locators = " + lookupLocatorArray.length);
            problemLogger.log(Levels.HANDLED, "number of successfully prepared recovered lookup locators = " + arrayList.size());
            for (n = 0; n < arrayList.size(); ++n) {
                problemLogger.log(Levels.HANDLED, "successfully prepared recovered lookup locator = " + arrayList.get(n));
            }
        }
        return arrayList.toArray(new LookupLocator[arrayList.size()]);
    }

    private static Set prepareOldLocators(ProxyPreparer proxyPreparer, Set set) {
        HashSet<LookupLocator> hashSet = new HashSet<LookupLocator>(set.size());
        LookupLocator[] lookupLocatorArray = FiddlerImpl.prepareOldLocators(proxyPreparer, set.toArray(new LookupLocator[set.size()]));
        for (int i = 0; i < lookupLocatorArray.length; ++i) {
            hashSet.add(lookupLocatorArray[i]);
        }
        return hashSet;
    }

    private void init(String[] stringArray, boolean bl) throws IOException, ConfigurationException, LoginException {
        this.config = ConfigurationProvider.getInstance((String[])stringArray, (ClassLoader)this.getClass().getClassLoader());
        try {
            this.loginContext = (LoginContext)Config.getNonNullEntry(this.config, COMPONENT_NAME, "loginContext", LoginContext.class);
            this.initWithLogin(this.config, bl, this.loginContext);
        }
        catch (NoSuchEntryException noSuchEntryException) {
            this.doInit(this.config, bl);
        }
    }

    private void initWithLogin(final Configuration configuration, final boolean bl, LoginContext loginContext) throws IOException, ConfigurationException, LoginException {
        loginContext.login();
        try {
            Subject.doAsPrivileged(loginContext.getSubject(), new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    FiddlerImpl.this.doInit(configuration, bl);
                    return null;
                }
            }, null);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (throwable instanceof PrivilegedExceptionAction) {
                throwable2 = throwable.getCause();
            }
            if (throwable2 instanceof IOException) {
                throw (IOException)throwable2;
            }
            if (throwable2 instanceof ConfigurationException) {
                throw (ConfigurationException)throwable2;
            }
            throw new RuntimeException(throwable2);
        }
    }

    private void doInit(Configuration configuration, boolean bl) throws IOException, ConfigurationException {
        BasicILFactory basicILFactory;
        String[] stringArray;
        block21: {
            this.discoveryMgr = new LookupDiscoveryManager(DiscoveryGroupManagement.NO_GROUPS, new LookupLocator[0], null, configuration);
            listenerPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, COMPONENT_NAME, "listenerPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            locatorToJoinPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, COMPONENT_NAME, "locatorToJoinPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            locatorToDiscoverPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, COMPONENT_NAME, "locatorToDiscoverPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            if (bl) {
                recoveredListenerPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, COMPONENT_NAME, "recoveredListenerPreparer", ProxyPreparer.class, new BasicProxyPreparer());
                recoveredLocatorToJoinPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, COMPONENT_NAME, "recoveredLocatorToJoinPreparer", ProxyPreparer.class, new BasicProxyPreparer());
                recoveredLocatorToDiscoverPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, COMPONENT_NAME, "recoveredLocatorToDiscoverPreparer", ProxyPreparer.class, new BasicProxyPreparer());
                this.persistDir = (String)Config.getNonNullEntry(configuration, COMPONENT_NAME, "persistenceDirectory", String.class);
                this.log = new ReliableLog(this.persistDir, new LocalLogHandler());
                this.inRecovery = true;
                this.log.recover();
                this.inRecovery = false;
            }
            if (this.initialStartup) {
                if (this.log != null) {
                    this.snapshotWt = ((Float)configuration.getEntry(COMPONENT_NAME, "initialPersistenceSnapshotWeight", Float.TYPE, (Object)new Float(this.snapshotWt))).floatValue();
                    this.snapshotThresh = Config.getIntEntry(configuration, COMPONENT_NAME, "initialPersistenceSnapshotThreshold", this.snapshotThresh, 0, Integer.MAX_VALUE);
                }
                this.leaseBound = Config.getLongEntry(configuration, COMPONENT_NAME, "initialLeaseBound", this.leaseBound, 0L, Long.MAX_VALUE);
                stringArray = (String[])configuration.getEntry(COMPONENT_NAME, "initialLookupAttributes", Entry;.class, null);
                if (stringArray != null) {
                    int n;
                    basicILFactory = new ArrayList(this.thisServicesAttrs.length + stringArray.length);
                    for (n = 0; n < this.thisServicesAttrs.length; ++n) {
                        basicILFactory.add(this.thisServicesAttrs[n]);
                    }
                    for (n = 0; n < stringArray.length; ++n) {
                        basicILFactory.add(stringArray[n]);
                    }
                    this.thisServicesAttrs = basicILFactory.toArray(new Entry[basicILFactory.size()]);
                }
                this.thisServicesGroups = (String[])configuration.getEntry(COMPONENT_NAME, "initialLookupGroups", String;.class, (Object)this.thisServicesGroups);
                this.thisServicesLocators = (LookupLocator[])configuration.getEntry(COMPONENT_NAME, "initialLookupLocators", LookupLocator;.class, (Object)new LookupLocator[0]);
                if (this.thisServicesLocators == null) {
                    this.thisServicesLocators = new LookupLocator[0];
                }
                this.proxyID = UuidFactory.generate();
            }
            if (this.proxyID == null) {
                throw new NullPointerException("proxyID == null");
            }
            this.leaseMax = Config.getLongEntry(configuration, COMPONENT_NAME, "leaseMax", this.leaseMax, 0L, Long.MAX_VALUE);
            if (this.log != null) {
                this.log.snapshot();
            }
            this.serviceID = new ServiceID(this.proxyID.getMostSignificantBits(), this.proxyID.getLeastSignificantBits());
            this.taskMgr = (TaskManager)Config.getNonNullEntry(configuration, COMPONENT_NAME, "taskManager", TaskManager.class, new TaskManager(10, 15000L, 1.0f));
            try {
                this.joinMgrLDM = (DiscoveryManagement)Config.getNonNullEntry(configuration, COMPONENT_NAME, "discoveryManager", DiscoveryManagement.class);
                if (this.joinMgrLDM instanceof DiscoveryGroupManagement) {
                    stringArray = ((DiscoveryGroupManagement)((Object)this.joinMgrLDM)).getGroups();
                    if (stringArray == DiscoveryGroupManagement.ALL_GROUPS || stringArray.length != 0) {
                        throw new ConfigurationException("discoveryManager entry must be configured to initially discover/join NO_GROUPS");
                    }
                } else {
                    throw new ConfigurationException("discoveryManager entry must implement DiscoveryGroupManagment");
                }
                if (this.joinMgrLDM instanceof DiscoveryLocatorManagement) {
                    stringArray = ((DiscoveryLocatorManagement)((Object)this.joinMgrLDM)).getLocators();
                    if (stringArray != null && stringArray.length != 0) {
                        throw new ConfigurationException("discoveryManager entry must be configured to initially discover/join no locators");
                    }
                    break block21;
                }
                throw new ConfigurationException("discoveryManager entry must implement DiscoveryLocatorManagement");
            }
            catch (NoSuchEntryException noSuchEntryException) {
                this.joinMgrLDM = new LookupDiscoveryManager(DiscoveryGroupManagement.NO_GROUPS, new LookupLocator[0], null, configuration);
            }
        }
        stringArray = TcpServerEndpoint.getInstance((int)0);
        basicILFactory = new BasicILFactory();
        BasicJeriExporter basicJeriExporter = new BasicJeriExporter((ServerEndpoint)stringArray, (InvocationLayerFactory)basicILFactory, false, true);
        if (this.activationID != null) {
            ProxyPreparer proxyPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, COMPONENT_NAME, "activationIdPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            ProxyPreparer proxyPreparer2 = (ProxyPreparer)Config.getNonNullEntry(configuration, COMPONENT_NAME, "activationSystemPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            this.activationID = (ActivationID)proxyPreparer.prepareProxy((Object)this.activationID);
            this.activationSystem = (ActivationSystem)proxyPreparer2.prepareProxy((Object)this.activationSystem);
            basicJeriExporter = new ActivationExporter(this.activationID, (Exporter)basicJeriExporter);
        }
        try {
            this.serverExporter = (Exporter)Config.getNonNullEntry(configuration, COMPONENT_NAME, "serverExporter", Exporter.class, basicJeriExporter, this.activationID);
        }
        catch (ConfigurationException configurationException) {
            throw new ExportException("Configuration exception while retrieving service's exporter", (Exception)((Object)configurationException));
        }
        this.innerProxy = (Fiddler)this.serverExporter.export((Remote)this);
        this.outerProxy = FiddlerProxy.createServiceProxy(this.innerProxy, this.proxyID);
        this.adminProxy = FiddlerAdminProxy.createAdminProxy(this.innerProxy, this.proxyID);
        this.leaseExpireThread = new LeaseExpireThread();
        if (this.log != null) {
            this.snapshotThread = new SnapshotThread();
        }
        this.discoveryMgr.addDiscoveryListener(this.discoveryListener);
        this.joinMgr = new JoinManager((Object)this.outerProxy, this.thisServicesAttrs, this.serviceID, this.joinMgrLDM, null, configuration);
        ((DiscoveryLocatorManagement)((Object)this.joinMgrLDM)).setLocators(this.thisServicesLocators);
        ((DiscoveryGroupManagement)((Object)this.joinMgrLDM)).setGroups(this.thisServicesGroups);
        this.leaseExpireThread.start();
        if (this.log != null) {
            this.snapshotThread.start();
        }
        this.logInfoStartup();
    }

    private void cleanupInitFailure() {
        if (this.innerProxy != null) {
            try {
                this.serverExporter.unexport(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.taskMgr != null) {
            try {
                this.taskMgr.terminate();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.joinMgr != null) {
            try {
                this.joinMgr.terminate();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.joinMgrLDM != null) {
            try {
                this.joinMgrLDM.terminate();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.discoveryMgr != null) {
            try {
                this.discoveryMgr.terminate();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.leaseExpireThread != null) {
            try {
                this.leaseExpireThread.interrupt();
                this.leaseExpireThread.join();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.snapshotThread != null) {
            try {
                this.snapshotThread.interrupt();
                this.snapshotThread.join();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void handleActivatableInitThrowable(Throwable throwable) throws IOException, ActivationException, ConfigurationException, LoginException, ClassNotFoundException {
        this.handleInitThrowable(throwable);
        if (throwable instanceof ActivationException) {
            throw (ActivationException)throwable;
        }
        if (throwable instanceof LoginException) {
            throw (ClassNotFoundException)throwable;
        }
        throw new AssertionError((Object)throwable);
    }

    private void handleInitThrowable(Throwable throwable) throws IOException, ConfigurationException, LoginException {
        problemLogger.log(Level.SEVERE, "cannot initialize the service", throwable);
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof ConfigurationException) {
            throw (ConfigurationException)throwable;
        }
        if (throwable instanceof LoginException) {
            throw (LoginException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    private void destroyDo() {
        new DestroyThread().start();
    }

    private LookupDiscoveryRegistration registerDo(String[] stringArray, LookupLocator[] lookupLocatorArray, RemoteEventListener remoteEventListener, MarshalledObject marshalledObject, long l) throws RemoteException, IOException {
        Uuid uuid;
        long l2 = System.currentTimeMillis();
        l = FiddlerImpl.applyBoundToLeaseDuration(l, this.leaseBound);
        Uuid uuid2 = uuid = UuidFactory.generate();
        long l3 = l2 + l;
        remoteEventListener = (RemoteEventListener)listenerPreparer.prepareProxy((Object)remoteEventListener);
        RegistrationInfo registrationInfo = new RegistrationInfo(uuid, stringArray, lookupLocatorArray, uuid2, l3, this.curEventID, marshalledObject, remoteEventListener);
        ++this.curEventID;
        this.addRegistration(registrationInfo);
        this.logInfoRegistration("\nadded registration:  registrationID = ", uuid);
        this.addLogRecord(new RegistrationGrantedLogObj(registrationInfo));
        this.taskMgr.add(new NewRegistrationTask(registrationInfo));
        if (l3 < this.minExpiration) {
            this.minExpiration = l3;
            this.concurrentObj.waiterNotify(this.leaseExpireThreadSyncObj);
        }
        FiddlerLease fiddlerLease = FiddlerLease.createLease(this.innerProxy, this.proxyID, uuid, uuid2, l3);
        EventRegistration eventRegistration = new EventRegistration(registrationInfo.eventID, (Object)this.outerProxy, (Lease)fiddlerLease, registrationInfo.seqNum);
        this.logInfoGroups();
        this.logInfoLocators();
        FiddlerRegistration fiddlerRegistration = FiddlerRegistration.createRegistration(this.innerProxy, uuid, eventRegistration);
        this.logInfoRegistration("\ncreated registration: registrationID = ", fiddlerRegistration);
        return fiddlerRegistration;
    }

    private void addRegistration(RegistrationInfo registrationInfo) throws IOException {
        if (registrationInfo.listener == null) {
            if (problemLogger.isLoggable(Level.INFO)) {
                problemLogger.log(Level.INFO, "cannot add registration (ID = " + registrationInfo.registrationID + "); failed to " + "unmarshal listener during recovery");
            }
            return;
        }
        this.registrationByID.put(registrationInfo.registrationID, registrationInfo);
        this.registrationByTime.put(registrationInfo, registrationInfo);
        this.updateDiscoveryMgrGroups();
        this.updateDiscoveryMgrLocators();
    }

    private void removeRegistration(RegistrationInfo registrationInfo) throws IOException {
        this.registrationByID.remove(registrationInfo.registrationID);
        this.registrationByTime.remove(registrationInfo);
        this.logInfoRegistration("\nremoved registration: registrationID = ", registrationInfo.registrationID);
        this.updateDiscoveryMgrGroups();
        this.updateDiscoveryMgrLocators();
        this.logInfoGroups();
        this.logInfoLocators();
    }

    private void addGroupsDo(RegistrationInfo registrationInfo, String[] stringArray) {
        this.taskMgr.add(new AddGroupsTask(registrationInfo, stringArray));
    }

    private void addGroupsDo(Uuid uuid, HashMap hashMap, String[] stringArray) {
        this.addGroupsDo((RegistrationInfo)hashMap.get(uuid), stringArray);
    }

    private void setGroupsDo(RegistrationInfo registrationInfo, String[] stringArray) {
        this.taskMgr.add(new SetGroupsTask(registrationInfo, stringArray));
    }

    private void setGroupsDo(Uuid uuid, HashMap hashMap, String[] stringArray) {
        this.setGroupsDo((RegistrationInfo)hashMap.get(uuid), stringArray);
    }

    private void removeGroupsDo(RegistrationInfo registrationInfo, String[] stringArray) {
        this.taskMgr.add(new RemoveGroupsTask(registrationInfo, stringArray));
    }

    private void removeGroupsDo(Uuid uuid, HashMap hashMap, String[] stringArray) {
        this.removeGroupsDo((RegistrationInfo)hashMap.get(uuid), stringArray);
    }

    private String[] getGroupsFromAllRegs() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.registrationByID.values().iterator();
        while (iterator.hasNext()) {
            RegistrationInfo registrationInfo = (RegistrationInfo)iterator.next();
            if (registrationInfo.groups == null) {
                return DiscoveryGroupManagement.ALL_GROUPS;
            }
            hashSet.addAll(registrationInfo.groups);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private HashMap getDesiredRegsByGroup(RegistrationInfo registrationInfo) {
        HashSet hashSet = registrationInfo.groups;
        HashMap<ServiceRegistrar, LocatorGroupsStruct> hashMap = new HashMap<ServiceRegistrar, LocatorGroupsStruct>(this.allDiscoveredRegs.size());
        Set set = this.allDiscoveredRegs.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            LocatorGroupsStruct locatorGroupsStruct = (LocatorGroupsStruct)entry.getValue();
            if (!FiddlerImpl.interested(locatorGroupsStruct.groups, hashSet)) continue;
            hashMap.put((ServiceRegistrar)entry.getKey(), locatorGroupsStruct);
        }
        return hashMap;
    }

    private void updateDiscoveryMgrGroups() {
        String[] stringArray = this.getGroupsFromAllRegs();
        try {
            this.discoveryMgr.setGroups(stringArray);
        }
        catch (IOException iOException) {
            String string = "IOException: on call to setGroups() method of discovery manager";
            problemLogger.log(Level.INFO, string, iOException);
            Entry[] entryArray = new Entry[]{new FiddlerStatus(StatusType.WARNING), new Comment(string)};
            this.joinMgr.addAttributes(entryArray, true);
        }
        catch (IllegalStateException illegalStateException) {
            String string = "IllegalStateException: discovery manager's setGroups() method was called after the manager was terminated";
            problemLogger.log(Level.INFO, string, illegalStateException);
            Entry[] entryArray = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment(string)};
            this.joinMgr.addAttributes(entryArray, true);
            throw new IllegalStateException(" discovery manager's setGroups() method was called after the manager was terminated");
        }
    }

    private void addLocatorsDo(RegistrationInfo registrationInfo, LookupLocator[] lookupLocatorArray) {
        this.taskMgr.add(new AddLocatorsTask(registrationInfo, lookupLocatorArray));
    }

    private void addLocatorsDo(Uuid uuid, HashMap hashMap, LookupLocator[] lookupLocatorArray) {
        this.addLocatorsDo((RegistrationInfo)hashMap.get(uuid), lookupLocatorArray);
    }

    private void setLocatorsDo(RegistrationInfo registrationInfo, LookupLocator[] lookupLocatorArray) {
        this.taskMgr.add(new SetLocatorsTask(registrationInfo, lookupLocatorArray));
    }

    private void setLocatorsDo(Uuid uuid, HashMap hashMap, LookupLocator[] lookupLocatorArray) {
        this.setLocatorsDo((RegistrationInfo)hashMap.get(uuid), lookupLocatorArray);
    }

    private void removeLocatorsDo(RegistrationInfo registrationInfo, LookupLocator[] lookupLocatorArray) {
        this.taskMgr.add(new RemoveLocatorsTask(registrationInfo, lookupLocatorArray));
    }

    private void removeLocatorsDo(Uuid uuid, HashMap hashMap, LookupLocator[] lookupLocatorArray) {
        this.removeLocatorsDo((RegistrationInfo)hashMap.get(uuid), lookupLocatorArray);
    }

    private LookupLocator[] getLocatorsFromAllRegs() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.registrationByID.values().iterator();
        while (iterator.hasNext()) {
            RegistrationInfo registrationInfo = (RegistrationInfo)iterator.next();
            if (registrationInfo.locators == null) {
                throw new AssertionError((Object)"registration contains a null set of locators");
            }
            hashSet.addAll(registrationInfo.locators);
        }
        return hashSet.toArray(new LookupLocator[hashSet.size()]);
    }

    private HashMap getDesiredRegsByLocator(RegistrationInfo registrationInfo) {
        HashSet hashSet = registrationInfo.locators;
        HashMap<ServiceRegistrar, LocatorGroupsStruct> hashMap = new HashMap<ServiceRegistrar, LocatorGroupsStruct>(this.allDiscoveredRegs.size());
        Set set = this.allDiscoveredRegs.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            LocatorGroupsStruct locatorGroupsStruct = (LocatorGroupsStruct)entry.getValue();
            if (!hashSet.contains(locatorGroupsStruct.locator)) continue;
            hashMap.put((ServiceRegistrar)entry.getKey(), locatorGroupsStruct);
        }
        return hashMap;
    }

    private void updateDiscoveryMgrLocators() {
        LookupLocator[] lookupLocatorArray = this.getLocatorsFromAllRegs();
        try {
            this.discoveryMgr.setLocators(lookupLocatorArray);
        }
        catch (IllegalStateException illegalStateException) {
            String string = "IllegalStateException: discovery manager's setLocators() method was called after the manager was terminated";
            problemLogger.log(Level.INFO, string, illegalStateException);
            Entry[] entryArray = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment(string)};
            this.joinMgr.addAttributes(entryArray, true);
            throw new IllegalStateException(" discovery manager's setLocators() method was called after the manager was terminated");
        }
    }

    private long renewLeaseDo(RegistrationInfo registrationInfo, Uuid uuid, long l) throws UnknownLeaseException {
        long l2 = System.currentTimeMillis();
        long l3 = this.renewLeaseInt(registrationInfo, uuid, l, l2);
        this.addLogRecord(new LeaseRenewedLogObj(registrationInfo.registrationID, uuid, l3));
        return l3 - l2;
    }

    private long renewLeaseInt(RegistrationInfo registrationInfo, Uuid uuid, long l, long l2) throws UnknownLeaseException {
        if (l == -1L) {
            l = this.leaseBound;
        } else if (l <= 0L) {
            throw new IllegalArgumentException("non-positive lease duration");
        }
        if (registrationInfo == null || !registrationInfo.leaseID.equals((Object)uuid) || registrationInfo.leaseExpiration <= l2) {
            throw new UnknownLeaseException();
        }
        if (l > this.leaseBound && l > registrationInfo.leaseExpiration - l2) {
            l = Math.max(registrationInfo.leaseExpiration - l2, this.leaseBound);
        }
        long l3 = l2 + l;
        this.registrationByTime.remove(registrationInfo);
        registrationInfo.leaseExpiration = l3;
        this.registrationByTime.put(registrationInfo, registrationInfo);
        if (l3 < this.minExpiration) {
            this.minExpiration = l3;
            this.concurrentObj.waiterNotify(this.leaseExpireThreadSyncObj);
        }
        return l3;
    }

    private void renewLeaseAbs(RegistrationInfo registrationInfo, Uuid uuid, long l) {
        if (registrationInfo == null || registrationInfo.leaseID != uuid) {
            return;
        }
        this.registrationByTime.remove(registrationInfo);
        registrationInfo.leaseExpiration = l;
        this.registrationByTime.put(registrationInfo, registrationInfo);
    }

    private void renewLeaseAbs(Uuid uuid, HashMap hashMap, Uuid uuid2, long l) {
        this.renewLeaseAbs((RegistrationInfo)hashMap.get(uuid), uuid2, l);
    }

    private FiddlerRenewResults renewLeasesDo(Uuid[] uuidArray, Uuid[] uuidArray2, long[] lArray) {
        int n;
        long l = System.currentTimeMillis();
        Exception[] exceptionArray = null;
        for (n = 0; n < uuidArray.length; ++n) {
            RegistrationInfo registrationInfo = (RegistrationInfo)this.registrationByID.get(uuidArray[n]);
            try {
                lArray[n] = this.renewLeaseInt(registrationInfo, uuidArray2[n], lArray[n], l);
                continue;
            }
            catch (Exception exception) {
                lArray[n] = -1L;
                exceptionArray = exceptionArray == null ? new Exception[]{exception} : (Exception[])FiddlerImpl.appendArray(exceptionArray, exception);
            }
        }
        this.addLogRecord(new LeasesRenewedLogObj(uuidArray, uuidArray2, lArray));
        n = uuidArray.length;
        while (--n >= 0) {
            if (lArray[n] < 0L) continue;
            int n2 = n;
            lArray[n2] = lArray[n2] - l;
        }
        return new FiddlerRenewResults(lArray, exceptionArray);
    }

    private void renewLeasesAbs(Uuid[] uuidArray, Uuid[] uuidArray2, long[] lArray) {
        int n = uuidArray.length;
        while (--n >= 0) {
            long l = lArray[n];
            if (l < 0L) continue;
            RegistrationInfo registrationInfo = (RegistrationInfo)this.registrationByID.get(uuidArray[n]);
            this.renewLeaseAbs(registrationInfo, uuidArray2[n], l);
        }
    }

    private void cancelLeaseDo(RegistrationInfo registrationInfo, Uuid uuid) throws UnknownLeaseException, IOException {
        long l = System.currentTimeMillis();
        if (registrationInfo == null || registrationInfo.leaseExpiration <= l) {
            throw new UnknownLeaseException();
        }
        this.removeRegistration(registrationInfo);
        if (registrationInfo.leaseExpiration == this.minExpiration) {
            this.concurrentObj.waiterNotify(this.leaseExpireThreadSyncObj);
        }
    }

    private void cancelLeaseDo(Uuid uuid, HashMap hashMap, Uuid uuid2) throws UnknownLeaseException, IOException {
        this.cancelLeaseDo((RegistrationInfo)hashMap.get(uuid), uuid2);
    }

    private Exception[] cancelLeasesDo(Uuid[] uuidArray, Uuid[] uuidArray2) {
        Exception[] exceptionArray = null;
        int n = uuidArray.length;
        while (--n >= 0) {
            try {
                RegistrationInfo registrationInfo = (RegistrationInfo)this.registrationByID.get(uuidArray[n]);
                this.cancelLeaseDo(registrationInfo, uuidArray2[n]);
            }
            catch (Exception exception) {
                if (exceptionArray == null) {
                    exceptionArray = new Exception[uuidArray.length];
                }
                exceptionArray[n] = exception;
            }
        }
        return exceptionArray;
    }

    private ServiceRegistrar[] intersectRegSets(ServiceRegistrar[] serviceRegistrarArray, ServiceRegistrar[] serviceRegistrarArray2) {
        HashSet<ServiceRegistrar> hashSet = new HashSet<ServiceRegistrar>();
        block0: for (int i = 0; i < serviceRegistrarArray.length; ++i) {
            for (int j = 0; j < serviceRegistrarArray2.length; ++j) {
                if (!serviceRegistrarArray[i].equals(serviceRegistrarArray2[j])) continue;
                hashSet.add(serviceRegistrarArray[i]);
                continue block0;
            }
        }
        return hashSet.toArray(new ServiceRegistrar[hashSet.size()]);
    }

    private boolean regIsElementOfRegSet(ServiceRegistrar serviceRegistrar, ServiceRegistrar[] serviceRegistrarArray) {
        for (int i = 0; i < serviceRegistrarArray.length; ++i) {
            if (!serviceRegistrarArray[i].equals(serviceRegistrar)) continue;
            return true;
        }
        return false;
    }

    private void maybeSendDiscoveredEvent(RegistrationInfo registrationInfo, Map map) {
        Object object;
        HashMap<ServiceRegistrar, LocatorGroupsStruct> hashMap = new HashMap<ServiceRegistrar, LocatorGroupsStruct>(map.size());
        Set set = map.entrySet();
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            ServiceRegistrar serviceRegistrar = (ServiceRegistrar)object.getKey();
            LocatorGroupsStruct locatorGroupsStruct = (LocatorGroupsStruct)object.getValue();
            if (registrationInfo.groups == null) {
                hashMap.put(serviceRegistrar, locatorGroupsStruct);
                continue;
            }
            if (!FiddlerImpl.interested(locatorGroupsStruct.locator, locatorGroupsStruct.groups, registrationInfo.locators, registrationInfo.groups)) continue;
            hashMap.put(serviceRegistrar, locatorGroupsStruct);
        }
        object2 = registrationInfo.addToDiscoveredRegs(hashMap);
        object = this.buildEvent(registrationInfo, (Map)object2, false);
        if (object != null) {
            this.queueEvent(registrationInfo, (RemoteDiscoveryEvent)((Object)object));
            this.logInfoEvents("NewReg/Discovered EventTask.run(): DISCOVERED Event was SENT\n");
        }
    }

    private RegistrationInfo externalDiscardRequest() {
        Iterator iterator = this.registrationByID.values().iterator();
        while (iterator.hasNext()) {
            RegistrationInfo registrationInfo = (RegistrationInfo)iterator.next();
            if (!registrationInfo.discardFlag) continue;
            this.logInfoDiscard("\nexternalDiscardRequest: discardFlag == true\n");
            registrationInfo.discardFlag = false;
            return registrationInfo;
        }
        return null;
    }

    private HashMap mapRegToGroups(ServiceRegistrar serviceRegistrar, String[] stringArray) {
        HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(1);
        hashMap.put(serviceRegistrar, stringArray);
        return hashMap;
    }

    private void maybeRemoveDiscardedRegsFromGlobalSet(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.maybeRemoveDiscardedRegFromGlobalSet(iterator.next());
        }
    }

    private void maybeRemoveDiscardedRegFromGlobalSet(Object object) {
        Iterator iterator = this.registrationByID.values().iterator();
        while (iterator.hasNext()) {
            RegistrationInfo registrationInfo = (RegistrationInfo)iterator.next();
            if (!registrationInfo.discoveredRegsMap.containsKey(object)) continue;
            return;
        }
        this.allDiscoveredRegs.remove(object);
    }

    private void updateGroupsInGlobalSet(Map map) {
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ServiceRegistrar serviceRegistrar = (ServiceRegistrar)entry.getKey();
            if (!this.allDiscoveredRegs.containsKey(serviceRegistrar)) continue;
            LookupLocator lookupLocator = ((LocatorGroupsStruct)this.allDiscoveredRegs.get((Object)serviceRegistrar)).locator;
            String[] stringArray = (String[])entry.getValue();
            LocatorGroupsStruct locatorGroupsStruct = new LocatorGroupsStruct(lookupLocator, stringArray);
            this.allDiscoveredRegs.put(serviceRegistrar, locatorGroupsStruct);
        }
    }

    private RemoteDiscoveryEvent buildEvent(RegistrationInfo registrationInfo, Map map, boolean bl) {
        RemoteDiscoveryEvent remoteDiscoveryEvent = null;
        if (map.size() > 0) {
            try {
                remoteDiscoveryEvent = new RemoteDiscoveryEvent(this.outerProxy, registrationInfo.eventID, ++registrationInfo.seqNum, registrationInfo.handback, bl, map);
                this.logInfoEvents(map, registrationInfo.eventID, registrationInfo.seqNum, registrationInfo.handback, bl, eventsLogger, Level.FINE);
            }
            catch (IOException iOException) {
                String string = "Failed to serialize ALL registrars during event construction ... could not send event";
                problemLogger.log(Level.INFO, string, iOException);
                Entry[] entryArray = new Entry[]{new FiddlerStatus(StatusType.WARNING), new Comment(string)};
                this.joinMgr.addAttributes(entryArray, true);
            }
        }
        return remoteDiscoveryEvent;
    }

    private void queueEvent(RegistrationInfo registrationInfo, RemoteDiscoveryEvent remoteDiscoveryEvent) {
        this.taskMgr.add(new SendEventTask(registrationInfo, remoteDiscoveryEvent));
    }

    private void takeSnapshot(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeUTF(FiddlerImpl.class.getName());
        objectOutputStream.writeInt(2);
        objectOutputStream.writeObject(this.proxyID);
        objectOutputStream.writeLong(this.curEventID);
        objectOutputStream.writeObject(this.thisServicesGroups);
        objectOutputStream.writeObject(this.thisServicesLocators);
        objectOutputStream.writeObject(FiddlerImpl.marshalAttributes(this, this.thisServicesAttrs));
        objectOutputStream.writeLong(this.leaseBound);
        objectOutputStream.writeInt(this.snapshotThresh);
        objectOutputStream.writeFloat(this.snapshotWt);
        Iterator iterator = this.registrationByID.values().iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.flush();
    }

    private void recoverSnapshot(InputStream inputStream) throws IOException, ClassNotFoundException {
        RegistrationInfo registrationInfo;
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        if (!FiddlerImpl.class.getName().equals(objectInputStream.readUTF())) {
            throw new IOException("log from wrong implementation");
        }
        if (objectInputStream.readInt() != 2) {
            throw new IOException("wrong log format version");
        }
        this.proxyID = (Uuid)objectInputStream.readObject();
        this.curEventID = objectInputStream.readLong();
        this.thisServicesGroups = (String[])objectInputStream.readObject();
        this.thisServicesLocators = FiddlerImpl.prepareOldLocators(recoveredLocatorToJoinPreparer, (LookupLocator[])objectInputStream.readObject());
        MarshalledObject[] marshalledObjectArray = (MarshalledObject[])objectInputStream.readObject();
        this.thisServicesAttrs = FiddlerImpl.unmarshalAttributes(this, marshalledObjectArray);
        this.leaseBound = objectInputStream.readLong();
        this.snapshotThresh = objectInputStream.readInt();
        this.snapshotWt = objectInputStream.readFloat();
        while ((registrationInfo = (RegistrationInfo)objectInputStream.readObject()) != null) {
            registrationInfo.seqNum += Integer.MAX_VALUE;
            this.addRegistration(registrationInfo);
        }
        this.initialStartup = false;
    }

    private void addLogRecord(LogRecord logRecord) {
        block4: {
            if (this.log == null) {
                return;
            }
            this.logInfoAddLogRecord(logRecord);
            try {
                int n;
                this.log.update(logRecord, true);
                if (++this.logFileSize >= this.snapshotThresh && (float)this.logFileSize >= this.snapshotWt * (float)(n = this.registrationByID.size())) {
                    this.concurrentObj.waiterNotify(this.snapshotThreadSyncObj);
                }
            }
            catch (Exception exception) {
                if (Thread.currentThread().isInterrupted()) break block4;
                String string = "Failure while updating the persistent log containing the service state";
                problemLogger.log(Level.INFO, string, exception);
                Entry[] entryArray = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment(string)};
                this.joinMgr.addAttributes(entryArray, true);
            }
        }
    }

    private static String writeArrayElementsToString(Object[] objectArray) {
        if (objectArray == null) {
            return new String("[]");
        }
        if (objectArray.length <= 0) {
            return new String("[]");
        }
        StringBuffer stringBuffer = new StringBuffer("[" + objectArray[0]);
        for (int i = 1; i < objectArray.length; ++i) {
            stringBuffer.append(", ").append(objectArray[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static void writeArrayElements(Object[] objectArray, Logger logger, Level level) {
        if (objectArray == null || logger == null || !logger.isLoggable(level)) {
            return;
        }
        String string = FiddlerImpl.writeArrayElementsToString(objectArray);
        logger.log(level, string);
    }

    private static String writeGroupArrayToString(String[] stringArray) {
        if (stringArray == null) {
            return new String("[ALL_GROUPS]");
        }
        if (stringArray.length <= 0) {
            return new String("[]");
        }
        StringBuffer stringBuffer = null;
        stringBuffer = stringArray[0].compareTo("") == 0 ? new StringBuffer("[The PUBLIC Group") : new StringBuffer("[" + stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i].compareTo("") == 0) {
                stringBuffer.append(", The PUBLIC Group");
                continue;
            }
            stringBuffer.append(", ").append(stringArray[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static void writeGroupArray(String[] stringArray, Logger logger, Level level) {
        if (logger == null || !logger.isLoggable(level)) {
            return;
        }
        String string = FiddlerImpl.writeGroupArrayToString(stringArray);
        logger.log(level, string);
    }

    private static void writeRegistrarsArray(ServiceRegistrar[] serviceRegistrarArray, Logger logger, Level level) {
        LookupLocator lookupLocator;
        if (serviceRegistrarArray == null || logger == null || !logger.isLoggable(level)) {
            return;
        }
        if (serviceRegistrarArray.length == 0) {
            logger.log(level, "[NO REGISTRARS for Event]");
        }
        if (serviceRegistrarArray.length == 1) {
            try {
                lookupLocator = serviceRegistrarArray[0].getLocator();
                logger.log(level, "[" + lookupLocator + "]");
            }
            catch (SecurityException securityException) {
                logger.log(level, "[SecurityException]");
            }
            catch (Exception exception) {
                logger.log(level, "[Exception]");
            }
        }
        if (serviceRegistrarArray.length > 1) {
            try {
                lookupLocator = serviceRegistrarArray[0].getLocator();
                logger.log(level, "[" + lookupLocator + ",");
            }
            catch (SecurityException securityException) {
                logger.log(level, "[SecurityException,");
            }
            catch (Exception exception) {
                logger.log(level, "[Exception,");
            }
            for (int i = 1; i < serviceRegistrarArray.length - 1; ++i) {
                try {
                    LookupLocator lookupLocator2 = serviceRegistrarArray[i].getLocator();
                    logger.log(level, lookupLocator2 + ",");
                    continue;
                }
                catch (SecurityException securityException) {
                    logger.log(level, "SecurityException,");
                    continue;
                }
                catch (Exception exception) {
                    logger.log(level, "Exception,");
                }
            }
            try {
                LookupLocator lookupLocator3 = serviceRegistrarArray[serviceRegistrarArray.length - 1].getLocator();
                logger.log(level, lookupLocator3 + "]");
            }
            catch (SecurityException securityException) {
                logger.log(level, "SecurityException]");
            }
            catch (Exception exception) {
                logger.log(level, "Exception]");
            }
        }
    }

    private static void writeAttribute(Entry entry, Logger logger, Level level) {
        if (entry == null || logger == null || !logger.isLoggable(level)) {
            return;
        }
        if (entry instanceof BasicServiceType) {
            logger.log(level, "  attribute = BasicServiceType");
            logger.log(level, "    Display Name = " + ((BasicServiceType)entry).getDisplayName());
            logger.log(level, "    Description  = " + ((BasicServiceType)entry).getShortDescription());
        } else if (entry instanceof ServiceInfo) {
            logger.log(level, "  attribute = ServiceInfo");
            logger.log(level, "    Service Name         = " + ((ServiceInfo)entry).name);
            logger.log(level, "    Service Manufacturer = " + ((ServiceInfo)entry).manufacturer);
            logger.log(level, "    Service Vendor       = " + ((ServiceInfo)entry).vendor);
            logger.log(level, "    Service Version      = " + ((ServiceInfo)entry).version);
            logger.log(level, "    Service Model        = " + ((ServiceInfo)entry).model);
            logger.log(level, "    Service Serial #     = " + ((ServiceInfo)entry).serialNumber);
        } else {
            logger.log(level, "  attribute = " + entry);
        }
    }

    private static void writeAttributes(Entry[] entryArray, Logger logger, Level level) {
        if (entryArray == null || logger == null || !logger.isLoggable(level)) {
            return;
        }
        for (int i = 0; i < entryArray.length; ++i) {
            if (entryArray[i] == null) continue;
            FiddlerImpl.writeAttribute(entryArray[i], logger, level);
        }
        logger.log(level, "");
    }

    private void logInfoStartup() {
        if (startupLogger.isLoggable(Level.INFO)) {
            startupLogger.log(Level.INFO, "Fiddler started: {0}, {1}, {2}", new Object[]{this.serviceID.toString(), FiddlerImpl.writeGroupArrayToString(this.thisServicesGroups), FiddlerImpl.writeArrayElementsToString(this.thisServicesLocators)});
        }
        if (startupLogger.isLoggable(Level.CONFIG)) {
            if (this.persistDir != null) {
                startupLogger.log(Level.CONFIG, " Persistent state directory:  {0}", this.persistDir);
            }
            startupLogger.log(Level.CONFIG, "Attributes to register in each lookup service: ");
            FiddlerImpl.writeAttributes(this.thisServicesAttrs, startupLogger, Level.CONFIG);
        }
    }

    private void logInfoShutdown() {
        if (startupLogger.isLoggable(Level.INFO)) {
            startupLogger.log(Level.INFO, "Fiddler destroyed: {0}, {1}, {2}", new Object[]{this.serviceID.toString(), FiddlerImpl.writeGroupArrayToString(this.thisServicesGroups), FiddlerImpl.writeArrayElementsToString(this.thisServicesLocators)});
        }
    }

    private void logInfoTasks(String string) {
        if (tasksLogger.isLoggable(Level.FINEST)) {
            tasksLogger.log(Level.FINEST, string);
        }
    }

    private void logInfoEvents(String string) {
        if (eventsLogger.isLoggable(Level.FINE)) {
            eventsLogger.log(Level.FINE, string);
        }
    }

    private void logInfoEvents(Map map, long l, long l2, MarshalledObject marshalledObject, boolean bl, Logger logger, Level level) {
        if (logger == null || !logger.isLoggable(level)) {
            return;
        }
        String string = bl ? "DISCARDED" : "DISCOVERED";
        Object var11_9 = null;
        if (marshalledObject != null) {
            try {
                var11_9 = marshalledObject.get();
            }
            catch (ClassNotFoundException classNotFoundException) {
                problemLogger.log(Levels.HANDLED, "ClassNotFoundException when unmarshalling handback", classNotFoundException);
            }
            catch (IOException iOException) {
                problemLogger.log(Levels.HANDLED, "IOException when unmarshalling handback", iOException);
            }
        }
        logger.log(level, "\n" + string + " Event:");
        logger.log(level, "  EventID  = " + l);
        logger.log(level, "  SeqNum   = " + l2);
        logger.log(level, "  handback = " + var11_9);
        ServiceRegistrar[] serviceRegistrarArray = map.keySet().toArray(new ServiceRegistrar[map.size()]);
        logger.log(level, "  Registrars = ");
        FiddlerImpl.writeRegistrarsArray(serviceRegistrarArray, logger, level);
        for (int i = 0; i < serviceRegistrarArray.length; ++i) {
            String[] stringArray = (String[])map.get(serviceRegistrarArray[i]);
            logger.log(level, "  member groups [" + i + "] = ");
            FiddlerImpl.writeGroupArray(stringArray, logger, level);
        }
        logger.log(level, "");
    }

    private void logInfoGroups() {
        String[] stringArray = this.discoveryMgr.getGroups();
        if (groupsLogger.isLoggable(Level.FINER)) {
            groupsLogger.log(Level.FINER, "Group(s) over all registrations: ");
            FiddlerImpl.writeGroupArray(stringArray, groupsLogger, Level.FINER);
        }
    }

    private void logInfoGroups(String string) {
        if (string != null && groupsLogger.isLoggable(Level.FINER)) {
            groupsLogger.log(Level.FINER, string);
        }
        this.logInfoGroups();
    }

    private void logInfoLocators() {
        Object[] objectArray = this.discoveryMgr.getLocators();
        if (locatorsLogger.isLoggable(Level.FINER)) {
            locatorsLogger.log(Level.FINER, "Locator(s) over all registrations: ");
            FiddlerImpl.writeArrayElements(objectArray, locatorsLogger, Level.FINER);
        }
    }

    private void logInfoDiscard(String string, Uuid uuid) {
        if (string != null && uuid != null && discardLogger.isLoggable(Level.FINE)) {
            discardLogger.log(Level.FINE, string + " registrationID = " + uuid);
        }
    }

    private void logInfoDiscard(String string) {
        if (discardLogger.isLoggable(Level.FINE)) {
            discardLogger.log(Level.FINE, string);
        }
    }

    private void logInfoLease(String string, Uuid uuid, Uuid uuid2) {
        if (string != null && uuid != null && leaseLogger.isLoggable(Level.FINER)) {
            leaseLogger.log(Level.FINER, string + " (registrationID,leaseID) = (" + uuid + ", " + uuid2 + ")");
        }
    }

    private void logInfoRegistration(String string, Object object) {
        if (string != null && object != null && registrationLogger.isLoggable(Level.FINER)) {
            registrationLogger.log(Level.FINER, string + " {0}", object);
        }
    }

    private static void logInfoPersist(String string) {
        if (persistLogger.isLoggable(Level.FINEST)) {
            persistLogger.log(Level.FINEST, string);
        }
    }

    private void logInfoAddLogRecord(LogRecord logRecord) {
        if (!persistLogger.isLoggable(Level.FINEST)) {
            return;
        }
        String string = "Logging a state change: Unknown log record instance";
        if (logRecord instanceof LookupAttrsAddedLogObj) {
            string = "Logging state change: lookup attributes added";
        } else if (logRecord instanceof LookupAttrsModifiedLogObj) {
            string = "Logging state change: lookup attributes modified";
        } else if (logRecord instanceof LookupGroupsChangedLogObj) {
            string = "Logging state change: groups to join changed to " + FiddlerImpl.writeGroupArrayToString(this.thisServicesGroups);
        } else if (logRecord instanceof LookupLocatorsChangedLogObj) {
            string = "Logging state change: locators to join changed to " + FiddlerImpl.writeArrayElementsToString(this.thisServicesLocators);
        } else if (logRecord instanceof LeaseBoundSetLogObj) {
            string = "Logging state change: lease duration bound changed";
        } else if (logRecord instanceof SnapshotWeightSetLogObj) {
            string = "Logging state change: snapshot weight factor changed";
        } else if (logRecord instanceof SnapshotThresholdSetLogObj) {
            string = "Logging state change: log-to-snapshot threshold changed";
        } else if (logRecord instanceof RegistrationGrantedLogObj) {
            string = "Logging state change: new registration granted";
        } else if (logRecord instanceof GroupsAddedToRegistrationLogObj) {
            string = "Logging state change: added new groups to registration's set of groups to discover";
        } else if (logRecord instanceof GroupsSetInRegistrationLogObj) {
            string = "Logging state change: replaced registration's set of groups to discover";
        } else if (logRecord instanceof GroupsRemovedFromRegistrationLogObj) {
            string = "Logging state change: removed groups from registration's set of groups to discover";
        } else if (logRecord instanceof LocsAddedToRegistrationLogObj) {
            string = "Logging state change: added new locators to registration's set of locators to discover";
        } else if (logRecord instanceof LocsSetInRegistrationLogObj) {
            string = "Logging state change: replaced registration's set of locators to discover";
        } else if (logRecord instanceof LocsRemovedFromRegistrationLogObj) {
            string = "Logging state change: removed locators from registration's set of locators to discover";
        } else if (logRecord instanceof LeaseRenewedLogObj) {
            string = "Logging state change: registration's lease renewed";
        } else if (logRecord instanceof LeasesRenewedLogObj) {
            string = "Logging state change: set of leases renewed for a set of registrations";
        } else if (logRecord instanceof LeaseCancelledLogObj) {
            string = "Logging state change: registration's lease cancelled";
        } else if (logRecord instanceof LeasesCancelledLogObj) {
            string = "Logging state change: set of leases cancelled for a set of registrations";
        }
        FiddlerImpl.logInfoPersist(string);
    }

    static /* synthetic */ Object access$3500(FiddlerImpl fiddlerImpl) {
        return fiddlerImpl.snapshotThreadSyncObj;
    }

    static /* synthetic */ int access$3702(FiddlerImpl fiddlerImpl, int n) {
        fiddlerImpl.logFileSize = n;
        return fiddlerImpl.logFileSize;
    }

    static /* synthetic */ Entry[] access$5102(FiddlerImpl fiddlerImpl, Entry[] entryArray) {
        fiddlerImpl.thisServicesAttrs = entryArray;
        return entryArray;
    }

    static /* synthetic */ String[] access$5202(FiddlerImpl fiddlerImpl, String[] stringArray) {
        fiddlerImpl.thisServicesGroups = stringArray;
        return stringArray;
    }

    static /* synthetic */ LookupLocator[] access$5302(FiddlerImpl fiddlerImpl, LookupLocator[] lookupLocatorArray) {
        fiddlerImpl.thisServicesLocators = lookupLocatorArray;
        return lookupLocatorArray;
    }

    private static class LeasesCancelledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid[] registrationIDs;
        private Uuid[] leaseIDs;

        public LeasesCancelledLogObj(Uuid[] uuidArray, Uuid[] uuidArray2) {
            this.registrationIDs = uuidArray;
            this.leaseIDs = uuidArray2;
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply cancelling leases corresponding to " + this.registrationIDs.length + " registration IDs");
            fiddlerImpl.cancelLeasesDo(this.registrationIDs, this.leaseIDs);
        }
    }

    private static class LeaseCancelledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid registrationID;
        private Uuid leaseID;

        public LeaseCancelledLogObj(Uuid uuid, Uuid uuid2) {
            this.registrationID = uuid;
            this.leaseID = uuid2;
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            try {
                FiddlerImpl.logInfoPersist("Log recovery: apply cancelling lease for registration\n              (ID = " + this.registrationID + ")");
                fiddlerImpl.cancelLeaseDo(this.registrationID, fiddlerImpl.registrationByID, this.leaseID);
            }
            catch (IOException iOException) {
                if (problemLogger.isLoggable(Level.SEVERE)) {
                    problemLogger.log(Level.SEVERE, "During log recovery (apply cancelLease) -- failure in multicast request protocol\n", iOException);
                }
                fiddlerImpl.destroyDo();
            }
            catch (UnknownLeaseException unknownLeaseException) {
                // empty catch block
            }
        }
    }

    private static class LeasesRenewedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid[] registrationIDs;
        private Uuid[] leaseIDs;
        private long[] expirations;

        public LeasesRenewedLogObj(Uuid[] uuidArray, Uuid[] uuidArray2, long[] lArray) {
            this.registrationIDs = uuidArray;
            this.leaseIDs = uuidArray2;
            this.expirations = lArray;
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply renewing leases corresponding to " + this.registrationIDs.length + " registration IDs");
            fiddlerImpl.renewLeasesAbs(this.registrationIDs, this.leaseIDs, this.expirations);
        }
    }

    private static class LeaseRenewedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid registrationID;
        private Uuid leaseID;
        private long expiration;

        public LeaseRenewedLogObj(Uuid uuid, Uuid uuid2, long l) {
            this.registrationID = uuid;
            this.leaseID = uuid2;
            this.expiration = l;
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply renewing lease for registration\n              (ID = " + this.registrationID + ")");
            fiddlerImpl.renewLeaseAbs(this.registrationID, fiddlerImpl.registrationByID, this.leaseID, this.expiration);
        }
    }

    private static class LocsRemovedFromRegistrationLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid registrationID;
        private LookupLocator[] locators;

        public LocsRemovedFromRegistrationLogObj(Uuid uuid, LookupLocator[] lookupLocatorArray) {
            this.registrationID = uuid;
            this.locators = lookupLocatorArray;
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply removing from locators to discover for registration\n              (ID = " + this.registrationID + ") ...");
            int n = this.locators.length;
            this.locators = FiddlerImpl.prepareOldLocators(recoveredLocatorToDiscoverPreparer, this.locators);
            if (n == this.locators.length) {
                fiddlerImpl.removeLocatorsDo(this.registrationID, fiddlerImpl.registrationByID, this.locators);
            } else {
                if (problemLogger.isLoggable(Level.WARNING)) {
                    problemLogger.log(Level.WARNING, "failure preparing locator while recoveringLocsRemovedFromRegistrationLogObj ... removing registration with ID = " + this.registrationID);
                }
                try {
                    fiddlerImpl.removeRegistration((RegistrationInfo)fiddlerImpl.registrationByID.get(this.registrationID));
                }
                catch (IOException iOException) {
                    String string = "failure removing registration (ID = " + this.registrationID + ") after locator preparation failure";
                    if (problemLogger.isLoggable(Level.WARNING)) {
                        problemLogger.log(Level.WARNING, string, iOException);
                    }
                    Entry[] entryArray = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment(string)};
                    fiddlerImpl.joinMgr.addAttributes(entryArray, true);
                }
            }
        }
    }

    private static class LocsSetInRegistrationLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid registrationID;
        private LookupLocator[] locators;

        public LocsSetInRegistrationLogObj(Uuid uuid, LookupLocator[] lookupLocatorArray) {
            this.registrationID = uuid;
            this.locators = lookupLocatorArray;
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply replacing locators to discover for registration\n              (ID = " + this.registrationID + ")");
            int n = this.locators.length;
            this.locators = FiddlerImpl.prepareOldLocators(recoveredLocatorToDiscoverPreparer, this.locators);
            if (n == this.locators.length) {
                fiddlerImpl.setLocatorsDo(this.registrationID, fiddlerImpl.registrationByID, this.locators);
            } else {
                if (problemLogger.isLoggable(Level.WARNING)) {
                    problemLogger.log(Level.WARNING, "failure preparing locator while recovering LocsSetInRegistrationLogObj ... removing registration with ID = " + this.registrationID);
                }
                try {
                    fiddlerImpl.removeRegistration((RegistrationInfo)fiddlerImpl.registrationByID.get(this.registrationID));
                }
                catch (IOException iOException) {
                    String string = "failure removing registration (ID = " + this.registrationID + ") after locator preparation failure";
                    if (problemLogger.isLoggable(Level.WARNING)) {
                        problemLogger.log(Level.WARNING, string, iOException);
                    }
                    Entry[] entryArray = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment(string)};
                    fiddlerImpl.joinMgr.addAttributes(entryArray, true);
                }
            }
        }
    }

    private static class LocsAddedToRegistrationLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid registrationID;
        private LookupLocator[] locators;

        public LocsAddedToRegistrationLogObj(Uuid uuid, LookupLocator[] lookupLocatorArray) {
            this.registrationID = uuid;
            this.locators = lookupLocatorArray;
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply adding to locators to discover for registration\n              (ID = " + this.registrationID + ")");
            int n = this.locators.length;
            this.locators = FiddlerImpl.prepareOldLocators(recoveredLocatorToDiscoverPreparer, this.locators);
            if (n == this.locators.length) {
                fiddlerImpl.addLocatorsDo(this.registrationID, fiddlerImpl.registrationByID, this.locators);
            } else {
                if (problemLogger.isLoggable(Level.WARNING)) {
                    problemLogger.log(Level.WARNING, "failure preparing locator while recovering LocsAddedToRegistrationLogObj ... removing registration with ID = " + this.registrationID);
                }
                try {
                    fiddlerImpl.removeRegistration((RegistrationInfo)fiddlerImpl.registrationByID.get(this.registrationID));
                }
                catch (IOException iOException) {
                    String string = "failure removing registration (ID = " + this.registrationID + ") after locator preparation failure";
                    if (problemLogger.isLoggable(Level.INFO)) {
                        problemLogger.log(Level.INFO, string, iOException);
                    }
                    Entry[] entryArray = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment(string)};
                    fiddlerImpl.joinMgr.addAttributes(entryArray, true);
                }
            }
        }
    }

    private static class GroupsRemovedFromRegistrationLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid registrationID;
        private String[] groups;

        public GroupsRemovedFromRegistrationLogObj(Uuid uuid, String[] stringArray) {
            this.registrationID = uuid;
            this.groups = stringArray;
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply removing from groups to discover for registration\n              (ID = " + this.registrationID + ")");
            try {
                fiddlerImpl.removeGroupsDo(this.registrationID, fiddlerImpl.registrationByID, this.groups);
            }
            catch (Exception exception) {
                if (problemLogger.isLoggable(Level.SEVERE)) {
                    problemLogger.log(Level.SEVERE, "Failure during log recovery (apply removeGroups) -- \n", exception);
                }
                fiddlerImpl.destroyDo();
            }
        }
    }

    private static class GroupsSetInRegistrationLogObj
    implements LogRecord {
        static final long serialVersionUID = 2L;
        private Uuid registrationID;
        private String[] groups;

        public GroupsSetInRegistrationLogObj(Uuid uuid, String[] stringArray) {
            this.registrationID = uuid;
            this.groups = stringArray;
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply replacing groups to discover for registration\n              (ID = " + this.registrationID + ") ...");
            try {
                fiddlerImpl.setGroupsDo(this.registrationID, fiddlerImpl.registrationByID, this.groups);
            }
            catch (Exception exception) {
                if (problemLogger.isLoggable(Level.SEVERE)) {
                    problemLogger.log(Level.SEVERE, "Failure during log recovery (apply setGroups) -- \n", exception);
                }
                fiddlerImpl.destroyDo();
            }
        }
    }

    private static class GroupsAddedToRegistrationLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Uuid registrationID;
        private String[] groups;

        public GroupsAddedToRegistrationLogObj(Uuid uuid, String[] stringArray) {
            this.registrationID = uuid;
            this.groups = stringArray;
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply adding to groups to discover for registration\n              (ID = " + this.registrationID + ")");
            try {
                fiddlerImpl.addGroupsDo(this.registrationID, fiddlerImpl.registrationByID, this.groups);
            }
            catch (Exception exception) {
                if (problemLogger.isLoggable(Level.SEVERE)) {
                    problemLogger.log(Level.SEVERE, "During log recovery (apply addGroupsDO) -- failure in multicast request protocol\n", exception);
                }
                fiddlerImpl.destroyDo();
            }
        }
    }

    private static class RegistrationGrantedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 3983963008572188308L;
        private RegistrationInfo regInfo;

        public RegistrationGrantedLogObj(RegistrationInfo registrationInfo) {
            this.regInfo = registrationInfo;
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply recording granted registration info\n              (ID = " + this.regInfo.registrationID + ")");
            this.regInfo.seqNum += Integer.MAX_VALUE;
            try {
                fiddlerImpl.addRegistration(this.regInfo);
            }
            catch (IOException iOException) {
                if (problemLogger.isLoggable(Level.SEVERE)) {
                    problemLogger.log(Level.SEVERE, "During log recovery (apply addRegistration) -- failure in multicast request protocol\n", iOException);
                }
                fiddlerImpl.destroyDo();
            }
            fiddlerImpl.curEventID++;
        }
    }

    private static class SnapshotThresholdSetLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2952948867001823559L;
        private int newThreshold;

        public SnapshotThresholdSetLogObj(int n) {
            this.newThreshold = n;
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply changing log-to-snapshot threshold");
            fiddlerImpl.snapshotThresh = this.newThreshold;
        }
    }

    private static class SnapshotWeightSetLogObj
    implements LogRecord {
        private static final long serialVersionUID = -4079318959709953285L;
        private float newWeight;

        public SnapshotWeightSetLogObj(float f) {
            this.newWeight = f;
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply changing snapshot weight factor");
            fiddlerImpl.snapshotWt = this.newWeight;
        }
    }

    private static class LeaseBoundSetLogObj
    implements LogRecord {
        private static final long serialVersionUID = 6084059678114714281L;
        private long newLeaseBound;

        public LeaseBoundSetLogObj(long l) {
            this.newLeaseBound = l;
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply changing lease duration bound");
            fiddlerImpl.leaseBound = this.newLeaseBound;
        }
    }

    private static class LookupLocatorsChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 6448427261140043291L;
        private LookupLocator[] locators;

        public LookupLocatorsChangedLogObj(LookupLocator[] lookupLocatorArray) {
            this.locators = lookupLocatorArray;
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply changing lookup locators to join");
            FiddlerImpl.access$5302(fiddlerImpl, FiddlerImpl.prepareOldLocators(recoveredLocatorToJoinPreparer, this.locators));
        }
    }

    private static class LookupGroupsChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = -6973676200404539919L;
        private String[] groups;

        public LookupGroupsChangedLogObj(String[] stringArray) {
            this.groups = stringArray;
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply changing lookup groups to join");
            FiddlerImpl.access$5202(fiddlerImpl, this.groups);
        }
    }

    private static class LookupAttrsModifiedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2671139518188470469L;
        private MarshalledObject[] marshalledAttrTmpls;
        private MarshalledObject[] marshalledModAttrs;

        public LookupAttrsModifiedLogObj(FiddlerImpl fiddlerImpl, Entry[] entryArray, Entry[] entryArray2) {
            this.marshalledAttrTmpls = FiddlerImpl.marshalAttributes(fiddlerImpl, entryArray);
            this.marshalledModAttrs = FiddlerImpl.marshalAttributes(fiddlerImpl, entryArray2);
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply modifying lookup attributes");
            Entry[] entryArray = FiddlerImpl.unmarshalAttributes(fiddlerImpl, this.marshalledAttrTmpls);
            Entry[] entryArray2 = FiddlerImpl.unmarshalAttributes(fiddlerImpl, this.marshalledModAttrs);
            FiddlerImpl.access$5102(fiddlerImpl, LookupAttributes.modify(fiddlerImpl.thisServicesAttrs, entryArray, entryArray2));
        }
    }

    private static class LookupAttrsAddedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 4983778026976938585L;
        private MarshalledObject[] marshalledAttrs;

        public LookupAttrsAddedLogObj(FiddlerImpl fiddlerImpl, Entry[] entryArray) {
            this.marshalledAttrs = FiddlerImpl.marshalAttributes(fiddlerImpl, entryArray);
        }

        public void apply(FiddlerImpl fiddlerImpl) {
            FiddlerImpl.logInfoPersist("Log recovery: apply adding lookup attributes");
            Entry[] entryArray = FiddlerImpl.unmarshalAttributes(fiddlerImpl, this.marshalledAttrs);
            FiddlerImpl.access$5102(fiddlerImpl, LookupAttributes.add(fiddlerImpl.thisServicesAttrs, entryArray));
        }
    }

    private static interface LogRecord
    extends Serializable {
        public void apply(FiddlerImpl var1);
    }

    private class DestroyThread
    extends Thread {
        private static final long MAX_UNEXPORT_DELAY = 120000L;

        public DestroyThread() {
            super("destroy");
            this.setDaemon(false);
        }

        public void run() {
            if (FiddlerImpl.this.activationID != null) {
                try {
                    FiddlerImpl.this.activationSystem.unregisterObject(FiddlerImpl.this.activationID);
                }
                catch (RemoteException remoteException) {
                    return;
                }
                catch (ActivationException activationException) {
                    // empty catch block
                }
            }
            long l = System.currentTimeMillis() + 120000L;
            boolean bl = false;
            while (!bl && System.currentTimeMillis() < l) {
                bl = FiddlerImpl.this.serverExporter.unexport(false);
                if (bl) continue;
                Thread.yield();
            }
            if (!bl) {
                FiddlerImpl.this.serverExporter.unexport(true);
            }
            FiddlerImpl.this.leaseExpireThread.interrupt();
            if (FiddlerImpl.this.log != null) {
                FiddlerImpl.this.snapshotThread.interrupt();
            }
            FiddlerImpl.this.taskMgr.terminate();
            FiddlerImpl.this.joinMgr.terminate();
            FiddlerImpl.this.joinMgrLDM.terminate();
            FiddlerImpl.this.discoveryMgr.terminate();
            try {
                FiddlerImpl.this.leaseExpireThread.join();
                if (FiddlerImpl.this.log != null) {
                    FiddlerImpl.this.snapshotThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (FiddlerImpl.this.log != null) {
                FiddlerImpl.this.log.deletePersistentStore();
            }
            if (FiddlerImpl.this.activationID != null) {
                try {
                    ActivationGroup.inactive((ActivationID)FiddlerImpl.this.activationID, (Exporter)FiddlerImpl.this.serverExporter);
                }
                catch (RemoteException remoteException) {
                }
                catch (ActivationException activationException) {}
            } else if (FiddlerImpl.this.lifeCycle != null) {
                FiddlerImpl.this.lifeCycle.unregister(FiddlerImpl.this);
            }
            if (FiddlerImpl.this.loginContext != null) {
                try {
                    FiddlerImpl.this.loginContext.logout();
                }
                catch (Exception exception) {
                    startupLogger.log(Level.INFO, "Problem logging out of JAAS login session", exception);
                }
            }
            FiddlerImpl.this.logInfoShutdown();
        }
    }

    private class SnapshotThread
    extends Thread {
        private boolean interrupted;

        public SnapshotThread() {
            super("snapshot thread");
            this.interrupted = false;
            this.setDaemon(true);
        }

        public synchronized void interrupt() {
            this.interrupted = true;
            super.interrupt();
        }

        public synchronized boolean isInterrupted() {
            return this.interrupted;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class LeaseExpireThread
    extends Thread {
        private boolean interrupted;

        public LeaseExpireThread() {
            super("lease expire");
            this.interrupted = false;
            this.setDaemon(true);
        }

        public synchronized void interrupt() {
            this.interrupted = true;
            super.interrupt();
        }

        public synchronized boolean isInterrupted() {
            return this.interrupted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                FiddlerImpl.this.concurrentObj.writeLock();
            }
            catch (ReadersWriter.ConcurrentLockException concurrentLockException) {
                return;
            }
            try {
                while (!this.isInterrupted()) {
                    long l = System.currentTimeMillis();
                    FiddlerImpl.this.minExpiration = Long.MAX_VALUE;
                    while (!FiddlerImpl.this.registrationByTime.isEmpty()) {
                        RegistrationInfo registrationInfo = (RegistrationInfo)FiddlerImpl.this.registrationByTime.firstKey();
                        if (registrationInfo.leaseExpiration > l) {
                            FiddlerImpl.this.minExpiration = registrationInfo.leaseExpiration;
                            break;
                        }
                        try {
                            FiddlerImpl.this.removeRegistration(registrationInfo);
                        }
                        catch (IOException iOException) {
                            String string = "Failure while removing registration (ID = " + registrationInfo.registrationID + ") from service state";
                            if (problemLogger.isLoggable(Level.INFO)) {
                                problemLogger.log(Level.INFO, string, iOException);
                            }
                            Entry[] entryArray = new Entry[]{new FiddlerStatus(StatusType.ERROR), new Comment(string)};
                            FiddlerImpl.this.joinMgr.addAttributes(entryArray, true);
                        }
                    }
                    try {
                        FiddlerImpl.this.concurrentObj.writerWait(FiddlerImpl.this.leaseExpireThreadSyncObj, FiddlerImpl.this.minExpiration - l);
                    }
                    catch (ReadersWriter.ConcurrentLockException concurrentLockException) {
                        Object var8_8 = null;
                        FiddlerImpl.this.concurrentObj.writeUnlock();
                        return;
                    }
                }
                Object var8_9 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
                throw throwable;
            }
        }
    }

    private class LocalLogHandler
    extends LogHandler {
        public void snapshot(OutputStream outputStream) throws IOException {
            FiddlerImpl.this.takeSnapshot(outputStream);
        }

        public void recover(InputStream inputStream) throws IOException, ClassNotFoundException {
            FiddlerImpl.this.recoverSnapshot(inputStream);
        }

        public void applyUpdate(Object object) {
            ((LogRecord)object).apply(FiddlerImpl.this);
        }
    }

    private final class SendEventTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;
        public final RemoteDiscoveryEvent event;

        public SendEventTask(RegistrationInfo registrationInfo, RemoteDiscoveryEvent remoteDiscoveryEvent) {
            this.regInfo = registrationInfo;
            this.event = remoteDiscoveryEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.regInfo.listener.notify((RemoteEvent)this.event);
            }
            catch (Throwable throwable) {
                problemLogger.log(Level.INFO, "Exception in SendEventTask", throwable);
                switch (ThrowableConstants.retryable(throwable)) {
                    case 2: {
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                    }
                    case 1: 
                    case 3: {
                        FiddlerImpl.this.concurrentObj.writeLock();
                        try {
                            try {
                                FiddlerImpl.this.logInfoEvents("  Cancelling lease on registration:  (registrationID,leaseID) = (" + this.regInfo.registrationID + ", " + this.regInfo.leaseID + ")");
                                FiddlerImpl.this.cancelLeaseDo(this.regInfo, this.regInfo.leaseID);
                                FiddlerImpl.this.addLogRecord(new LeaseCancelledLogObj(this.regInfo.registrationID, this.regInfo.leaseID));
                            }
                            catch (UnknownLeaseException unknownLeaseException) {
                            }
                            catch (IOException iOException) {
                            }
                            Object var4_4 = null;
                            FiddlerImpl.this.concurrentObj.writeUnlock();
                            break;
                        }
                        catch (Throwable throwable2) {
                            Object var4_5 = null;
                            FiddlerImpl.this.concurrentObj.writeUnlock();
                            throw throwable2;
                        }
                    }
                }
            }
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private final class RemoveLocatorsTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;
        public final LookupLocator[] locators;

        public RemoveLocatorsTask(RegistrationInfo registrationInfo, LookupLocator[] lookupLocatorArray) {
            this.regInfo = registrationInfo;
            this.locators = lookupLocatorArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            try {
                if (this.locators.length == 0) {
                    Object var7_1 = null;
                    FiddlerImpl.this.concurrentObj.writeUnlock();
                    return;
                }
                FiddlerImpl.this.logInfoTasks("RemoveLocatorsTask.run(): removing locators from the registration's current locator set");
                HashMap hashMap = FiddlerImpl.this.getDesiredRegsByLocator(this.regInfo);
                this.removeRegInfoLocators(this.regInfo, this.locators);
                Map map = FiddlerImpl.getUndesiredRegsByLocator(hashMap, this.regInfo);
                HashMap<ServiceRegistrar, String[]> hashMap2 = new HashMap<ServiceRegistrar, String[]>(map.size());
                Object object = map.keySet().iterator();
                while (object.hasNext()) {
                    ServiceRegistrar serviceRegistrar = (ServiceRegistrar)object.next();
                    this.regInfo.discoveredRegsMap.remove(serviceRegistrar);
                    hashMap2.put(serviceRegistrar, ((LocatorGroupsStruct)((FiddlerImpl)FiddlerImpl.this).allDiscoveredRegs.get((Object)serviceRegistrar)).groups);
                }
                object = FiddlerImpl.this.buildEvent(this.regInfo, hashMap2, true);
                if (object != null) {
                    FiddlerImpl.this.queueEvent(this.regInfo, object);
                    FiddlerImpl.this.logInfoEvents("SetLocatorsTask.run(): DISCARDED Event was SENT\n");
                }
                FiddlerImpl.this.updateDiscoveryMgrLocators();
            }
            catch (Throwable throwable) {
                Object var7_3 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
                throw throwable;
            }
            Object var7_2 = null;
            FiddlerImpl.this.concurrentObj.writeUnlock();
        }

        private void removeRegInfoLocators(RegistrationInfo registrationInfo, LookupLocator[] lookupLocatorArray) {
            HashSet<LookupLocator> hashSet = new HashSet<LookupLocator>();
            for (int i = 0; i < lookupLocatorArray.length; ++i) {
                hashSet.add(lookupLocatorArray[i]);
            }
            registrationInfo.locators.removeAll(hashSet);
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private final class SetLocatorsTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;
        public final LookupLocator[] locators;

        public SetLocatorsTask(RegistrationInfo registrationInfo, LookupLocator[] lookupLocatorArray) {
            this.regInfo = registrationInfo;
            this.locators = lookupLocatorArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            try {
                if (this.locators.length == 0) {
                    Object var10_1 = null;
                    FiddlerImpl.this.concurrentObj.writeUnlock();
                    return;
                }
                FiddlerImpl.this.logInfoTasks("SetLocatorsTask.run(): setting the registration's locators");
                HashMap hashMap = FiddlerImpl.this.getDesiredRegsByLocator(this.regInfo);
                this.setRegInfoLocators(this.regInfo, this.locators);
                HashMap hashMap2 = FiddlerImpl.this.getDesiredRegsByLocator(this.regInfo);
                HashMap hashMap3 = this.regInfo.addToDiscoveredRegs(hashMap2);
                RemoteDiscoveryEvent remoteDiscoveryEvent = FiddlerImpl.this.buildEvent(this.regInfo, hashMap3, false);
                if (remoteDiscoveryEvent != null) {
                    FiddlerImpl.this.queueEvent(this.regInfo, remoteDiscoveryEvent);
                    FiddlerImpl.this.logInfoEvents("SetLocatorsTask.run(): DISCOVERED Event was SENT\n");
                }
                Map map = FiddlerImpl.getUndesiredRegsByLocator(hashMap, this.regInfo);
                HashMap<ServiceRegistrar, String[]> hashMap4 = new HashMap<ServiceRegistrar, String[]>(map.size());
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    ServiceRegistrar serviceRegistrar = (ServiceRegistrar)iterator.next();
                    this.regInfo.discoveredRegsMap.remove(serviceRegistrar);
                    hashMap4.put(serviceRegistrar, ((LocatorGroupsStruct)((FiddlerImpl)FiddlerImpl.this).allDiscoveredRegs.get((Object)serviceRegistrar)).groups);
                }
                remoteDiscoveryEvent = FiddlerImpl.this.buildEvent(this.regInfo, hashMap4, true);
                if (remoteDiscoveryEvent != null) {
                    FiddlerImpl.this.queueEvent(this.regInfo, remoteDiscoveryEvent);
                    FiddlerImpl.this.logInfoEvents("SetLocatorsTask.run(): DISCARDED Event was SENT\n");
                }
                FiddlerImpl.this.updateDiscoveryMgrLocators();
            }
            catch (Throwable throwable) {
                Object var10_3 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
                throw throwable;
            }
            Object var10_2 = null;
            FiddlerImpl.this.concurrentObj.writeUnlock();
        }

        private void setRegInfoLocators(RegistrationInfo registrationInfo, LookupLocator[] lookupLocatorArray) {
            HashSet<LookupLocator> hashSet = new HashSet<LookupLocator>();
            for (int i = 0; i < lookupLocatorArray.length; ++i) {
                hashSet.add(lookupLocatorArray[i]);
            }
            if (registrationInfo.locators == null) {
                registrationInfo.locators = new HashSet();
            } else {
                registrationInfo.locators.clear();
            }
            registrationInfo.locators.addAll(hashSet);
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private final class AddLocatorsTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;
        public final LookupLocator[] locators;

        public AddLocatorsTask(RegistrationInfo registrationInfo, LookupLocator[] lookupLocatorArray) {
            this.regInfo = registrationInfo;
            this.locators = lookupLocatorArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            try {
                HashSet hashSet = this.addRegInfoLocators(this.regInfo, this.locators);
                if (hashSet.size() > 0) {
                    FiddlerImpl.this.logInfoTasks("AddLocatorsTask.run(): adding to the registration's locators");
                    HashMap hashMap = FiddlerImpl.this.getDesiredRegsByLocator(this.regInfo);
                    HashMap hashMap2 = this.regInfo.addToDiscoveredRegs(hashMap);
                    RemoteDiscoveryEvent remoteDiscoveryEvent = FiddlerImpl.this.buildEvent(this.regInfo, hashMap2, false);
                    if (remoteDiscoveryEvent != null) {
                        FiddlerImpl.this.queueEvent(this.regInfo, remoteDiscoveryEvent);
                        FiddlerImpl.this.logInfoEvents("AddLocatorsTask.run(): DISCOVERED Event was SENT\n");
                    }
                    FiddlerImpl.this.updateDiscoveryMgrLocators();
                }
                Object var6_5 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
                throw throwable;
            }
        }

        private HashSet addRegInfoLocators(RegistrationInfo registrationInfo, LookupLocator[] lookupLocatorArray) {
            HashSet<LookupLocator> hashSet = new HashSet<LookupLocator>(1);
            for (int i = 0; i < lookupLocatorArray.length; ++i) {
                hashSet.add(lookupLocatorArray[i]);
            }
            if (hashSet.size() > 0) {
                registrationInfo.locators.addAll(hashSet);
            }
            return hashSet;
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private final class RemoveGroupsTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;
        public final String[] groups;

        public RemoveGroupsTask(RegistrationInfo registrationInfo, String[] stringArray) {
            this.regInfo = registrationInfo;
            this.groups = stringArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            try {
                if (this.groups.length == 0) {
                    Object var5_1 = null;
                    FiddlerImpl.this.concurrentObj.writeUnlock();
                    return;
                }
                FiddlerImpl.this.logInfoTasks("RemoveGroupsTask.run(): removing groups from the registration's current group set");
                HashMap hashMap = FiddlerImpl.this.getDesiredRegsByGroup(this.regInfo);
                this.removeRegInfoGroups(this.regInfo, this.groups);
                HashMap hashMap2 = FiddlerImpl.getUndesiredRegsByGroup(hashMap, this.regInfo);
                Object object = hashMap2.keySet().iterator();
                while (object.hasNext()) {
                    this.regInfo.discoveredRegsMap.remove(object.next());
                }
                object = FiddlerImpl.this.buildEvent(this.regInfo, hashMap2, true);
                if (object != null) {
                    FiddlerImpl.this.queueEvent(this.regInfo, object);
                    FiddlerImpl.this.logInfoEvents("RemoveGroupsTask.run(): DISCARDED Event was SENT\n");
                }
                FiddlerImpl.this.updateDiscoveryMgrGroups();
            }
            catch (Throwable throwable) {
                Object var5_3 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
                throw throwable;
            }
            Object var5_2 = null;
            FiddlerImpl.this.concurrentObj.writeUnlock();
        }

        private void removeRegInfoGroups(RegistrationInfo registrationInfo, String[] stringArray) {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
            registrationInfo.groups.removeAll(hashSet);
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private final class SetGroupsTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;
        public final String[] groups;

        public SetGroupsTask(RegistrationInfo registrationInfo, String[] stringArray) {
            this.regInfo = registrationInfo;
            this.groups = stringArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            try {
                FiddlerImpl.this.logInfoTasks("SetGroupsTask.run(): setting the registration's groups");
                HashMap hashMap = FiddlerImpl.this.getDesiredRegsByGroup(this.regInfo);
                this.setRegInfoGroups(this.regInfo, this.groups);
                HashMap hashMap2 = FiddlerImpl.this.getDesiredRegsByGroup(this.regInfo);
                HashMap hashMap3 = this.regInfo.addToDiscoveredRegs(hashMap2);
                RemoteDiscoveryEvent remoteDiscoveryEvent = FiddlerImpl.this.buildEvent(this.regInfo, hashMap3, false);
                if (remoteDiscoveryEvent != null) {
                    FiddlerImpl.this.queueEvent(this.regInfo, remoteDiscoveryEvent);
                    FiddlerImpl.this.logInfoEvents("SetGroupsTask.run(): DISCOVERED Event was SENT\n");
                }
                HashMap hashMap4 = FiddlerImpl.getUndesiredRegsByGroup(hashMap, this.regInfo);
                Iterator iterator = hashMap4.keySet().iterator();
                while (iterator.hasNext()) {
                    this.regInfo.discoveredRegsMap.remove(iterator.next());
                }
                remoteDiscoveryEvent = FiddlerImpl.this.buildEvent(this.regInfo, hashMap4, true);
                if (remoteDiscoveryEvent != null) {
                    FiddlerImpl.this.queueEvent(this.regInfo, remoteDiscoveryEvent);
                    FiddlerImpl.this.logInfoEvents("SetGroupsTask.run(): DISCARDED Event was SENT\n");
                }
                FiddlerImpl.this.updateDiscoveryMgrGroups();
                Object var8_7 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
                throw throwable;
            }
        }

        private void setRegInfoGroups(RegistrationInfo registrationInfo, String[] stringArray) {
            if (stringArray == DiscoveryGroupManagement.ALL_GROUPS) {
                registrationInfo.groups = null;
            } else {
                HashSet<String> hashSet = new HashSet<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
                if (registrationInfo.groups == null) {
                    registrationInfo.groups = new HashSet();
                } else {
                    registrationInfo.groups.clear();
                }
                registrationInfo.groups.addAll(hashSet);
            }
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private final class AddGroupsTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;
        public final String[] groups;

        public AddGroupsTask(RegistrationInfo registrationInfo, String[] stringArray) {
            this.regInfo = registrationInfo;
            this.groups = stringArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            try {
                HashSet hashSet = this.addRegInfoGroups(this.regInfo, this.groups);
                if (hashSet.size() > 0) {
                    FiddlerImpl.this.logInfoTasks("AddGroupsTask.run(): adding to the registration's groups");
                    HashMap hashMap = FiddlerImpl.this.getDesiredRegsByGroup(this.regInfo);
                    HashMap hashMap2 = this.regInfo.addToDiscoveredRegs(hashMap);
                    RemoteDiscoveryEvent remoteDiscoveryEvent = FiddlerImpl.this.buildEvent(this.regInfo, hashMap2, false);
                    if (remoteDiscoveryEvent != null) {
                        FiddlerImpl.this.queueEvent(this.regInfo, remoteDiscoveryEvent);
                        FiddlerImpl.this.logInfoEvents("AddGroupsTask.run(): DISCOVERED Event was SENT\n");
                    }
                    FiddlerImpl.this.updateDiscoveryMgrGroups();
                }
                Object var6_5 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
                throw throwable;
            }
        }

        private HashSet addRegInfoGroups(RegistrationInfo registrationInfo, String[] stringArray) {
            HashSet<String> hashSet = new HashSet<String>(1);
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
            if (hashSet.size() > 0) {
                registrationInfo.groups.addAll(hashSet);
            }
            return hashSet;
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private final class ChangedEventTask
    implements TaskManager.Task {
        public final DiscoveryEvent event;

        public ChangedEventTask(DiscoveryEvent discoveryEvent) {
            this.event = discoveryEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            FiddlerImpl.this.logInfoTasks("ChangedEventTask.run(): processing CHANGED event from discovery manager");
            try {
                Object object;
                Map map = this.event.getGroups();
                HashSet hashSet = new HashSet(map.size());
                HashMap<ServiceRegistrar, LookupLocator> hashMap = new HashMap<ServiceRegistrar, LookupLocator>(map.size());
                Iterator<Object> iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    object = (ServiceRegistrar)iterator.next();
                    hashMap.put((ServiceRegistrar)object, ((LocatorGroupsStruct)((FiddlerImpl)FiddlerImpl.this).allDiscoveredRegs.get((Object)object)).locator);
                }
                iterator = FiddlerImpl.this.registrationByID.values().iterator();
                while (iterator.hasNext()) {
                    object = (RegistrationInfo)iterator.next();
                    HashSet hashSet2 = this.maybeSendDiscardedEvent((RegistrationInfo)object, map, hashMap);
                    Iterator iterator2 = hashSet2.iterator();
                    while (iterator2.hasNext()) {
                        hashSet.add(iterator2.next());
                    }
                }
                FiddlerImpl.this.maybeRemoveDiscardedRegsFromGlobalSet(hashSet);
                FiddlerImpl.this.updateGroupsInGlobalSet(map);
                Object var9_8 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
                throw throwable;
            }
        }

        private HashSet maybeSendDiscardedEvent(RegistrationInfo registrationInfo, Map map, Map map2) {
            HashSet<ServiceRegistrar> hashSet = new HashSet<ServiceRegistrar>(map.size());
            if (registrationInfo.groups != null && registrationInfo.groups.size() == 0) {
                return hashSet;
            }
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(map.size());
            Set set = map.entrySet();
            Object object = set.iterator();
            while (object.hasNext()) {
                Map.Entry entry = object.next();
                ServiceRegistrar serviceRegistrar = (ServiceRegistrar)entry.getKey();
                String[] stringArray = (String[])entry.getValue();
                LookupLocator lookupLocator = (LookupLocator)map2.get(serviceRegistrar);
                if (!registrationInfo.discoveredRegsMap.containsKey(serviceRegistrar) || FiddlerImpl.interested(lookupLocator, stringArray, registrationInfo.locators, registrationInfo.groups)) continue;
                hashMap.put(serviceRegistrar, stringArray);
                hashSet.add(serviceRegistrar);
                registrationInfo.discoveredRegsMap.remove(serviceRegistrar);
            }
            object = FiddlerImpl.this.buildEvent(registrationInfo, hashMap, true);
            if (object != null) {
                FiddlerImpl.this.queueEvent(registrationInfo, object);
                FiddlerImpl.this.logInfoEvents("ChangedEventTask.run(): DISCARDED Event was SENT\n");
            }
            return hashSet;
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private final class DiscardRegistrarTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;
        public final ServiceRegistrar registrar;

        public DiscardRegistrarTask(RegistrationInfo registrationInfo, ServiceRegistrar serviceRegistrar) {
            this.regInfo = registrationInfo;
            this.registrar = serviceRegistrar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            try {
                FiddlerImpl.this.logInfoTasks("DiscardRegistrarTask.run(): registrar requested to be discarded");
                if (this.regInfo.discoveredRegsMap.remove(this.registrar) != null) {
                    HashMap hashMap = FiddlerImpl.this.mapRegToGroups(this.registrar, ((LocatorGroupsStruct)((FiddlerImpl)FiddlerImpl.this).allDiscoveredRegs.get((Object)this.registrar)).groups);
                    RemoteDiscoveryEvent remoteDiscoveryEvent = FiddlerImpl.this.buildEvent(this.regInfo, hashMap, true);
                    if (remoteDiscoveryEvent != null) {
                        FiddlerImpl.this.queueEvent(this.regInfo, remoteDiscoveryEvent);
                        FiddlerImpl.this.logInfoEvents("DiscardRegistrarTask.run(): DISCARDED Event was SENT\n");
                    }
                    FiddlerImpl.this.maybeRemoveDiscardedRegFromGlobalSet(this.registrar);
                }
                Object var4_3 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
                throw throwable;
            }
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private final class DiscardedEventTask
    implements TaskManager.Task {
        public final DiscoveryEvent event;

        public DiscardedEventTask(DiscoveryEvent discoveryEvent) {
            this.event = discoveryEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            FiddlerImpl.this.logInfoTasks("DiscardedEventTask.run(): processing DISCARDED event from discovery manager");
            try {
                Map map = this.event.getGroups();
                HashSet hashSet = new HashSet(map.size());
                RegistrationInfo registrationInfo = FiddlerImpl.this.externalDiscardRequest();
                if (registrationInfo != null) {
                    HashSet hashSet2 = this.maybeSendDiscardedEvent(registrationInfo, map, true);
                    Iterator iterator = hashSet2.iterator();
                    while (iterator.hasNext()) {
                        hashSet.add(iterator.next());
                    }
                } else {
                    Iterator iterator = FiddlerImpl.this.registrationByID.values().iterator();
                    while (iterator.hasNext()) {
                        registrationInfo = (RegistrationInfo)iterator.next();
                        HashSet hashSet3 = this.maybeSendDiscardedEvent(registrationInfo, map, false);
                        Iterator iterator2 = hashSet3.iterator();
                        while (iterator2.hasNext()) {
                            hashSet.add(iterator2.next());
                        }
                    }
                }
                FiddlerImpl.this.maybeRemoveDiscardedRegsFromGlobalSet(hashSet);
                Object var8_9 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
                throw throwable;
            }
        }

        private HashSet maybeSendDiscardedEvent(RegistrationInfo registrationInfo, Map map, boolean bl) {
            HashSet<ServiceRegistrar> hashSet = new HashSet<ServiceRegistrar>(map.size());
            if (registrationInfo.groups != null && registrationInfo.groups.size() == 0 && registrationInfo.locators.size() == 0) {
                return hashSet;
            }
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(map.size());
            Set set = map.entrySet();
            Object object = set.iterator();
            while (object.hasNext()) {
                String[] stringArray;
                Map.Entry entry = object.next();
                ServiceRegistrar serviceRegistrar = (ServiceRegistrar)entry.getKey();
                if (!registrationInfo.discoveredRegsMap.containsKey(serviceRegistrar)) continue;
                String[] stringArray2 = stringArray = bl ? (String[])entry.getValue() : ((LocatorGroupsStruct)((FiddlerImpl)FiddlerImpl.this).allDiscoveredRegs.get((Object)serviceRegistrar)).groups;
                if (!bl && !FiddlerImpl.interested(stringArray, registrationInfo.groups)) continue;
                hashMap.put(serviceRegistrar, stringArray);
                hashSet.add(serviceRegistrar);
                registrationInfo.discoveredRegsMap.remove(serviceRegistrar);
            }
            object = FiddlerImpl.this.buildEvent(registrationInfo, hashMap, true);
            if (object != null) {
                FiddlerImpl.this.queueEvent(registrationInfo, object);
                FiddlerImpl.this.logInfoEvents("DiscardedEventTask.run(): DISCARDED Event SENT to regInfo\n");
            }
            return hashSet;
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private final class DiscoveredEventTask
    implements TaskManager.Task {
        public final DiscoveryEvent event;

        public DiscoveredEventTask(DiscoveryEvent discoveryEvent) {
            this.event = discoveryEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            Object object2;
            Map map = this.event.getGroups();
            ServiceRegistrar[] serviceRegistrarArray = this.event.getRegistrars();
            HashMap<ServiceRegistrar, LocatorGroupsStruct> hashMap = new HashMap<ServiceRegistrar, LocatorGroupsStruct>(serviceRegistrarArray.length);
            for (int i = 0; i < serviceRegistrarArray.length; ++i) {
                try {
                    object2 = serviceRegistrarArray[i].getLocator();
                    object = (String[])map.get(serviceRegistrarArray[i]);
                    LocatorGroupsStruct locatorGroupsStruct = new LocatorGroupsStruct((LookupLocator)object2, (String[])object);
                    hashMap.put(serviceRegistrarArray[i], locatorGroupsStruct);
                    continue;
                }
                catch (Exception exception) {
                    problemLogger.log(Levels.FAILED, "problem retrieving locator from discovered lookup service ... discarded the lookup service", exception);
                    FiddlerImpl.this.discoveryMgr.discard(serviceRegistrarArray[i]);
                }
            }
            FiddlerImpl.this.concurrentObj.writeLock();
            FiddlerImpl.this.logInfoTasks("DiscoveredEventTask.run(): processing DISCOVERED event from discovery manager");
            try {
                Set set = hashMap.entrySet();
                object2 = set.iterator();
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    FiddlerImpl.this.allDiscoveredRegs.put(object.getKey(), object.getValue());
                }
                object2 = FiddlerImpl.this.registrationByID.values().iterator();
                while (object2.hasNext()) {
                    object = (RegistrationInfo)object2.next();
                    FiddlerImpl.this.maybeSendDiscoveredEvent((RegistrationInfo)object, hashMap);
                }
                Object var9_10 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
                throw throwable;
            }
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private final class NewRegistrationTask
    implements TaskManager.Task {
        public final RegistrationInfo regInfo;

        public NewRegistrationTask(RegistrationInfo registrationInfo) {
            this.regInfo = registrationInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FiddlerImpl.this.concurrentObj.writeLock();
            try {
                FiddlerImpl.this.logInfoTasks("NewRegistrationTask.run(): new Registration added");
                FiddlerImpl.this.maybeSendDiscoveredEvent(this.regInfo, FiddlerImpl.this.allDiscoveredRegs);
                Object var2_1 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                FiddlerImpl.this.concurrentObj.writeUnlock();
                throw throwable;
            }
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private static final class RegistrationInfo
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 2L;
        public final Uuid registrationID;
        public HashMap discoveredRegsMap;
        public HashSet groups;
        public HashSet locators;
        public final Uuid leaseID;
        public long leaseExpiration;
        public long eventID;
        public long seqNum;
        public final MarshalledObject handback;
        public boolean discardFlag;
        public transient RemoteEventListener listener;

        public RegistrationInfo(Uuid uuid, String[] stringArray, LookupLocator[] lookupLocatorArray, Uuid uuid2, long l, long l2, MarshalledObject marshalledObject, RemoteEventListener remoteEventListener) {
            int n;
            this.registrationID = uuid;
            if (stringArray != null) {
                this.groups = new HashSet();
                for (n = 0; n < stringArray.length; ++n) {
                    if (stringArray[n] == null) continue;
                    this.groups.add(stringArray[n]);
                }
            }
            this.locators = new HashSet();
            if (lookupLocatorArray != null && lookupLocatorArray.length > 0) {
                for (n = 0; n < lookupLocatorArray.length; ++n) {
                    if (lookupLocatorArray[n] == null) continue;
                    this.locators.add(lookupLocatorArray[n]);
                }
            }
            this.discoveredRegsMap = new HashMap(11);
            this.leaseID = uuid2;
            this.leaseExpiration = l;
            this.eventID = l2;
            this.seqNum = 0L;
            this.handback = marshalledObject;
            this.discardFlag = false;
            this.listener = remoteEventListener;
        }

        public HashMap addToDiscoveredRegs(HashMap hashMap) {
            HashMap<ServiceRegistrar, String[]> hashMap2 = new HashMap<ServiceRegistrar, String[]>(hashMap.size());
            Iterator iterator = hashMap.entrySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                block4: {
                    Map.Entry entry = iterator.next();
                    ServiceRegistrar serviceRegistrar = (ServiceRegistrar)entry.getKey();
                    if (!this.discoveredRegsMap.containsKey(serviceRegistrar)) {
                        MarshalledObject<ServiceRegistrar> marshalledObject = null;
                        try {
                            marshalledObject = new MarshalledObject<ServiceRegistrar>(serviceRegistrar);
                        }
                        catch (IOException iOException) {
                            break block4;
                        }
                        this.discoveredRegsMap.put(serviceRegistrar, marshalledObject);
                        hashMap2.put(serviceRegistrar, ((LocatorGroupsStruct)entry.getValue()).groups);
                    }
                }
                ++n;
            }
            return hashMap2;
        }

        public int compareTo(Object object) {
            RegistrationInfo registrationInfo = (RegistrationInfo)object;
            if (this == registrationInfo) {
                return 0;
            }
            if (this.leaseExpiration < registrationInfo.leaseExpiration || this.leaseExpiration == registrationInfo.leaseExpiration && this.eventID < registrationInfo.eventID) {
                return -1;
            }
            return 1;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(new MarshalledObject<RemoteEventListener>(this.listener));
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            block4: {
                objectInputStream.defaultReadObject();
                MarshalledObject marshalledObject = (MarshalledObject)objectInputStream.readObject();
                try {
                    this.listener = (RemoteEventListener)marshalledObject.get();
                    this.listener = (RemoteEventListener)recoveredListenerPreparer.prepareProxy((Object)this.listener);
                }
                catch (Throwable throwable) {
                    problemLogger.log(Level.INFO, "problem recovering listener for recovered registration", throwable);
                    if (!(throwable instanceof Error) || ThrowableConstants.retryable(throwable) != 2) break block4;
                    throw (Error)throwable;
                }
            }
            int n = this.locators.size();
            this.locators = (HashSet)FiddlerImpl.prepareOldLocators(recoveredLocatorToDiscoverPreparer, this.locators);
            if (n != this.locators.size()) {
                this.listener = null;
                if (problemLogger.isLoggable(Level.WARNING)) {
                    problemLogger.log(Level.WARNING, "failure preparing locator while recovering registration... discarding recoveredregistration");
                }
            }
        }
    }

    private class LookupDiscoveryListener
    implements DiscoveryChangeListener {
        public void discovered(DiscoveryEvent discoveryEvent) {
            FiddlerImpl.this.taskMgr.add(new DiscoveredEventTask(discoveryEvent));
        }

        public void discarded(DiscoveryEvent discoveryEvent) {
            FiddlerImpl.this.taskMgr.add(new DiscardedEventTask(discoveryEvent));
        }

        public void changed(DiscoveryEvent discoveryEvent) {
            FiddlerImpl.this.taskMgr.add(new ChangedEventTask(discoveryEvent));
        }
    }

    private static class FiddlerStatus
    extends Status {
        private static final long serialVersionUID = -8511826097053446749L;

        public FiddlerStatus(StatusType statusType) {
            super(statusType);
        }
    }

    protected final class LocatorGroupsStruct {
        public LookupLocator locator;
        public String[] groups;

        LocatorGroupsStruct(LookupLocator lookupLocator, String[] stringArray) {
            this.locator = lookupLocator;
            this.groups = stringArray;
        }
    }
}

