/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.binding;

import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.VariableIcon;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.binding.DefaultKeyBindingSet;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingSet;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.mwswing.binding.TestActionUtils;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.PlatformInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class MatlabTestActionUtils {
    public static final Collection<KeyBindingSet> EMACS = Collections.unmodifiableCollection(Arrays.asList(DefaultKeyBindingSet.EMACS));
    public static final Collection<KeyBindingSet> WINDOWS = Collections.unmodifiableCollection(Arrays.asList(DefaultKeyBindingSet.WINDOWS));
    public static final Collection<KeyBindingSet> MAC = Collections.unmodifiableCollection(Arrays.asList(DefaultKeyBindingSet.MAC));
    public static final Collection<KeyBindingSet> WINDOWS_AND_MAC = Collections.unmodifiableCollection(Arrays.asList(DefaultKeyBindingSet.WINDOWS, DefaultKeyBindingSet.MAC));
    public static final Collection<KeyBindingSet> WINDOWS_AND_EMACS = Collections.unmodifiableCollection(Arrays.asList(DefaultKeyBindingSet.WINDOWS, DefaultKeyBindingSet.EMACS));
    public static final Collection<KeyBindingSet> ALL_SETS = Collections.unmodifiableCollection(Arrays.asList(DefaultKeyBindingSet.WINDOWS, DefaultKeyBindingSet.EMACS, DefaultKeyBindingSet.MAC));

    private MatlabTestActionUtils() {
    }

    public static void testCopyAction(MJAbstractAction mJAbstractAction, String string, ActionMap actionMap, InputMap inputMap) {
        String string2 = "copy-to-clipboard";
        MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, actionMap, string2);
        MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, actionMap, "copy");
        MatlabTestActionUtils.doCopyActionTest(WINDOWS_AND_MAC, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(67, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), inputMap, string2, mJAbstractAction, string);
        MatlabTestActionUtils.doCopyActionTest(EMACS, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(87, 8)}), inputMap, string2, mJAbstractAction, string);
        if (inputMap != null) {
            TestActionUtils.checkInputMap(EMACS, (KeyBindingManager)MatlabKeyBindings.getManager(), (InputMap)inputMap, (String)"copy-to-clipboard", (KeyStroke[])new KeyStroke[]{KeyStroke.getKeyStroke(87, 4)});
            TestActionUtils.checkInputMap(WINDOWS, (KeyBindingManager)MatlabKeyBindings.getManager(), (InputMap)inputMap, (String)"copy-to-clipboard", (KeyStroke[])new KeyStroke[]{KeyStroke.getKeyStroke(155, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)});
        }
    }

    private static void doCopyActionTest(Collection<KeyBindingSet> collection, KeyStrokeList keyStrokeList, InputMap inputMap, String string, MJAbstractAction mJAbstractAction, String string2) {
        MatlabTestActionUtils.checkInputMapAndActionProperties(inputMap, string, collection, mJAbstractAction, "Copy", "Copy", 'C', keyStrokeList, string2, CommonIcon.COPY.getIcon());
    }

    public static void testCutAction(MJAbstractAction mJAbstractAction, String string, ActionMap actionMap, InputMap inputMap) {
        String string2 = "cut-to-clipboard";
        MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, actionMap, string2);
        MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, actionMap, "cut");
        MatlabTestActionUtils.doCutActionTest(WINDOWS_AND_MAC, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(88, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), inputMap, string2, mJAbstractAction, string);
        MatlabTestActionUtils.doCutActionTest(EMACS, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(87, 2)}), inputMap, string2, mJAbstractAction, string);
        if (inputMap != null) {
            TestActionUtils.checkInputMap(WINDOWS, (KeyBindingManager)MatlabKeyBindings.getManager(), (InputMap)inputMap, (String)"cut-to-clipboard", (KeyStroke[])new KeyStroke[]{KeyStroke.getKeyStroke(127, 1)});
        }
    }

    private static void doCutActionTest(Collection<KeyBindingSet> collection, KeyStrokeList keyStrokeList, InputMap inputMap, String string, MJAbstractAction mJAbstractAction, String string2) {
        MatlabTestActionUtils.checkInputMapAndActionProperties(inputMap, string, collection, mJAbstractAction, "Cut", "Cut", 'T', keyStrokeList, string2, CommonIcon.CUT.getIcon());
    }

    public static void testPasteAction(MJAbstractAction mJAbstractAction, String string, ActionMap actionMap, InputMap inputMap) {
        String string2 = "paste-from-clipboard";
        MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, actionMap, string2);
        MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, actionMap, "paste");
        MatlabTestActionUtils.doPasteActionTest(WINDOWS_AND_MAC, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(86, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), inputMap, string2, mJAbstractAction, string);
        MatlabTestActionUtils.doPasteActionTest(EMACS, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(89, 2)}), inputMap, string2, mJAbstractAction, string);
        if (inputMap != null) {
            TestActionUtils.checkInputMap(WINDOWS, (KeyBindingManager)MatlabKeyBindings.getManager(), (InputMap)inputMap, (String)"paste-from-clipboard", (KeyStroke[])new KeyStroke[]{KeyStroke.getKeyStroke(155, 1)});
        }
    }

    private static void doPasteActionTest(Collection<KeyBindingSet> collection, KeyStrokeList keyStrokeList, InputMap inputMap, String string, MJAbstractAction mJAbstractAction, String string2) {
        MatlabTestActionUtils.checkInputMapAndActionProperties(inputMap, string, collection, mJAbstractAction, "Paste", "Paste", 'P', keyStrokeList, string2, CommonIcon.PASTE.getIcon());
    }

    public static void testDeleteAction(MJAbstractAction mJAbstractAction, ActionMap actionMap, InputMap inputMap) {
        MatlabTestActionUtils.testDeleteAction("Delete Selection", "Delete", 'D', null, "delete-next", mJAbstractAction, actionMap, inputMap);
    }

    public static void testDeleteAction(String string, String string2, char c, Icon icon, String string3, MJAbstractAction mJAbstractAction, ActionMap actionMap, InputMap inputMap) {
        String string4 = "delete-next";
        MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, actionMap, string4);
        Collection<KeyBindingSet> collection = PlatformInfo.isMacintosh() ? ALL_SETS : WINDOWS_AND_EMACS;
        MatlabTestActionUtils.checkInputMapAndActionProperties(inputMap, string4, collection, mJAbstractAction, string, string2, c, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(127, 0)}), string3, icon);
        if (inputMap != null) {
            TestActionUtils.checkInputMap(EMACS, (KeyBindingManager)MatlabKeyBindings.getManager(), (InputMap)inputMap, (String)"delete-next", (KeyStroke[])new KeyStroke[]{KeyStroke.getKeyStroke(68, 2)});
            if (PlatformInfo.isMacintosh()) {
                TestActionUtils.checkInputMap(MAC, (KeyBindingManager)MatlabKeyBindings.getManager(), (InputMap)inputMap, (String)"delete-next", (KeyStroke[])new KeyStroke[]{KeyStroke.getKeyStroke(68, 2)});
            }
        }
    }

    public static void testFindAction(MJAbstractAction mJAbstractAction) throws Exception {
        MatlabTestActionUtils.testFindAction(mJAbstractAction, "find-and-replace", null, null);
    }

    public static void testFindAction(MJAbstractAction mJAbstractAction, String string, ActionMap actionMap, InputMap inputMap) {
        String string2 = "find-and-replace";
        MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, actionMap, string2);
        MatlabTestActionUtils.doFindActionTest(WINDOWS_AND_MAC, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(70, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), inputMap, string2, mJAbstractAction, string);
        MatlabTestActionUtils.doFindActionTest(EMACS, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(72, 2)}), inputMap, string2, mJAbstractAction, string);
        if (inputMap != null) {
            TestActionUtils.checkInputMap(WINDOWS, (KeyBindingManager)MatlabKeyBindings.getManager(), (InputMap)inputMap, (String)string2, (KeyStroke[])new KeyStroke[]{KeyStroke.getKeyStroke(72, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)});
        }
    }

    private static void doFindActionTest(Collection<KeyBindingSet> collection, KeyStrokeList keyStrokeList, InputMap inputMap, String string, MJAbstractAction mJAbstractAction, String string2) {
        MatlabTestActionUtils.checkInputMapAndActionProperties(inputMap, string, collection, mJAbstractAction, "Find...", "Find text", 'F', keyStrokeList, string2, CommonIcon.FIND.getIcon());
    }

    public static void testPrintAction(MJAbstractAction mJAbstractAction) {
        MatlabTestActionUtils.testPrintAction(mJAbstractAction, "print", null, null);
    }

    public static void testPrintAction(MJAbstractAction mJAbstractAction, String string, ActionMap actionMap, InputMap inputMap) {
        String string2 = "print";
        MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, actionMap, string2);
        MatlabTestActionUtils.doTestPrintAction(WINDOWS_AND_MAC, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(80, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), inputMap, string2, mJAbstractAction, string);
        MatlabTestActionUtils.doTestPrintAction(EMACS, null, inputMap, string2, mJAbstractAction, string);
    }

    private static void doTestPrintAction(Collection<KeyBindingSet> collection, KeyStrokeList keyStrokeList, InputMap inputMap, String string, MJAbstractAction mJAbstractAction, String string2) {
        MatlabTestActionUtils.checkInputMapAndActionProperties(inputMap, string, collection, mJAbstractAction, "Print...", "Print", 'P', keyStrokeList, string2, CommonIcon.PRINT.getIcon());
    }

    public static void testPrintSelectionAction(MJAbstractAction mJAbstractAction, String string) {
        MatlabTestActionUtils.testPrintSelectionAction(mJAbstractAction, string, null);
    }

    public static void testPrintSelectionAction(MJAbstractAction mJAbstractAction, String string, JComponent jComponent) {
        MatlabTestActionUtils.doTestPrintSelection(WINDOWS_AND_EMACS, null, mJAbstractAction, string, jComponent);
        MatlabTestActionUtils.doTestPrintSelection(MAC, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(80, 8 + KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), mJAbstractAction, string, jComponent);
    }

    private static void doTestPrintSelection(Collection<KeyBindingSet> collection, KeyStrokeList keyStrokeList, MJAbstractAction mJAbstractAction, String string, JComponent jComponent) {
        TestActionUtils.checkActionProperties(collection, (KeyBindingManager)MatlabKeyBindings.getManager(), (ExtendedAction)mJAbstractAction, (String)"Print Selection...", (String)"Print selection", (char)'T', (KeyStrokeList)keyStrokeList, (String)string, null);
        if (jComponent != null && keyStrokeList != null) {
            String string2 = "print-selection";
            assert (mJAbstractAction.equals(jComponent.getActionMap().get(string2))) : string2 + " is not in action map";
            TestActionUtils.checkInputMap(collection, (KeyBindingManager)MatlabKeyBindings.getManager(), (InputMap)jComponent.getInputMap(), (String)string2, (KeyStroke[])keyStrokeList.toKeyStrokeArray());
        }
    }

    public static void testPageSetupAction(MJAbstractAction mJAbstractAction, String string) {
        MatlabTestActionUtils.testPageSetupAction(mJAbstractAction, string, null);
    }

    public static void testPageSetupAction(MJAbstractAction mJAbstractAction, String string, JComponent jComponent) {
        MatlabTestActionUtils.doTestPageSetup(WINDOWS_AND_EMACS, null, mJAbstractAction, string, jComponent);
        MatlabTestActionUtils.doTestPageSetup(MAC, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(80, 1 + KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), mJAbstractAction, string, jComponent);
    }

    private static void doTestPageSetup(Collection<KeyBindingSet> collection, KeyStrokeList keyStrokeList, MJAbstractAction mJAbstractAction, String string, JComponent jComponent) {
        TestActionUtils.checkActionProperties(collection, (KeyBindingManager)MatlabKeyBindings.getManager(), (ExtendedAction)mJAbstractAction, (String)"Page Setup...", (String)"Page setup", (char)'G', (KeyStrokeList)keyStrokeList, (String)string, null);
        if (jComponent != null && keyStrokeList != null) {
            String string2 = "show-page-setup";
            assert (mJAbstractAction.equals(jComponent.getActionMap().get(string2))) : string2 + " is not in action map";
            TestActionUtils.checkInputMap(collection, (KeyBindingManager)MatlabKeyBindings.getManager(), (InputMap)jComponent.getInputMap(), (String)string2, (KeyStroke[])keyStrokeList.toKeyStrokeArray());
        }
    }

    public static void testSelectAllAction(MJAbstractAction mJAbstractAction, String string, ActionMap actionMap, InputMap inputMap) {
        String string2 = "select-all";
        MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, actionMap, string2);
        MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, actionMap, "selectAll");
        MatlabTestActionUtils.doTestSelectAllAction(WINDOWS_AND_MAC, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(65, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), inputMap, string2, mJAbstractAction, string);
        MatlabTestActionUtils.doTestSelectAllAction(EMACS, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(88, 2), KeyStroke.getKeyStroke(72, 0)}), inputMap, string2, mJAbstractAction, string);
    }

    private static void doTestSelectAllAction(Collection<KeyBindingSet> collection, KeyStrokeList keyStrokeList, InputMap inputMap, String string, MJAbstractAction mJAbstractAction, String string2) {
        MatlabTestActionUtils.checkInputMapAndActionProperties(inputMap, string, collection, mJAbstractAction, "Select All", "Select All", 'S', keyStrokeList, string2, null);
    }

    public static void testOpenSelectionAction(MJAbstractAction mJAbstractAction, String string, ActionMap actionMap, InputMap inputMap, Icon icon) {
        String string2 = "open-selection";
        MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, actionMap, string2);
        MatlabTestActionUtils.doTestOpenSelectionAction(WINDOWS, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(68, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), icon, inputMap, string2, mJAbstractAction, string);
        MatlabTestActionUtils.doTestOpenSelectionAction(MAC, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(68, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK + 1)}), icon, inputMap, string2, mJAbstractAction, string);
        MatlabTestActionUtils.doTestOpenSelectionAction(EMACS, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(115, 0)}), icon, inputMap, string2, mJAbstractAction, string);
    }

    private static void doTestOpenSelectionAction(Collection<KeyBindingSet> collection, KeyStrokeList keyStrokeList, Icon icon, InputMap inputMap, String string, MJAbstractAction mJAbstractAction, String string2) {
        MatlabTestActionUtils.checkInputMapAndActionProperties(inputMap, string, collection, mJAbstractAction, "Open Selection", "Open selection", '\u0000', keyStrokeList, string2, icon);
    }

    public static void testHelpOnSelectionAction(MJAbstractAction mJAbstractAction, ActionMap actionMap, InputMap inputMap, String string) {
        String string2 = "help-on-selection";
        MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, actionMap, string2);
        MatlabTestActionUtils.checkInputMapAndActionProperties(inputMap, string2, ALL_SETS, mJAbstractAction, string, "Help on Selection", '\u0000', new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(112, 0)}), "help-on-selection", null);
    }

    public static void testEvaluateSelectionAction(MJAbstractAction mJAbstractAction, ActionMap actionMap, InputMap inputMap) {
        String string = "evaluate-selection";
        MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, actionMap, string);
        MatlabTestActionUtils.doTestEvaluateSelectionAction(WINDOWS_AND_EMACS, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(120, 0)}), inputMap, string, mJAbstractAction);
        MatlabTestActionUtils.doTestEvaluateSelectionAction(MAC, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(118, 1)}), inputMap, string, mJAbstractAction);
    }

    private static void doTestEvaluateSelectionAction(Collection<KeyBindingSet> collection, KeyStrokeList keyStrokeList, InputMap inputMap, String string, MJAbstractAction mJAbstractAction) {
        MatlabTestActionUtils.checkInputMapAndActionProperties(inputMap, string, collection, mJAbstractAction, "Evaluate Selection", "Evaluate Selection", 'E', keyStrokeList, "evaluate-selection", null);
    }

    public static void testNewAction(MJAbstractAction mJAbstractAction, String string, String string2, char c, String string3, ActionMap actionMap, InputMap inputMap) {
        String string4 = "new-mfile";
        MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, actionMap, string4);
        MatlabTestActionUtils.checkInputMapAndActionProperties(inputMap, string4, WINDOWS_AND_MAC, mJAbstractAction, string, string2, c, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(78, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), string3, CommonIcon.NEW.getIcon());
        MatlabTestActionUtils.checkInputMapAndActionProperties(inputMap, string4, EMACS, mJAbstractAction, string, string2, c, null, string3, CommonIcon.NEW.getIcon());
    }

    public static void testOpenAction(MJAbstractAction mJAbstractAction, String string, String string2) {
        MatlabTestActionUtils.doTestOpenAction(WINDOWS_AND_MAC, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(79, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), mJAbstractAction, string, string2);
        MatlabTestActionUtils.doTestOpenAction(EMACS, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(88, 2), KeyStroke.getKeyStroke(70, 2)}), mJAbstractAction, string, string2);
    }

    private static void doTestOpenAction(Collection<KeyBindingSet> collection, KeyStrokeList keyStrokeList, MJAbstractAction mJAbstractAction, String string, String string2) {
        TestActionUtils.checkActionProperties(collection, (KeyBindingManager)MatlabKeyBindings.getManager(), (ExtendedAction)mJAbstractAction, (String)"Open...", (String)string, (char)'O', (KeyStrokeList)keyStrokeList, (String)string2, (Icon)CommonIcon.OPEN.getIcon());
    }

    public static void testRedoAction(MJAbstractAction mJAbstractAction, String string, ActionMap actionMap, InputMap inputMap) {
        String string2 = "redo";
        MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, actionMap, string2);
        MatlabTestActionUtils.doTestRedoAction(WINDOWS, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(89, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), inputMap, string2, mJAbstractAction, string);
        MatlabTestActionUtils.doTestRedoAction(MAC, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(90, 1 + KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), inputMap, string2, mJAbstractAction, string);
        MatlabTestActionUtils.doTestRedoAction(EMACS, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(90, 1 + KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), inputMap, string2, mJAbstractAction, string);
        if (inputMap != null) {
            TestActionUtils.checkInputMap(WINDOWS, (KeyBindingManager)MatlabKeyBindings.getManager(), (InputMap)inputMap, (String)string2, (KeyStroke[])new KeyStroke[]{KeyStroke.getKeyStroke(90, 1 + KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)});
            TestActionUtils.checkInputMap(WINDOWS, (KeyBindingManager)MatlabKeyBindings.getManager(), (InputMap)inputMap, (String)string2, (KeyStroke[])new KeyStroke[]{KeyStroke.getKeyStroke(8, 9)});
        }
    }

    private static void doTestRedoAction(Collection<KeyBindingSet> collection, KeyStrokeList keyStrokeList, InputMap inputMap, String string, MJAbstractAction mJAbstractAction, String string2) {
        MatlabTestActionUtils.checkInputMapAndActionProperties(inputMap, string, collection, mJAbstractAction, "Redo", "Redo", 'R', keyStrokeList, string2, CommonIcon.REDO.getIcon());
    }

    public static void testUndoAction(MJAbstractAction mJAbstractAction, String string, ActionMap actionMap, InputMap inputMap) {
        String string2 = "undo";
        MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, actionMap, string2);
        MatlabTestActionUtils.doUndoActionTest(WINDOWS_AND_MAC, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(90, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), inputMap, string2, mJAbstractAction, string);
        MatlabTestActionUtils.doUndoActionTest(EMACS, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(45, 3)}), inputMap, string2, mJAbstractAction, string);
        if (inputMap != null) {
            TestActionUtils.checkInputMap(WINDOWS, (KeyBindingManager)MatlabKeyBindings.getManager(), (InputMap)inputMap, (String)string2, (KeyStroke[])new KeyStroke[]{KeyStroke.getKeyStroke(8, 8)});
            TestActionUtils.checkInputMap(EMACS, (KeyBindingManager)MatlabKeyBindings.getManager(), (InputMap)inputMap, (String)string2, (KeyStroke[])new KeyStroke[]{KeyStroke.getKeyStroke(523, 2)});
            TestActionUtils.checkInputMap(EMACS, (KeyBindingManager)MatlabKeyBindings.getManager(), (InputMap)inputMap, (String)string2, (KeyStroke[])new KeyStroke[]{KeyStroke.getKeyStroke(88, 2), KeyStroke.getKeyStroke(85, 0)});
        }
    }

    private static void doUndoActionTest(Collection<KeyBindingSet> collection, KeyStrokeList keyStrokeList, InputMap inputMap, String string, MJAbstractAction mJAbstractAction, String string2) {
        MatlabTestActionUtils.checkInputMapAndActionProperties(inputMap, string, collection, mJAbstractAction, "Undo", "Undo", 'U', keyStrokeList, string2, CommonIcon.UNDO.getIcon());
    }

    public static void testSaveAction(MJAbstractAction mJAbstractAction, String string) {
        MatlabTestActionUtils.testSaveAction(mJAbstractAction, string, CommonIcon.SAVE.getIcon(), null, "save");
    }

    public static void testSaveAction(MJAbstractAction mJAbstractAction, String string, Icon icon, JComponent jComponent, String string2) {
        InputMap inputMap;
        InputMap inputMap2 = inputMap = jComponent == null ? null : jComponent.getInputMap();
        if (jComponent != null) {
            MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, jComponent.getActionMap(), string2);
        }
        MatlabTestActionUtils.doSaveActionTest(WINDOWS_AND_MAC, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(83, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), inputMap, string2, mJAbstractAction, string, icon);
        MatlabTestActionUtils.doSaveActionTest(EMACS, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(88, 2), KeyStroke.getKeyStroke(83, 2)}), inputMap, string2, mJAbstractAction, string, icon);
    }

    private static void doSaveActionTest(Collection<KeyBindingSet> collection, KeyStrokeList keyStrokeList, InputMap inputMap, String string, MJAbstractAction mJAbstractAction, String string2, Icon icon) {
        MatlabTestActionUtils.checkInputMapAndActionProperties(inputMap, string, collection, mJAbstractAction, "Save", "Save", 'S', keyStrokeList, string2, icon);
    }

    public static void testSaveAsAction(MJAbstractAction mJAbstractAction, String string, JComponent jComponent) {
        MatlabTestActionUtils.doTestSaveAsAction(WINDOWS, null, mJAbstractAction, string, jComponent);
        MatlabTestActionUtils.doTestSaveAsAction(EMACS, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(88, 2), KeyStroke.getKeyStroke(87, 2)}), mJAbstractAction, string, jComponent);
        MatlabTestActionUtils.doTestSaveAsAction(MAC, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(83, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK + 1)}), mJAbstractAction, string, jComponent);
    }

    private static void doTestSaveAsAction(Collection<KeyBindingSet> collection, KeyStrokeList keyStrokeList, MJAbstractAction mJAbstractAction, String string, JComponent jComponent) {
        TestActionUtils.checkActionProperties(collection, (KeyBindingManager)MatlabKeyBindings.getManager(), (ExtendedAction)mJAbstractAction, (String)"Save As...", (String)"Save as", (char)'A', (KeyStrokeList)keyStrokeList, (String)string, (Icon)CommonIcon.SAVE_AS.getIcon());
        if (jComponent != null) {
            String string2 = "save-as";
            assert (mJAbstractAction.equals(jComponent.getActionMap().get(string2))) : string2 + "  is not in action map";
            if (keyStrokeList != null) {
                TestActionUtils.checkInputMap(collection, (KeyBindingManager)MatlabKeyBindings.getManager(), (InputMap)jComponent.getInputMap(), (String)string2, (KeyStroke[])keyStrokeList.toKeyStrokeArray());
            }
        }
    }

    public static void testSaveWorkspaceAsAction(MJAbstractAction mJAbstractAction, String string, char c, String string2, JComponent jComponent) {
        InputMap inputMap = jComponent == null ? null : jComponent.getInputMap();
        String string3 = "save-workspace";
        if (jComponent != null) {
            MatlabTestActionUtils.checkActionMapEntry(mJAbstractAction, jComponent.getActionMap(), string3);
        }
        KeyStrokeList keyStrokeList = new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(83, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)});
        MatlabTestActionUtils.testSaveWorkspaceAction(WINDOWS_AND_MAC, mJAbstractAction, keyStrokeList, string, c, string2, inputMap, string3);
        MatlabTestActionUtils.testSaveWorkspaceAction(EMACS, mJAbstractAction, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(88, 2), KeyStroke.getKeyStroke(83, 2)}), string, c, string2, inputMap, string3);
    }

    private static void testSaveWorkspaceAction(Collection<KeyBindingSet> collection, MJAbstractAction mJAbstractAction, KeyStrokeList keyStrokeList, String string, char c, String string2, InputMap inputMap, String string3) {
        MatlabTestActionUtils.checkInputMapAndActionProperties(inputMap, string3, collection, mJAbstractAction, string, "Save", c, keyStrokeList, string2, VariableIcon.SAVE_WORKSPACE.getIcon());
    }

    public static void testProductHelpActionNonMac(MJAbstractAction mJAbstractAction, String string, KeyStrokeList keyStrokeList) {
        MatlabTestActionUtils.doTestProductHelpAction(WINDOWS_AND_EMACS, mJAbstractAction, string, keyStrokeList);
    }

    public static void testProductHelpActionMac(MJAbstractAction mJAbstractAction, String string) {
        MatlabTestActionUtils.doTestProductHelpAction(MAC, mJAbstractAction, string, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(47, 1 + KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}));
    }

    private static void doTestProductHelpAction(Collection<KeyBindingSet> collection, MJAbstractAction mJAbstractAction, String string, KeyStrokeList keyStrokeList) {
        TestActionUtils.checkActionProperties(collection, (KeyBindingManager)MatlabKeyBindings.getManager(), (ExtendedAction)mJAbstractAction, (String)"Product Help", (String)"Help", (char)'H', (KeyStrokeList)keyStrokeList, (String)string, (Icon)CommonIcon.HELP.getIcon());
    }

    public static void testRefreshAction(MJAbstractAction mJAbstractAction, MInputMap mInputMap, String string) {
        MatlabTestActionUtils.testRefreshAction(mJAbstractAction, mInputMap, string, CommonIcon.REFRESH.getIcon(), 'R');
    }

    public static void testRefreshAction(MJAbstractAction mJAbstractAction, MInputMap mInputMap, String string, Icon icon, char c) {
        MatlabTestActionUtils.doTestRefreshAction(WINDOWS_AND_EMACS, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(116, 0)}), mJAbstractAction, mInputMap, string, icon, c);
        MatlabTestActionUtils.doTestRefreshAction(MAC, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(82, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), mJAbstractAction, mInputMap, string, icon, c);
    }

    private static void doTestRefreshAction(Collection<KeyBindingSet> collection, KeyStrokeList keyStrokeList, MJAbstractAction mJAbstractAction, MInputMap mInputMap, String string, Icon icon, char c) {
        String string2 = "refresh";
        MatlabTestActionUtils.checkInputMapAndActionProperties((InputMap)mInputMap, string2, collection, mJAbstractAction, "Refresh", "Refresh", c, keyStrokeList, string, icon);
    }

    public static void testPreferencesAction(MJAbstractAction mJAbstractAction, String string) {
        MatlabTestActionUtils.doTestPreferences(WINDOWS_AND_EMACS, null, mJAbstractAction, string);
        MatlabTestActionUtils.doTestPreferences(MAC, new KeyStrokeList(new KeyStroke[]{KeyStroke.getKeyStroke(44, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK)}), mJAbstractAction, string);
    }

    private static void doTestPreferences(Collection<KeyBindingSet> collection, KeyStrokeList keyStrokeList, MJAbstractAction mJAbstractAction, String string) {
        TestActionUtils.checkActionProperties(collection, (KeyBindingManager)MatlabKeyBindings.getManager(), (ExtendedAction)mJAbstractAction, (String)"Preferences...", (String)"Preferences", (char)'F', (KeyStrokeList)keyStrokeList, (String)string, (Icon)CommonIcon.SETTINGS.getIcon());
    }

    private static void checkActionMapEntry(MJAbstractAction mJAbstractAction, ActionMap actionMap, String string) {
        if (actionMap != null && !mJAbstractAction.equals(actionMap.get(string))) {
            throw new IllegalStateException("Action '" + mJAbstractAction.getName() + "' is not in the action map with key '" + string + "'");
        }
    }

    private static void checkInputMapAndActionProperties(InputMap inputMap, String string, Collection<KeyBindingSet> collection, MJAbstractAction mJAbstractAction, String string2, String string3, char c, KeyStrokeList keyStrokeList, String string4, Icon icon) {
        if (inputMap != null && keyStrokeList != null) {
            TestActionUtils.checkInputMap(collection, (KeyBindingManager)MatlabKeyBindings.getManager(), (InputMap)inputMap, (String)string, (KeyStroke[])keyStrokeList.toKeyStrokeArray());
        }
        TestActionUtils.checkActionProperties(collection, (KeyBindingManager)MatlabKeyBindings.getManager(), (ExtendedAction)mJAbstractAction, (String)string2, (String)string3, (char)c, (KeyStrokeList)keyStrokeList, (String)string4, (Icon)icon);
    }
}

