/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services;

import com.mathworks.services.Browseable;
import com.mathworks.services.BrowseableEvent;
import com.mathworks.services.BrowseableListener;
import com.mathworks.services.ObjRegBrowseableEvent;
import com.mathworks.services.ObjectOwner;
import com.mathworks.services.ObjectRegistryEntryDynamic;
import java.util.Vector;

class ObjectRegistryEntry
implements Browseable {
    private ObjectOwner fOwner;
    private Object fObject;
    private ObjectRegistryEntry fParent;
    private boolean fCanHaveChildren;
    private Vector fChildren;
    private Vector fListener;
    private Browseable fNext;
    private Browseable fPrev;

    ObjectRegistryEntry(Object object, ObjectOwner objectOwner, boolean bl) {
        this.fObject = object;
        this.fOwner = objectOwner;
        this.fParent = null;
        this.fCanHaveChildren = bl;
        this.fChildren = new Vector();
        this.fListener = null;
        this.fNext = null;
        this.fPrev = null;
    }

    ObjectOwner getOwner() {
        return this.fOwner;
    }

    void setParent(ObjectRegistryEntry objectRegistryEntry) {
        this.fParent = objectRegistryEntry;
    }

    void setNextSibling(Browseable browseable) {
        this.fNext = browseable;
    }

    void setPrevSibling(Browseable browseable) {
        this.fPrev = browseable;
    }

    void addChild(Browseable browseable, int n) {
        Browseable[] browseableArray = new Browseable[]{browseable};
        this.addChildren(browseableArray, n);
    }

    void addChildren(Browseable[] browseableArray, int n) {
        if (browseableArray != null && browseableArray.length > 0) {
            int n2 = this.browseableChildCount();
            for (int i = 0; i < browseableArray.length; ++i) {
                Browseable browseable = null;
                if (this.fChildren.contains(browseableArray[i])) continue;
                if (this.fChildren.size() > 0) {
                    browseable = (Browseable)this.fChildren.lastElement();
                }
                if (browseable instanceof ObjectRegistryEntry) {
                    ((ObjectRegistryEntry)browseable).setNextSibling(browseableArray[i]);
                }
                if (browseableArray[i] instanceof ObjectRegistryEntry) {
                    ((ObjectRegistryEntry)browseableArray[i]).setPrevSibling(browseable);
                    ((ObjectRegistryEntry)browseableArray[i]).setNextSibling(null);
                }
                if (browseableArray[i] instanceof ObjectRegistryEntry) {
                    ((ObjectRegistryEntry)browseableArray[i]).setParent(this);
                }
                this.fChildren.addElement(browseableArray[i]);
            }
            this.fireBrowseableEvent(new BrowseableEvent(this, 0, browseableArray, n2, n));
        }
    }

    void insertChild(Browseable browseable, int n, int n2) {
        Browseable[] browseableArray = new Browseable[]{browseable};
        this.insertChildren(browseableArray, n, n2);
    }

    void insertChildren(Browseable[] browseableArray, int n, int n2) {
        if (n >= this.fChildren.size()) {
            this.addChildren(browseableArray, n2);
        } else if (browseableArray != null && browseableArray.length > 0) {
            Browseable browseable = n > 0 ? (Browseable)this.fChildren.elementAt(n - 1) : null;
            Browseable browseable2 = browseable != null ? browseable.browseableNextSibling() : (Browseable)this.fChildren.firstElement();
            for (int i = 0; i < browseableArray.length; ++i) {
                if (this.fChildren.contains(browseableArray[i])) continue;
                if (browseableArray[i] instanceof ObjectRegistryEntry) {
                    ((ObjectRegistryEntry)browseableArray[i]).setNextSibling(browseable2);
                    ((ObjectRegistryEntry)browseableArray[i]).setPrevSibling(browseable);
                }
                if (browseable2 instanceof ObjectRegistryEntry) {
                    ((ObjectRegistryEntry)browseable2).setPrevSibling(browseableArray[i]);
                }
                if (browseable instanceof ObjectRegistryEntry) {
                    ((ObjectRegistryEntry)browseable).setNextSibling(browseableArray[i]);
                }
                if (browseableArray[i] instanceof ObjectRegistryEntry) {
                    ((ObjectRegistryEntry)browseableArray[i]).setParent(this);
                }
                this.fChildren.insertElementAt(browseableArray[i], n + i);
                browseable = browseableArray[i];
            }
            this.fireBrowseableEvent(new BrowseableEvent(this, 0, browseableArray, n, n2));
        }
    }

    void removeChild(Browseable browseable, int n) {
        Browseable[] browseableArray = new Browseable[]{browseable};
        this.removeChildren(browseableArray, n);
    }

    void removeChildren(Browseable[] browseableArray, int n) {
        if (browseableArray != null && browseableArray.length > 0) {
            for (int i = 0; i < browseableArray.length; ++i) {
                if (!this.fChildren.contains(browseableArray[i])) continue;
                Browseable browseable = browseableArray[i].browseableNextSibling();
                Browseable browseable2 = browseableArray[i].browseablePrevSibling();
                if (browseable instanceof ObjectRegistryEntry) {
                    ((ObjectRegistryEntry)browseable).setPrevSibling(browseable2);
                }
                if (browseable2 instanceof ObjectRegistryEntry) {
                    ((ObjectRegistryEntry)browseable2).setNextSibling(browseable);
                }
                if (browseableArray[i] instanceof ObjectRegistryEntry) {
                    ((ObjectRegistryEntry)browseableArray[i]).setParent(null);
                }
                this.fChildren.removeElement(browseableArray[i]);
            }
            this.fireBrowseableEvent(new BrowseableEvent(this, 1, browseableArray, n));
        }
    }

    void changeChild(Browseable browseable, int n, Object object) {
        Browseable[] browseableArray = new Browseable[]{browseable};
        this.changeChildren(browseableArray, n, object);
    }

    void changeChildren(Browseable[] browseableArray, int n, Object object) {
        if (browseableArray != null && browseableArray.length > 0) {
            this.fireBrowseableEvent(new ObjRegBrowseableEvent((Browseable)this, browseableArray, object, n));
        }
    }

    @Override
    public Object browseableDisplayObject() {
        return null;
    }

    @Override
    public Object browseableDataObject() {
        return this.fObject;
    }

    @Override
    public Browseable browseableParent() {
        return this.fParent;
    }

    @Override
    public boolean browseableHasChildren() {
        return this.fChildren.size() > 0;
    }

    @Override
    public boolean browseableCanHaveChildren() {
        return this.fCanHaveChildren;
    }

    @Override
    public int browseableChildCount() {
        return this.fChildren.size();
    }

    @Override
    public Browseable browseableChild(int n) {
        return this.getChildImpl(n);
    }

    @Override
    public Browseable[] browseableChildren() {
        Browseable[] browseableArray = new Browseable[this.browseableChildCount()];
        for (int i = 0; i < browseableArray.length; ++i) {
            browseableArray[i] = this.getChildImpl(i);
        }
        return browseableArray;
    }

    @Override
    public Browseable[] browseableNChildren(int n, int n2) {
        Browseable[] browseableArray;
        if (this.validChild(n)) {
            int n3 = Math.min(n2, this.browseableChildCount() - n);
            browseableArray = new Browseable[n3];
            for (int i = 0; i < n3; ++i) {
                browseableArray[i] = this.getChildImpl(n + i);
            }
        } else {
            browseableArray = new Browseable[]{};
        }
        return browseableArray;
    }

    @Override
    public Browseable browseableNextSibling() {
        return this.fNext;
    }

    @Override
    public Browseable[] browseableNextNSiblings(int n) {
        Browseable[] browseableArray;
        Browseable[] browseableArray2 = browseableArray = n > 0 ? new Browseable[n] : new Browseable[]{};
        if (n > 0) {
            int n2 = 0;
            for (Browseable browseable = this.browseableNextSibling(); browseable != null && n2 < n; browseable = browseable.browseableNextSibling()) {
                browseableArray[n2++] = browseable;
            }
            if (n2 < n) {
                Browseable[] browseableArray3 = new Browseable[n2];
                System.arraycopy(browseableArray, 0, browseableArray3, 0, n2);
                browseableArray = browseableArray3;
            }
        }
        return browseableArray;
    }

    @Override
    public Browseable browseablePrevSibling() {
        return this.fPrev;
    }

    @Override
    public Browseable[] browseablePrevNSiblings(int n) {
        Browseable[] browseableArray;
        Browseable[] browseableArray2 = browseableArray = n > 0 ? new Browseable[n] : new Browseable[]{};
        if (n > 0) {
            int n2 = 0;
            for (Browseable browseable = this.browseablePrevSibling(); browseable != null && n2 < n; browseable = browseable.browseablePrevSibling()) {
                browseableArray[n - 1 - n2++] = browseable;
            }
            if (n2 < n) {
                Browseable[] browseableArray3 = new Browseable[n2];
                System.arraycopy(browseableArray, n - n2, browseableArray3, 0, n2);
                browseableArray = browseableArray3;
            }
        }
        return browseableArray;
    }

    @Override
    public int browseableChildFetchCount() {
        return -1;
    }

    @Override
    public void addBrowseableListener(BrowseableListener browseableListener) {
        if (this.fListener == null) {
            this.fListener = new Vector();
        }
        if (!this.fListener.contains(browseableListener)) {
            this.fListener.addElement(browseableListener);
        }
    }

    @Override
    public void removeBrowseableListener(BrowseableListener browseableListener) {
        if (this.fListener != null) {
            if (this.fListener.contains(browseableListener)) {
                this.fListener.removeElement(browseableListener);
            }
            if (this.fListener.size() == 0) {
                this.fListener = null;
            }
        }
    }

    private void fireBrowseableEvent(BrowseableEvent browseableEvent) {
        if (this.fListener != null && this.fListener.size() > 0) {
            Vector vector = (Vector)this.fListener.clone();
            block7: for (int i = 0; i < vector.size(); ++i) {
                BrowseableListener browseableListener = (BrowseableListener)vector.elementAt(i);
                switch (browseableEvent.getEventType()) {
                    case 0: {
                        browseableListener.childAdded(browseableEvent);
                        continue block7;
                    }
                    case 1: {
                        browseableListener.childRemoved(browseableEvent);
                        continue block7;
                    }
                    case 2: {
                        browseableListener.childChanged(browseableEvent);
                        continue block7;
                    }
                    case 101: {
                        browseableListener.transactionStarted(browseableEvent);
                        continue block7;
                    }
                    case 102: {
                        browseableListener.transactionEnded(browseableEvent);
                    }
                }
            }
        }
    }

    private final Browseable getChildImpl(int n) {
        Browseable browseable = null;
        if (this.validChild(n)) {
            browseable = (Browseable)this.fChildren.elementAt(n);
        }
        return browseable;
    }

    private final boolean validChild(int n) {
        return n >= 0 && n < this.fChildren.size() && this.fChildren.elementAt(n) instanceof Browseable;
    }

    static ObjectRegistryEntry newEntry(Object object, ObjectOwner objectOwner, boolean bl) {
        ObjectRegistryEntry objectRegistryEntry = null;
        objectRegistryEntry = object instanceof Browseable ? new ObjectRegistryEntryDynamic((Browseable)object, objectOwner) : new ObjectRegistryEntry(object, objectOwner, bl);
        return objectRegistryEntry;
    }

    static ObjectRegistryEntry newStaticEntry(Object object, ObjectOwner objectOwner, boolean bl) {
        return new ObjectRegistryEntry(object, objectOwner, bl);
    }
}

