/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.dtd;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.netbeans.editor.ext.html.WeakHashSet;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.dtd.ReaderProvider;

class DTDParser {
    private ReaderProvider provider = null;
    private WeakHashSet stringCache = new WeakHashSet(131, 0.75f);
    private WeakHashSet attributes = new WeakHashSet(23, 0.75f);
    private WeakHashSet models = new WeakHashSet(131, 0.75f);
    private WeakHashSet contents = new WeakHashSet(131, 0.75f);
    Set leafs = new HashSet(131, 0.75f);
    private SortedMap charRefs = new TreeMap();
    private SortedMap elementMap = new TreeMap();
    private Map entityMap = new HashMap();
    private static final int DTD_INIT = 0;
    private static final int DTD_LT = 1;
    private static final int DTD_EXC = 2;
    private static final int DTD_MINUS = 3;
    private static final int DTD_ACOMMENT = 4;
    private static final int PED_INIT = 0;
    private static final int PED_PERCENT = 1;
    private static final int PED_CHAR = 2;
    private static final int PED_NAME = 3;
    private static final int PED_ANAME = 4;
    private static final int PED_VAL = 5;
    private static final int PED_TYPE = 6;
    private static final int PED_AVAL = 7;
    private static final int PED_AVAL_M = 8;
    private static final int PED_ATYPE = 9;
    private static final int PED_ID = 10;
    private static final int PED_AID = 11;
    private static final int PED_FILE = 12;
    private static final int PED_AFILE = 13;
    private static final int PED_AFILE_M = 14;
    private static final int PED_ACHAR = 15;
    private static final int PED_CH_TYPE = 16;
    private static final int PED_CH_ATYPE = 17;
    private static final int PED_CH_QUOT = 18;
    private static final int GR_INIT = 0;
    private static final int GR_NAME = 1;
    private static final int GR_ANAME = 2;
    private static final int EL_INIT = 0;
    private static final int EL_NAME = 1;
    private static final int EL_ANAME = 2;
    private static final int EL_ASTART = 3;
    private static final int EL_ACONTENT = 4;
    private static final int EL_PLUS = 5;
    private static final int EL_MINUS = 6;
    private static final int CO_INIT = 0;
    private static final int CO_NAME = 1;
    private static final int CO_AMODEL = 2;
    private static final int CO_AND = 3;
    private static final int CO_OR = 4;
    private static final int CO_SEQ = 5;
    private static final int CO_AGROUP = 6;
    private static final int ATT_INIT = 0;
    private static final int ATT_NAME = 1;
    private static final int ATT_ANAME = 2;
    private static final int ATT_ANAME_M = 3;
    private static final int ATT_VAR = 4;
    private static final int ATT_AVAR = 5;
    private static final int ATT_TYPE = 6;
    private static final int ATT_ATYPE = 7;
    private static final int ATT_MODE = 8;
    private static final int OPT_INIT = 0;
    private static final int OPT_PROCESS = 1;
    private static final int OPT_APROCESS = 2;
    private static final int OPT_CONTENT = 3;
    private static final int OPT_BRAC1 = 4;
    private static final int OPT_BRAC2 = 5;
    private static final int COMM_TEXT = 0;
    private static final int COMM_DASH = 1;

    DTDParser() {
    }

    private Reader getReader(String string, String string2) {
        if (this.provider == null) {
            return null;
        }
        return this.provider.getReaderForIdentifier(string, string2);
    }

    public DTD createDTD(ReaderProvider readerProvider, String string, String string2) throws WrongDTDException {
        this.provider = readerProvider;
        Reader reader = this.getReader(string, string2);
        if (reader == null) {
            throw new WrongDTDException("Can't open Reader for public identifier " + string);
        }
        try {
            this.parseDTD(new PushbackReader(reader, 131072));
        }
        catch (IOException iOException) {
            throw new WrongDTDException("IOException during parsing: " + iOException.getMessage());
        }
        for (Object object : this.elementMap.values()) {
            Object object2;
            Object object32;
            ContentModelImpl contentModelImpl = (ContentModelImpl)object.getContentModel();
            HashSet hashSet = new HashSet();
            for (Object object32 : contentModelImpl.included) {
                object2 = object32;
                if (object2 instanceof String) {
                    object2 = this.elementMap.get(((String)object2).toUpperCase());
                }
                if (object2 == null) {
                    throw new WrongDTDException("'" + object32 + "' element referenced from " + object.getName() + " not found throughout the DTD.");
                }
                hashSet.add(object2);
            }
            contentModelImpl.included = hashSet;
            HashSet hashSet2 = new HashSet();
            object32 = contentModelImpl.excluded.iterator();
            while (object32.hasNext()) {
                object2 = object32.next();
                Object object4 = object2;
                if (object4 instanceof String) {
                    object4 = this.elementMap.get(((String)object4).toUpperCase());
                }
                if (object4 == null) {
                    throw new WrongDTDException("'" + object2 + "' element referenced from " + object.getName() + " not found throughout the DTD.");
                }
                hashSet2.add(object4);
            }
            contentModelImpl.excluded = hashSet2;
            contentModelImpl.hashcode = contentModelImpl.content.hashCode() + 2 * ((Object)contentModelImpl.included).hashCode() + 3 * ((Object)contentModelImpl.excluded).hashCode();
        }
        for (Object object : this.leafs) {
            ((ContentLeafImpl)object).elem = (DTD.Element)this.elementMap.get(((ContentLeafImpl)object).elemName);
        }
        return new DTDImpl(string, this.elementMap, this.charRefs);
    }

    void addEntity(String string, String string2) {
        if (this.entityMap.get(string) == null) {
            this.entityMap.put(string, string2);
        }
    }

    void addPublicEntity(String string, String string2, String string3) throws WrongDTDException {
        if (this.entityMap.get(string) == null) {
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[16384];
            Reader reader = this.getReader(string2, string3);
            try {
                int n;
                while ((n = reader.read(cArray)) >= 0) {
                    stringBuffer.append(cArray, 0, n);
                }
            }
            catch (IOException iOException) {
                throw new WrongDTDException("Error reading included public entity " + string + " - " + iOException.getMessage());
            }
            this.entityMap.put(string, stringBuffer.toString());
        }
    }

    DTD.Value createValue(String string) {
        return new ValueImpl((String)this.stringCache.put(string));
    }

    DTD.ContentModel createContentModel(DTD.Content content, Set set, Set set2) {
        ContentModelImpl contentModelImpl = new ContentModelImpl(content, set, set2);
        return (DTD.ContentModel)this.models.put(contentModelImpl);
    }

    DTD.Content createContentLeaf(String string) {
        DTD.Content content = new ContentLeafImpl(string);
        content = (DTD.Content)this.contents.put(content);
        this.leafs.add(content);
        return content;
    }

    DTD.Content createContentNode(char c, DTD.Content content) {
        return (DTD.Content)this.contents.put(new UnaryContentNodeImpl(c, content));
    }

    DTD.Content createContentNode(char c, DTD.Content[] contentArray) {
        return (DTD.Content)this.contents.put(new MultiContentNodeImpl(c, contentArray));
    }

    DTD.Element createElement(String string, DTD.ContentModel contentModel, boolean bl, boolean bl2) {
        ElementImpl elementImpl = new ElementImpl(string, contentModel, bl, bl2, new TreeMap());
        return elementImpl;
    }

    DTD.Attribute createAttribute(String string, int n, String string2, String string3, String string4, SortedMap sortedMap) {
        AttributeImpl attributeImpl = new AttributeImpl(string, n, (String)this.stringCache.put(string2), (String)this.stringCache.put(string3), (String)this.stringCache.put(string4), sortedMap);
        return (DTD.Attribute)this.attributes.put(attributeImpl);
    }

    void addAttrToElement(String string, DTD.Attribute attribute) throws WrongDTDException {
        ElementImpl elementImpl = (ElementImpl)this.elementMap.get(string.toUpperCase());
        if (elementImpl == null) {
            throw new WrongDTDException("Attribute definition for unknown Element \"" + string + "\".");
        }
        elementImpl.addAttribute(attribute);
    }

    void createAddCharRef(String string, char c) {
        CharRefImpl charRefImpl = new CharRefImpl(string, c);
        this.charRefs.put(string, charRefImpl);
    }

    private boolean isNameChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '.' || c == ':';
    }

    private void parseDTD(PushbackReader pushbackReader) throws IOException, WrongDTDException {
        int n;
        int n2 = 0;
        while ((n = pushbackReader.read()) != -1) {
            block0 : switch (n2) {
                case 0: {
                    switch (n) {
                        case 60: {
                            n2 = 1;
                            break block0;
                        }
                        case 37: {
                            this.parseEntityReference(pushbackReader);
                        }
                    }
                    break;
                }
                case 1: {
                    if (n != 33) {
                        throw new WrongDTDException("Unexpected char '" + (char)n + "' after '<'");
                    }
                    n2 = 2;
                    break;
                }
                case 2: {
                    switch (n) {
                        case 45: {
                            n2 = 3;
                            break block0;
                        }
                        case 91: {
                            this.parseOptional(pushbackReader);
                            n2 = 0;
                            break block0;
                        }
                    }
                    pushbackReader.unread(n);
                    this.parseMarkup(pushbackReader);
                    n2 = 0;
                    break;
                }
                case 3: {
                    if (n != 45) {
                        throw new WrongDTDException("Unexpected char '" + (char)n + "' after \"<!-\"");
                    }
                    this.parseComment(pushbackReader);
                    n2 = 4;
                    break;
                }
                case 4: {
                    if (n != 62) {
                        throw new WrongDTDException("Unexpected char '" + (char)n + "' after comment");
                    }
                    n2 = 0;
                }
            }
        }
        if (n2 != 0) {
            throw new WrongDTDException("Premature end of DTD");
        }
    }

    private void parseMarkup(PushbackReader pushbackReader) throws IOException, WrongDTDException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = pushbackReader.read()) == -1) {
                throw new WrongDTDException("Premature end of DTD");
            }
            if (n == 32) break;
            stringBuffer.append((char)n);
        }
        String string = stringBuffer.toString();
        if ("ENTITY".equals(string)) {
            this.parseEntityDefinition(pushbackReader);
        } else if ("ELEMENT".equals(string)) {
            this.parseElement(pushbackReader);
        } else if ("ATTLIST".equals(string)) {
            this.parseAttlist(pushbackReader);
        } else {
            throw new WrongDTDException("Wrong DTD markup <!" + string);
        }
    }

    private void parseEntityDefinition(PushbackReader pushbackReader) throws IOException, WrongDTDException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        block21: while (true) {
            int n2;
            if ((n2 = pushbackReader.read()) == -1) {
                throw new WrongDTDException("Premature end of DTD");
            }
            switch (n) {
                case 0: {
                    if (Character.isWhitespace((char)n2)) continue block21;
                    if (n2 == 37) {
                        n = 1;
                        break;
                    }
                    stringBuffer.append((char)n2);
                    n = 2;
                    break;
                }
                case 1: {
                    if (Character.isWhitespace((char)n2)) continue block21;
                    stringBuffer.append((char)n2);
                    n = 3;
                    break;
                }
                case 3: {
                    if (Character.isWhitespace((char)n2)) {
                        n = 4;
                        break;
                    }
                    stringBuffer.append((char)n2);
                    break;
                }
                case 4: {
                    if (Character.isWhitespace((char)n2)) continue block21;
                    if (n2 == 34) {
                        n = 5;
                        break;
                    }
                    pushbackReader.unread(n2);
                    n = 6;
                    break;
                }
                case 5: {
                    if (n2 == 34) {
                        this.addEntity(stringBuffer.toString(), stringBuffer2.toString());
                        n = 7;
                        break;
                    }
                    stringBuffer2.append((char)n2);
                    break;
                }
                case 7: {
                    if (n2 == 62) {
                        return;
                    }
                    if (n2 != 45) break;
                    n = 8;
                    break;
                }
                case 8: {
                    if (n2 == 45) {
                        this.parseComment(pushbackReader);
                    }
                    n = 7;
                    break;
                }
                case 6: {
                    if (Character.isWhitespace((char)n2)) {
                        if (stringBuffer3.toString().equals("PUBLIC")) {
                            n = 9;
                            break;
                        }
                        throw new WrongDTDException("Unexpected entity type \"" + stringBuffer3 + "\".");
                    }
                    stringBuffer3.append((char)n2);
                    break;
                }
                case 9: {
                    if (Character.isWhitespace((char)n2)) continue block21;
                    if (n2 == 34) {
                        n = 10;
                        break;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n2 + "' in PUBLIC entity.");
                }
                case 10: {
                    if (n2 == 34) {
                        n = 11;
                        break;
                    }
                    stringBuffer4.append((char)n2);
                    break;
                }
                case 11: {
                    if (Character.isWhitespace((char)n2)) continue block21;
                    if (n2 == 34) {
                        n = 12;
                        break;
                    }
                    if (n2 == 62) {
                        this.addPublicEntity(stringBuffer.toString(), stringBuffer4.toString(), null);
                        return;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n2 + "' in PUBLIC entity.");
                }
                case 12: {
                    if (n2 == 34) {
                        n = 13;
                        break;
                    }
                    stringBuffer2.append((char)n2);
                    break;
                }
                case 13: {
                    if (Character.isWhitespace((char)n2)) continue block21;
                    if (n2 == 45) {
                        n = 14;
                        break;
                    }
                    if (n2 == 62) {
                        this.addPublicEntity(stringBuffer.toString(), stringBuffer4.toString(), stringBuffer2.toString());
                        return;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n2 + "' in PUBLIC entity.");
                }
                case 14: {
                    if (n2 == 45) {
                        this.parseComment(pushbackReader);
                        n = 12;
                        break;
                    }
                    throw new WrongDTDException("Unexpected sequence \"-" + (char)n2 + "\" in in PUBLIC entity.");
                }
                case 2: {
                    if (Character.isWhitespace((char)n2)) {
                        n = 15;
                        break;
                    }
                    stringBuffer.append((char)n2);
                    break;
                }
                case 15: {
                    if (Character.isWhitespace((char)n2)) continue block21;
                    stringBuffer3.append((char)n2);
                    n = 16;
                    break;
                }
                case 16: {
                    if (Character.isWhitespace((char)n2)) {
                        if (stringBuffer3.toString().equals("CDATA")) {
                            n = 9;
                            n = 17;
                            break;
                        }
                        throw new WrongDTDException("Unexpected entity type \"" + stringBuffer3 + "\".");
                    }
                    stringBuffer3.append((char)n2);
                    break;
                }
                case 17: {
                    if (Character.isWhitespace((char)n2)) continue block21;
                    if (n2 == 34) {
                        n = 18;
                        break;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n2 + "' in entity.");
                }
                case 18: {
                    if (n2 == 34) {
                        stringBuffer2.delete(0, 2);
                        stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
                        int n3 = Integer.parseInt(stringBuffer2.toString());
                        this.createAddCharRef(stringBuffer.toString(), (char)n3);
                        n = 7;
                        break;
                    }
                    stringBuffer2.append((char)n2);
                }
            }
        }
    }

    private List parseGroup(PushbackReader pushbackReader) throws IOException, WrongDTDException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        block13: while (true) {
            int n2;
            if ((n2 = pushbackReader.read()) == -1) {
                throw new WrongDTDException("Premature end of DTD");
            }
            block0 : switch (n) {
                case 0: {
                    if (Character.isWhitespace((char)n2)) continue block13;
                    if (n2 == 37) {
                        this.parseEntityReference(pushbackReader);
                        break;
                    }
                    stringBuffer.append((char)n2);
                    n = 1;
                    break;
                }
                case 1: {
                    if (this.isNameChar((char)n2)) {
                        stringBuffer.append((char)n2);
                        break;
                    }
                    switch (n2) {
                        case 41: {
                            arrayList.add(stringBuffer.toString());
                            return arrayList;
                        }
                        case 124: {
                            arrayList.add(stringBuffer.toString());
                            stringBuffer.setLength(0);
                            n = 0;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace((char)n2)) {
                        arrayList.add(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        n = 2;
                        break;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n2 + "' in group definition.");
                }
                case 2: {
                    if (Character.isWhitespace((char)n2)) continue block13;
                    switch (n2) {
                        case 41: {
                            return arrayList;
                        }
                        case 124: {
                            n = 0;
                            break block0;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n2 + "' in group definition.");
                }
            }
        }
    }

    private void parseElement(PushbackReader pushbackReader) throws IOException, WrongDTDException {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = null;
        boolean bl = false;
        boolean bl2 = false;
        DTD.Content content = null;
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        while ((n = pushbackReader.read()) != -1) {
            block0 : switch (n2) {
                case 0: {
                    if (Character.isWhitespace((char)n)) break;
                    switch (n) {
                        case 40: {
                            arrayList = this.parseGroup(pushbackReader);
                            n2 = 2;
                            break block0;
                        }
                        case 37: {
                            this.parseEntityReference(pushbackReader);
                            break block0;
                        }
                    }
                    stringBuffer.append((char)n);
                    n2 = 1;
                    break;
                }
                case 1: {
                    if (Character.isWhitespace((char)n)) {
                        n2 = 2;
                        arrayList = new ArrayList<String>();
                        arrayList.add(stringBuffer.toString());
                        break;
                    }
                    stringBuffer.append((char)n);
                    break;
                }
                case 2: {
                    if (Character.isWhitespace((char)n)) break;
                    switch (n) {
                        case 79: {
                            bl = true;
                        }
                        case 45: {
                            n2 = 3;
                            break block0;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n + "' in ELEMENT optStart definition.");
                }
                case 3: {
                    if (Character.isWhitespace((char)n)) break;
                    switch (n) {
                        case 79: {
                            bl2 = true;
                        }
                        case 45: {
                            content = this.parseContent(pushbackReader);
                            n2 = 4;
                            break block0;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n + "' in ELEMENT optEnd definition.");
                }
                case 4: {
                    Object object;
                    if (Character.isWhitespace((char)n)) break;
                    switch (n) {
                        case 43: {
                            n2 = 5;
                            break block0;
                        }
                        case 45: {
                            n2 = 6;
                            break block0;
                        }
                        case 62: {
                            object = this.createContentModel(content, hashSet, hashSet2);
                            Iterator iterator = arrayList.iterator();
                            while (iterator.hasNext()) {
                                String string = ((String)iterator.next()).toUpperCase();
                                this.elementMap.put(string, this.createElement(string, (DTD.ContentModel)object, bl, bl2));
                            }
                            return;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n + "' in ELEMENT definition.");
                }
                case 5: {
                    if (n == 40) {
                        n2 = 4;
                        hashSet.addAll(this.parseGroup(pushbackReader));
                        break;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n + "' in ELEMENT definition.");
                }
                case 6: {
                    Object object;
                    switch (n) {
                        case 40: {
                            n2 = 4;
                            object = this.parseGroup(pushbackReader);
                            hashSet2.addAll(object);
                            break block0;
                        }
                        case 45: {
                            n2 = 4;
                            this.parseComment(pushbackReader);
                            break block0;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n + "' in ELEMENT definition.");
                }
            }
        }
    }

    private DTD.Content parseContent(PushbackReader pushbackReader) throws IOException, WrongDTDException {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<DTD.Content> arrayList = null;
        DTD.Content content = null;
        while ((n = pushbackReader.read()) != -1) {
            block0 : switch (n2) {
                case 0: {
                    if (Character.isWhitespace((char)n)) break;
                    switch (n) {
                        case 37: {
                            this.parseEntityReference(pushbackReader);
                            break block0;
                        }
                        case 40: {
                            content = this.parseContent(pushbackReader);
                            n2 = 2;
                            break block0;
                        }
                    }
                    stringBuffer.append((char)n);
                    n2 = 1;
                    break;
                }
                case 1: {
                    if (this.isNameChar((char)n)) {
                        stringBuffer.append((char)n);
                        break;
                    }
                    switch (n) {
                        case 42: 
                        case 43: 
                        case 63: {
                            DTD.Content content2 = this.createContentLeaf(stringBuffer.toString());
                            return this.createContentNode((char)n, content2);
                        }
                    }
                    pushbackReader.unread(n);
                    return this.createContentLeaf(stringBuffer.toString());
                }
                case 2: {
                    if (Character.isWhitespace((char)n)) break;
                    switch (n) {
                        case 38: {
                            arrayList = new ArrayList<DTD.Content>();
                            arrayList.add(content);
                            arrayList.add(this.parseContent(pushbackReader));
                            n2 = 3;
                            break block0;
                        }
                        case 124: {
                            arrayList = new ArrayList();
                            arrayList.add(content);
                            arrayList.add(this.parseContent(pushbackReader));
                            n2 = 4;
                            break block0;
                        }
                        case 44: {
                            arrayList = new ArrayList();
                            arrayList.add(content);
                            arrayList.add(this.parseContent(pushbackReader));
                            n2 = 5;
                            break block0;
                        }
                        case 41: {
                            n2 = 6;
                            break block0;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n + "' in ELEMENT optEnd definition.");
                }
                case 3: {
                    if (Character.isWhitespace((char)n)) break;
                    switch (n) {
                        case 38: {
                            arrayList.add(this.parseContent(pushbackReader));
                            break block0;
                        }
                        case 41: {
                            content = this.createContentNode('&', arrayList.toArray(new DTD.Content[0]));
                            n2 = 6;
                            break block0;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n + "' in ContentModel definition.");
                }
                case 4: {
                    if (Character.isWhitespace((char)n)) break;
                    switch (n) {
                        case 124: {
                            arrayList.add(this.parseContent(pushbackReader));
                            break block0;
                        }
                        case 41: {
                            content = this.createContentNode('|', arrayList.toArray(new DTD.Content[0]));
                            n2 = 6;
                            break block0;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n + "' in ContentModel definition.");
                }
                case 5: {
                    if (Character.isWhitespace((char)n)) break;
                    switch (n) {
                        case 44: {
                            arrayList.add(this.parseContent(pushbackReader));
                            break block0;
                        }
                        case 41: {
                            content = this.createContentNode(',', arrayList.toArray(new DTD.Content[0]));
                            n2 = 6;
                            break block0;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n + "' in ContentModel definition.");
                }
                case 6: {
                    if (Character.isWhitespace((char)n)) {
                        return content;
                    }
                    switch (n) {
                        case 42: 
                        case 43: 
                        case 63: {
                            return this.createContentNode((char)n, content);
                        }
                    }
                    pushbackReader.unread(n);
                    return content;
                }
            }
        }
        throw new WrongDTDException("Premature end of DTD");
    }

    private void parseAttlist(PushbackReader pushbackReader) throws IOException, WrongDTDException {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        List list = null;
        StringBuffer stringBuffer2 = new StringBuffer();
        List list2 = null;
        StringBuffer stringBuffer3 = new StringBuffer();
        String string = null;
        StringBuffer stringBuffer4 = new StringBuffer();
        while ((n = pushbackReader.read()) != -1) {
            block0 : switch (n2) {
                case 0: {
                    if (Character.isWhitespace((char)n)) break;
                    switch (n) {
                        case 37: {
                            this.parseEntityReference(pushbackReader);
                            break block0;
                        }
                        case 40: {
                            list = this.parseGroup(pushbackReader);
                            n2 = 2;
                            break block0;
                        }
                    }
                    stringBuffer.append((char)n);
                    n2 = 1;
                    break;
                }
                case 1: {
                    if (Character.isWhitespace((char)n)) {
                        list = new ArrayList<String>();
                        list.add(stringBuffer.toString());
                        n2 = 2;
                        break;
                    }
                    stringBuffer.append((char)n);
                    break;
                }
                case 2: {
                    if (Character.isWhitespace((char)n)) break;
                    switch (n) {
                        case 37: {
                            this.parseEntityReference(pushbackReader);
                            break block0;
                        }
                        case 45: {
                            n2 = 3;
                            break block0;
                        }
                        case 62: {
                            return;
                        }
                    }
                    stringBuffer2.append((char)n);
                    n2 = 4;
                    break;
                }
                case 3: {
                    if (n == 45) {
                        this.parseComment(pushbackReader);
                        n2 = 2;
                        break;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n + "' in ATTLIST definition.");
                }
                case 4: {
                    if (Character.isWhitespace((char)n)) {
                        n2 = 5;
                        break;
                    }
                    stringBuffer2.append((char)n);
                    break;
                }
                case 5: {
                    if (Character.isWhitespace((char)n)) break;
                    switch (n) {
                        case 37: {
                            string = this.parseEntityReference(pushbackReader);
                            break block0;
                        }
                        case 40: {
                            list2 = this.parseGroup(pushbackReader);
                            n2 = 7;
                            break block0;
                        }
                    }
                    stringBuffer3.append((char)n);
                    n2 = 6;
                    break;
                }
                case 6: {
                    if (Character.isWhitespace((char)n)) {
                        n2 = 7;
                        break;
                    }
                    stringBuffer3.append((char)n);
                    break;
                }
                case 7: {
                    if (Character.isWhitespace((char)n)) break;
                    switch (n) {
                        case 37: {
                            this.parseEntityReference(pushbackReader);
                            break block0;
                        }
                    }
                    stringBuffer4.append((char)n);
                    n2 = 8;
                    break;
                }
                case 8: {
                    if (Character.isWhitespace((char)n)) {
                        Object object;
                        DTD.Attribute attribute = null;
                        if (list2 == null) {
                            attribute = this.createAttribute(stringBuffer2.toString(), 2, stringBuffer3.toString(), string, stringBuffer4.toString(), null);
                        } else if (list2.size() == 1) {
                            attribute = this.createAttribute(stringBuffer2.toString(), 0, null, string, stringBuffer4.toString(), null);
                        } else {
                            object = new TreeMap();
                            Iterator iterator = list2.iterator();
                            while (iterator.hasNext()) {
                                String string2 = ((String)iterator.next()).toLowerCase();
                                object.put(string2, this.createValue(string2));
                            }
                            attribute = this.createAttribute(stringBuffer2.toString(), 1, null, string, stringBuffer4.toString(), (SortedMap)object);
                        }
                        object = list.iterator();
                        while (object.hasNext()) {
                            this.addAttrToElement((String)object.next(), attribute);
                        }
                        string = null;
                        stringBuffer2.setLength(0);
                        stringBuffer3.setLength(0);
                        stringBuffer4.setLength(0);
                        list2 = null;
                        n2 = 2;
                        break;
                    }
                    stringBuffer4.append((char)n);
                }
            }
        }
    }

    private void parseOptional(PushbackReader pushbackReader) throws IOException, WrongDTDException {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        while ((n = pushbackReader.read()) != -1) {
            switch (n2) {
                case 0: {
                    if (Character.isWhitespace((char)n)) break;
                    if (n == 37) {
                        this.parseEntityReference(pushbackReader);
                        break;
                    }
                    stringBuffer.append((char)n);
                    n2 = 1;
                    break;
                }
                case 1: {
                    if (Character.isWhitespace((char)n)) {
                        String string = stringBuffer.toString();
                        if ("IGNORE".equals(string)) {
                            bl = true;
                        } else if (!"INCLUDE".equals(string)) {
                            throw new WrongDTDException("Unexpected processing instruction " + string);
                        }
                        n2 = 2;
                        break;
                    }
                    stringBuffer.append((char)n);
                    break;
                }
                case 2: {
                    if (Character.isWhitespace((char)n)) break;
                    if (n == 91) {
                        n2 = 3;
                        break;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n + "' in processing instruction.");
                }
                case 3: {
                    if (n == 93) {
                        n2 = 4;
                        break;
                    }
                    stringBuffer2.append((char)n);
                    break;
                }
                case 4: {
                    if (n == 93) {
                        n2 = 5;
                        break;
                    }
                    stringBuffer2.append(']').append((char)n);
                    n2 = 3;
                    break;
                }
                case 5: {
                    if (Character.isWhitespace((char)n)) break;
                    if (n == 62) {
                        if (!bl) {
                            pushbackReader.unread(stringBuffer2.toString().toCharArray());
                        }
                        return;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)n + "' in processing instruction.");
                }
            }
        }
    }

    private void parseComment(PushbackReader pushbackReader) throws IOException, WrongDTDException {
        int n;
        int n2 = 0;
        while ((n = pushbackReader.read()) != -1) {
            switch (n2) {
                case 0: {
                    if (n != 45) break;
                    n2 = 1;
                    break;
                }
                case 1: {
                    if (n == 45) {
                        return;
                    }
                    n2 = 0;
                }
            }
        }
        throw new WrongDTDException("Premature end of DTD");
    }

    private String parseEntityReference(PushbackReader pushbackReader) throws IOException, WrongDTDException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = pushbackReader.read()) != -1) {
            if (this.isNameChar((char)n)) {
                stringBuffer.append((char)n);
                continue;
            }
            String string = (String)this.entityMap.get(stringBuffer.toString());
            if (string == null) {
                throw new WrongDTDException("No such entity: \"" + stringBuffer + "\"");
            }
            if (n != 59) {
                pushbackReader.unread(n);
            }
            pushbackReader.unread(string.toCharArray());
            return stringBuffer.toString();
        }
        throw new WrongDTDException("Premature end of DTD");
    }

    private static class MultiContentNodeImpl
    implements DTD.ContentNode {
        int hashcode;
        char type;
        DTD.Content[] content;

        public MultiContentNodeImpl(char c, DTD.Content[] contentArray) {
            if (c != '|' && c != '&' && c != ',') {
                throw new IllegalArgumentException("Unknown n-ary content type '" + c + "'");
            }
            this.type = c;
            this.content = contentArray;
            this.hashcode = c;
            for (int i = 0; i < contentArray.length; ++i) {
                this.hashcode += contentArray[i].hashCode();
            }
        }

        public boolean isLeaf() {
            return false;
        }

        @Override
        public char getType() {
            return this.type;
        }

        public DTD.Content[] getContent() {
            return this.content;
        }

        public boolean equals(Object object) {
            if (!(object instanceof MultiContentNodeImpl)) {
                return false;
            }
            return this.type == ((MultiContentNodeImpl)object).type && Arrays.equals(this.content, ((MultiContentNodeImpl)object).content);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("(");
            for (int i = 0; i < this.content.length; ++i) {
                stringBuffer.append(this.content[i].toString());
                if (i + 1 >= this.content.length) continue;
                stringBuffer.append(this.type);
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        public int hashCode() {
            return this.hashcode;
        }

        @Override
        public boolean isDiscardable() {
            if (this.type == '&' || this.type == ',') {
                for (int i = 0; i < this.content.length; ++i) {
                    if (this.content[i].isDiscardable()) continue;
                    return false;
                }
                return true;
            }
            for (int i = 0; i < this.content.length; ++i) {
                if (!this.content[i].isDiscardable()) continue;
                return true;
            }
            return false;
        }

        @Override
        public DTD.Content reduce(String string) {
            if (this.type == '|') {
                for (int i = 0; i < this.content.length; ++i) {
                    DTD.Content content = this.content[i].reduce(string);
                    if (content == null) continue;
                    return content;
                }
                return null;
            }
            if (this.type == ',') {
                for (int i = 0; i < this.content.length; ++i) {
                    DTD.Content content = this.content[i].reduce(string);
                    if (content == null && !this.content[i].isDiscardable()) {
                        return null;
                    }
                    if (content == EMPTY_CONTENT) {
                        int n = this.content.length - i - 1;
                        if (n > 1) {
                            DTD.Content[] contentArray = new DTD.Content[n];
                            System.arraycopy(this.content, i + 1, contentArray, 0, n);
                            return new MultiContentNodeImpl(',', contentArray);
                        }
                        return this.content[i + 1];
                    }
                    if (content == null) continue;
                    int n = this.content.length - i;
                    if (n > 1) {
                        DTD.Content[] contentArray = new DTD.Content[n];
                        System.arraycopy(this.content, i + 1, contentArray, 1, n - 1);
                        contentArray[0] = content;
                        return new MultiContentNodeImpl(',', contentArray);
                    }
                    return content;
                }
                return null;
            }
            for (int i = 0; i < this.content.length; ++i) {
                DTD.Content content;
                DTD.Content content2 = this.content[i].reduce(string);
                if (content2 == EMPTY_CONTENT) {
                    int n = this.content.length - 1;
                    if (n > 1) {
                        DTD.Content[] contentArray = new DTD.Content[n];
                        System.arraycopy(this.content, 0, contentArray, 0, i);
                        if (i < contentArray.length) {
                            System.arraycopy(this.content, i + 1, contentArray, i, n - i);
                        }
                        return new MultiContentNodeImpl('&', contentArray);
                    }
                    return this.content[1 - i];
                }
                if (content2 == null) continue;
                if (this.content.length > 1) {
                    int n = this.content.length - 1;
                    DTD.Content[] contentArray = new DTD.Content[n];
                    System.arraycopy(this.content, 0, contentArray, 0, i);
                    if (i < contentArray.length) {
                        System.arraycopy(this.content, i + 1, contentArray, i, n - i);
                    }
                    content = new MultiContentNodeImpl('&', contentArray);
                } else {
                    content = this.content[1 - i];
                }
                return new MultiContentNodeImpl(',', new DTD.Content[]{content2, content});
            }
            return null;
        }

        @Override
        public Set getPossibleElements() {
            HashSet hashSet = new HashSet(11);
            if (this.type == '|' || this.type == '&') {
                for (int i = 0; i < this.content.length; ++i) {
                    hashSet.addAll(this.content[i].getPossibleElements());
                }
            } else {
                for (int i = 0; i < this.content.length; ++i) {
                    hashSet.addAll(this.content[i].getPossibleElements());
                    if (this.content[i].isDiscardable()) {
                        continue;
                    }
                    break;
                }
            }
            return hashSet;
        }
    }

    private static class UnaryContentNodeImpl
    implements DTD.ContentNode {
        int hashcode;
        char type;
        DTD.Content content;

        public UnaryContentNodeImpl(char c, DTD.Content content) {
            if (c != '*' && c != '?' && c != '+') {
                throw new IllegalArgumentException("Unknown unary content type '" + c + "'");
            }
            this.type = c;
            this.content = content;
            this.hashcode = c + content.hashCode();
        }

        public boolean isLeaf() {
            return false;
        }

        @Override
        public char getType() {
            return this.type;
        }

        public DTD.Content[] getContent() {
            return new DTD.Content[]{this.content};
        }

        public boolean equals(Object object) {
            if (!(object instanceof UnaryContentNodeImpl)) {
                return false;
            }
            return this.type == ((UnaryContentNodeImpl)object).type && this.content.equals(((UnaryContentNodeImpl)object).content);
        }

        public int hashCode() {
            return this.hashcode;
        }

        public String toString() {
            return this.content.toString() + this.type;
        }

        @Override
        public boolean isDiscardable() {
            if (this.type == '*' || this.type == '?') {
                return true;
            }
            return this.content.isDiscardable();
        }

        @Override
        public DTD.Content reduce(String string) {
            DTD.Content content = this.content.reduce(string);
            if (content == null) {
                return null;
            }
            if (content == EMPTY_CONTENT) {
                if (this.type == '?') {
                    return EMPTY_CONTENT;
                }
                if (this.type == '*') {
                    return this;
                }
                return new UnaryContentNodeImpl('*', this.content);
            }
            if (this.type == '?') {
                return content;
            }
            UnaryContentNodeImpl unaryContentNodeImpl = this.type == '*' ? this : new UnaryContentNodeImpl('*', this.content);
            return new MultiContentNodeImpl(',', new DTD.Content[]{content, unaryContentNodeImpl});
        }

        @Override
        public Set getPossibleElements() {
            return this.content.getPossibleElements();
        }
    }

    static class ContentLeafImpl
    implements DTD.ContentLeaf {
        String elemName;
        DTD.Element elem;

        public ContentLeafImpl(String string) {
            this.elemName = string;
        }

        public String getName() {
            return this.elemName;
        }

        @Override
        public DTD.Element getElement() {
            return this.elem;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ContentLeafImpl)) {
                return false;
            }
            return this.elemName.equals(((ContentLeafImpl)object).elemName);
        }

        public int hashCode() {
            return this.elemName.hashCode();
        }

        public String toString() {
            return this.elemName;
        }

        @Override
        public boolean isDiscardable() {
            return false;
        }

        @Override
        public DTD.Content reduce(String string) {
            if (this.elemName.equals(string)) {
                return EMPTY_CONTENT;
            }
            return null;
        }

        @Override
        public Set getPossibleElements() {
            HashSet<DTD.Element> hashSet = new HashSet<DTD.Element>();
            hashSet.add(this.elem);
            return hashSet;
        }
    }

    private static class ContentModelImpl
    implements DTD.ContentModel {
        int hashcode;
        DTD.Content content;
        Set included;
        Set excluded;

        public ContentModelImpl(DTD.Content content, Set set, Set set2) {
            this.content = content;
            this.included = set;
            this.excluded = set2;
            this.hashcode = content.hashCode() + 2 * ((Object)set).hashCode() + 3 * ((Object)set2).hashCode();
        }

        @Override
        public DTD.Content getContent() {
            return this.content;
        }

        @Override
        public Set getIncludes() {
            return this.included;
        }

        @Override
        public Set getExcludes() {
            return this.excluded;
        }

        public String toString() {
            Iterator iterator;
            StringBuffer stringBuffer = new StringBuffer(this.content.toString());
            if (!this.included.isEmpty()) {
                stringBuffer.append(" +(");
                iterator = this.included.iterator();
                while (true) {
                    stringBuffer.append(((DTD.Element)iterator.next()).getName());
                    if (!iterator.hasNext()) break;
                    stringBuffer.append("|");
                }
                stringBuffer.append(")");
            }
            if (!this.excluded.isEmpty()) {
                stringBuffer.append(" -(");
                iterator = this.excluded.iterator();
                while (true) {
                    stringBuffer.append(((DTD.Element)iterator.next()).getName());
                    if (!iterator.hasNext()) break;
                    stringBuffer.append("|");
                }
                stringBuffer.append(")");
            }
            return stringBuffer.toString();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ContentModelImpl)) {
                return false;
            }
            ContentModelImpl contentModelImpl = (ContentModelImpl)object;
            return this.content.equals(contentModelImpl.content) && ((Object)this.included).equals(contentModelImpl.included) && ((Object)this.excluded).equals(contentModelImpl.excluded);
        }

        public int hashCode() {
            return this.hashcode;
        }
    }

    private static class CharRefImpl
    implements DTD.CharRef {
        private String name;
        private char value;

        CharRefImpl(String string, char c) {
            this.name = string;
            this.value = c;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public char getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + "->'" + this.value + "'(&#" + this.value + ";)";
        }

        public boolean equals(Object object) {
            if (!(object instanceof CharRefImpl)) {
                return false;
            }
            return this.name.equals(((CharRefImpl)object).name) && this.value == ((CharRefImpl)object).value;
        }

        public int hashCode() {
            return this.name.hashCode() * this.value;
        }
    }

    private static class ValueImpl
    implements DTD.Value {
        String name;

        ValueImpl(String string) {
            this.name = string;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ValueImpl)) {
                return false;
            }
            return this.name.equals(((ValueImpl)object).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class AttributeImpl
    implements DTD.Attribute {
        private String name;
        private int type;
        private String baseType;
        private String typeHelper;
        private String defaultMode;
        private SortedMap values;
        private int hashcode;

        public AttributeImpl(String string, int n, String string2, String string3, String string4, SortedMap sortedMap) {
            this.name = string;
            this.type = n;
            this.baseType = string2;
            this.typeHelper = string3;
            this.defaultMode = string4;
            this.values = sortedMap;
            this.hashcode = string.hashCode() * (n + 1) * (string2 == null ? 1 : string2.hashCode()) + (string3 == null ? 1 : string3.hashCode()) + string4.hashCode() + (sortedMap == null ? 1 : sortedMap.hashCode());
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public String getBaseType() {
            return this.baseType;
        }

        @Override
        public String getTypeHelper() {
            return this.typeHelper;
        }

        @Override
        public String getDefaultMode() {
            return this.defaultMode;
        }

        @Override
        public boolean isRequired() {
            return this.defaultMode.equals("#REQUIRED");
        }

        @Override
        public List getValueList(String string) {
            if (this.type != 1) {
                return null;
            }
            string = string == null ? "" : string.toLowerCase();
            ArrayList arrayList = new ArrayList();
            for (Map.Entry entry : this.values.tailMap(string).entrySet()) {
                if (!entry.getKey().startsWith(string)) break;
                arrayList.add(entry.getValue());
            }
            return arrayList;
        }

        @Override
        public DTD.Value getValue(String string) {
            return (DTD.Value)this.values.get(string);
        }

        public String toString() {
            if (this.type == 1) {
                return this.name + " " + this.values + "[" + this.typeHelper + "] " + this.defaultMode;
            }
            if (this.type == 0) {
                return this.name + " (" + this.name + ")[" + this.typeHelper + "] " + this.defaultMode;
            }
            return this.name + " " + this.baseType + "[" + this.typeHelper + "] " + this.defaultMode;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object object) {
            if (!(object instanceof AttributeImpl)) {
                return false;
            }
            AttributeImpl attributeImpl = (AttributeImpl)object;
            return this.hashcode == attributeImpl.hashcode && this.name.equals(attributeImpl.name) && this.type == attributeImpl.type && (this.baseType == attributeImpl.baseType || this.baseType != null && this.baseType.equals(attributeImpl.baseType)) && (this.typeHelper == attributeImpl.typeHelper || this.typeHelper != null && this.typeHelper.equals(attributeImpl.typeHelper)) && this.defaultMode.equals(attributeImpl.defaultMode) && (this.values == attributeImpl.values || this.values != null && this.values.equals(attributeImpl.values));
        }
    }

    private static class ElementImpl
    implements DTD.Element {
        private String name;
        private DTD.ContentModel model;
        private boolean optStart;
        private boolean optEnd;
        private SortedMap attributes;
        private DTD dtd;

        ElementImpl(String string, DTD.ContentModel contentModel, boolean bl, boolean bl2, SortedMap sortedMap) {
            this.name = string;
            this.model = contentModel;
            this.optStart = bl;
            this.optEnd = bl2;
            this.attributes = sortedMap;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isEmpty() {
            return this.optEnd && this.model.getContent() instanceof DTD.ContentLeaf;
        }

        @Override
        public boolean hasOptionalStart() {
            return this.optStart;
        }

        @Override
        public boolean hasOptionalEnd() {
            return this.optEnd;
        }

        @Override
        public List getAttributeList(String string) {
            TreeSet treeSet = new TreeSet(new Comparator(){

                public int compare(Object object, Object object2) {
                    if (this.isRequired(object) && !this.isRequired(object2)) {
                        return -1;
                    }
                    if (!this.isRequired(object) && this.isRequired(object2)) {
                        return 1;
                    }
                    return ((DTD.Attribute)object).getName().compareTo(((DTD.Attribute)object2).getName());
                }

                private final boolean isRequired(Object object) {
                    return ((DTD.Attribute)object).getDefaultMode().equals("#REQUIRED");
                }
            });
            string = string.toLowerCase();
            for (Map.Entry entry : this.attributes.tailMap(string).entrySet()) {
                if (!entry.getKey().startsWith(string)) break;
                treeSet.add(entry.getValue());
            }
            return new ArrayList(treeSet);
        }

        @Override
        public DTD.Attribute getAttribute(String string) {
            return (DTD.Attribute)this.attributes.get(string);
        }

        void addAttribute(DTD.Attribute attribute) {
            this.attributes.put(attribute.getName(), attribute);
        }

        @Override
        public DTD.ContentModel getContentModel() {
            return this.model;
        }

        public String toString() {
            return super.toString() + "[" + this.name + (this.optStart ? " O" : " -") + (this.optEnd ? " O " : " - ") + this.model + " attribs=" + this.attributes + "]";
        }
    }

    private static class DTDImpl
    implements DTD {
        private String id;
        private SortedMap elements;
        private SortedMap charRefs;

        DTDImpl(String string, SortedMap sortedMap, SortedMap sortedMap2) {
            this.id = string;
            this.elements = sortedMap;
            this.charRefs = sortedMap2;
        }

        @Override
        public String getIdentifier() {
            return this.id;
        }

        @Override
        public List getElementList(String string) {
            ArrayList arrayList = new ArrayList();
            string = string == null ? "" : string.toUpperCase();
            for (Map.Entry entry : this.elements.tailMap(string).entrySet()) {
                if (!entry.getKey().startsWith(string)) break;
                arrayList.add(entry.getValue());
            }
            return arrayList;
        }

        @Override
        public DTD.Element getElement(String string) {
            return (DTD.Element)this.elements.get(string);
        }

        @Override
        public List getCharRefList(String string) {
            ArrayList arrayList = new ArrayList();
            for (Map.Entry entry : this.charRefs.tailMap(string).entrySet()) {
                if (!entry.getKey().startsWith(string)) break;
                arrayList.add(entry.getValue());
            }
            return arrayList;
        }

        @Override
        public DTD.CharRef getCharRef(String string) {
            return (DTD.CharRef)this.charRefs.get(string);
        }

        public String toString() {
            return super.toString() + "[id=" + this.id + ", elements=" + this.elements + ",charRefs=" + this.charRefs + "]";
        }
    }

    public static class WrongDTDException
    extends Exception {
        public WrongDTDException(String string) {
            super(string);
        }
    }
}

