/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.ExtUtilities;

public class ExtCaret
extends BaseCaret {
    public static final String HIGHLIGHT_ROW_LAYER_NAME = "highlight-row-layer";
    public static final int HIGHLIGHT_ROW_LAYER_VISIBILITY = 2050;
    public static final String HIGHLIGHT_BRACE_LAYER_NAME = "highlight-brace-layer";
    public static final int HIGHLIGHT_BRACE_LAYER_VISIBILITY = 11000;
    boolean highlightRow;
    boolean highlightBrace;
    Coloring highlightRowColoring;
    Coloring highlightBraceColoring;
    MarkFactory.DrawMark highlightRowMark;
    MarkFactory.DrawMark highlightBraceStartMark;
    MarkFactory.DrawMark highlightBraceEndMark;
    private Timer braceTimer;
    private ActionListener braceTimerListener;
    private boolean matchBraceUpdateSync;
    boolean braceMarksValid;
    boolean simpleMatchBrace;
    private boolean popupMenuEnabled;
    static final long serialVersionUID = -4292670043122577690L;

    @Override
    protected void modelChanged(BaseDocument baseDocument, BaseDocument baseDocument2) {
        this.braceMarksValid = false;
        if (this.highlightRowMark != null) {
            try {
                this.highlightRowMark.remove();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
            this.highlightRowMark = null;
        }
        if (this.highlightBraceStartMark != null) {
            try {
                this.highlightBraceStartMark.remove();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
            this.highlightBraceStartMark = null;
        }
        if (this.highlightBraceEndMark != null) {
            try {
                this.highlightBraceEndMark.remove();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
            this.highlightBraceEndMark = null;
        }
        super.modelChanged(baseDocument, baseDocument2);
    }

    @Override
    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        super.settingsChange(settingsChangeEvent);
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
            Class clazz = Utilities.getKitClass(jTextComponent);
            this.highlightRowColoring = editorUI.getColoring("highlight-caret-row");
            this.highlightBraceColoring = editorUI.getColoring("highlight-match-brace");
            boolean bl = this.highlightRow;
            this.highlightRow = SettingsUtil.getBoolean(clazz, "highlight-caret-row", ExtSettingsDefaults.defaultHighlightCaretRow);
            if (bl && !this.highlightRow && this.highlightRowMark != null) {
                try {
                    this.highlightRowMark.remove();
                }
                catch (InvalidMarkException invalidMarkException) {
                    // empty catch block
                }
                this.highlightRowMark = null;
            }
            this.highlightBrace = SettingsUtil.getBoolean(clazz, "highlight-match-brace", ExtSettingsDefaults.defaultHighlightMatchBrace);
            int n = SettingsUtil.getInteger(clazz, "highlight-match-brace-delay", ExtSettingsDefaults.defaultHighlightMatchBraceDelay);
            if (this.highlightBrace) {
                if (n > 0) {
                    final JTextComponent jTextComponent2 = this.component;
                    this.braceTimer = new Timer(n, null);
                    this.braceTimerListener = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            SwingUtilities.invokeLater(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    BaseDocument baseDocument;
                                    if (jTextComponent2 != null && (baseDocument = Utilities.getDocument(jTextComponent2)) != null) {
                                        baseDocument.readLock();
                                        try {
                                            ExtCaret.this.updateMatchBrace();
                                        }
                                        finally {
                                            baseDocument.readUnlock();
                                        }
                                    }
                                }
                            });
                        }
                    };
                    this.braceTimer.addActionListener(new WeakTimerListener(this.braceTimerListener));
                    this.braceTimer.setRepeats(false);
                } else {
                    this.braceTimer = null;
                }
                jTextComponent.repaint();
            }
            this.simpleMatchBrace = SettingsUtil.getBoolean(clazz, "caret-simple-match-brace", ExtSettingsDefaults.defaultCaretSimpleMatchBrace);
            this.popupMenuEnabled = SettingsUtil.getBoolean(clazz, "popup-menu-enabled", true);
        }
    }

    @Override
    public void install(JTextComponent jTextComponent) {
        EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
        editorUI.addLayer(new HighlightRowLayer(), 2050);
        editorUI.addLayer(new HighlightBraceLayer(), 11000);
        super.install(jTextComponent);
    }

    @Override
    public void deinstall(JTextComponent jTextComponent) {
        EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
        editorUI.removeLayer(HIGHLIGHT_ROW_LAYER_NAME);
        editorUI.removeLayer(HIGHLIGHT_BRACE_LAYER_NAME);
        super.deinstall(jTextComponent);
    }

    protected void updateMatchBrace() {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null && this.highlightBrace) {
            try {
                int[] nArray;
                EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int n = this.getDot();
                boolean bl = false;
                if (n > 0 && (nArray = ((ExtSyntaxSupport)baseDocument.getSyntaxSupport()).findMatchingBlock(n - 1, this.simpleMatchBrace)) != null) {
                    if (this.highlightBraceStartMark != null) {
                        int n2 = this.highlightBraceStartMark.getOffset();
                        int n3 = this.highlightBraceEndMark.getOffset();
                        if (n2 != nArray[0] || n3 != nArray[1]) {
                            editorUI.repaintBlock(n2, n3);
                            Utilities.moveMark(baseDocument, this.highlightBraceStartMark, nArray[0]);
                            Utilities.moveMark(baseDocument, this.highlightBraceEndMark, nArray[1]);
                            editorUI.repaintBlock(nArray[0], nArray[1]);
                        } else if (!this.braceMarksValid) {
                            editorUI.repaintBlock(nArray[0], nArray[1]);
                        }
                    } else {
                        this.highlightBraceStartMark = new MarkFactory.DrawMark(HIGHLIGHT_BRACE_LAYER_NAME, editorUI);
                        this.highlightBraceEndMark = new MarkFactory.DrawMark(HIGHLIGHT_BRACE_LAYER_NAME, editorUI);
                        this.highlightBraceStartMark.setActivateLayer(true);
                        Utilities.insertMark(baseDocument, this.highlightBraceStartMark, nArray[0]);
                        Utilities.insertMark(baseDocument, this.highlightBraceEndMark, nArray[1]);
                        editorUI.repaintBlock(nArray[0], nArray[1]);
                    }
                    this.braceMarksValid = true;
                    bl = true;
                }
                if (!bl && this.braceMarksValid) {
                    this.braceMarksValid = false;
                    editorUI.repaintBlock(this.highlightBraceStartMark.getOffset(), this.highlightBraceEndMark.getOffset());
                }
            }
            catch (BadLocationException badLocationException) {
                Utilities.annotateLoggable(badLocationException);
                this.highlightBrace = false;
            }
            catch (InvalidMarkException invalidMarkException) {
                Utilities.annotateLoggable(invalidMarkException);
                this.highlightBrace = false;
            }
        }
    }

    @Override
    protected void update(boolean bl) {
        JTextComponent jTextComponent;
        if (this.highlightRow && (jTextComponent = this.component) != null) {
            EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            int n = this.getDot();
            try {
                int n2 = Utilities.getRowStart(baseDocument, n);
                if (this.highlightRowMark != null) {
                    int n3 = this.highlightRowMark.getOffset();
                    if (n2 != n3) {
                        editorUI.repaintOffset(n3);
                        Utilities.moveMark(baseDocument, this.highlightRowMark, n2);
                        editorUI.repaintOffset(n2);
                    }
                } else {
                    this.highlightRowMark = new MarkFactory.DrawMark(HIGHLIGHT_ROW_LAYER_NAME, editorUI);
                    this.highlightRowMark.setActivateLayer(true);
                    Utilities.insertMark(baseDocument, this.highlightRowMark, n2);
                    editorUI.repaintOffset(n2);
                }
            }
            catch (BadLocationException badLocationException) {
                this.highlightRow = false;
            }
            catch (InvalidMarkException invalidMarkException) {
                this.highlightRow = false;
            }
        }
        if (this.highlightBrace) {
            if (this.matchBraceUpdateSync || this.braceTimer == null) {
                this.updateMatchBrace();
                this.matchBraceUpdateSync = false;
            } else {
                this.braceTimer.restart();
            }
        }
        super.update(bl);
    }

    public void requestMatchBraceUpdateSync() {
        this.matchBraceUpdateSync = true;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Completion completion = ExtUtilities.getCompletion(this.component);
        if (completion != null && completion.isPaneVisible()) {
            completion.setPaneVisible(false);
        }
        super.mousePressed(mouseEvent);
        this.showPopup(mouseEvent);
    }

    private boolean showPopup(MouseEvent mouseEvent) {
        if (this.component != null && mouseEvent.isPopupTrigger() && this.popupMenuEnabled) {
            ExtUtilities.getExtEditorUI(this.component).showPopupMenu(mouseEvent.getX(), mouseEvent.getY());
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.showPopup(mouseEvent)) {
            super.mouseReleased(mouseEvent);
        }
    }

    class HighlightBraceLayer
    extends DrawLayer.AbstractLayer {
        public HighlightBraceLayer() {
            super(ExtCaret.HIGHLIGHT_BRACE_LAYER_NAME);
        }

        @Override
        public void init(DrawContext drawContext) {
        }

        @Override
        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            if (ExtCaret.this.braceMarksValid) {
                if (drawMark != null) {
                    return drawMark.getActivateLayer();
                }
                try {
                    if (drawContext.getStartOffset() > ExtCaret.this.highlightBraceEndMark.getOffset()) {
                        return ExtCaret.this.highlightBraceEndMark.getActivateLayer();
                    }
                    if (drawContext.getStartOffset() > ExtCaret.this.highlightBraceStartMark.getOffset()) {
                        return ExtCaret.this.highlightBraceStartMark.getActivateLayer();
                    }
                }
                catch (InvalidMarkException invalidMarkException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void updateContext(DrawContext drawContext) {
            if (ExtCaret.this.highlightBraceColoring != null) {
                ExtCaret.this.highlightBraceColoring.apply(drawContext);
            }
        }
    }

    class HighlightRowLayer
    extends DrawLayerFactory.ColorLineLayer {
        public HighlightRowLayer() {
            super(ExtCaret.HIGHLIGHT_ROW_LAYER_NAME);
        }

        @Override
        protected Coloring getColoring(DrawContext drawContext) {
            return ExtCaret.this.highlightRowColoring;
        }
    }
}

