/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui.validation;

import com.jidesoft.popup.JidePopup;
import com.jidesoft.tooltip.BalloonShape;
import com.jidesoft.tooltip.BalloonTip;
import com.jidesoft.tooltip.shapes.RoundedRectangularBalloonShape;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.project.impl.settingsui.validation.ValidationRule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public final class BasicTextValidator {
    private final JTextComponent fField;
    private final BalloonTip fTip;
    private final MJLabel fTipContent;
    private final ValidationRule fRule;
    private int fLastKnownCaretPosition;
    private String fLastKnownText;
    private boolean fSuppressCheck;
    private boolean fMessageAllowed = true;

    public BasicTextValidator(JTextComponent jTextComponent, ValidationRule validationRule) {
        this.fField = jTextComponent;
        this.fLastKnownText = this.fField.getText();
        this.fRule = validationRule;
        this.fTipContent = new MJLabel();
        this.fTip = new BalloonTip((Component)this.fTipContent){

            protected void customizePopup(JidePopup jidePopup) {
                super.customizePopup(jidePopup);
                jidePopup.setResizable(false);
            }
        };
        this.fTip.setShadowStyle(null);
        this.fTip.setBalloonShape((BalloonShape)new RoundedRectangularBalloonShape(){
            {
                this.setBalloonSizeRatio(0.8);
            }

            public Insets getInsets(Dimension dimension) {
                return new Insets(6, 6, 25, 6);
            }
        });
        this.fField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (BasicTextValidator.this.fTip.isVisible()) {
                    BasicTextValidator.this.fTip.hide();
                }
            }
        });
        this.fField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                String string = BasicTextValidator.this.fRule.getErrorMessage(keyEvent);
                if (string != null) {
                    BasicTextValidator.this.showMessage(string);
                    keyEvent.consume();
                } else {
                    BasicTextValidator.this.fTip.hide();
                }
            }
        });
        this.fField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                BasicTextValidator.this.checkText();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                BasicTextValidator.this.checkText();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.fField.getCaret().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!BasicTextValidator.this.fSuppressCheck) {
                    BasicTextValidator.this.fLastKnownCaretPosition = BasicTextValidator.this.fField.getCaretPosition();
                }
            }
        });
    }

    public void reset() {
        this.fLastKnownCaretPosition = 0;
        this.fLastKnownText = "";
    }

    public void setMessageAllowed(boolean bl) {
        this.fMessageAllowed = bl;
    }

    private void checkText() {
        if (this.fSuppressCheck || !this.fField.hasFocus()) {
            this.fLastKnownText = this.fField.getText();
            return;
        }
        String string = this.fRule.getErrorMessage(this.fField.getText());
        if (string != null) {
            this.showMessage(string);
            this.fSuppressCheck = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BasicTextValidator.this.fField.setText(BasicTextValidator.this.fLastKnownText);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                BasicTextValidator.this.fField.setCaretPosition(BasicTextValidator.this.fLastKnownCaretPosition);
                            }
                            catch (RuntimeException runtimeException) {
                                // empty catch block
                            }
                            BasicTextValidator.this.fSuppressCheck = false;
                        }
                    });
                }
            });
        } else {
            this.fLastKnownCaretPosition = this.fField.getCaretPosition();
            this.fLastKnownText = this.fField.getText();
        }
    }

    private void showMessage(String string) {
        if (string != null && this.fMessageAllowed) {
            this.fTipContent.setText(string);
            Point point = new Point(this.fField.getWidth(), 4);
            Window window = SwingUtilities.windowForComponent(this.fField);
            if (window != null) {
                Point point2 = new Point(window.getWidth(), 0);
                point2 = SwingUtilities.convertPoint(window, point2, this.fField);
                while (point.getX() > 0.0 && this.fTip.getPreferredSize().getWidth() + point.getX() > point2.getX()) {
                    point.setLocation(point.getX() - 2.0, point.getY());
                }
            }
            this.fTip.show((JComponent)this.fField, (int)point.getX(), (int)point.getY());
        } else {
            this.fTip.hide();
        }
    }
}

