/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.plugin;

import com.mathworks.project.api.XmlLooper;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.plugin.XmlReaderImpl;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

final class XmlWriterImpl
implements XmlWriter {
    private final XmlWriterImpl fParent;
    private final Element fElement;

    XmlWriterImpl(XmlWriterImpl xmlWriterImpl, String string, String string2, String string3) {
        this.fParent = xmlWriterImpl;
        this.fElement = new Element(string);
        if (string2 != null) {
            this.fElement.setNamespace(Namespace.getNamespace((String)string2, (String)string3));
        }
        if (xmlWriterImpl != null) {
            xmlWriterImpl.fElement.addContent((Content)this.fElement);
        }
    }

    XmlWriterImpl(Element element) {
        this.fElement = element;
        this.fParent = null;
    }

    public XmlWriter writeXML(String string) {
        XmlReaderImpl xmlReaderImpl;
        try {
            xmlReaderImpl = new XmlReaderImpl(string);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(string + " is not valid XML");
        }
        this.writeXML(xmlReaderImpl);
        return this;
    }

    private void writeXML(XmlReader xmlReader) {
        final XmlWriterImpl xmlWriterImpl = this.createElement(xmlReader.getCurrentElementName());
        for (Map.Entry entry : xmlReader.readAttributes().entrySet()) {
            xmlWriterImpl.writeAttribute((String)entry.getKey(), entry.getValue());
        }
        String string = xmlReader.readText();
        if (string != null) {
            xmlWriterImpl.writeText(string);
        }
        xmlReader.loop(new XmlLooper(){

            public void iterate(XmlReader xmlReader) {
                xmlWriterImpl.writeXML(xmlReader);
            }
        }, new String[0]);
    }

    public XmlWriterImpl writeText(Object object) {
        if (object != null) {
            this.fElement.addContent(object.toString());
        }
        return this;
    }

    public XmlWriterImpl writeText(String string, Object ... objectArray) {
        for (Object object : objectArray) {
            Element element = new Element(string);
            if (object != null) {
                element.addContent(object.toString());
            }
            this.fElement.addContent((Content)element);
        }
        return this;
    }

    public XmlWriterImpl createElement(String string) {
        return this.createElement(string, null, null);
    }

    public XmlWriterImpl createElement(String string, String string2, String string3) {
        return new XmlWriterImpl(this, string, string2, string3);
    }

    public XmlWriterImpl writeAttribute(String string, Object object) {
        this.fElement.setAttribute(string, object.toString());
        return this;
    }

    public XmlWriterImpl getParent() {
        return this.fParent;
    }

    public synchronized String getXML() {
        StringWriter stringWriter = new StringWriter();
        Document document = new Document(this.getRoot().fElement);
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            xMLOutputter.output(document, (Writer)stringWriter);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        document.removeContent();
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            printWriter.print(this.getXML());
            printWriter.close();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public XmlWriter getSubtree() {
        return new XmlWriterImpl(this.fElement);
    }

    private XmlWriterImpl getRoot() {
        XmlWriterImpl xmlWriterImpl = this;
        while (xmlWriterImpl.getParent() != null) {
            xmlWriterImpl = xmlWriterImpl.fParent;
        }
        return xmlWriterImpl;
    }
}

