/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.model.EnumOptionExpression;
import com.mathworks.project.impl.model.FileSetFilter;
import com.mathworks.project.impl.model.InvalidParameterValueException;
import com.mathworks.project.impl.model.MatlabExpression;
import com.mathworks.project.impl.model.ParamType;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.model.ResourceStringProvider;
import com.mathworks.project.impl.model.XmlGenerationContext;
import com.mathworks.project.impl.model.XmlGenerationFlag;
import com.mathworks.project.impl.model.XslInput;
import com.mathworks.project.impl.settingsui.validation.ValidationRule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class Param {
    private final ResourceStringProvider fResourceProvider;
    private final String fKey;
    private final String fName;
    private final String fDescription;
    private final String fDetailedDescriptionHtml;
    private final String fInstanceKey;
    private final String fInstanceName;
    private final String fMoreInfoLinkText;
    private final String fMoreInfoLinkCallback;
    private final DynamicTargetAttribute fMoreInfoLinkVisible;
    private final ParamType fType;
    private final EnumOptionExpression fOptionExpression;
    private final MatlabExpression fDefaultValueExpression;
    private final boolean fShouldSaveUnsetValue;
    private final DynamicTargetAttribute fDefaultValue;
    private final DynamicTargetAttribute fVisible;
    private final DynamicTargetAttribute fEnabled;
    private final DynamicTargetAttribute fSyntax;
    private final Map<String, String> fOptions;
    private final List<FileSetFilter> fFileFilters;
    private final String fCustomWidgetClass;
    private final ValidationRule fValidationRule;
    private final boolean fExperimental;
    private final Map<String, String> fExtraAttributes;
    private final Map<String, String> fInfrastructureAttributes;
    private final Set<String> fProfileKeys;
    private final Set<String> fDependentKeys;

    public Param(ParamType paramType, ResourceStringProvider resourceStringProvider, String string, String string2, String string3, String string4, String string5, String string6, DynamicTargetAttribute dynamicTargetAttribute, String string7, String string8, EnumOptionExpression enumOptionExpression, MatlabExpression matlabExpression, DynamicTargetAttribute dynamicTargetAttribute2, Map<String, String> map, List<FileSetFilter> list, String string9, boolean bl, DynamicTargetAttribute dynamicTargetAttribute3, DynamicTargetAttribute dynamicTargetAttribute4, DynamicTargetAttribute dynamicTargetAttribute5, ValidationRule validationRule, boolean bl2, Set<String> set, Map<String, String> map2, Map<String, String> map3, Set<String> set2) {
        this.fResourceProvider = resourceStringProvider;
        this.fKey = string;
        this.fName = string2;
        this.fDescription = string3;
        this.fDetailedDescriptionHtml = string4;
        this.fMoreInfoLinkText = string5;
        this.fMoreInfoLinkCallback = string6;
        this.fMoreInfoLinkVisible = dynamicTargetAttribute;
        this.fInstanceKey = string7;
        this.fInstanceName = string8;
        this.fDefaultValueExpression = matlabExpression;
        this.fOptionExpression = enumOptionExpression;
        this.fType = paramType;
        this.fFileFilters = list == null ? new ArrayList<FileSetFilter>(0) : new ArrayList<FileSetFilter>(list);
        this.fOptions = map == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(map);
        this.fDefaultValue = dynamicTargetAttribute2;
        this.fCustomWidgetClass = string9;
        this.fVisible = dynamicTargetAttribute3;
        this.fShouldSaveUnsetValue = bl;
        this.fEnabled = dynamicTargetAttribute4;
        this.fSyntax = dynamicTargetAttribute5;
        this.fValidationRule = validationRule;
        this.fExperimental = bl2;
        this.fExtraAttributes = new TreeMap<String, String>(map3);
        this.fInfrastructureAttributes = new TreeMap<String, String>(map2);
        this.fProfileKeys = new HashSet<String>(set);
        this.fDependentKeys = new HashSet<String>(set2);
    }

    public ResourceStringProvider getResourceProvider() {
        return this.fResourceProvider;
    }

    public DynamicTargetAttribute getDefaultValueAttribute() {
        return this.fDefaultValue;
    }

    public Set<String> getProfileKeys() {
        return new HashSet<String>(this.fProfileKeys);
    }

    public boolean isExperimental() {
        return this.fExperimental;
    }

    public String getInstanceKey() {
        return this.fInstanceKey;
    }

    public String getInstanceName() {
        return this.fInstanceName;
    }

    public String getCustomWidgetClassName() {
        return this.fCustomWidgetClass;
    }

    public ParamType getType() {
        return this.fType;
    }

    public EnumOptionExpression getOptionExpression() {
        return this.fOptionExpression;
    }

    public MatlabExpression getDefaultValueExpression() {
        return this.fDefaultValueExpression;
    }

    public DynamicTargetAttribute getVisibleAttribute() {
        return this.fVisible;
    }

    public DynamicTargetAttribute getEnabledAttribute() {
        return this.fEnabled;
    }

    public DynamicTargetAttribute getSyntax() {
        return this.fSyntax;
    }

    public ValidationRule getValidationRule() {
        return this.fValidationRule;
    }

    public boolean shouldSaveUnsetValue() {
        return this.fShouldSaveUnsetValue;
    }

    public String getKey() {
        return this.fKey;
    }

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getDetailedDescriptionHtml() {
        return this.fDetailedDescriptionHtml;
    }

    public String getMoreInfoLinkText() {
        return this.fMoreInfoLinkText;
    }

    public String getMoreInfoLinkCallback() {
        return this.fMoreInfoLinkCallback;
    }

    public DynamicTargetAttribute getMoreInfoLinkVisible() {
        return this.fMoreInfoLinkVisible;
    }

    public List<FileSetFilter> getFileFilters() {
        return new ArrayList<FileSetFilter>(this.fFileFilters);
    }

    public Map<String, String> getExtraAttributes() {
        return new TreeMap<String, String>(this.fExtraAttributes);
    }

    public Map<String, String> getInfrastructureAttributes() {
        return new TreeMap<String, String>(this.fInfrastructureAttributes);
    }

    public LinkedHashMap<String, String> getOptions() {
        return new LinkedHashMap<String, String>(this.fOptions);
    }

    public Object evaluate(Project project) {
        return this.evaluate(project, new XmlGenerationContext(new XmlGenerationFlag[0]));
    }

    public Object evaluate(Project project, XmlGenerationContext xmlGenerationContext) {
        Object object = project.getConfiguration().getSetParameterValue(this.fKey);
        if (object != null) {
            return object;
        }
        return this.evaluateDefault(project, xmlGenerationContext);
    }

    public Object evaluateDefault(Project project) {
        return this.evaluateDefault(project, new XmlGenerationContext(new XmlGenerationFlag[0]));
    }

    public Object evaluateDefault(Project project, XmlGenerationContext xmlGenerationContext) {
        if (this.fDefaultValue != null) {
            XmlReader xmlReader = null;
            try {
                XmlGenerationContext xmlGenerationContext2 = new XmlGenerationContext(xmlGenerationContext, this.fKey).withFlags(XmlGenerationFlag.EXCLUDE_BUILD_DELIVERABLES);
                String string = ProjectManager.configurationToXslInput(project, xmlGenerationContext2);
                xmlReader = this.fDefaultValue.evaluate(new XslInput(string));
                return this.fType.deserialize(project, this, xmlReader);
            }
            catch (InvalidParameterValueException invalidParameterValueException) {
                throw new IllegalStateException("The default parameter XSL for " + this.fKey + " generated the unacceptable result: " + xmlReader.getXML());
            }
        }
        return this.fType.getDefaultValue(this);
    }

    public String toString() {
        return this.fName;
    }

    public Set<String> getDependentKeys() {
        return this.fDependentKeys;
    }
}

