/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.SimpleDOMParser;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.desktop.ProjectAction;
import com.mathworks.project.impl.desktop.ProjectClient;
import com.mathworks.services.Prefs;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.ComponentIcon;
import com.mathworks.widgets.desk.DTToolBarConfiguration;
import com.mathworks.widgets.desk.DTToolBarFactory;
import com.mathworks.widgets.desk.DTToolBarInfo;
import com.mathworks.widgets.desk.DTToolBarRegistry;
import com.mathworks.widgets.desk.DTToolSet;
import com.mathworks.xml.XMLUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class CustomizableToolbar {
    static final String NON_PLUGIN_SPECIFIC_KEY = "9b";
    private static final String PACKAGE_SUPPORT_KEY_SUFFIX = "_p";
    public static final String HISTORY_COMPONENT_KEY = "history";
    public static final String ACTION_BUTTON_COMPONENT_KEY = "actions";
    private final String fPluginKey;
    private final JToolBar fToolBar;
    private final DTToolBarInfo fInfo;

    CustomizableToolbar(final ProjectClient projectClient, List<ProjectAction> list, List<String> list2, JComponent jComponent, JComponent jComponent2, String string, boolean bl) {
        ProjectAction projectAction2;
        for (int i = 0; i < list2.size(); ++i) {
            list2.set(i, list2.get(i).toLowerCase(Locale.ENGLISH));
        }
        this.fPluginKey = string + (bl ? PACKAGE_SUPPORT_KEY_SUFFIX : "");
        DTToolSet dTToolSet = new DTToolSet(){

            public boolean includeLabelOnBar(String string) {
                return false;
            }
        };
        dTToolSet.add(HISTORY_COMPONENT_KEY, BuiltInResources.getString("history.toolbar.label"), (Component)jComponent2, (Icon)ComponentIcon.COMBO_BOX.getIcon());
        for (ProjectAction projectAction2 : list) {
            dTToolSet.add(projectAction2.getKey().toLowerCase(Locale.ENGLISH), (Action)((Object)projectAction2));
        }
        dTToolSet.add(ACTION_BUTTON_COMPONENT_KEY, BuiltInResources.getString("tooltip.actions"), (Component)jComponent, (Icon)DocumentIcon.ACTIONS.getIcon());
        DTToolBarConfiguration dTToolBarConfiguration = new DTToolBarConfiguration(list2);
        this.fInfo = new DTToolBarInfo("deploytool", BuiltInResources.getString("title"), dTToolSet, dTToolBarConfiguration);
        this.fToolBar = DTToolBarFactory.createToolBar((DTToolBarInfo)this.fInfo, (DTToolBarConfiguration)dTToolBarConfiguration, (Object)projectClient.getComponent());
        this.fToolBar.setBorder(BorderFactory.createEmptyBorder(2, 0, 4, 0));
        projectAction2 = new MJPopupMenu();
        projectAction2.add((Action)new MJAbstractAction(BuiltInResources.getString("toolbar.popup.customize")){

            public void actionPerformed(ActionEvent actionEvent) {
                MLDesktop.getInstance().showToolBarCustomizationPanel(CustomizableToolbar.this.fInfo.getKey());
            }
        });
        final MouseAdapter mouseAdapter = new MouseAdapter((MJPopupMenu)projectAction2){
            final /* synthetic */ MJPopupMenu val$popup;
            {
                this.val$popup = mJPopupMenu;
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (MJUtilities.isMacintoshPopupTrigger((MouseEvent)mouseEvent) || !PlatformInfo.isMacintosh() && SwingUtilities.isRightMouseButton(mouseEvent)) {
                    this.val$popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        this.fToolBar.addMouseListener(mouseAdapter);
        MLDesktop.getInstance().getToolBarRegistry().register(this.fInfo.getKey(), new DTToolBarRegistry.Registrant(){
            private DTToolBarConfiguration fConfig;
            {
                this.updateToolBars(CustomizableToolbar.this.fInfo.getKey(), CustomizableToolbar.load(CustomizableToolbar.this.fInfo.getToolSet(), CustomizableToolbar.this.fInfo.getDefaultConfig(), CustomizableToolbar.this.fPluginKey));
            }

            public String getToolBarLabel(String string) {
                return CustomizableToolbar.this.fInfo.getLabel();
            }

            public DTToolBarInfo getToolBarInfo(String string) {
                return CustomizableToolbar.this.fInfo;
            }

            public DTToolBarConfiguration getToolBarConfiguration(String string) {
                return this.fConfig;
            }

            public void updateToolBars(String string, DTToolBarConfiguration dTToolBarConfiguration) {
                this.fConfig = dTToolBarConfiguration;
                CustomizableToolbar.save(this.fConfig, CustomizableToolbar.this.fPluginKey);
                DTToolBarFactory.udpateToolBar((JToolBar)CustomizableToolbar.this.fToolBar, (DTToolSet)CustomizableToolbar.this.fInfo.getToolSet(), (DTToolBarConfiguration)this.fConfig, (Object)projectClient);
                for (int i = 0; i < CustomizableToolbar.this.fToolBar.getComponentCount(); ++i) {
                    CustomizableToolbar.this.fToolBar.getComponent(i).removeMouseListener(mouseAdapter);
                    CustomizableToolbar.this.fToolBar.getComponent(i).addMouseListener(mouseAdapter);
                }
            }
        });
    }

    void dispose() {
        MLDesktop.getInstance().getToolBarRegistry().unregister(this.fInfo.getKey());
    }

    JToolBar getComponent() {
        return this.fToolBar;
    }

    static void save(DTToolBarConfiguration dTToolBarConfiguration, String string) {
        try {
            File file = new File(new File(Prefs.getPropertyDirectory()), "deploytool_toolbar_" + string + ".xml");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = dTToolBarConfiguration.toXML(document, null);
            document.appendChild(element);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8");
            XMLUtils.serializeXML((Object)document, (Object)outputStreamWriter, (String)"utf-8");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
    }

    static DTToolBarConfiguration load(DTToolSet dTToolSet, DTToolBarConfiguration dTToolBarConfiguration, String string) {
        File file = new File(new File(Prefs.getPropertyDirectory()), "deploytool_toolbar_" + string + ".xml");
        if (!file.exists()) {
            file = new File(new File(Prefs.getPropertyDirectory()), "deploytool_toolbar_9b.xml");
        }
        DTToolBarConfiguration dTToolBarConfiguration2 = dTToolBarConfiguration;
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "utf-8"));
                SimpleDOMParser simpleDOMParser = new SimpleDOMParser();
                SimpleElement simpleElement = simpleDOMParser.parse((Reader)bufferedReader);
                dTToolBarConfiguration2 = new DTToolBarConfiguration(simpleElement);
                dTToolBarConfiguration2 = DTToolBarFactory.reconcile((DTToolSet)dTToolSet, (DTToolBarConfiguration)dTToolBarConfiguration2, (DTToolBarConfiguration)dTToolBarConfiguration);
                fileInputStream.close();
            }
            catch (Exception exception) {
                dTToolBarConfiguration2 = dTToolBarConfiguration;
            }
        }
        return dTToolBarConfiguration2;
    }
}

