/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.util.ParseDate;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;

public class Cookie
implements Serializable {
    String name;
    String value;
    String comment;
    String domain;
    int maxAge;
    String path;
    boolean secure;
    Date expires;
    String version;
    private int size = 0;
    private long lastAccess;
    private boolean isPrivate = false;

    public Cookie() {
    }

    Cookie(URL uRL) {
        int n;
        this.version = null;
        this.comment = null;
        this.value = null;
        this.name = null;
        this.maxAge = 0;
        this.secure = false;
        this.expires = null;
        this.domain = uRL.getHost();
        this.path = uRL.getFile();
        if (!this.path.endsWith("/") && (n = this.path.lastIndexOf(47)) >= 0) {
            this.path = this.path.substring(0, n + 1);
        }
    }

    public Cookie(String string, String string2, String string3, String string4, int n, String string5, boolean bl, Date date, String string6) {
        this.name = string;
        this.value = string2;
        this.comment = string3;
        this.domain = string4;
        this.maxAge = n;
        this.path = string5;
        this.secure = bl;
        this.expires = date;
        this.version = string6;
    }

    public String toString() {
        String string = "Cookie: " + this.name + "=" + this.value + "; Comment=" + this.comment + "; Domain=" + this.domain + "Max-Age=" + this.maxAge + "; Path=" + this.path + "; Version=" + this.version + "; Secure=" + this.secure;
        return string;
    }

    public static Cookie parseFromString(URL uRL, String string) {
        Cookie cookie = new Cookie(uRL);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3;
            String string4 = stringTokenizer.nextToken();
            int n = string4.indexOf(61);
            if (n > 0) {
                string3 = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            } else {
                string3 = string4;
                string2 = "";
            }
            string3 = string3.trim();
            string2 = string2.trim();
            if (string3.equalsIgnoreCase("comment")) {
                cookie.comment = string2;
                continue;
            }
            if (string3.equalsIgnoreCase("domain")) {
                cookie.domain = string2;
                continue;
            }
            if (string3.equalsIgnoreCase("path")) {
                cookie.path = string2;
                continue;
            }
            if (string3.equalsIgnoreCase("version")) {
                cookie.version = string2;
                continue;
            }
            if (string3.equalsIgnoreCase("expires")) {
                cookie.expires = ParseDate.parseDate((String)string2);
                continue;
            }
            if (string3.equalsIgnoreCase("secure")) {
                cookie.secure = true;
                continue;
            }
            if (string3.equalsIgnoreCase("max-age")) {
                cookie.maxAge = Integer.parseInt(string2);
                cookie.expires = new Date(System.currentTimeMillis() + (long)(cookie.maxAge * 1000));
                continue;
            }
            if (string3.equalsIgnoreCase("httponly")) continue;
            cookie.name = string3;
            cookie.value = string2;
        }
        if (cookie.name == null || cookie.value == null) {
            cookie = null;
        }
        if (cookie != null) {
            cookie.OEAB(string.length());
        }
        return cookie;
    }

    private void OEAB(int n) {
        this.size = n;
    }

    public boolean isExpired() {
        return this.expires != null && this.expires.before(new Date());
    }

    public boolean isSessionCookie() {
        return this.expires == null;
    }

    public String use() {
        this.lastAccess = System.currentTimeMillis();
        return this.name + "=" + this.value;
    }

    public long lastUsed() {
        return this.lastAccess;
    }

    public int size() {
        return this.size;
    }

    public Date expirationDate() {
        return new Date(this.expires.getTime());
    }

    public void setExpirationDate(Date date) {
        this.expires = date;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int n) {
        this.maxAge = n;
    }

    public void setPrivate(boolean bl) {
        this.isPrivate = bl;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }
}

