/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.util;

import com.mathworks.comparisons.util.ResourceManager;
import java.text.MessageFormat;

public class HTMLUtils {
    private static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String DOCTYPE_DECLARATION_STRING = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">";
    private static final String HTML_ELEMENT_STRING = "<html xmlns=\"http://www.w3.org/1999/xhtml\">";
    private static final String META_ELEMENT_STRING = "<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />";
    private static final String CSS_LINK_STRING = "<link rel=\"stylesheet\" href=\"{0}\" type=\"text/css\" />";
    private static final String COMPARED_BODY = "<table border=\"0\" width=\"100%\" height=\"100%\"><tr><td align=\"center\" valign=\"middle\">{0}</td></tr></table>";

    public static String getComparedIdenticalAsHTML(String string, String string2) {
        return HTMLUtils.wrapInHTML("", HTMLUtils.getComparedBody(ResourceManager.format("binarycomparison.identical", string, string2)));
    }

    public static String getComparedDifferentAsHTML(String string, String string2) {
        return HTMLUtils.wrapInHTML("", HTMLUtils.getComparedBody(ResourceManager.format("binarycomparison.different", string, string2)));
    }

    public static String wrapInHTML(String string, String string2) {
        return MessageFormat.format("{0}<title>{1}</title></head><body><h4>{1}</h4><p>{2}</p></body></html>", HTMLUtils.makeHeadHTML(), string, string2);
    }

    private static String makeHeadHTML() {
        return MessageFormat.format("{0}{1}{2}{3}", HTMLUtils.getXMLDeclaration(), HTMLUtils.getDocTypeDeclaration(), HTMLUtils.getHTMLElement(), HTMLUtils.getMetaElement());
    }

    private static String getXMLDeclaration() {
        return XML_DECLARATION;
    }

    private static String getDocTypeDeclaration() {
        return DOCTYPE_DECLARATION_STRING;
    }

    private static String getHTMLElement() {
        return HTML_ELEMENT_STRING;
    }

    private static String getMetaElement() {
        return META_ELEMENT_STRING;
    }

    private static String getComparedBody(String string) {
        return MessageFormat.format(COMPARED_BODY, string);
    }

    private HTMLUtils() {
    }
}

