/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.desktop.overlay;

import com.mathworks.desktop.overlay.OverlayEffect;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.logger.Log;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;

public class Effects {
    public static OverlayEffect appearIn(final int n) {
        return new OverlayEffect(){
            float fTransparency = 0.0f;
            String fKey;

            @Override
            public Component create(Component component) {
                return new EffectComponent(component){

                    @Override
                    public void paint(Graphics graphics) {
                        Graphics2D graphics2D = (Graphics2D)graphics.create();
                        graphics2D.setComposite(AlphaComposite.getInstance(3, fTransparency));
                        super.paint(graphics2D);
                    }
                };
            }

            @Override
            public void start(final Component component) {
                final long l = System.currentTimeMillis();
                final long l2 = l + (long)n;
                this.fKey = component + "_appear";
                AnimationService.start(this.fKey, new Runnable(){

                    @Override
                    public void run() {
                        long l3 = System.currentTimeMillis();
                        if (l3 > l2) {
                            AnimationService.stop(fKey);
                        } else {
                            fTransparency = (float)(l3 - l) / (float)(l2 - l);
                            component.repaint();
                        }
                    }
                });
            }

            @Override
            public void stop(Component component) {
                AnimationService.stop(this.fKey);
            }
        };
    }

    public static final class AnimationService {
        private static final Log LOG = Log.getInstance((String)"com.mathworks.util.AnimationService");
        public static final int INTERNAL_PERIOD = 50;
        private static final Map<Object, Task> myTasks = new WeakHashMap<Object, Task>();
        private static long myInternalCounter;
        private static Runnable myRunner;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean isRunning(Object object) {
            Map<Object, Task> map = myTasks;
            synchronized (map) {
                return myTasks.containsKey(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void stop(Object object) {
            Map<Object, Task> map = myTasks;
            synchronized (map) {
                myTasks.remove(object);
            }
        }

        public static void start(Object object, Runnable runnable) {
            AnimationService.start(object, runnable, 50);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void start(Object object, Runnable runnable, int n) {
            Map<Object, Task> map = myTasks;
            synchronized (map) {
                myTasks.put(object, new Task(runnable, n));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean startIfNotRunning(Object object, Runnable runnable, int n) {
            Map<Object, Task> map = myTasks;
            synchronized (map) {
                if (!AnimationService.isRunning(object)) {
                    myTasks.put(object, new Task(runnable, n));
                    return true;
                }
                return false;
            }
        }

        static {
            myRunner = new MyRunner();
            Thread thread = new Thread((Runnable)new MyAnimator(), "Animation Service");
            thread.setDaemon(true);
            thread.setPriority(5);
            thread.start();
        }

        private static class Task {
            private Runnable runnable;
            private int skipLoops;
            private int current;

            public Task(Runnable runnable, int n) {
                this.runnable = runnable;
                this.current = this.skipLoops = n / 50;
            }
        }

        private static class MyAnimator
        implements Runnable {
            private MyAnimator() {
            }

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    MJUtilities.invokeLater((Runnable)myRunner);
                }
            }
        }

        private static class MyRunner
        implements Runnable {
            private final List<Task> torun = new ArrayList<Task>();
            private boolean running;

            private MyRunner() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                myInternalCounter++;
                if (this.running) {
                    return;
                }
                this.running = true;
                try {
                    this.torun.clear();
                    Map map = myTasks;
                    synchronized (map) {
                        for (Task task : myTasks.values()) {
                            if (task == null || --task.current > 0) continue;
                            task.current = task.skipLoops;
                            this.torun.add(task);
                        }
                    }
                    for (Task task : this.torun) {
                        try {
                            task.runnable.run();
                        }
                        catch (Throwable throwable) {
                            LOG.error(throwable);
                        }
                    }
                }
                finally {
                    this.running = false;
                }
            }
        }
    }

    private static class EffectComponent
    extends JComponent {
        EffectComponent(Component component) {
            this.setLayout(new BorderLayout());
            this.add(component, "Center");
            this.setOpaque(false);
        }
    }
}

