/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table;

import com.mathworks.hg.types.table.ColumnFormatEnum;
import com.mathworks.hg.types.table.format.FormatTypeEnum;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ColumnDefinition {
    private String title;
    private boolean autoWidth;
    private Long fixedWidth;
    private boolean editability;
    private ColumnFormatEnum format;
    private List<String> choiceList;
    private FormatTypeEnum formatType;
    private String formatString;

    public ColumnDefinition(String string) {
        this.title = string;
        this.autoWidth = true;
        this.fixedWidth = null;
        this.editability = false;
        this.format = ColumnFormatEnum.DEFAULT;
        this.choiceList = new LinkedList<String>();
        this.formatType = null;
        this.formatString = null;
    }

    public ColumnDefinition(ColumnDefinition columnDefinition) {
        this.title = columnDefinition.getTitle();
        this.autoWidth = columnDefinition.isAutoWidth();
        this.fixedWidth = columnDefinition.getFixedWidth();
        this.editability = columnDefinition.isEditable();
        this.format = columnDefinition.getFormat();
        this.choiceList = new LinkedList<String>();
        if (columnDefinition.getChoiceList() != null) {
            for (String string : columnDefinition.getChoiceList()) {
                this.choiceList.add(string);
            }
        }
        this.formatType = columnDefinition.getCustomFormatType();
        this.formatString = columnDefinition.getCustomFormatString();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public boolean isEditable() {
        return this.editability;
    }

    public void setEditable(boolean bl) {
        this.editability = bl;
    }

    public ColumnFormatEnum getFormat() {
        return this.format;
    }

    public void setFormat(ColumnFormatEnum columnFormatEnum) {
        if (this.getFormat() != columnFormatEnum) {
            this.choiceList = columnFormatEnum == ColumnFormatEnum.CHOICE_LIST ? new ArrayList<String>() : null;
        }
        this.format = columnFormatEnum;
    }

    public Long getFixedWidth() {
        return this.fixedWidth;
    }

    public void setFixedWidth(Long l) {
        this.fixedWidth = l;
    }

    public boolean isAutoWidth() {
        return this.autoWidth;
    }

    public void setAutoWidth(boolean bl) {
        this.autoWidth = bl;
    }

    public void setChoiceList(List<String> list) {
        this.choiceList.clear();
        for (String string : list) {
            this.choiceList.add(string);
        }
        if (this.choiceList.isEmpty()) {
            this.setFormat(ColumnFormatEnum.DEFAULT);
        }
    }

    public List<String> getChoiceList() {
        return this.choiceList;
    }

    public void setCustomFormatType(FormatTypeEnum formatTypeEnum) {
        this.formatType = formatTypeEnum;
    }

    public FormatTypeEnum getCustomFormatType() {
        return this.formatType;
    }

    public void setCustomFormatString(String string) {
        this.formatString = string;
    }

    public String getCustomFormatString() {
        return this.formatString;
    }
}

