/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.hg.types.AlphaCategory;
import com.mathworks.hg.types.AlphaEnum;
import com.mathworks.hg.types.AlphaSpec;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class HGAlpha {
    static final String FLAT_STRING = "flat";
    static final String INTERP_STRING = "interp";
    static final String TEXTUREMAP_STRING = "texturemap";
    static final String AUTO_STRING = "auto";
    static final double MAX_ALPHA = 1.0;
    static final double MIN_ALHPA = 0.0;
    private volatile double fAlpha = 0.0;
    static final int ALPHA = -1;
    static final int FLAT = 0;
    static final int INTERP = 1;
    static final int TEXTUREMAP = 2;
    static final int AUTO = 3;
    private volatile int fStyle;
    static final int NONE_FLAT_INTERP_TEXTURE = 0;
    static final int NONE_FLAT_INTERP = 1;
    static final int NONE_ONLY = 2;
    private volatile int fAllowedStyles;
    private static final NumberFormat sNumberFormat = NumberFormat.getInstance(Locale.ENGLISH);

    public HGAlpha(double d, int n) {
        this.fAlpha = d;
        this.fStyle = -1;
        this.fAllowedStyles = n;
    }

    public HGAlpha(int n, int n2) {
        this.fStyle = n;
        this.fAllowedStyles = n2;
    }

    public double getAlpha() {
        return this.fAlpha;
    }

    public void setAlpha(double d) {
        this.fAlpha = d;
    }

    public int getStyle() {
        return this.fStyle;
    }

    public void setStyle(int n) {
        this.fStyle = n;
    }

    public String getValueAndStyleAsString() {
        String string = null;
        if (this.fStyle == 0) {
            string = FLAT_STRING;
        } else if (this.fStyle == 1) {
            string = INTERP_STRING;
        } else if (this.fStyle == 2) {
            string = TEXTUREMAP_STRING;
        } else if (this.fStyle == 3) {
            string = AUTO_STRING;
        } else if (this.fStyle == -1) {
            string = String.valueOf(this.fAlpha);
        }
        return string;
    }

    public void setValueAndStyleAsString(String string) {
        if (string.equalsIgnoreCase(FLAT_STRING) && (this.fAllowedStyles == 0 || this.fAllowedStyles == 1)) {
            this.setStyle(0);
        } else if (string.equalsIgnoreCase(INTERP_STRING) && (this.fAllowedStyles == 0 || this.fAllowedStyles == 1)) {
            this.setStyle(1);
        } else if (string.equalsIgnoreCase(TEXTUREMAP_STRING) && this.fAllowedStyles == 0) {
            this.setStyle(2);
        } else {
            double d;
            Number number = null;
            try {
                number = sNumberFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (number != null && (d = number.doubleValue()) >= 0.0 && d <= 1.0) {
                this.setAlpha(number.doubleValue());
                this.setStyle(-1);
            }
        }
    }

    public int getAllowedStyles() {
        return this.fAllowedStyles;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof HGAlpha) {
            HGAlpha hGAlpha = (HGAlpha)object;
            bl = hGAlpha.getStyle() == this.getStyle() && (this.getStyle() != -1 || hGAlpha.getAlpha() == this.getAlpha());
        }
        return bl;
    }

    public static HGAlpha valueOf(AlphaSpec alphaSpec) {
        if (alphaSpec == null) {
            return null;
        }
        AlphaCategory alphaCategory = alphaSpec.getCategory();
        assert (alphaCategory != null);
        if (alphaSpec.isCategorical()) {
            AlphaEnum alphaEnum = alphaSpec.getCategoricalValue();
            HGAlpha hGAlpha = new HGAlpha(alphaEnum.getId(), alphaCategory.getId());
            return hGAlpha;
        }
        double d = alphaSpec.getContinuousValue();
        HGAlpha hGAlpha = new HGAlpha(d, alphaCategory.getId());
        return hGAlpha;
    }

    public AlphaSpec getAlphaSpec() {
        AlphaCategory alphaCategory = AlphaCategory.find(this.fAllowedStyles);
        assert (alphaCategory != null);
        if (this.fStyle == -1) {
            AlphaSpec alphaSpec = new AlphaSpec(this.fAlpha, alphaCategory);
            return alphaSpec;
        }
        AlphaEnum alphaEnum = AlphaEnum.find(this.fStyle);
        assert (alphaEnum != null);
        AlphaSpec alphaSpec = new AlphaSpec(alphaEnum, alphaCategory);
        return alphaSpec;
    }

    public String toString() {
        AlphaSpec alphaSpec = this.getAlphaSpec();
        return alphaSpec.toString();
    }
}

