/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.CDataGrabber;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FigureComponent;
import com.mathworks.hg.peer.FigurePanel;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.GLCanvasInterface;
import com.mathworks.hg.peer.HGCanvasPeer;
import com.mathworks.hg.peer.JavaSceneServerGLCanvas;
import com.mathworks.hg.peer.JavaSceneServerPeer;
import com.mathworks.hg.peer.JavaSceneServerPeerInterface;
import com.mathworks.hg.peer.OffscreenWindowProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.swing.JPanel;

public class JavaSceneServerOffScreenCanvas
extends JPanel
implements FigureComponent,
CDataGrabber.CDataGrabberProvider,
HGCanvasPeer,
FigurePanel.Child {
    private GLCanvasInterface fOffscreenCanvas = null;
    private JavaSceneServerPeerInterface fJSSP;
    private boolean fIsOffScreen = false;
    private boolean fHasLightweightSiblings;
    private boolean fInitialized = false;
    private boolean fDisposed = true;
    private FigurePanel.ChildAdapter fChildAdapter = new FigurePanel.ChildAdapter(this);
    private InitializedListener fParentHierarchyListener = null;
    private InitializedListener fParentContainerListener = null;
    private Vector<InitializedListener> fSiblingListeners = null;
    private Container fOldParent = null;
    private Vector<Container> fOldSiblings = null;

    protected GLCanvasInterface createCanvas(GLCapabilities gLCapabilities, JavaSceneServerPeerInterface javaSceneServerPeerInterface) {
        return new JavaSceneServerGLCanvas(gLCapabilities, javaSceneServerPeerInterface);
    }

    public JavaSceneServerOffScreenCanvas(GLCapabilities gLCapabilities, JavaSceneServerPeerInterface javaSceneServerPeerInterface) {
        this.fOffscreenCanvas = this.createCanvas(gLCapabilities, javaSceneServerPeerInterface);
        this.fDisposed = false;
        this.fOffscreenCanvas.getComponent().setEnabled(!FigurePeer.LightWeightManager.isUseLightWeightContainer());
        this.fJSSP = javaSceneServerPeerInterface;
        this.setLayout(new BorderLayout());
        this.moveCanvasOffScreen();
        this.moveCanvasOnScreen();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DebugUtilities.logMessage(512, "JavaSceneServerOffScreenCanvas.ComponentAdapter.componentResized", this);
                JavaSceneServerOffScreenCanvas.this.fixCanvasSize();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JavaSceneServerOffScreenCanvas.this.requestFocus();
            }
        });
    }

    @Override
    public void dispose() {
        if (this.fOffscreenCanvas != null) {
            this.moveCanvasOnScreen();
            this.fOffscreenCanvas.dispose();
            this.fOffscreenCanvas = null;
            this.fDisposed = true;
        }
    }

    private void fixCanvasSize() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.fOffscreenCanvas.getComponent().getWidth() != n || this.fOffscreenCanvas.getComponent().getHeight() != n2) {
            this.fOffscreenCanvas.getComponent().setSize(n, n2);
            this.causeExpose();
        }
    }

    @Override
    public void setCDataGrabber(CDataGrabber cDataGrabber) {
        this.fOffscreenCanvas.setCDataGrabber(cDataGrabber);
    }

    @Override
    public CDataGrabber getCDataGrabber() {
        return this.fOffscreenCanvas.getCDataGrabber();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public synchronized void addKeyListener(KeyListener keyListener) {
        super.addKeyListener(keyListener);
        this.fOffscreenCanvas.getComponent().addKeyListener(keyListener);
    }

    @Override
    public boolean isComponentLightweight() {
        return true;
    }

    protected boolean isDrawingOffscreen() {
        return this.fIsOffScreen;
    }

    @Override
    public GLAutoDrawable getGLAutoDrawable() {
        return this.fOffscreenCanvas.getGLAutoDrawable();
    }

    @Override
    public void print(Graphics graphics) {
        this.fOffscreenCanvas.getComponent().print(graphics);
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        super.addMouseMotionListener(mouseMotionListener);
        this.fOffscreenCanvas.addMouseMotionListener(mouseMotionListener);
    }

    @Override
    public synchronized void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        this.fOffscreenCanvas.addMouseListener(mouseListener);
    }

    @Override
    public void causeExpose() {
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
    }

    private boolean moveCanvasOffScreen() {
        if (!this.fIsOffScreen) {
            this.fIsOffScreen = true;
            OffscreenWindowProvider.getWindow().add(this.fOffscreenCanvas.getComponent());
            this.requestFocus();
            return true;
        }
        return false;
    }

    private boolean moveCanvasOnScreen() {
        if (this.fIsOffScreen) {
            this.fIsOffScreen = false;
            this.add(this.fOffscreenCanvas.getComponent());
            this.requestFocus();
            return true;
        }
        return false;
    }

    @Override
    public void requestFocus() {
        if (this.fIsOffScreen || !this.fOffscreenCanvas.getComponent().isEnabled()) {
            super.requestFocus();
        } else {
            this.fOffscreenCanvas.getComponent().requestFocus();
        }
    }

    @Override
    public void setInFigurePanel(boolean bl) {
        this.fChildAdapter.setInFigurePanel(bl);
    }

    @Override
    public boolean isInFigurePanel() {
        return this.fChildAdapter.isInFigurePanel();
    }

    private void checkForLightweightSiblings() {
        if (this.getParent() == null) {
            this.fHasLightweightSiblings = false;
            return;
        }
        if (!this.fInitialized) {
            Object object;
            int n;
            this.fInitialized = true;
            if (!this.isInFigurePanel()) {
                this.fHasLightweightSiblings = false;
                return;
            }
            if (this.fOldParent != null) {
                this.fOldParent.removeHierarchyListener(this.fParentHierarchyListener);
                this.fOldParent.removeContainerListener(this.fParentContainerListener);
            }
            this.fParentHierarchyListener = new InitializedListener();
            this.fParentContainerListener = new InitializedListener();
            this.fOldParent = this.getParent();
            this.fOldParent.addHierarchyListener(this.fParentHierarchyListener);
            this.fOldParent.addContainerListener(this.fParentContainerListener);
            if (this.fOldSiblings != null) {
                for (n = 0; n < this.fOldSiblings.size(); ++n) {
                    Container container = this.fOldSiblings.elementAt(n);
                    object = this.fSiblingListeners.elementAt(n);
                    container.removeHierarchyListener((HierarchyListener)object);
                    container.removeContainerListener((ContainerListener)object);
                }
            }
            this.fOldSiblings = new Vector();
            this.fSiblingListeners = new Vector();
            n = 0;
            block1: for (int i = 0; i < this.getParent().getComponentCount(); ++i) {
                Container container;
                object = this.getParent().getComponent(i);
                if (!(object instanceof Container) || (container = (Container)object).equals(this)) continue;
                this.fOldSiblings.add(container);
                InitializedListener initializedListener = new InitializedListener();
                this.fSiblingListeners.add(initializedListener);
                container.addHierarchyListener(initializedListener);
                container.addContainerListener(initializedListener);
                if (container.getComponentCount() <= 0) continue;
                for (int j = 0; j < container.getComponentCount(); ++j) {
                    Component component = container.getComponent(j);
                    if (!component.isLightweight()) continue;
                    n = 1;
                    continue block1;
                }
            }
            this.fHasLightweightSiblings = n;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.fJSSP.getGLEventListenerHandler() == null || !this.fJSSP.getGLEventListenerHandler().isReady()) {
            return;
        }
        this.checkForLightweightSiblings();
        if (this.fHasLightweightSiblings) {
            Image image;
            if (this.moveCanvasOffScreen()) {
                return;
            }
            try {
                image = this.fJSSP.generateAndGrabBufferedImage();
                if (image == null) {
                    throw new JavaSceneServerPeer.HGGLException("Null Buffered Image");
                }
            }
            catch (JavaSceneServerPeer.HGGLException hGGLException) {
                DebugUtilities.logMessage(16, "JavaSceneServerOffScreenCanvas render off screen image failed", this);
                return;
            }
            graphics.drawImage(image, 0, 0, this.getWidth(), this.getHeight(), null);
        } else {
            if (this.moveCanvasOnScreen()) {
                return;
            }
            this.fOffscreenCanvas.getComponent().paint(graphics);
        }
    }

    @Override
    public String toString() {
        String string = this.fIsOffScreen ? " off screen " : " onscreen ";
        return this.getClass().getName() + " (JPanel): " + this.getSize() + " (GLCanvas" + string + "): " + this.fOffscreenCanvas.getComponent().getSize();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.fDisposed) {
            boolean bl = false;
            if (!$assertionsDisabled) {
                bl = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (bl) {
                System.out.println("Dispose was not called. Users of " + this.getClass().toString() + " must call dispose before releasing all references.");
                Thread.dumpStack();
            }
        }
    }

    private class InitializedListener
    implements HierarchyListener,
    ContainerListener {
        private InitializedListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            JavaSceneServerOffScreenCanvas.this.fInitialized = false;
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            JavaSceneServerOffScreenCanvas.this.fInitialized = false;
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            JavaSceneServerOffScreenCanvas.this.fInitialized = false;
        }
    }
}

