/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.jmi.AWTUtilities;
import java.awt.EventQueue;

class FigureRenderLocker {
    private static final FigureRenderLocker sSingleton = new FigureRenderLocker();
    private static final int WAIT_TIME = 5;
    private AWTUtilities.MatlabLatch fLatchRun;
    private RenderLatch fLatchLock;

    private FigureRenderLocker() {
    }

    public static boolean blockAwtThread() {
        DebugUtilities.logMessage(4096, "FigureRenderLocker.blockAwtThread", null);
        assert (sSingleton != null);
        return sSingleton.doBlockAwtThread();
    }

    public static boolean unblockAwtThread() {
        DebugUtilities.logMessage(4096, "FigureRenderLocker.unblockAwtThread", null);
        assert (sSingleton != null);
        return sSingleton.doUnblockAwtThread();
    }

    private boolean doBlockAwtThread() {
        DebugUtilities.logMessage(4096, "FigureRenderLocker.doBlockAwtThread", this);
        if (this.fLatchRun != null || this.fLatchLock != null) {
            return false;
        }
        this.fLatchRun = new AWTUtilities.MatlabLatch();
        this.fLatchLock = new RenderLatch();
        EventQueue.invokeLater(new WaitRunnable(this.fLatchRun, this.fLatchLock));
        FigureRenderLocker.lockAttempt((AWTUtilities.Synchronizer)this.fLatchRun, 5);
        boolean bl = this.fLatchLock.inRenderLock();
        if (!bl) {
            // empty if block
        }
        return bl;
    }

    private boolean checkIsBlocked() {
        return this.fLatchLock != null;
    }

    static boolean isBlocked() {
        boolean bl = false;
        if (sSingleton != null) {
            bl = sSingleton.checkIsBlocked();
        }
        return bl;
    }

    private boolean doUnblockAwtThread() {
        DebugUtilities.logMessage(4096, "FigureRenderLocker.doUnblockAwtThread", this);
        boolean bl = false;
        if (this.fLatchLock != null) {
            this.fLatchLock.release();
            bl = true;
        }
        this.fLatchRun = null;
        this.fLatchLock = null;
        return false;
    }

    static void lockAttempt(AWTUtilities.Synchronizer synchronizer, int n) {
        try {
            synchronizer.attempt((long)(n * 1000));
        }
        catch (Exception exception) {
            DebugUtilities.logMessage(4096, "FigureRenderLock.locWait Exception", exception);
        }
    }

    static void lockWait(RenderLatch renderLatch) {
        while (renderLatch.inRenderLock()) {
            if (!FigureRenderLocker.isBlocked()) {
                renderLatch.release();
            }
            try {
                renderLatch.attempt(250L);
            }
            catch (Exception exception) {
                DebugUtilities.logMessage(4096, "FigureRenderLock.locWait Exception", exception);
            }
        }
    }

    static Object invokeAndWait(AWTUtilities.InvocationRunnable invocationRunnable) {
        if (FigureRenderLocker.isBlocked()) {
            return invocationRunnable.runWithOutput();
        }
        try {
            return AWTUtilities.invokeAndWait((AWTUtilities.InvocationRunnable)invocationRunnable);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static class WaitRunnable
    implements Runnable,
    AWTUtilities.InvokerObservable {
        private AWTUtilities.MatlabLatch fSafeLatchRun;
        private RenderLatch fLatchRender;
        private boolean fInvoking;

        private WaitRunnable(AWTUtilities.MatlabLatch matlabLatch, RenderLatch renderLatch) {
            assert (matlabLatch != null && renderLatch != null);
            this.fSafeLatchRun = matlabLatch;
            this.fLatchRender = renderLatch;
            this.fInvoking = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                assert (EventQueue.isDispatchThread());
                this.fInvoking = true;
                AWTUtilities.addInvokerObservable((AWTUtilities.InvokerObservable)this);
                DebugUtilities.logMessage(4096, "WaitRunnable:run", this);
                this.fSafeLatchRun.release();
                FigureRenderLocker.lockWait(this.fLatchRender);
                DebugUtilities.logMessage(4096, "WaitRunnable out of run", this);
            }
            finally {
                AWTUtilities.removeInvokerObservable((AWTUtilities.InvokerObservable)this);
                this.fInvoking = false;
            }
        }

        public boolean isInvoking() {
            return this.fInvoking;
        }
    }

    private class RenderLatch
    extends AWTUtilities.Latch {
        private RenderLatch() {
        }

        public synchronized boolean inRenderLock() {
            return !this.isLatched();
        }
    }
}

