/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextArea;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.SwingUtilities;

public class DebugUtilities {
    private static Logger sLogger;
    public static final int DEBUG_CMD_WINDOW = 1;
    public static final int DEBUG_LOG_FILE = 2;
    public static final int DEBUG_LOG_WINDOW = 4;
    public static final int DEBUG_SURPRISES = 16;
    public static final int DEBUG_TRACE_METHODS = 32;
    public static final int DEBUG_TRACE_INVOKES = 64;
    public static final int DEBUG_SIZE = 128;
    public static final int DEBUG_LISTENERS = 256;
    public static final int DEBUG_EVENTS = 512;
    public static final int DEBUG_DESKTOP = 1024;
    public static final int DEBUG_MODAL = 2048;
    public static final int DEBUG_TREELOCK = 4096;
    public static final int DEBUG_TEMP = 8192;
    public static final int DEBUG_ACTIVATE = 16384;
    public static final int DEBUG_JOGL = 32768;

    public static void initializeLogger() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                sLogger = new Logger();
            }
        };
        if (null == sLogger) {
            FigurePeer.runOnEDT(runnable);
        }
    }

    public static void setDebugOptions(int n) {
        if (sLogger != null) {
            sLogger.setDebugOptions(n);
        }
    }

    public static boolean isDebugOptions() {
        if (sLogger == null) {
            return false;
        }
        return sLogger.isDebugOptions();
    }

    public static void logMessage(int n, String string, Object object) {
        if (sLogger != null) {
            sLogger.logMessage(n, string, object);
        }
    }

    static {
        DebugUtilities.initializeLogger();
    }

    private static class Logger {
        MJFrame fLogFrame;
        MJTextArea fjta;
        MJScrollPane fjsp;
        PrintStream ps;
        private int fDebug = 0;

        public Logger() {
            assert (SwingUtilities.isEventDispatchThread());
            if (!GraphicsEnvironment.isHeadless()) {
                this.fLogFrame = new MJFrame("Logger");
                this.fjta = new MJTextArea();
                this.fjsp = new MJScrollPane((Component)this.fjta);
                MJButton mJButton = new MJButton("Clear");
                mJButton.addActionListener((ActionListener)new MyActionListener());
                MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout());
                mJPanel.add((Component)mJButton);
                this.fLogFrame.getContentPane().add((Component)this.fjsp, "Center");
                this.fLogFrame.getContentPane().add((Component)mJPanel, "North");
                this.fLogFrame.setSize(200, 400);
            }
        }

        public void setDebugOptions(int n) {
            if ((n & 4) != 0 && GraphicsEnvironment.isHeadless()) {
                throw new Error("The LOG window cannot be used when Matlab is started with -nodisplay startup option");
            }
            this.fDebug = n;
        }

        public boolean isDebugOptions() {
            return this.fDebug != 0;
        }

        final void logMessage(int n, String string, Object object) {
            if ((this.fDebug & 7) == 0) {
                return;
            }
            if ((n & this.fDebug) == 0) {
                return;
            }
            if ((this.fDebug & 1) != 0) {
                System.out.println(string + " " + object);
            }
            if ((this.fDebug & 2) != 0) {
                this.println(string + " " + object);
            }
            if ((this.fDebug & 4) != 0) {
                assert (!GraphicsEnvironment.isHeadless());
                this.showln(string + " " + object);
            }
        }

        private void println(String string) {
            if (this.ps == null) {
                try {
                    this.ps = new PrintStream(new FileOutputStream("figure_log.txt"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.ps != null) {
                this.ps.println(string);
                this.ps.flush();
            }
        }

        private void showln(String string) {
            if (!string.endsWith("\n")) {
                string = string.concat("\n");
            }
            final String string2 = string;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!Logger.this.fLogFrame.isVisible()) {
                        Logger.this.fLogFrame.setVisible(true);
                    }
                    Logger.this.fjta.append(string2);
                    Logger.this.fjsp.getVerticalScrollBar().setValue(Logger.this.fjsp.getVerticalScrollBar().getMaximum());
                }
            };
            FigurePeer.runOnEDT(runnable);
        }

        private class MyActionListener
        implements ActionListener {
            private MyActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Logger.this.fjta.setText("");
            }
        }
    }
}

