/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.client.Client;
import com.mathworks.desktop.client.ClientCollection;
import com.mathworks.desktop.mnemonics.HasMnemonic;
import com.mathworks.desktop.mnemonics.Mnemonic;
import com.mathworks.desktop.mnemonics.MnemonicPath;
import com.mathworks.desktop.mnemonics.Mnemonics;
import com.mathworks.desktop.mnemonics.MnemonicsManager;
import com.mathworks.desktop.mnemonics.MnemonicsManagers;
import com.mathworks.desktop.mnemonics.MnemonicsProvider;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.SimpleStringTrimmer;
import com.mathworks.toolstrip.DefaultToolstrip;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.impl.ToolstripHeaderPanel;
import com.mathworks.toolstrip.plaf.ControlMap;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripIcons;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import com.mathworks.util.Disposable;
import com.mathworks.util.Disposer;
import com.mathworks.util.StringUtils;
import com.mathworks.util.async.Status;
import com.mathworks.util.event.AWTKeyListener;
import com.mathworks.util.event.AbstractInputEventsDispatcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.PanelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolstripHeaderUI
extends PanelUI
implements Disposable {
    private static final int DOUBLE_CLICK_TIMER_VALUE = 250;
    protected static final boolean IMAGE_BACKGROUND = true;
    protected final ToolstripHeaderPanel fHeader;
    private MnemonicsProvider fMnemonicsProvider;
    private AWTKeyListener fAWTKeyListener;
    private Timer fTimer;
    private GeneralPath TabshadowPath;
    static final int MIN_TAB_WIDTH = 30;
    static final int VGAP_TOP = 3;
    static final int VGAP_BOTTOM = 2;
    static final int VGAP = 5;
    static final int VGAP_EXTRA = 2;
    static final int HGAP = 30;
    static final int TAB_EXTRA_GAP = 10;
    public static final ImageIcon sHeaderBackgroundImage = ToolstripIcons.HEADER_BACKGROUND.getIcon();
    private ControlMap fControlMap;

    public ToolstripHeaderUI(ToolstripHeaderPanel toolstripHeaderPanel) {
        this.fHeader = toolstripHeaderPanel;
        toolstripHeaderPanel.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ToolstripHeaderUI.this.fHeader.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ToolstripHeaderUI.this.fHeader.repaint();
            }
        });
        toolstripHeaderPanel.setFocusTraversalKeysEnabled(false);
        toolstripHeaderPanel.setFocusable(false);
        this.initShortcuts();
    }

    public void enableMnemonics() {
        if (this.fAWTKeyListener == null) {
            this.fAWTKeyListener = new MyMouseListener();
        }
        AbstractInputEventsDispatcher.getDefault().addAWTKeyListener(this.fAWTKeyListener);
        MnemonicsManager mnemonicsManager = MnemonicsManagers.get();
        this.fMnemonicsProvider = new MnemonicsProvider(){

            @NotNull
            public Mnemonics getMnemonics(@NotNull MnemonicPath mnemonicPath) {
                if (mnemonicPath.isEmpty()) {
                    ArrayList arrayList = Lists.newArrayList();
                    for (ToolstripTab toolstripTab : ToolstripHeaderUI.this.getToolstrip().getModel()) {
                        char c;
                        String string = (String)toolstripTab.getAttribute((Attribute)ToolstripTab.MNEMONIC);
                        if (StringUtils.isEmpty((String)string) && ToolstripHeaderUI.isLatinLetter(c = ((String)toolstripTab.getAttribute(Client.TITLE)).charAt(0))) {
                            string = String.valueOf(c);
                        }
                        if (StringUtils.isEmpty((String)string)) continue;
                        arrayList.add(new TabMnemonic(string, toolstripTab));
                    }
                    return new Mnemonics((Iterable)arrayList);
                }
                if (mnemonicPath.getPath().size() == 1) {
                    TabMnemonic tabMnemonic = (TabMnemonic)mnemonicPath.getRoot();
                    ToolstripTab toolstripTab = tabMnemonic.fTab;
                    ControlMap controlMap = new ControlMap(toolstripTab.getComponent());
                    ArrayList arrayList = Lists.newArrayList();
                    for (ControlMap.Control control : controlMap.getControls()) {
                        HasMnemonic hasMnemonic;
                        Mnemonic mnemonic;
                        JComponent jComponent = control.getComponent();
                        if (!(jComponent instanceof HasMnemonic) || (mnemonic = (hasMnemonic = (HasMnemonic)jComponent).getComponentMnemonic()) == null) continue;
                        arrayList.add(new ControlMnemonic(hasMnemonic, mnemonic));
                    }
                    return new Mnemonics((Iterable)arrayList);
                }
                ImmutableList immutableList = mnemonicPath.getPath();
                ControlMnemonic controlMnemonic = (ControlMnemonic)immutableList.get(immutableList.size() - 1);
                MnemonicsProvider mnemonicsProvider = controlMnemonic.fMnem.getMnemonicsProvider();
                if (mnemonicsProvider != null) {
                    return mnemonicsProvider.getMnemonics(new MnemonicPath((Iterable)immutableList.subList(2, immutableList.size())));
                }
                return new Mnemonics();
            }

            @NotNull
            public Status<Component> select(@NotNull MnemonicPath mnemonicPath) {
                ImmutableList immutableList = mnemonicPath.getPath();
                if (immutableList.isEmpty()) {
                    if (ToolstripHeaderUI.this.getToolstrip().getAttribute((Attribute)Toolstrip.STATE) == Toolstrip.State.EXPANDED_AS_POPUP) {
                        ToolstripHeaderUI.this.getToolstrip().setAttribute((Attribute)Toolstrip.STATE, (Object)Toolstrip.State.COLLAPSED);
                    }
                    return new Status.Success((Object)ToolstripHeaderUI.this.fHeader);
                }
                if (immutableList.size() == 1) {
                    TabMnemonic tabMnemonic = (TabMnemonic)immutableList.get(0);
                    ToolstripTab toolstripTab = tabMnemonic.fTab;
                    ToolstripHeaderUI.this.getToolstrip().setCurrentTab(toolstripTab.getName());
                    if (ToolstripHeaderUI.this.getToolstrip().getAttribute((Attribute)Toolstrip.STATE) == Toolstrip.State.COLLAPSED) {
                        ToolstripHeaderUI.this.getToolstrip().setAttribute((Attribute)Toolstrip.STATE, (Object)Toolstrip.State.EXPANDED_AS_POPUP);
                    }
                    final Status.Future future = new Status.Future();
                    MJUtilities.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            future.success((Object)ToolstripHeaderUI.this.fHeader);
                        }
                    });
                    return future;
                }
                ControlMnemonic controlMnemonic = (ControlMnemonic)immutableList.get(immutableList.size() - 1);
                MnemonicsProvider mnemonicsProvider = controlMnemonic.fMnem.getMnemonicsProvider();
                if (mnemonicsProvider != null) {
                    return mnemonicsProvider.select(new MnemonicPath((Iterable)immutableList.subList(2, immutableList.size())));
                }
                return new Status.Success((Object)controlMnemonic.fMnemonic.getComponent());
            }

            @Nullable
            public Status<Component> cancel(@NotNull MnemonicPath mnemonicPath) {
                ControlMnemonic controlMnemonic;
                MnemonicsProvider mnemonicsProvider;
                ImmutableList immutableList = mnemonicPath.getPath();
                if (immutableList.size() == 2 && (mnemonicsProvider = (controlMnemonic = (ControlMnemonic)immutableList.get(immutableList.size() - 1)).fMnem.getMnemonicsProvider()) != null) {
                    return mnemonicsProvider.cancel(new MnemonicPath((Iterable)immutableList.subList(2, immutableList.size())));
                }
                return null;
            }

            public boolean isDefaultFocusOwner() {
                return true;
            }

            public boolean isFocusOwner() {
                return ToolstripHeaderUI.doesToolstripHaveFocus(ToolstripHeaderUI.this.getToolstrip());
            }
        };
        mnemonicsManager.register(this.fMnemonicsProvider, SwingUtilities.windowForComponent(this.fHeader));
    }

    public void disableMnemonics() {
        if (this.fMnemonicsProvider != null) {
            MnemonicsManagers.get().unRegister(this.fMnemonicsProvider, SwingUtilities.windowForComponent(this.fHeader));
            this.fMnemonicsProvider = null;
        }
        if (this.fAWTKeyListener != null) {
            AbstractInputEventsDispatcher.getDefault().removeAWTKeyListener(this.fAWTKeyListener);
            this.fAWTKeyListener = null;
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.paintImageBackground(graphics2D, jComponent);
    }

    protected void paintImageBackground(Graphics2D graphics2D, JComponent jComponent) {
        Image image = sHeaderBackgroundImage.getImage();
        int n = sHeaderBackgroundImage.getIconWidth();
        int n2 = sHeaderBackgroundImage.getIconWidth();
        int n3 = jComponent.getWidth();
        if (n3 <= n) {
            graphics2D.drawImage(image, n3 - n, 0, jComponent);
        } else {
            graphics2D.drawImage(image, 0, 0, n3 - n, jComponent.getHeight(), 0, 0, 1, jComponent.getHeight(), jComponent);
            graphics2D.drawImage(image, n3 - n, 0, jComponent);
        }
    }

    protected void drawInactiveTabs(Graphics2D graphics2D, Dimension dimension, DefaultToolstrip defaultToolstrip, Color color, Color color2, Color color3) {
        Color color4 = color;
        graphics2D.setColor(color4);
        graphics2D.fillRoundRect(2, 3, dimension.width - 2, (int)(0.75 * (double)dimension.height), 10, 10);
        Color color5 = color2;
        graphics2D.setPaint(new GradientPaint(2.0f, (int)(0.75 * (double)dimension.height), color4, 2.0f, dimension.height, color5));
        graphics2D.fillRect(2, (int)(0.75 * (double)dimension.height), dimension.width - 2, (int)(0.25 * (double)dimension.height) + 2);
        Color color6 = color3;
        graphics2D.setColor(color6);
        graphics2D.fill(this.createShadow(dimension));
    }

    public HeaderTab createTab(ToolstripTab toolstripTab) {
        return new HeaderTab(toolstripTab);
    }

    protected DefaultToolstrip getToolstrip() {
        return this.fHeader.getToolstrip();
    }

    protected static Color getTabTextColor() {
        ToolstripTheme toolstripTheme = ToolstripTheme.getInstance();
        return toolstripTheme.getTabTextColorWithImage();
    }

    private GeneralPath createShadow(Dimension dimension) {
        this.TabshadowPath = new GeneralPath();
        Point[] pointArray = new Point[]{new Point(2, 8), new Point(3, 5), new Point(7, 4), new Point(dimension.width - 7, 4), new Point(dimension.width - 4, 3), new Point(dimension.width, 8), new Point(dimension.width, 3), new Point(dimension.width - 7, 3), new Point(7, 3), new Point(2, 3)};
        this.TabshadowPath.moveTo(pointArray[0].x, pointArray[0].y);
        this.TabshadowPath.curveTo(pointArray[0].x, pointArray[0].y, pointArray[1].x, pointArray[1].y, pointArray[2].x, pointArray[2].y);
        this.TabshadowPath.lineTo(pointArray[3].x, pointArray[3].y);
        this.TabshadowPath.curveTo(pointArray[3].x, pointArray[3].y, pointArray[4].x, pointArray[4].y, pointArray[5].x, pointArray[5].y);
        this.TabshadowPath.curveTo(pointArray[5].x, pointArray[5].y, pointArray[6].x, pointArray[6].y, pointArray[7].x, pointArray[7].y);
        this.TabshadowPath.lineTo(pointArray[8].x, pointArray[8].y);
        this.TabshadowPath.curveTo(pointArray[8].x, pointArray[8].y, pointArray[9].x, pointArray[9].y, pointArray[0].x, pointArray[0].y);
        return this.TabshadowPath;
    }

    public void dispose() {
    }

    public static ToolstripHeaderUI createUI(JComponent jComponent) {
        return new ToolstripHeaderUI((ToolstripHeaderPanel)jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        jComponent.setLayout(new HeaderLayout());
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.setLayout(null);
        Disposer.dispose((Disposable)this);
    }

    private void initShortcuts() {
        ActionMap actionMap = this.fHeader.getActionMap();
        InputMap inputMap = this.fHeader.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "left");
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "right");
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "up");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "down");
        actionMap.put("left", new HeaderNavAction(){

            @Override
            protected void actionPerformed(DefaultToolstrip defaultToolstrip, ClientCollection<ToolstripTab> clientCollection, ToolstripTab toolstripTab) {
                int n = clientCollection.indexOf((Client)toolstripTab);
                int n2 = clientCollection.size();
                n = (n + n2 - 1) % n2;
                defaultToolstrip.setCurrentTab(((ToolstripTab)clientCollection.get(n)).getName());
            }
        });
        actionMap.put("right", new HeaderNavAction(){

            @Override
            protected void actionPerformed(DefaultToolstrip defaultToolstrip, ClientCollection<ToolstripTab> clientCollection, ToolstripTab toolstripTab) {
                int n = clientCollection.indexOf((Client)toolstripTab);
                int n2 = clientCollection.size();
                n = (n + 1) % n2;
                defaultToolstrip.setCurrentTab(((ToolstripTab)clientCollection.get(n)).getName());
            }
        });
        actionMap.put("up", new HeaderNavAction(){

            @Override
            protected void actionPerformed(DefaultToolstrip defaultToolstrip, ClientCollection<ToolstripTab> clientCollection, ToolstripTab toolstripTab) {
            }
        });
        actionMap.put("down", new HeaderNavAction(){

            @Override
            protected void actionPerformed(DefaultToolstrip defaultToolstrip, ClientCollection<ToolstripTab> clientCollection, ToolstripTab toolstripTab) {
                ToolstripHeaderUI.this.fControlMap = new ControlMap(toolstripTab.getComponent());
                ControlMap.Control control = ToolstripHeaderUI.this.fControlMap.first();
                if (control != null) {
                    ToolstripHeaderUI.this.fHeader.setFocusable(false);
                    ToolstripHeaderUI.this.initShortcutsInContent(defaultToolstrip);
                    control.getComponent().requestFocusInWindow();
                }
            }
        });
    }

    private void initShortcutsInContent(DefaultToolstrip defaultToolstrip) {
        JComponent jComponent = defaultToolstrip.getContentPanel();
        ActionMap actionMap = jComponent.getActionMap();
        if (actionMap.get("right") == null) {
            InputMap inputMap = jComponent.getInputMap(1);
            inputMap.put(KeyStroke.getKeyStroke(39, 0), "right");
            inputMap.put(KeyStroke.getKeyStroke(37, 0), "left");
            inputMap.put(KeyStroke.getKeyStroke(38, 0), "up");
            inputMap.put(KeyStroke.getKeyStroke(40, 0), "down");
            inputMap.put(KeyStroke.getKeyStroke(9, 0), "tab");
            inputMap.put(KeyStroke.getKeyStroke(9, 64), "shift_tab");
            actionMap.put("right", new AbstractAction("right"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JComponent jComponent = ToolstripHeaderUI.this.fControlMap.right();
                    if (jComponent != null) {
                        jComponent.requestFocusInWindow();
                    }
                }
            });
            actionMap.put("left", new AbstractAction("left"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JComponent jComponent = ToolstripHeaderUI.this.fControlMap.left();
                    if (jComponent != null) {
                        jComponent.requestFocusInWindow();
                    }
                }
            });
            actionMap.put("up", new AbstractAction("up"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JComponent jComponent = ToolstripHeaderUI.this.fControlMap.up();
                    if (jComponent != null) {
                        jComponent.requestFocusInWindow();
                    } else {
                        ToolstripHeaderUI.this.fHeader.setFocusable(true);
                        ToolstripHeaderUI.this.fHeader.requestFocusInWindow();
                    }
                }
            });
            actionMap.put("down", new AbstractAction("down"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JComponent jComponent = ToolstripHeaderUI.this.fControlMap.down();
                    if (jComponent != null) {
                        jComponent.requestFocusInWindow();
                    }
                }
            });
            actionMap.put("tab", new AbstractAction("tab"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JComponent jComponent = ToolstripHeaderUI.this.fControlMap.next();
                    if (jComponent != null) {
                        jComponent.requestFocusInWindow();
                    }
                }
            });
            actionMap.put("shift_tab", new AbstractAction("shift_tab"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JComponent jComponent = ToolstripHeaderUI.this.fControlMap.prev();
                    if (jComponent != null) {
                        jComponent.requestFocusInWindow();
                    }
                }
            });
        }
    }

    private static boolean doesToolstripHaveFocus(DefaultToolstrip defaultToolstrip) {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return component != null && SwingUtilities.isDescendingFrom(component, defaultToolstrip.getComponent());
    }

    private static boolean isLatinLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private class MyMouseListener
    implements AWTKeyListener {
        private MyMouseListener() {
        }

        public void keyEventDispatched(KeyEvent keyEvent, @Nullable Window window) {
            boolean bl;
            DefaultToolstrip defaultToolstrip = ToolstripHeaderUI.this.getToolstrip();
            Window window2 = SwingUtilities.getWindowAncestor(defaultToolstrip.getComponent());
            if (window != null && window2 != window) {
                return;
            }
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getID();
            boolean bl2 = bl = n2 == 401;
            if (n == 9 && bl && ToolstripHeaderUI.doesToolstripHaveFocus(defaultToolstrip)) {
                this.handleTab(defaultToolstrip, (keyEvent.getModifiersEx() & 0x40) != 0);
                keyEvent.consume();
            }
        }

        private void handleTab(DefaultToolstrip defaultToolstrip, boolean bl) {
            Action action = null;
            if (ToolstripHeaderUI.this.fHeader.isFocusOwner()) {
                ActionMap actionMap = ToolstripHeaderUI.this.fHeader.getActionMap();
                action = actionMap.get(bl ? "left" : "right");
            } else {
                JComponent jComponent = defaultToolstrip.getContentPanel();
                ActionMap actionMap = jComponent.getActionMap();
                action = actionMap.get(bl ? "shift_tab" : "tab");
            }
            if (action != null) {
                action.actionPerformed(null);
            }
        }
    }

    private abstract class HeaderNavAction
    extends AbstractAction {
        private HeaderNavAction() {
            super("");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefaultToolstrip defaultToolstrip = ToolstripHeaderUI.this.getToolstrip();
            ClientCollection<ToolstripTab> clientCollection = defaultToolstrip.getModel();
            ToolstripTab toolstripTab = (ToolstripTab)clientCollection.get(defaultToolstrip.getCurrentTab());
            this.actionPerformed(defaultToolstrip, clientCollection, toolstripTab);
        }

        protected abstract void actionPerformed(DefaultToolstrip var1, ClientCollection<ToolstripTab> var2, ToolstripTab var3);
    }

    private class HeaderLayout
    implements LayoutManager2 {
        private Sizes fSizes;

        private HeaderLayout() {
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
            this.invalidateLayout(component.getParent());
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            this.invalidateLayout(component.getParent());
        }

        @Override
        public void removeLayoutComponent(Component component) {
            this.invalidateLayout(component.getParent());
        }

        @Override
        public void invalidateLayout(Container container) {
            this.fSizes = null;
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            this.calcSizes(container);
            return this.getMinimumSize(this.fSizes);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            this.calcSizes(container);
            Dimension dimension = this.getMinimumSize(this.fSizes);
            int n = container.getSize().width;
            if (dimension.width >= n) {
                return dimension;
            }
            return new Dimension(n, dimension.height);
        }

        private Dimension getMinimumSize(Sizes sizes) {
            return new Dimension(sizes.extraWidth + this.getMinTabsWidth(sizes), Math.max(sizes.textHeight + 5, sizes.extraHeight + 4));
        }

        private int getMinTabsWidth(Sizes sizes) {
            return sizes.tabsCount * 30;
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            int n2;
            Component component;
            int n3;
            int n4;
            int n5;
            Sizes sizes = this.calcSizes(container);
            if (sizes.tabsCount == 0) {
                return;
            }
            int n6 = container.getSize().width;
            int n7 = Math.max(sizes.textHeight + 5, sizes.extraHeight + 4);
            int n8 = n6 - (sizes.extraWidth > 0 ? sizes.extraWidth + 10 : 0);
            int n9 = n8 - sizes.textWidth;
            if (n9 > 0) {
                n5 = n9 - 60 * sizes.tabsCount;
                n4 = n5 >= 0 ? 0 : n5 / sizes.tabsCount;
            } else {
                n5 = this.getMinTabsWidth(sizes);
                if (n8 < n5) {
                    n8 = n5;
                    n9 = n8 - sizes.textWidth;
                }
                n4 = n9 / sizes.tabsCount - 60;
            }
            n5 = 0;
            int n10 = n6 - n8;
            Component[] componentArray = container.getComponents();
            for (n3 = 0; n3 < componentArray.length; ++n3) {
                component = componentArray[n3];
                if (component instanceof HeaderTab || this.getNeighborEdge(component) != 2) continue;
                n2 = sizes.sizes[n3].width;
                n = sizes.sizes[n3].height;
                if (n5 + n2 > n10) {
                    component.setVisible(false);
                } else {
                    component.setVisible(true);
                    component.setBounds(n5, Math.round((float)(n7 - n) * component.getAlignmentY()), n2, n);
                }
                n5 += n2;
            }
            for (n3 = 0; n3 < componentArray.length; ++n3) {
                component = componentArray[n3];
                if (!(component instanceof HeaderTab)) continue;
                n2 = sizes.sizes[n3].width + 60 + n4;
                component.setBounds(n5, 0, n2, n7);
                n5 += n2;
                if (n4 < 0) {
                    ((HeaderTab)component).ellipsize(n2 - 30);
                    continue;
                }
                ((HeaderTab)component).resetLabel();
            }
            n10 = n5;
            n5 = n6;
            for (n3 = 0; n3 < componentArray.length; ++n3) {
                component = componentArray[n3];
                if (!this.isCollpseButton(component)) continue;
                n2 = sizes.sizes[n3].width;
                n = sizes.sizes[n3].height;
                n6 -= n2;
                if ((n5 -= n2) < n10) {
                    component.setBounds(n10, Math.round((float)(n7 - n) * component.getAlignmentY()), n2, n);
                    break;
                }
                component.setBounds(n5, Math.round((float)(n7 - n) * component.getAlignmentY()), n2, n);
                break;
            }
            n3 = componentArray.length;
            while (--n3 >= 0) {
                component = componentArray[n3];
                if (component instanceof HeaderTab || this.getNeighborEdge(component) != 4 || this.isCollpseButton(component)) continue;
                n2 = sizes.sizes[n3].width;
                n = sizes.sizes[n3].height;
                n6 -= n2;
                if ((n5 -= n2) < n10) {
                    component.setBounds(n10, Math.round((float)(n7 - n) * component.getAlignmentY()), (n6 -= n10) + n2, n);
                    continue;
                }
                component.setBounds(n5, Math.round((float)(n7 - n) * component.getAlignmentY()), n2, n);
            }
        }

        Sizes calcSizes(Container container) {
            if (this.fSizes == null) {
                Component[] componentArray = container.getComponents();
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                Dimension[] dimensionArray = new Dimension[componentArray.length];
                for (int i = 0; i < componentArray.length; ++i) {
                    Dimension dimension;
                    Component component = componentArray[i];
                    if (component instanceof HeaderTab) {
                        dimension = ((HeaderTab)component).getTextSize();
                        n += dimension.width;
                        n2 = Math.max(n2, dimension.height);
                        ++n5;
                    } else {
                        dimension = component.getPreferredSize();
                        n3 += dimension.width;
                        n4 = Math.max(n4, dimension.height);
                    }
                    dimensionArray[i] = dimension;
                }
                this.fSizes = new Sizes(dimensionArray, n5, n, n2, n3, n4);
            }
            return this.fSizes;
        }

        private int getNeighborEdge(Component component) {
            int n = 4;
            if (component instanceof JComponent) {
                n = (Integer)((JComponent)component).getClientProperty("toolstrip-edge");
            }
            return n;
        }

        private boolean isCollpseButton(Component component) {
            return component != null && component.getName() != null && component.getName().equals("toolstrip.header.collapseButton");
        }

        class Sizes {
            Dimension[] sizes;
            int tabsCount;
            int textWidth;
            int textHeight;
            int extraWidth;
            int extraHeight;

            Sizes(Dimension[] dimensionArray, int n, int n2, int n3, int n4, int n5) {
                this.sizes = dimensionArray;
                this.tabsCount = n;
                this.textWidth = n2;
                this.textHeight = n3;
                this.extraWidth = n4;
                this.extraHeight = n5;
            }
        }
    }

    public class HeaderTab
    extends JPanel
    implements MouseListener {
        final ToolstripTab fClient;
        boolean fMouseOver;
        Point fMnemonicLocation;
        final String fOrigString;
        String fDisplayedString;
        final SimpleStringTrimmer st;

        HeaderTab(ToolstripTab toolstripTab) {
            this.fClient = toolstripTab;
            this.fOrigString = ((String)this.fClient.getAttribute(ToolstripTab.TITLE)).toUpperCase();
            this.fDisplayedString = ((String)this.fClient.getAttribute(ToolstripTab.TITLE)).toUpperCase();
            this.st = new SimpleStringTrimmer();
            this.addMouseListener(this);
            this.setOpaque(false);
            this.setName(toolstripTab.getName() + "Tab");
        }

        public ToolstripTab getClient() {
            return this.fClient;
        }

        Dimension getTextSize() {
            Dimension dimension = FontUtils.getTextSize((Font)ToolstripTheme.getInstance().getTabFont(), (String)this.fOrigString);
            dimension.width += 4;
            return dimension;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n;
            Color color;
            Object object;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ToolstripTheme toolstripTheme = ToolstripTheme.getInstance();
            graphics2D.setFont(toolstripTheme.getTabFont());
            boolean bl = (Boolean)this.fClient.getAttribute((Attribute)ToolstripTab.ISLIGHTER);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n2 = fontMetrics.stringWidth(this.fOrigString);
            Dimension dimension = this.getSize();
            Shape shape = null;
            DefaultToolstrip defaultToolstrip = ToolstripHeaderUI.this.getToolstrip();
            if (this.fClient.getName().equals(defaultToolstrip.getAttribute(Toolstrip.SELECTED_TAB)) && (defaultToolstrip.getAttribute((Attribute)Toolstrip.STATE) == Toolstrip.State.EXPANDED || defaultToolstrip.getAttribute((Attribute)Toolstrip.STATE) == Toolstrip.State.EXPANDED_AS_POPUP)) {
                object = LAFUtil.getTabBackgroundColors(this.fClient);
                if (ToolstripHeaderUI.this.fHeader.isFocusOwner()) {
                    object[0] = new Color(15712261);
                }
                color = new Color(255, 255, 255);
                Color color2 = new Color(229, 229, 229);
                Color color3 = new Color(222, 222, 222);
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color2, 0.0f, dimension.height + 1, color3));
                graphics2D.fillRoundRect(2, 3, dimension.width - 2, dimension.height + 1, 10, 10);
                graphics2D.setColor(color);
                graphics2D.fill(ToolstripHeaderUI.this.createShadow(dimension));
                graphics2D.setColor(toolstripTheme.getTabActiveTextColor());
            } else if (this.fMouseOver) {
                shape = graphics2D.getClip();
                object = new Color(31, 78, 127);
                color = new Color(13, 50, 86);
                Color color4 = new Color(85, 121, 154);
                ToolstripHeaderUI.this.drawInactiveTabs(graphics2D, dimension, defaultToolstrip, (Color)object, color, color4);
                graphics2D.setColor(toolstripTheme.getTabInactiveHoveredTextColor());
            } else {
                Color color5;
                if (bl) {
                    object = new Color(69, 106, 141);
                    color = new Color(39, 73, 103);
                    color5 = new Color(97, 128, 158);
                    ToolstripHeaderUI.this.drawInactiveTabs(graphics2D, dimension, defaultToolstrip, (Color)object, color, color5);
                } else {
                    object = new Color(9, 57, 101);
                    color = new Color(4, 42, 75);
                    color5 = new Color(85, 121, 154);
                }
                ToolstripHeaderUI.this.drawInactiveTabs(graphics2D, dimension, defaultToolstrip, (Color)object, color, color5);
                graphics2D.setColor(ToolstripHeaderUI.getTabTextColor());
            }
            int n3 = dimension.height / 2;
            if (dimension.width - 4 < n2) {
                if (shape == null) {
                    shape = graphics2D.getClip();
                }
                graphics2D.clip(new Rectangle(1, 0, dimension.width - 3, dimension.height));
                n = 2;
            } else {
                n = (dimension.width - n2) / 2;
            }
            LAFUtil.drawString(graphics2D, this.fDisplayedString, n, n3 + fontMetrics.getAscent() / 2);
            this.fMnemonicLocation = new Point(n + n2 / 2, n3 + fontMetrics.getHeight() + 5);
            if (shape != null) {
                graphics2D.setClip(shape);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
        }

        public void ellipsize(int n) {
            FontMetrics fontMetrics = FontUtils.getFontMetrics((Font)ToolstripTheme.getInstance().getTabFont());
            String string = this.st.shortenString(this.fOrigString, fontMetrics, n);
            this.fDisplayedString = !string.equals("...") ? string : this.fOrigString.substring(0, 1).concat("...");
            this.setToolTipText(this.fOrigString);
        }

        public void resetLabel() {
            this.fDisplayedString = this.fOrigString;
            this.setToolTipText(null);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isPopupTrigger()) {
                return;
            }
            int n = mouseEvent.getClickCount();
            DefaultToolstrip defaultToolstrip = ToolstripHeaderUI.this.getToolstrip();
            String string = defaultToolstrip.getCurrentTab();
            defaultToolstrip.setCurrentTab(this.fClient.getName());
            Toolstrip.State state = (Toolstrip.State)((Object)defaultToolstrip.getAttribute((Attribute)Toolstrip.STATE));
            if (n == 2) {
                if (ToolstripHeaderUI.this.fTimer != null) {
                    ToolstripHeaderUI.this.fTimer.stop();
                }
                if (state == Toolstrip.State.COLLAPSED || state == Toolstrip.State.EXPANDED_AS_POPUP) {
                    defaultToolstrip.setAttribute((Attribute)Toolstrip.STATE, (Object)Toolstrip.State.EXPANDED);
                } else {
                    defaultToolstrip.setAttribute((Attribute)Toolstrip.STATE, (Object)Toolstrip.State.COLLAPSED);
                }
                this.repaint();
            } else if (n == 1) {
                if (state == Toolstrip.State.EXPANDED_AS_POPUP && !Objects.equal((Object)string, (Object)this.fClient.getName())) {
                    defaultToolstrip.setAttribute((Attribute)Toolstrip.STATE, (Object)Toolstrip.State.EXPANDED_AS_POPUP);
                    return;
                }
                if (state != Toolstrip.State.EXPANDED) {
                    Timer timer = new Timer(250, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            HeaderTab.this.handleSingleClick();
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                    ToolstripHeaderUI.this.fTimer = timer;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.fMouseOver = true;
            this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.fMouseOver = false;
            this.repaint();
        }

        private void handleSingleClick() {
            DefaultToolstrip defaultToolstrip = ToolstripHeaderUI.this.getToolstrip();
            String string = defaultToolstrip.getCurrentTab();
            defaultToolstrip.setCurrentTab(this.fClient.getName());
            Toolstrip.State state = (Toolstrip.State)((Object)defaultToolstrip.getAttribute((Attribute)Toolstrip.STATE));
            if (state == Toolstrip.State.COLLAPSED) {
                defaultToolstrip.setAttribute((Attribute)Toolstrip.STATE, (Object)Toolstrip.State.EXPANDED_AS_POPUP);
            } else if (state == Toolstrip.State.EXPANDED_AS_POPUP && Objects.equal((Object)string, (Object)this.fClient.getName())) {
                defaultToolstrip.setAttribute((Attribute)Toolstrip.STATE, (Object)Toolstrip.State.COLLAPSED);
            }
            this.repaint();
        }
    }

    private class TabMnemonic
    implements Mnemonic {
        private final String fText;
        private final ToolstripTab fTab;

        TabMnemonic(String string, ToolstripTab toolstripTab) {
            this.fText = string;
            this.fTab = toolstripTab;
        }

        @NotNull
        public String getMnemonic() {
            return this.fText;
        }

        @NotNull
        public Point getLocationOnComponent() {
            Component[] componentArray;
            for (Component component : componentArray = ToolstripHeaderUI.this.fHeader.getComponents()) {
                if (!(component instanceof HeaderTab)) continue;
                HeaderTab headerTab = (HeaderTab)component;
                if (headerTab.fClient != this.fTab || headerTab.fMnemonicLocation == null) continue;
                return SwingUtilities.convertPoint(component, headerTab.fMnemonicLocation, ToolstripHeaderUI.this.fHeader);
            }
            return new Point(0, 0);
        }

        @NotNull
        public JComponent getComponent() {
            return ToolstripHeaderUI.this.fHeader;
        }
    }

    private static class ControlMnemonic
    implements Mnemonic {
        private HasMnemonic fMnem;
        private Mnemonic fMnemonic;

        private ControlMnemonic(HasMnemonic hasMnemonic, Mnemonic mnemonic) {
            this.fMnem = hasMnemonic;
            this.fMnemonic = mnemonic;
        }

        @NotNull
        public String getMnemonic() {
            return this.fMnemonic.getMnemonic();
        }

        @NotNull
        public Point getLocationOnComponent() {
            return this.fMnemonic.getLocationOnComponent();
        }

        @NotNull
        public JComponent getComponent() {
            return this.fMnemonic.getComponent();
        }
    }
}

