/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.popups;

import com.google.common.base.Preconditions;
import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.attr.AttributeChangeEvent;
import com.mathworks.desktop.attr.AttributeChangeListener;
import com.mathworks.toolstrip.accessories.TSContextMenuContributor;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.plaf.TSListCellRenderer;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class PopupList
extends JList
implements TSContextMenuContributor {
    private ListStyle fListStyle = ListStyle.ICON_TEXT_DESCRIPTION;
    private boolean fInitialized = false;

    public PopupList(ListModel listModel) {
        super(listModel);
        this.init();
    }

    public PopupList(ListItem[] listItemArray) {
        super(listItemArray);
        this.init();
    }

    public PopupList(Vector<ListItem> vector) {
        super(vector);
        this.init();
    }

    public PopupList() {
        this.init();
    }

    public ListStyle getListStyle() {
        return this.fListStyle;
    }

    public void setListStyle(ListStyle listStyle) {
        ListStyle listStyle2 = this.fListStyle;
        this.fListStyle = listStyle;
        this.firePropertyChange("popupListStyle", (Object)listStyle2, (Object)this.fListStyle);
    }

    public void addListActionListener(ListActionListener listActionListener) {
        ((TSListCellRenderer)this.getCellRenderer()).addListActionListener(listActionListener);
    }

    public void removeListActionListener(ListActionListener listActionListener) {
        ((TSListCellRenderer)this.getCellRenderer()).removeListActionListener(listActionListener);
    }

    public int getFirstValidSelectionIndex() {
        int n = -1;
        ListModel listModel = this.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            ListItem listItem = (ListItem)listModel.getElementAt(i);
            if (listItem.isHeader() || !((Boolean)listItem.getAttributes().getAttribute((Attribute)ListItem.ENABLED_STATE)).booleanValue()) continue;
            n = i;
            break;
        }
        return n;
    }

    private void init() {
        this.getSelectionModel().setSelectionMode(0);
        final ListModel listModel = this.getModel();
        final AttributeChangeListener attributeChangeListener = new AttributeChangeListener(){

            public void attributeChange(AttributeChangeEvent attributeChangeEvent) {
                PopupList.this.revalidate();
                PopupList.this.repaint();
            }
        };
        listModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                this.setupListeners(listDataEvent);
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                this.setupListeners(listDataEvent);
            }

            private void setupListeners(ListDataEvent listDataEvent) {
                for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                    ListItem listItem = (ListItem)listModel.getElementAt(i);
                    listItem.getAttributes().addAttributeChangeListenerWeakly(attributeChangeListener);
                }
            }
        });
        for (int i = 0; i < listModel.getSize(); ++i) {
            ((ListItem)listModel.getElementAt(i)).getAttributes().addAttributeChangeListenerWeakly(attributeChangeListener);
        }
        this.setCellRenderer((ListCellRenderer)new TSListCellRenderer(this));
        this.fInitialized = true;
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        Preconditions.checkArgument((!this.fInitialized || listCellRenderer instanceof TSListCellRenderer ? 1 : 0) != 0, (Object)"Only TSListCellRenderer is accepted as CellRenderer for PopupList");
        super.setCellRenderer(listCellRenderer);
    }

    @Override
    public void contributeToToolsripContextMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        TSContextMenuContributor tSContextMenuContributor;
        ListItem listItem;
        Action action;
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this);
        int n = this.locationToIndex(point);
        if (n >= 0 && (action = (Action)(listItem = (ListItem)this.getModel().getElementAt(n)).getAttributes().getAttribute(TSFactory.ACTION_ATTRIBUTE)) != null && (tSContextMenuContributor = (TSContextMenuContributor)action.getValue("toolstrip-context-menu-contributor")) != null) {
            tSContextMenuContributor.contributeToToolsripContextMenu(jPopupMenu, mouseEvent);
        }
    }
}

