/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.screener.Divider;
import com.mathworks.toolbox.coder.screener.ScreenerProblemType;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.LinkedList;
import java.util.List;

final class SectionedReportView
extends MJPanel {
    private final List<Divider> fDividers = new LinkedList<Divider>();
    private final boolean fStartWithDark;
    private boolean fFirstSection = true;

    SectionedReportView(boolean bl) {
        this.fStartWithDark = bl;
        if (!PlatformInfo.isMacintosh()) {
            this.setOpaque(false);
        }
        this.setLayout(new GridBagLayout());
    }

    public void startSection(GridBagConstraints gridBagConstraints, String string) {
        this.startSection(gridBagConstraints, new HeaderLabel(string));
    }

    public void startSection(GridBagConstraints gridBagConstraints, ScreenerProblemType screenerProblemType, int n) {
        this.startSection(gridBagConstraints, new HeaderLabel(screenerProblemType, n));
    }

    public void endSection(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 0;
        Divider divider = new Divider();
        this.fDividers.add(divider);
        this.add((Component)((Object)divider), gridBagConstraints);
    }

    private void startSection(GridBagConstraints gridBagConstraints, HeaderLabel headerLabel) {
        if (this.fFirstSection && (PlatformInfo.isMacintosh() || gridBagConstraints.gridy > 0)) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.insets.right = 0;
            Divider divider = new Divider();
            this.fDividers.add(divider);
            this.add((Component)((Object)divider), gridBagConstraints);
            gridBagConstraints.insets.top = 0;
        }
        gridBagConstraints.insets = new Insets(5, PlatformInfo.isMacintosh() ? 12 : 6, 6, 6);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridy;
        this.add((Component)((Object)headerLabel), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.fFirstSection = false;
    }

    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(PlatformInfo.isMacintosh() ? new Color(225, 225, 225) : new Color(250, 250, 250));
        int n2 = n = this.fStartWithDark ? 0 : 1;
        while (n < this.fDividers.size()) {
            int n3 = this.fDividers.get(n).getY();
            int n4 = this.getHeight();
            if (n < this.fDividers.size() - 1) {
                n4 = this.fDividers.get(n + 1).getY();
            }
            graphics2D.fillRect(0, n3 + 1, this.getWidth(), n4 - n3 - 1);
            n += 2;
        }
        graphics2D.dispose();
    }

    private static String getUnits(ScreenerProblemType screenerProblemType, int n) {
        String string = "screener.units.";
        string = screenerProblemType == ScreenerProblemType.UNSUPPORTED_FUNCTION ? string + "invocations." : string + "general.";
        string = n > 1 ? string + "plural" : string + "singular";
        return CoderResources.getString(string);
    }

    private class HeaderLabel
    extends MJLabel {
        HeaderLabel(ScreenerProblemType screenerProblemType, int n) {
            super("<html><b>" + CoderResources.getString("screener.problem." + StringUtils.upperCaseToCamelCase((String)screenerProblemType.toString(), (boolean)false)) + "</b><font color=\"#444444\"> - " + n + " " + SectionedReportView.getUnits(screenerProblemType, n) + "</font></html>");
            this.setFont(new Font("Arial", 0, 13));
        }

        HeaderLabel(String string) {
            super("<html><b>" + string + "</b></html>");
        }
    }
}

