/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.inputtypes;

import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.table.ClickSensitiveCellEditor;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;
import com.mathworks.project.impl.table.PropertyTableColumn;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTableNode;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.EntryPoint;
import com.mathworks.toolbox.coder.plugin.inputtypes.ExampleConversionResult;
import com.mathworks.toolbox.coder.plugin.inputtypes.FormattedTypeField;
import com.mathworks.toolbox.coder.plugin.inputtypes.GlobalVariableList;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPAttributes;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPChangeListener;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPClassEnum;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPUtils;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataProperty;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputTableActionMenu;
import com.mathworks.toolbox.coder.plugin.inputtypes.NameCellEditor;
import com.mathworks.toolbox.coder.plugin.inputtypes.TypeEntryMode;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class InputTable {
    private final Root fRoot;
    private final Configuration fConfiguration;
    private final IDPChangeListener fChangeListener;
    private final PropertyTableModel<InputDataProperty> fModel;
    private final PropertyTable<InputDataProperty> fTable;
    private final Runnable fChangeNotifier;

    public InputTable(Configuration configuration, EntryPoint entryPoint, IDPChangeListener iDPChangeListener, Runnable runnable) {
        this(configuration, new EntryPointRoot(entryPoint, iDPChangeListener, runnable), iDPChangeListener, runnable);
    }

    public InputTable(Configuration configuration, GlobalVariableList globalVariableList, IDPChangeListener iDPChangeListener, Runnable runnable) {
        this(configuration, new GlobalsRoot(globalVariableList), iDPChangeListener, runnable);
    }

    private InputTable(Configuration configuration, Root root, IDPChangeListener iDPChangeListener, Runnable runnable) {
        this.fConfiguration = configuration;
        this.fRoot = root;
        this.fChangeListener = iDPChangeListener;
        this.fChangeNotifier = runnable;
        List<PropertyTableColumn> list = Arrays.asList(new NameColumn(), new TypeColumn());
        this.fModel = new PropertyTableModel(list, this.createRootLevelRows());
        this.fTable = new PropertyTable(this.fModel, (PropertyTableCellEditorFactory)new CellEditorFactory());
        this.fTable.setHeaderVisible(false);
        this.fTable.setColumnWeights(new double[]{0.35, 0.75});
        this.fTable.setAllowSelectingExpandableRows(true);
        this.fTable.setPreferToShowAllRows(true);
        InputTableActionMenu.bindKeyStrokes(this.fTable, this.fChangeNotifier, this.createRootLevelItemRemover());
    }

    public JComponent getComponent() {
        return this.fTable.getComponent();
    }

    public void clearSelection() {
        this.fTable.clearSelection();
    }

    public void reload() {
        this.fModel.setRootLevelRows(this.createRootLevelRows());
    }

    public void dispose() {
        this.fTable.dispose();
    }

    public void addRootLevelItem() {
        this.fTable.stopEditing(false);
        InputDataProperty inputDataProperty = new InputDataProperty(((RootWithAddRemoveSupport)this.fRoot).getNewItemName());
        ((RootWithAddRemoveSupport)this.fRoot).add(inputDataProperty);
        int n = this.fTable.getModel().addRootLevel((Object)inputDataProperty);
        this.fChangeNotifier.run();
        this.fTable.select(n);
        this.fTable.startEditing(n, 0, false);
        this.fTable.getComponent().revalidate();
        this.fTable.getComponent().repaint();
    }

    private List<PropertyTableNode<InputDataProperty>> createRootLevelRows() {
        ArrayList<PropertyTableNode<InputDataProperty>> arrayList = new ArrayList<PropertyTableNode<InputDataProperty>>();
        for (InputDataProperty inputDataProperty : this.fRoot.getData()) {
            arrayList.add(this.createNode(null, inputDataProperty));
        }
        return arrayList;
    }

    private PropertyTableNode<InputDataProperty> createNode(PropertyTableNode<InputDataProperty> propertyTableNode, InputDataProperty inputDataProperty) {
        PropertyTableNode propertyTableNode2 = new PropertyTableNode(propertyTableNode, false, Arrays.asList(inputDataProperty));
        this.addChildrenRecursively((PropertyTableNode<InputDataProperty>)propertyTableNode2, inputDataProperty);
        return propertyTableNode2;
    }

    private ParameterRunnable<Integer> createRootLevelItemRemover() {
        if (this.fRoot instanceof RootWithAddRemoveSupport) {
            return new ParameterRunnable<Integer>(){

                public void run(Integer n) {
                    InputTable.this.fTable.stopEditing(false);
                    InputDataProperty inputDataProperty = (InputDataProperty)InputTable.this.fModel.getValue(n.intValue(), 0);
                    ((RootWithAddRemoveSupport)InputTable.this.fRoot).remove(inputDataProperty);
                    InputTable.this.fChangeNotifier.run();
                    InputTable.this.fTable.getModel().remove(n.intValue());
                    InputTable.this.fTable.select(n - 1);
                    InputTable.this.fTable.getComponent().revalidate();
                    InputTable.this.fTable.getComponent().repaint();
                }
            };
        }
        return null;
    }

    private void addChildrenRecursively(PropertyTableNode<InputDataProperty> propertyTableNode, InputDataProperty inputDataProperty) {
        for (InputDataProperty inputDataProperty2 : inputDataProperty.getChildren()) {
            PropertyTableNode propertyTableNode2 = new PropertyTableNode(propertyTableNode, false, Arrays.asList(inputDataProperty2));
            this.addChildrenRecursively((PropertyTableNode<InputDataProperty>)propertyTableNode2, inputDataProperty2);
        }
    }

    private MJPopupMenu createPopupMenu(InputDataProperty inputDataProperty, int n, Component component, FormattedTypeField formattedTypeField, JToggleButton jToggleButton) {
        return InputTableActionMenu.createAndShow(component, this.fConfiguration, this.fTable, n, inputDataProperty, formattedTypeField, jToggleButton, this.fChangeNotifier, this.createRootLevelItemRemover(), new Converter<String, InputDataProperty>(){

            public InputDataProperty convert(String string) {
                return InputTable.this.fRoot.create(string);
            }
        });
    }

    private static class GlobalsRoot
    implements RootWithAddRemoveSupport {
        private final GlobalVariableList fGlobals;

        GlobalsRoot(GlobalVariableList globalVariableList) {
            this.fGlobals = globalVariableList;
        }

        @Override
        public List<InputDataProperty> getData() {
            return this.fGlobals.getVariables();
        }

        @Override
        public InputDataProperty createFromResult(ExampleConversionResult exampleConversionResult, IDPChangeListener iDPChangeListener) throws IOException {
            return InputDataProperty.createInputDataProperty(XmlApi.getInstance().read(exampleConversionResult.getXML()), iDPChangeListener, null);
        }

        @Override
        public InputDataProperty create(String string) {
            return new InputDataProperty(string);
        }

        @Override
        public void replace(InputDataProperty inputDataProperty, InputDataProperty inputDataProperty2) {
            this.fGlobals.replace(inputDataProperty, inputDataProperty2);
        }

        @Override
        public String getNewItemName() {
            return "g" + (this.getData().isEmpty() ? "" : Integer.valueOf(this.getData().size()));
        }

        @Override
        public void add(InputDataProperty inputDataProperty) {
            this.fGlobals.add(inputDataProperty);
        }

        @Override
        public void remove(InputDataProperty inputDataProperty) {
            this.fGlobals.remove(inputDataProperty);
        }
    }

    private static class EntryPointRoot
    implements Root {
        private final EntryPoint fEntryPoint;
        private final IDPChangeListener fChangeListener;
        private final Runnable fChangeNotifier;

        EntryPointRoot(EntryPoint entryPoint, IDPChangeListener iDPChangeListener, Runnable runnable) {
            this.fEntryPoint = entryPoint;
            this.fChangeListener = iDPChangeListener;
            this.fChangeNotifier = runnable;
        }

        @Override
        public List<InputDataProperty> getData() {
            return this.fEntryPoint.getInputDataProperties();
        }

        @Override
        public InputDataProperty createFromResult(ExampleConversionResult exampleConversionResult, IDPChangeListener iDPChangeListener) throws IOException {
            return InputDataProperty.createInputDataProperty(XmlApi.getInstance().read(exampleConversionResult.getXML()), iDPChangeListener, this.fEntryPoint);
        }

        @Override
        public InputDataProperty create(String string) {
            InputDataProperty inputDataProperty = new InputDataProperty(this.fEntryPoint, string);
            inputDataProperty.setChangeListener(this.fChangeListener);
            return inputDataProperty;
        }

        @Override
        public void replace(InputDataProperty inputDataProperty, InputDataProperty inputDataProperty2) {
            this.fEntryPoint.replaceInput(inputDataProperty, inputDataProperty2);
            inputDataProperty2.setChangeListener(this.fChangeListener);
            this.fChangeNotifier.run();
        }
    }

    private static interface RootWithAddRemoveSupport
    extends Root {
        public String getNewItemName();

        public void add(InputDataProperty var1);

        public void remove(InputDataProperty var1);
    }

    private static interface Root {
        public List<InputDataProperty> getData();

        public InputDataProperty createFromResult(ExampleConversionResult var1, IDPChangeListener var2) throws IOException;

        public InputDataProperty create(String var1);

        public void replace(InputDataProperty var1, InputDataProperty var2);
    }

    private class TypeCellEditor
    implements ClickSensitiveCellEditor<InputDataProperty> {
        private final InputDataProperty fProperty;
        private final int fRow;
        private final FormattedTypeField fTextField;
        private final MJToggleButton fPopupButton;
        private final MJPanel fPanel;
        private Point fInitialClickPoint;
        private String fDisplayedText;
        private MJPopupMenu fPopup;
        private boolean fActivating;

        TypeCellEditor(InputDataProperty inputDataProperty, int n) {
            this.fProperty = inputDataProperty;
            this.fTextField = new FormattedTypeField((PropertyTable<InputDataProperty>)InputTable.this.fTable, this.fProperty, InputTable.this.fRoot instanceof GlobalsRoot, new ParameterRunnable<Runnable>(){

                public void run(Runnable runnable) {
                    TypeCellEditor.this.fProperty.setClass(TypeCellEditor.this.fTextField.getTypeName(), true);
                    InputTableActionMenu.showProperties(InputTable.this.fConfiguration, (PropertyTable<InputDataProperty>)InputTable.this.fTable, TypeCellEditor.this.fProperty, runnable);
                }
            });
            if (inputDataProperty.isVarargin()) {
                this.fTextField.setEditable(false);
            }
            this.fTextField.lockFormatTip();
            this.fRow = n;
            this.fPopupButton = new MJToggleButton(DocumentIcon.ACTIONS.getIcon()){

                public Dimension getMinimumSize() {
                    return new Dimension(20, 0);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(20, (int)super.getPreferredSize().getHeight());
                }
            };
            this.fPopupButton.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (TypeCellEditor.this.fPopup == null) {
                        TypeCellEditor.this.fActivating = true;
                        InputTable.this.fTable.setKeepEditorAlive(true);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    TypeCellEditor.this.clearActivatingFlag();
                }
            });
            this.fPopupButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (TypeCellEditor.this.fActivating) {
                        TypeCellEditor.this.fTextField.closeFormatTip();
                        TypeCellEditor.this.fPopup = InputTable.this.createPopupMenu(TypeCellEditor.this.fProperty, TypeCellEditor.this.fRow, (Component)TypeCellEditor.this.fPanel, TypeCellEditor.this.fTextField, (JToggleButton)TypeCellEditor.this.fPopupButton);
                        TypeCellEditor.this.fPopup.show();
                    } else if (TypeCellEditor.this.fPopup != null) {
                        TypeCellEditor.this.fPopup.hide();
                        Timer timer = new Timer(20, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                if (FocusManager.getCurrentManager().getFocusedWindow() == SwingUtilities.windowForComponent(TypeCellEditor.this.fTextField.getComponent())) {
                                    TypeCellEditor.this.fTextField.getComponent().requestFocus();
                                }
                                InputTable.this.fTable.setKeepEditorAlive(false);
                                TypeCellEditor.this.fPopup = null;
                                TypeCellEditor.this.fPopupButton.setSelected(false);
                            }
                        });
                        timer.setRepeats(false);
                        timer.start();
                    }
                }
            });
            this.fTextField.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    TypeCellEditor.this.fPopupButton.setVisible(TypeCellEditor.this.fProperty.isVarargin() || InputTable.this.fRoot instanceof GlobalsRoot || TypeCellEditor.this.fProperty.getParent() != null && TypeCellEditor.this.fProperty.getParent().isVarargin() || TypeCellEditor.this.fTextField.getTypeName() != null && TypeCellEditor.this.fTextField.getTypeName().equals("struct") || TypeCellEditor.this.fProperty.getParent() != null && TypeCellEditor.this.fProperty.getParent().isStruct());
                }
            });
            this.fPopupButton.setVisible(this.fProperty.isVarargin() || InputTable.this.fRoot instanceof GlobalsRoot || this.fProperty.getParent() != null && this.fProperty.getParent().isVarargin() || this.fProperty.isStruct() || this.fProperty.getParent() != null && this.fProperty.getParent().isStruct());
            this.fPanel = new MJPanel((LayoutManager)new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this.fPanel.add((Component)this.fTextField.getComponent(), (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.fill = 3;
            gridBagConstraints.weightx = 0.0;
            this.fPanel.add((Component)this.fPopupButton, (Object)gridBagConstraints);
        }

        private void clearActivatingFlag() {
            Timer timer = new Timer(20, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TypeCellEditor.this.fActivating = false;
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        public void setInitialClickPoint(Point point) {
            this.fInitialClickPoint = point;
        }

        public void loadData(Object object, String string) {
            this.fDisplayedText = string;
            InputDataProperty inputDataProperty = (InputDataProperty)object;
            if (inputDataProperty.isConstant()) {
                this.fTextField.setMode(TypeEntryMode.CONSTANT);
            } else {
                this.fTextField.setText(inputDataProperty.getDefinition(false));
            }
        }

        public void commitData() {
            if (this.fProperty.isVarargin()) {
                return;
            }
            if (this.fTextField.getFullText().length() == 0) {
                if (this.fTextField.getMode() == TypeEntryMode.INITIAL_VALUE) {
                    this.fProperty.setInitialValue(null);
                    InputTable.this.fChangeNotifier.run();
                } else {
                    this.fProperty.setAttributesDirect(new IDPAttributes(this.fProperty.getAttributes().getName()));
                    this.fProperty.setValue(null);
                    this.commit(this.fProperty, true);
                }
                return;
            }
            if (this.fTextField.getFullText().length() > 0 && this.fTextField.getTypeName() == null) {
                final String string = this.fTextField.getFullText();
                if (string.trim().isEmpty()) {
                    return;
                }
                IDPUtils.evaluateExampleExpression(this.fProperty, string, new ParameterRunnable<ExampleConversionResult>(){

                    public void run(ExampleConversionResult exampleConversionResult) {
                        if (exampleConversionResult.getMessage().isEmpty()) {
                            try {
                                if (TypeCellEditor.this.fTextField.getMode() == TypeEntryMode.INITIAL_VALUE) {
                                    TypeCellEditor.this.fProperty.setInitialValue(string);
                                    if (!TypeCellEditor.this.fProperty.getClassName().equals(IDPClassEnum.UNDEFINED.getClassName())) {
                                        InputTable.this.fChangeNotifier.run();
                                        return;
                                    }
                                }
                                InputDataProperty inputDataProperty = InputTable.this.fRoot.createFromResult(exampleConversionResult, InputTable.this.fChangeListener);
                                if (TypeCellEditor.this.fTextField.getMode() != TypeEntryMode.INITIAL_VALUE) {
                                    inputDataProperty.setValue(string);
                                    inputDataProperty.setConstant(TypeCellEditor.this.fTextField.getMode() == TypeEntryMode.CONSTANT, true);
                                } else {
                                    inputDataProperty.setInitialValue(string);
                                }
                                TypeCellEditor.this.commit(inputDataProperty, true);
                            }
                            catch (IOException iOException) {
                                throw new IllegalStateException(iOException);
                            }
                        } else {
                            HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(exampleConversionResult.getMessage(), new HyperlinkTextLabel.HyperlinkHandler(){

                                public void processHyperlink(String string) {
                                    if (string.startsWith("matlab:")) {
                                        new Matlab().evalConsoleOutput(string.substring("matlab:".length()));
                                    }
                                }
                            }, false, "link.badConversion.innerComponent", exampleConversionResult.getMessage());
                            MJOptionPane.showMessageDialog((Component)MJFrame.getFrame((Component)InputTable.this.fTable.getComponent()), (Object)hyperlinkTextLabel.getComponent(), (String)CoderResources.getString("typedef.error.example.title"), (int)0);
                        }
                    }
                });
            } else if (this.fTextField.getTypeName() != null) {
                InputDataProperty inputDataProperty = InputTable.this.fRoot.create(this.fProperty.getName());
                inputDataProperty.setClass(this.fTextField.getTypeName(), false);
                inputDataProperty.setSize(this.fTextField.getSize(), false);
                inputDataProperty.setComplex(this.fTextField.isComplex(), false);
                this.commit(inputDataProperty, false);
            }
        }

        private void commit(InputDataProperty inputDataProperty, boolean bl) {
            if (inputDataProperty.getClassID().equals((Object)this.fProperty.getClassID()) && inputDataProperty.getSizeString().equals(this.fProperty.getSizeString()) && (inputDataProperty.getValue() == null || inputDataProperty.getValue().isEmpty()) && inputDataProperty.isComplex() == this.fProperty.isComplex()) {
                return;
            }
            if (!bl && this.fProperty.getClassID().equals((Object)inputDataProperty.getClassID()) && (this.fProperty.getValue() == null || this.fProperty.getValue().isEmpty()) && (inputDataProperty.getValue() == null || inputDataProperty.getValue().isEmpty())) {
                this.fProperty.setSize(inputDataProperty.getSizeString(), true);
                this.fProperty.setComplex(inputDataProperty.isComplex(), true);
            } else {
                if (this.fProperty.getParent() != null) {
                    inputDataProperty.setParent(this.fProperty.getParent());
                    this.fProperty.getParent().replaceField(this.fProperty, inputDataProperty);
                } else {
                    InputTable.this.fRoot.replace(this.fProperty, inputDataProperty);
                }
                PropertyTableNode propertyTableNode = new PropertyTableNode(null, false, Arrays.asList(inputDataProperty));
                InputTable.this.fModel.replaceRow(this.fRow, propertyTableNode);
                InputTable.this.addChildrenRecursively((PropertyTableNode<InputDataProperty>)propertyTableNode, inputDataProperty);
            }
            InputTable.this.fChangeNotifier.run();
        }

        public JComponent getComponent() {
            return this.fPanel;
        }

        public void activate() {
            Serializable serializable;
            this.fTextField.getComponent().requestFocus();
            boolean bl = false;
            if (this.fInitialClickPoint != null) {
                serializable = this.fPopupButton.getLocation();
                SwingUtilities.convertPointToScreen((Point)serializable, this.fPopupButton.getParent());
                bl = new Rectangle((Point)serializable, this.fPopupButton.getSize()).contains(this.fInitialClickPoint);
                if (bl) {
                    this.fActivating = true;
                    this.fTextField.closeFormatTip();
                    InputTable.this.fTable.setKeepEditorAlive(true);
                    this.fPopupButton.setSelected(true);
                    this.clearActivatingFlag();
                } else {
                    SwingUtilities.convertPointFromScreen(this.fInitialClickPoint, this.fTextField.getComponent());
                    this.fTextField.clickFromRendererIntoEditor(this.fDisplayedText, this.fInitialClickPoint);
                }
            }
            serializable = new Timer(bl ? 200 : 1, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TypeCellEditor.this.fTextField.unlockFormatTip();
                }
            });
            ((Timer)serializable).setRepeats(false);
            ((Timer)serializable).start();
        }

        public void dispose() {
            if (this.fPopup != null) {
                this.fPopup.hide();
                this.fPopup = null;
            }
            this.fTextField.dispose();
        }
    }

    private class CellEditorFactory
    implements PropertyTableCellEditorFactory<InputDataProperty> {
        private CellEditorFactory() {
        }

        public PropertyTableCellEditor<InputDataProperty> createWidget(PropertyTable<InputDataProperty> propertyTable, int n, int n2, InputDataProperty inputDataProperty) {
            if (n2 == 1) {
                return new TypeCellEditor(inputDataProperty, n);
            }
            if (n2 == 0 && (inputDataProperty.getParent() != null && inputDataProperty.getParent().isStruct() || InputTable.this.fRoot instanceof RootWithAddRemoveSupport)) {
                return new NameCellEditor(propertyTable, inputDataProperty);
            }
            return null;
        }
    }

    private class TypeColumn
    implements PropertyTableColumn<InputDataProperty> {
        private TypeColumn() {
        }

        public String getText(InputDataProperty inputDataProperty) {
            String string = inputDataProperty.getDefinition();
            if (string.equals("<Undefined>")) {
                string = CoderResources.getString("typedef.frozen.prompt" + (PlatformInfo.isMacintosh() ? ".mac" : ""));
            }
            return string;
        }

        public HyperlinkTextLabel createLink(InputDataProperty inputDataProperty) {
            return null;
        }

        public String getName() {
            return "Type";
        }

        public boolean isEditable() {
            return true;
        }
    }

    private class NameColumn
    implements PropertyTableColumn<InputDataProperty> {
        private NameColumn() {
        }

        public String getText(InputDataProperty inputDataProperty) {
            return inputDataProperty.getName();
        }

        public HyperlinkTextLabel createLink(InputDataProperty inputDataProperty) {
            return null;
        }

        public String getName() {
            return "Name";
        }

        public boolean isEditable() {
            return true;
        }
    }
}

