/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.ParamWidgetBinder;
import com.mathworks.project.impl.settingsui.SettingComponentDefinition;
import com.mathworks.project.impl.settingsui.SettingsPanelBuilder;
import com.mathworks.project.impl.settingsui.SettingsPanelBuilderFactory;
import com.mathworks.project.impl.settingsui.table.NameColumn;
import com.mathworks.project.impl.settingsui.table.SettingsTableUtils;
import com.mathworks.project.impl.settingsui.table.ValueColumn;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class HardwareImplementationWidget
implements ProjectComponent {
    private final Project fProject;
    private final Configuration fConfiguration;
    private final MJPanel fComponent;
    private final PropertyTable<Param> fTable;
    private final MJLabel fCodeReplacementLibraryWarningLabel;
    private final MJLabel fSizeErrorLabel;
    private final MJPanel fSizeErrorLabelContainer;
    private final ParameterRunnable<ProjectComponent> fComponentRegistry;
    private final List<ProjectComponent> fBatchComponents;
    private final ParamWidgetBinder fBinder;
    private final PropertyChangeListener fPropertyChangeListener;
    private final PropertyChangeListener fFocusListener;
    private boolean fNeedCrlRefresh = true;
    private HyperlinkTextLabel fCrlSetupLink;
    private static final String TARGET_INSTANCE_KEY = "Target";
    private static final String PRODUCTION_INSTANCE_KEY = "Production";
    private static final String SAME_HARDWARE_FLAG_KEY = "param.SameHardware";
    private static final String CODE_REPLACEMENT_LIBRARY_KEY = "param.CodeReplacementLibrary";
    private static final String HARDWARE_VENDOR_KEY_PREFIX = "param.HardwareVendor.";
    private static final String HARDWARE_TYPE_KEY_PREFIX = "param.HardwareType.";
    private static final String HARDWARE_SIZE_KEY_PREFIX = "param.HardwareSize";
    private static final String RIGHT_SHIFT_ARITHMETIC_KEY_PREFIX = "param.HardwareArithmeticRightShift.";
    private static final String ENDIANNESS_KEY_PREFIX = "param.HardwareEndianness.";
    private static final String ENDIANNESS_OPTION_PREFIX = "option.HardwareEndianness.";
    private static final String ATOMIC_INTEGER_KEY_PREFIX = "param.HardwareAtomicIntegerSize.";
    private static final String ATOMIC_INTEGER_OPTION_PREFIX = "option.HardwareAtomicIntegerSize.";
    private static final String ATOMIC_FLOAT_KEY_PREFIX = "param.HardwareAtomicFloatSize.";
    private static final String ATOMIC_FLOAT_OPTION_PREFIX = "option.HardwareAtomicFloatSize.";
    private static final String INTEGER_DIVISION_ROUNDING_KEY_PREFIX = "param.HardwareDivisionRounding.";
    private static final String INTEGER_DIVISION_ROUNDING_OPTION_PREFIX = "option.HardwareDivisionRounding.";
    private static final String ASIC_DEVICE = "ASIC/FPGA";

    public HardwareImplementationWidget(WritableConfiguration writableConfiguration) {
        Font font;
        this.fConfiguration = (Configuration)writableConfiguration;
        this.fProject = this.fConfiguration.getProject();
        this.fComponent = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fComponent.setOpaque(false);
        this.fCodeReplacementLibraryWarningLabel = new MJLabel();
        this.fSizeErrorLabel = new MJLabel();
        this.fSizeErrorLabelContainer = new MJPanel(new BorderLayout(0, 0)){

            public Dimension getPreferredSize() {
                if (HardwareImplementationWidget.this.fTable != null) {
                    return new Dimension(HardwareImplementationWidget.this.fTable.getComponent().getWidth(), (int)super.getPreferredSize().getHeight());
                }
                return super.getPreferredSize();
            }
        };
        this.fSizeErrorLabelContainer.add((Component)this.fSizeErrorLabel);
        this.fSizeErrorLabelContainer.setOpaque(false);
        if (PlatformInfo.isMacintosh()) {
            font = this.fCodeReplacementLibraryWarningLabel.getFont();
            this.fCodeReplacementLibraryWarningLabel.setFont(font.deriveFont((float)font.getSize() - 1.0f));
            this.fSizeErrorLabel.setFont(this.fCodeReplacementLibraryWarningLabel.getFont());
        }
        this.fBinder = new ParamWidgetBinder(this.fProject, false);
        this.fBatchComponents = new ArrayList<ProjectComponent>();
        this.fComponentRegistry = new ParameterRunnable<ProjectComponent>(){

            public void run(ProjectComponent projectComponent) {
                HardwareImplementationWidget.this.fBatchComponents.add(projectComponent);
            }
        };
        font = this.fConfiguration.getTarget().getParamSet("paramset.hardware");
        List<Param> list = HardwareImplementationWidget.findTableParams((ParamSet)font);
        List<Param> list2 = HardwareImplementationWidget.findNonTableParams((ParamSet)font);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new NameColumn());
        arrayList.add(new ValueColumn(this.fConfiguration, CoderResources.getString("hardware.column.production")));
        arrayList.add(new ValueColumn(this.fConfiguration, CoderResources.getString("hardware.column.test")));
        this.fTable = SettingsTableUtils.createTable((Configuration)this.fConfiguration, (ParamSet)font, list, Arrays.asList(PRODUCTION_INSTANCE_KEY, TARGET_INSTANCE_KEY), arrayList);
        this.fTable.setPreferToShowAllRows(true);
        this.fTable.setColumnWeights(new double[]{0.48, 0.26, 0.26});
        this.fTable.setNoStretch(true);
        SettingsPanelBuilder settingsPanelBuilder = SettingsPanelBuilderFactory.createSettingsPanelBuilder((Project)this.fConfiguration.getProject(), (boolean)false, this.fComponentRegistry);
        for (final Param param : list2) {
            if (param.getKey().equals(SAME_HARDWARE_FLAG_KEY)) {
                settingsPanelBuilder.startCategory(CoderResources.getString("category.hardware.settings"));
            }
            Component component = this.fBinder.createAndRegister(param);
            String string = null;
            if (this.fBinder.get(param).isExternalLabelRequired()) {
                string = param.getName();
            }
            if (param.getKey().equals(CODE_REPLACEMENT_LIBRARY_KEY)) {
                MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("fill:d:grow, 3dlu, fill:d", "center:d"));
                mJPanel.setOpaque(false);
                CellConstraints cellConstraints = new CellConstraints();
                this.fCrlSetupLink = new HyperlinkTextLabel("<html><a href=\"\">" + param.getMoreInfoLinkText() + "</a></html>", new HyperlinkTextLabel.HyperlinkHandler(){

                    public void processHyperlink(String string) {
                        new Matlab().evalConsoleOutput(param.getMoreInfoLinkCallback());
                    }
                });
                this.fCrlSetupLink.getComponent().setVisible(this.fConfiguration.isMoreInfoVisible(param.getKey()));
                mJPanel.add(component, (Object)cellConstraints.xy(1, 1));
                mJPanel.add((Component)this.fCrlSetupLink.getComponent(), (Object)cellConstraints.xy(3, 1));
                component = mJPanel;
            }
            settingsPanelBuilder.addComponent(new SettingComponentDefinition(param, string, param.getDescription(), null, component));
            if (!param.getKey().equals(CODE_REPLACEMENT_LIBRARY_KEY)) continue;
            settingsPanelBuilder.addComponent((Component)this.fCodeReplacementLibraryWarningLabel, false);
        }
        settingsPanelBuilder.addComponent((Component)this.fSizeErrorLabelContainer, false);
        settingsPanelBuilder.addComponent((Component)this.fTable.getComponent(), false);
        settingsPanelBuilder.endCategory();
        settingsPanelBuilder.addPadding();
        if (this.fConfiguration.getParamAsBoolean(SAME_HARDWARE_FLAG_KEY)) {
            this.fTable.foldInLastColumn(true);
        }
        this.fComponent.add((Component)settingsPanelBuilder.getComponent(), (Object)"Center");
        this.fPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().startsWith(HardwareImplementationWidget.HARDWARE_TYPE_KEY_PREFIX)) {
                    String string = propertyChangeEvent.getPropertyName().substring(HardwareImplementationWidget.HARDWARE_TYPE_KEY_PREFIX.length());
                    HardwareImplementationWidget.this.updateHardwareDetails(string, true);
                } else if (propertyChangeEvent.getPropertyName().equals("param.HardwareVendor.Production") && propertyChangeEvent.getNewValue().equals(HardwareImplementationWidget.ASIC_DEVICE)) {
                    HardwareImplementationWidget.this.fConfiguration.setParamAsBoolean(HardwareImplementationWidget.SAME_HARDWARE_FLAG_KEY, false);
                } else if (propertyChangeEvent.getPropertyName().equals(HardwareImplementationWidget.SAME_HARDWARE_FLAG_KEY)) {
                    if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        HardwareImplementationWidget.this.fTable.foldInLastColumn(false);
                    } else {
                        HardwareImplementationWidget.this.fTable.foldOutLastColumn();
                        HardwareImplementationWidget.this.updateHardwareDetails(HardwareImplementationWidget.TARGET_INSTANCE_KEY, false);
                    }
                } else if (propertyChangeEvent.getPropertyName().equals(HardwareImplementationWidget.CODE_REPLACEMENT_LIBRARY_KEY)) {
                    HardwareImplementationWidget.this.updateCodeReplacementLibraryWarning();
                } else if (propertyChangeEvent.getPropertyName().startsWith(HardwareImplementationWidget.HARDWARE_SIZE_KEY_PREFIX)) {
                    HardwareImplementationWidget.this.updateSizeError();
                } else if (Configuration.isMoreInfoVisibilityChange((PropertyChangeEvent)propertyChangeEvent)) {
                    HardwareImplementationWidget.this.fCrlSetupLink.getComponent().setVisible(HardwareImplementationWidget.this.fConfiguration.isMoreInfoVisible(HardwareImplementationWidget.CODE_REPLACEMENT_LIBRARY_KEY));
                }
            }
        };
        this.fConfiguration.addPropertyChangeListener(this.fPropertyChangeListener);
        this.updateHardwareDetails(TARGET_INSTANCE_KEY, false);
        this.updateHardwareDetails(PRODUCTION_INSTANCE_KEY, false);
        this.updateCodeReplacementLibraryWarning();
        this.updateSizeError();
        this.fFocusListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() != SwingUtilities.windowForComponent((Component)HardwareImplementationWidget.this.fComponent)) {
                    HardwareImplementationWidget.this.fNeedCrlRefresh = true;
                } else if (HardwareImplementationWidget.this.fNeedCrlRefresh) {
                    HardwareImplementationWidget.this.fConfiguration.refreshParamOptions(HardwareImplementationWidget.CODE_REPLACEMENT_LIBRARY_KEY);
                    HardwareImplementationWidget.this.fNeedCrlRefresh = false;
                }
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.fFocusListener);
    }

    private void updateCodeReplacementLibraryWarning() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String string = HardwareImplementationWidget.this.fConfiguration.getParamAsString(HardwareImplementationWidget.CODE_REPLACEMENT_LIBRARY_KEY);
                if (!HardwareImplementationWidget.this.fConfiguration.getParamOptions(HardwareImplementationWidget.CODE_REPLACEMENT_LIBRARY_KEY).getOptions().containsKey(string)) {
                    HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.setText(CoderResources.getString("msg.crl.notRegistered"));
                    HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.setIcon((Icon)DialogIcon.WARNING_12x12.getIcon());
                } else {
                    HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.setText("");
                    HardwareImplementationWidget.this.fCodeReplacementLibraryWarningLabel.setIcon(null);
                }
            }
        });
    }

    private void updateSizeError() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                List list = HardwareImplementationWidget.this.fConfiguration.getTarget().validate(HardwareImplementationWidget.this.fConfiguration.getProject());
                for (ValidationMessage validationMessage : list) {
                    if (validationMessage.getParamKey() == null || !validationMessage.getParamKey().startsWith(HardwareImplementationWidget.HARDWARE_SIZE_KEY_PREFIX)) continue;
                    HardwareImplementationWidget.this.fSizeErrorLabel.setText(validationMessage.getText());
                    HardwareImplementationWidget.this.fSizeErrorLabel.setIcon((Icon)DialogIcon.ERROR_12x12.getIcon());
                    if (!PlatformInfo.isMacintosh()) {
                        HardwareImplementationWidget.this.fSizeErrorLabel.setBorder((Border)new LineBorder(Color.RED));
                    }
                    HardwareImplementationWidget.this.fSizeErrorLabelContainer.setBorder((Border)new EmptyBorder(4, 0, 1, 0));
                    HardwareImplementationWidget.this.fSizeErrorLabel.setOpaque(true);
                    HardwareImplementationWidget.this.fSizeErrorLabel.setBackground(new Color(230, 180, 180));
                    return;
                }
                HardwareImplementationWidget.this.fSizeErrorLabel.setText("");
                HardwareImplementationWidget.this.fSizeErrorLabel.setIcon(null);
                HardwareImplementationWidget.this.fSizeErrorLabel.setBorder(null);
                HardwareImplementationWidget.this.fSizeErrorLabel.setOpaque(false);
                HardwareImplementationWidget.this.fSizeErrorLabelContainer.setBorder(null);
            }
        });
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this.fFocusListener);
        this.fConfiguration.removePropertyChangeListener(this.fPropertyChangeListener);
        this.fTable.dispose();
        this.fBinder.dispose();
        for (ProjectComponent projectComponent : this.fBatchComponents) {
            projectComponent.dispose();
        }
        this.fBatchComponents.clear();
    }

    private void updateHardwareDetails(final String string, final boolean bl) {
        String string2 = this.fConfiguration.getParamAsString(HARDWARE_VENDOR_KEY_PREFIX + string);
        String string3 = this.fConfiguration.getParamAsString(HARDWARE_TYPE_KEY_PREFIX + string);
        final String[] stringArray = new String[]{"Char", "Short", "Int", "Long", "Float", "Double", "Pointer", "Word"};
        new Matlab().fevalConsoleOutput("emlcprivate", new Object[]{"getHardwareDetails", string2, string3}, 14, new CompletionObserver(){

            public void completed(int n, Object object) {
                if (Matlab.getExecutionStatus((int)n) == 0 && object != null) {
                    Object[] objectArray = (Object[])object;
                    for (int i = 0; i < stringArray.length; ++i) {
                        HardwareImplementationWidget.this.setSizeParam(objectArray, i, stringArray[i], string);
                    }
                    String string5 = (String)objectArray[8];
                    if (string5.endsWith("Endian")) {
                        string5 = string5.substring(0, string5.indexOf("Endian"));
                    }
                    boolean bl2 = ((boolean[])objectArray[9])[0];
                    String string2 = (String)objectArray[10];
                    String string3 = (String)objectArray[11];
                    String string4 = (String)objectArray[12];
                    HardwareImplementationWidget.this.fConfiguration.setParamAsBoolean(HardwareImplementationWidget.RIGHT_SHIFT_ARITHMETIC_KEY_PREFIX + string, bl2);
                    HardwareImplementationWidget.this.fConfiguration.setParamAsString(HardwareImplementationWidget.ENDIANNESS_KEY_PREFIX + string, HardwareImplementationWidget.ENDIANNESS_OPTION_PREFIX + string5);
                    if (bl || !HardwareImplementationWidget.this.fConfiguration.isParamExplicitlySet(HardwareImplementationWidget.ATOMIC_INTEGER_KEY_PREFIX + string)) {
                        HardwareImplementationWidget.this.fConfiguration.setParamAsString(HardwareImplementationWidget.ATOMIC_INTEGER_KEY_PREFIX + string, HardwareImplementationWidget.ATOMIC_INTEGER_OPTION_PREFIX + string2);
                    }
                    if (bl || !HardwareImplementationWidget.this.fConfiguration.isParamExplicitlySet(HardwareImplementationWidget.ATOMIC_FLOAT_KEY_PREFIX + string)) {
                        HardwareImplementationWidget.this.fConfiguration.setParamAsString(HardwareImplementationWidget.ATOMIC_FLOAT_KEY_PREFIX + string, HardwareImplementationWidget.ATOMIC_FLOAT_OPTION_PREFIX + string3);
                    }
                    if (bl || !HardwareImplementationWidget.this.fConfiguration.isParamExplicitlySet(HardwareImplementationWidget.INTEGER_DIVISION_ROUNDING_KEY_PREFIX + string)) {
                        HardwareImplementationWidget.this.fConfiguration.setParamAsString(HardwareImplementationWidget.INTEGER_DIVISION_ROUNDING_KEY_PREFIX + string, HardwareImplementationWidget.INTEGER_DIVISION_ROUNDING_OPTION_PREFIX + string4);
                    }
                    boolean[] blArray = (boolean[])objectArray[13];
                    for (int i = 0; i < stringArray.length; ++i) {
                        HardwareImplementationWidget.this.setForceDisableSizeParam(!blArray[i], stringArray[i], string);
                    }
                    HardwareImplementationWidget.this.fConfiguration.setForcedDisabled(HardwareImplementationWidget.ENDIANNESS_KEY_PREFIX + string, !blArray[8]);
                    HardwareImplementationWidget.this.fConfiguration.setForcedDisabled(HardwareImplementationWidget.RIGHT_SHIFT_ARITHMETIC_KEY_PREFIX + string, !blArray[9]);
                    HardwareImplementationWidget.this.fConfiguration.setForcedDisabled(HardwareImplementationWidget.INTEGER_DIVISION_ROUNDING_KEY_PREFIX + string, !blArray[10]);
                    HardwareImplementationWidget.this.fConfiguration.setForcedDisabled(HardwareImplementationWidget.ATOMIC_INTEGER_KEY_PREFIX + string, !blArray[11]);
                    HardwareImplementationWidget.this.fConfiguration.setForcedDisabled(HardwareImplementationWidget.ATOMIC_FLOAT_KEY_PREFIX + string, !blArray[12]);
                }
            }
        });
    }

    private void setSizeParam(Object[] objectArray, int n, String string, String string2) {
        int n2 = (int)((double[])objectArray[n])[0];
        this.fConfiguration.setParamAsInt(HARDWARE_SIZE_KEY_PREFIX + string + "." + string2, n2);
    }

    private void setForceDisableSizeParam(boolean bl, String string, String string2) {
        this.fConfiguration.setForcedDisabled(HARDWARE_SIZE_KEY_PREFIX + string + "." + string2, bl);
    }

    private static List<Param> findTableParams(ParamSet paramSet) {
        ArrayList<Param> arrayList = new ArrayList<Param>();
        for (Param param : paramSet.getParams()) {
            String string = param.getKey();
            if (!string.startsWith("param.Hardware")) continue;
            arrayList.add(param);
        }
        return arrayList;
    }

    private static List<Param> findNonTableParams(ParamSet paramSet) {
        ArrayList<Param> arrayList = new ArrayList<Param>();
        for (Param param : paramSet.getParams()) {
            String string = param.getKey();
            if (string.startsWith("param.Hardware") || string.startsWith("var.")) continue;
            arrayList.add(param);
        }
        return arrayList;
    }
}

