/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class FitScrollPane
extends JScrollPane
implements ComponentListener {
    public FitScrollPane() {
        this.initScrollPane();
    }

    public FitScrollPane(Component component) {
        super(component);
        this.initScrollPane();
    }

    public FitScrollPane(Component component, int n, int n2) {
        super(component, n, n2);
        this.initScrollPane();
    }

    public FitScrollPane(int n, int n2) {
        super(n, n2);
        this.initScrollPane();
    }

    private void initScrollPane() {
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(21);
        this.getViewport().getView().addComponentListener(this);
        this.removeMouseWheelListeners();
    }

    private void removeMouseWheelListeners() {
        MouseWheelListener[] mouseWheelListenerArray;
        for (MouseWheelListener mouseWheelListener : mouseWheelListenerArray = this.getMouseWheelListeners()) {
            this.removeMouseWheelListener(mouseWheelListener);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.removeMouseWheelListeners();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.setSize(this.getSize().width, this.getPreferredSize().height);
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public Dimension getPreferredSize() {
        Component component;
        JViewport jViewport = this.getViewport();
        if (jViewport != null && (component = jViewport.getView()) != null) {
            jViewport.setPreferredSize(component.getPreferredSize());
        }
        return super.getPreferredSize();
    }
}

