/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.workunit;

import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.credentials.NontransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.TransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialTransferException;
import com.mathworks.toolbox.distcomp.auth.credentials.store.NoCredentialsException;
import com.mathworks.toolbox.distcomp.jobmanager.JobCounter;
import com.mathworks.toolbox.distcomp.jobmanager.JobRunner;
import com.mathworks.toolbox.distcomp.jobmanager.TaskDispatcher;
import com.mathworks.toolbox.distcomp.jobmanager.TaskDispatcherForJobs;
import com.mathworks.toolbox.distcomp.jobmanager.WorkUnitTimeoutChecker;
import com.mathworks.toolbox.distcomp.jobmanager.WorkerPool;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.datastore.TransferableData;
import com.mathworks.toolbox.distcomp.storage.DataStorage;
import com.mathworks.toolbox.distcomp.storage.DataStorageException;
import com.mathworks.toolbox.distcomp.storage.JobStorage;
import com.mathworks.toolbox.distcomp.storage.LargeStorageItem;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.util.TimeProvider;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.worker.WorkerProxy;
import com.mathworks.toolbox.distcomp.workunit.AlreadyRerunningException;
import com.mathworks.toolbox.distcomp.workunit.Job;
import com.mathworks.toolbox.distcomp.workunit.JobInfo;
import com.mathworks.toolbox.distcomp.workunit.JobLargeDataAccessor;
import com.mathworks.toolbox.distcomp.workunit.JobStateException;
import com.mathworks.toolbox.distcomp.workunit.LargeDataAccessor;
import com.mathworks.toolbox.distcomp.workunit.NoRerunsLeftException;
import com.mathworks.toolbox.distcomp.workunit.PackageInfo;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import com.mathworks.toolbox.distcomp.workunit.TaskInfo;
import com.mathworks.toolbox.distcomp.workunit.TaskStateException;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitInfo;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitStateException;
import com.mathworks.toolbox.distcomp.workunit.WorkerSortStrategy;
import com.mathworks.toolbox.distcomp.workunit.WorkerTaskInfo;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import net.jini.id.Uuid;

public class JobImpl
extends WorkUnitImpl
implements Job {
    public static final int INTERACTIVE_JOB = 1;
    public static final int BATCH_JOB = 0;
    private static final WorkerSortStrategy DEFAULT_DISTRIBUTED_STRATEGY = WorkerSortStrategy.BY_HOSTNAME;
    private WorkerSortStrategy fWorkerSortStrategy;
    private String fTag;
    private String fApiTag;
    protected int fMaxWorkers = Integer.MAX_VALUE;
    protected int fMinWorkers = 1;
    private boolean fRestartWorker;
    private String[] fFileDepPathList;
    private String[] fPathList;
    private byte[] fProductList;
    private LargeStorageItem fFileDepDataItem = new LargeStorageItem(0);
    private LargeStorageItem fJobScopeDataItem = new LargeStorageItem(0);
    private long fQueueNum = Long.MAX_VALUE;
    private long fSubmitTime = -1L;
    private Uuid[] fWorkersToUse;
    private int fJobMLType;
    protected int fMATLABExecutionMode;
    private long fTaskSequenceNum = 1L;
    private TransferableCredentials fCredentials;
    private final LargeDataAccessor fLargeDataAccessor;
    private transient CryptoModule fCryptoModule;
    private static byte[] sSalt = new byte[0];
    private transient DataStorage fLargeDataStorage;
    private transient JobStorage fStorage;
    private transient DataStorage fAppendableDataStorage;

    public JobImpl(long l, int n, String string) {
        super(l, string);
        this.fName = this.getDefaultName();
        this.fJobMLType = n;
        this.setWorkerSortStrategy(DEFAULT_DISTRIBUTED_STRATEGY);
        this.fLargeDataAccessor = new JobLargeDataAccessor(this.getID());
    }

    public JobImpl(long l, int n, String string, TimeProvider timeProvider) {
        super(l, string, timeProvider);
        this.fName = this.getDefaultName();
        this.fJobMLType = n;
        this.setWorkerSortStrategy(DEFAULT_DISTRIBUTED_STRATEGY);
        this.fLargeDataAccessor = new JobLargeDataAccessor(this.getID());
    }

    void setJobStorage(JobStorage jobStorage) {
        this.setWorkUnitStorage(jobStorage);
        this.fStorage = jobStorage;
    }

    protected JobStorage getJobStorage() {
        return this.fStorage;
    }

    void setLargeDataStorage(DataStorage dataStorage) {
        this.fLargeDataStorage = dataStorage;
    }

    void setAppendableDataStorage(DataStorage dataStorage) {
        this.fAppendableDataStorage = dataStorage;
    }

    void setCryptoModule(CryptoModule cryptoModule) {
        this.fCryptoModule = cryptoModule;
    }

    @Override
    public String getTag() {
        return (String)this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return JobImpl.this.fTag;
            }
        });
    }

    @Override
    public String getApiTag() {
        return (String)this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return JobImpl.this.fApiTag;
            }
        });
    }

    @Override
    public Uuid[] getTasks() {
        return (Uuid[])this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return JobImpl.this.fStorage.readTasksByJobID(JobImpl.this.getID());
            }
        });
    }

    @Override
    public Uuid[][] getTasks(final int[] nArray) {
        return (Uuid[][])this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return JobImpl.this.fStorage.readTasksByJobIDAndState(JobImpl.this.getID(), nArray);
            }
        });
    }

    @Override
    public boolean isRestartWorker() {
        return (Boolean)this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return JobImpl.this.fRestartWorker;
            }
        });
    }

    @Override
    public int getMaxWorkers() {
        return (Integer)this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return JobImpl.this.fMaxWorkers;
            }
        });
    }

    @Override
    public int getMinWorkers() {
        return (Integer)this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return JobImpl.this.fMinWorkers;
            }
        });
    }

    @Override
    public byte[] getProductList() {
        return (byte[])this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return JobImpl.this.fProductList;
            }
        });
    }

    byte[] getFileDepData() throws MJSException {
        return (byte[])this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws DataStorageException {
                return JobImpl.this.fLargeDataAccessor.readLargeData(JobImpl.this.fFileDepDataItem, JobImpl.this.fLargeDataStorage);
            }
        });
    }

    public void getFileDepData(final OutputStream outputStream, final int n) throws MJSException {
        this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws DataStorageException {
                JobImpl.this.fLargeDataAccessor.readLargeData(JobImpl.this.fFileDepDataItem, outputStream, JobImpl.this.fLargeDataStorage, n);
                return null;
            }
        });
    }

    public void getJobScopeData(final OutputStream outputStream, final int n) throws MJSException {
        this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws DataStorageException {
                JobImpl.this.fLargeDataAccessor.readLargeData(JobImpl.this.fJobScopeDataItem, outputStream, JobImpl.this.fLargeDataStorage, n);
                return null;
            }
        });
    }

    public byte[] getJobScopeData() throws MJSException {
        return (byte[])this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws DataStorageException {
                return JobImpl.this.fLargeDataAccessor.readLargeData(JobImpl.this.fJobScopeDataItem, JobImpl.this.fLargeDataStorage);
            }
        });
    }

    public int getFileDepDataSize() {
        return (Integer)this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return JobImpl.this.fFileDepDataItem.getNumBytes();
            }
        });
    }

    public int getJobScopeDataSize() {
        return (Integer)this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return JobImpl.this.fJobScopeDataItem.getNumBytes();
            }
        });
    }

    @Override
    public String[] getFileDepPathList() {
        return (String[])this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return JobImpl.this.fFileDepPathList;
            }
        });
    }

    @Override
    public String[] getPathList() {
        return (String[])this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return JobImpl.this.fPathList;
            }
        });
    }

    @Override
    public Date getSubmitTime() {
        return (Date)this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return JobImpl.this.fSubmitTime == -1L ? null : new Date(JobImpl.this.fSubmitTime);
            }
        });
    }

    @Override
    public JobInfo getWorkUnitInfo() {
        return (JobInfo)this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                Uuid[] uuidArray = JobImpl.this.fStorage.readTasksByJobID(JobImpl.this.getID());
                return new JobInfo(JobImpl.this.fName, JobImpl.this.fTimeout, JobImpl.this.fTag, JobImpl.this.fNum, JobImpl.this.fState, JobImpl.this.fCreateTime, JobImpl.this.fSubmitTime, JobImpl.this.fStartTime, JobImpl.this.fFinishTime, JobImpl.this.getRunningDuration(), JobImpl.this.fMaxWorkers, JobImpl.this.fMinWorkers, JobImpl.this.fRestartWorker, JobImpl.this.fFileDepPathList, JobImpl.this.fPathList, JobImpl.this.getWorkUnitUserName(), JobImpl.this.fProductList, uuidArray, JobImpl.this.fJobMLType, JobImpl.this.fMATLABExecutionMode, JobImpl.getListenerInfosFromMap(JobImpl.this.fListenerInfoToNumEvents));
            }
        });
    }

    @Override
    public int getMATLABExecutionMode() {
        return (Integer)this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return JobImpl.this.fMATLABExecutionMode;
            }
        });
    }

    @Override
    public void setAuthorisedUsers(final String[] stringArray) {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                JobImpl.this.setWorkUnitAuthorisedUsers(stringArray);
                JobImpl.this.setAuthorisedUsersOfAllTasks(stringArray);
                return null;
            }
        });
    }

    private void setAuthorisedUsersOfAllTasks(String[] stringArray) {
        Uuid[] uuidArray;
        for (Uuid uuid : uuidArray = this.fStorage.readTasksByJobID(this.getID())) {
            try {
                TaskImpl taskImpl = (TaskImpl)this.fStorage.readWorkUnit(uuid);
                taskImpl.setAuthorisedUsers(stringArray);
            }
            catch (WorkUnitNotFoundException workUnitNotFoundException) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unexpected problem while changing a job's authorized users: one of its tasks could not be retrieved from the database.");
            }
        }
    }

    @Override
    public void setUserName(final String string) {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                if (string != null) {
                    JobImpl.this.setWorkUnitUserName(string);
                    JobImpl.this.setUserNameOfAllTasks(string);
                }
                return null;
            }
        });
    }

    private void setUserNameOfAllTasks(String string) {
        Uuid[] uuidArray;
        for (Uuid uuid : uuidArray = this.fStorage.readTasksByJobID(this.getID())) {
            try {
                TaskImpl taskImpl = (TaskImpl)this.fStorage.readWorkUnit(uuid);
                taskImpl.setUserName(string);
            }
            catch (WorkUnitNotFoundException workUnitNotFoundException) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unexpected problem while changing a job's user name: one of its tasks could not be retrieved from the database.");
            }
        }
    }

    @Override
    public void setTag(final String string) {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                JobImpl.this.fTag = string;
                return null;
            }
        });
    }

    @Override
    public void setApiTag(final String string) {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                JobImpl.this.fApiTag = string;
                return null;
            }
        });
    }

    @Override
    public void setRestartWorker(final boolean bl) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws WorkUnitStateException {
                JobImpl.this.checkStateBeforeSet("RestartWorker");
                JobImpl.this.fRestartWorker = bl;
                return null;
            }
        });
    }

    @Override
    public void setMaxWorkers(final int n) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws WorkUnitStateException {
                JobImpl.this.checkStateBeforeSet("MaximumNumberOfWorkers");
                JobImpl.this.fMaxWorkers = n;
                return null;
            }
        });
    }

    @Override
    public void setMinWorkers(final int n) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws WorkUnitStateException {
                JobImpl.this.checkStateBeforeSet("MinimumNumberOfWorkers");
                JobImpl.this.fMinWorkers = n;
                return null;
            }
        });
    }

    @Override
    public void setProductList(final byte[] byArray) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws WorkUnitStateException {
                JobImpl.this.checkStateBeforeSet("ProductList");
                JobImpl.access$402(JobImpl.this, byArray);
                return null;
            }
        });
    }

    void setFileDepDataItem(final TransferableData transferableData) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws MJSException {
                JobImpl.this.checkStateBeforeSet("FileDependencies");
                JobImpl.this.fFileDepDataItem = JobImpl.this.fLargeDataAccessor.writeLargeData(JobImpl.this.fFileDepDataItem, transferableData, JobImpl.this.fLargeDataStorage);
                return null;
            }
        });
    }

    void setJobScopeDataItem(final TransferableData transferableData) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws MJSException {
                JobImpl.this.checkStateBeforeSet("JobData");
                JobImpl.this.fJobScopeDataItem = JobImpl.this.fLargeDataAccessor.writeLargeData(JobImpl.this.fJobScopeDataItem, transferableData, JobImpl.this.fLargeDataStorage);
                return null;
            }
        });
    }

    @Override
    public void setFileDepPathList(final String[] stringArray) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws WorkUnitStateException {
                JobImpl.this.checkStateBeforeSet("FileDependenciesPathList");
                JobImpl.access$902(JobImpl.this, stringArray);
                return null;
            }
        });
    }

    @Override
    public void setPathList(final String[] stringArray) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws WorkUnitStateException {
                JobImpl.this.checkStateBeforeSet("PathList");
                JobImpl.access$1002(JobImpl.this, stringArray);
                return null;
            }
        });
    }

    @Override
    public void setWorkUnitInfoSmallItems(WorkUnitInfo workUnitInfo) throws MJSException {
        final JobInfo jobInfo = (JobInfo)workUnitInfo;
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws WorkUnitStateException {
                JobImpl.this.fTag = jobInfo.getTag();
                JobImpl.this.checkStateBeforeSet("JobInfo");
                JobImpl.this.doSetName(jobInfo.getName());
                JobImpl.this.fTimeout = jobInfo.getTimeout();
                JobImpl.this.setWorkUnitUserName(jobInfo.getUserName());
                JobImpl.this.fMaxWorkers = jobInfo.getMaxWorkers();
                JobImpl.this.fMinWorkers = jobInfo.getMinWorkers();
                JobImpl.this.fRestartWorker = jobInfo.isRestartWorker();
                JobImpl.this.fMATLABExecutionMode = jobInfo.getMATLABExecutionMode();
                JobImpl.access$902(JobImpl.this, jobInfo.getFileDepPathList());
                JobImpl.access$402(JobImpl.this, jobInfo.getProductList());
                JobImpl.access$1002(JobImpl.this, jobInfo.getPathList());
                JobImpl.this.fListenerInfoToNumEvents = JobImpl.createListenerInfosMap(jobInfo.getListenerInfo());
                return null;
            }
        });
    }

    @Override
    public void setWorkUnitInfo(WorkUnitInfo workUnitInfo) throws MJSException {
        final JobInfo jobInfo = (JobInfo)workUnitInfo;
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws MJSException {
                block2: {
                    JobImpl.this.fTag = jobInfo.getTag();
                    JobImpl.this.checkStateBeforeSet("JobInfo");
                    JobImpl.this.doSetName(jobInfo.getName());
                    JobImpl.this.fTimeout = jobInfo.getTimeout();
                    JobImpl.this.setWorkUnitUserName(jobInfo.getUserName());
                    JobImpl.this.fMaxWorkers = jobInfo.getMaxWorkers();
                    JobImpl.this.fMinWorkers = jobInfo.getMinWorkers();
                    JobImpl.this.fRestartWorker = jobInfo.isRestartWorker();
                    JobImpl.this.fMATLABExecutionMode = jobInfo.getMATLABExecutionMode();
                    JobImpl.access$902(JobImpl.this, jobInfo.getFileDepPathList());
                    JobImpl.access$402(JobImpl.this, jobInfo.getProductList());
                    JobImpl.access$1002(JobImpl.this, jobInfo.getPathList());
                    JobImpl.this.fFileDepDataItem = JobImpl.this.fLargeDataAccessor.writeLargeData(JobImpl.this.fFileDepDataItem, (TransferableData)jobInfo.getFileDepData(), JobImpl.this.fLargeDataStorage);
                    JobImpl.this.fJobScopeDataItem = JobImpl.this.fLargeDataAccessor.writeLargeData(JobImpl.this.fJobScopeDataItem, (TransferableData)jobInfo.getJobScopeData(), JobImpl.this.fLargeDataStorage);
                    JobImpl.this.fListenerInfoToNumEvents = JobImpl.createListenerInfosMap(jobInfo.getListenerInfo());
                    try {
                        NontransferableCredentials nontransferableCredentials = jobInfo.getCredentials(JobImpl.this.fCryptoModule);
                        JobImpl.this.fCredentials = nontransferableCredentials.prepare(true, sSalt, JobImpl.this.fCryptoModule.getEncryptor());
                    }
                    catch (CredentialTransferException credentialTransferException) {
                        if (credentialTransferException.getCause() instanceof NoCredentialsException) break block2;
                        throw credentialTransferException;
                    }
                }
                return null;
            }
        });
    }

    @Override
    public Uuid createTask(TaskInfo taskInfo) throws MJSException {
        Uuid uuid = this.createTaskAndSetInfo(taskInfo);
        this.notifyJobRunnerOfNewTask();
        return uuid;
    }

    @Override
    public void submit(final Uuid[] uuidArray) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws JobStateException {
                if (JobImpl.this.fState != 0) {
                    throw new JobStateException("Only pending jobs may be submitted to the job queue");
                }
                JobImpl.access$2402(JobImpl.this, uuidArray);
                JobImpl.this.addToJobQueue();
                return null;
            }
        });
        JobRunner.instance().runAvailableTasks();
    }

    @Override
    public void setMATLABExecutionMode(final int n) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws WorkUnitStateException {
                JobImpl.this.checkStateBeforeSet("Interactive");
                JobImpl.this.fMATLABExecutionMode = n;
                return null;
            }
        });
    }

    @Override
    public void cancel(final String string) {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                if (JobImpl.this.fState != 3) {
                    Uuid[] uuidArray;
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, JobImpl.this.workUnitTypeForPrinting() + " " + JobImpl.this.fNum + " cancellation has begun");
                    for (Uuid uuid : uuidArray = JobImpl.this.fStorage.readTasksByJobIDAndBeforeState(JobImpl.this.getID(), 3)) {
                        try {
                            TaskImpl taskImpl = (TaskImpl)JobImpl.this.fStorage.readWorkUnit(uuid);
                            boolean bl = true;
                            taskImpl.cancelWithoutNotifyingJob(string, bl);
                        }
                        catch (WorkUnitNotFoundException workUnitNotFoundException) {
                            // empty catch block
                        }
                    }
                    JobImpl.this.finishJob();
                }
                return null;
            }
        });
    }

    @Override
    public void destroy() {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoStorageUpdateNoException(){

            @Override
            public Object invoke() {
                JobImpl.this.cancel("The job was destroyed");
                try {
                    JobImpl.this.fLargeDataStorage.removeDataForJobAndTasks(JobImpl.this.getID());
                }
                catch (DataStorageException dataStorageException) {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Failed to delete large data for job: " + JobImpl.this.fNum, dataStorageException);
                }
                try {
                    JobImpl.this.fAppendableDataStorage.removeDataForJobAndTasks(JobImpl.this.getID());
                }
                catch (DataStorageException dataStorageException) {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Failed to delete appendable data for job: " + JobImpl.this.fNum, dataStorageException);
                }
                JobImpl.this.fStorage.removeJob(JobImpl.this.getID());
                PackageInfo.LOGGER.log(DistcompLevel.ONE, JobImpl.this.workUnitTypeForPrinting() + " " + JobImpl.this.fNum + " has been destroyed");
                return null;
            }
        });
    }

    public long getQueueNum() {
        return (Long)this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return JobImpl.this.fQueueNum;
            }
        });
    }

    public void setQueueNum(final long l) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws JobStateException {
                if (JobImpl.this.fState != 1) {
                    throw new JobStateException("The job is not in the queued state");
                }
                if (l == Long.MAX_VALUE || l == Long.MIN_VALUE) {
                    throw new JobStateException("The new queue number is invalid");
                }
                JobImpl.this.fQueueNum = l;
                return null;
            }
        });
    }

    public Worker[] checkConstraintsAndRunJob(final Worker[][] workerArray) throws MJSException {
        return (Worker[])this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws JobStateException {
                if (JobImpl.this.fState != 1 && JobImpl.this.fState != 2) {
                    throw new JobStateException("cannot run job");
                }
                if (JobImpl.this.fMinWorkers > JobImpl.this.fMaxWorkers) {
                    JobImpl.this.cancelJobBeforeRunning("The job was cancelled because the MinimumNumberOfWorkers property was set to " + JobImpl.this.fMinWorkers + ",\nwhich was smaller than the value of the MaximumNumberOfWorkers property, " + JobImpl.this.fMaxWorkers + ".");
                }
                if (JobImpl.this.fMaxWorkers == 0) {
                    JobImpl.this.cancelJobBeforeRunning("The job was cancelled because the MaximumNumberOfWorkers property was set to 0.");
                }
                JobImpl.this.checkNumTasksBeforeRunning();
                Worker[][] workerArray3 = JobImpl.this.selectFromWorkersToUse(workerArray);
                JobImpl.this.checkTotalNumberOfWorkers(workerArray3);
                Worker[] workerArray2 = JobImpl.this.chooseIdleWorkersForQueuedJob(workerArray3);
                if (JobImpl.this.fState == 1 && workerArray2 != null) {
                    JobImpl.this.removeFromJobQueue();
                    JobImpl.this.startJobRunning();
                }
                return workerArray2;
            }
        });
    }

    public Worker[] checkConstraintsOnRunningJob(final Worker[][] workerArray) {
        return (Worker[])this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                Worker[][] workerArray2 = JobImpl.this.selectFromWorkersToUse(workerArray);
                return JobImpl.this.chooseIdleWorkersForRunningJob(workerArray2);
            }
        });
    }

    public int getJobMLType() {
        return (Integer)this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                return JobImpl.this.fJobMLType;
            }
        });
    }

    @Override
    public String workUnitTypeForPrinting() {
        return "job";
    }

    public TaskDispatcher getTaskDispatcherToUse() {
        return TaskDispatcherForJobs.instance();
    }

    protected void taskCompleted(TaskImpl taskImpl) {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoStorageUpdateNoException(){

            @Override
            public Object invoke() {
                int n;
                if (JobImpl.this.fState == 2 && (n = JobImpl.this.fStorage.countTasksByJobIDAndBeforeState(JobImpl.this.getID(), 3)) == 0) {
                    JobImpl.this.finishJobAndUpdateStorage();
                }
                return null;
            }
        });
    }

    protected Uuid createTaskAndSetInfo(final TaskInfo taskInfo) throws MJSException {
        return (Uuid)this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws MJSException {
                if (JobImpl.this.fState == 3) {
                    throw new JobStateException("A task cannot be created because the job has finished");
                }
                long l = JobImpl.this.fTaskSequenceNum;
                Uuid uuid = JobImpl.this.createTaskInStorage();
                JobImpl.this.setInfoOfCreatedTask(uuid, taskInfo);
                JobImpl.this.setUsersOfCreatedTask(uuid);
                PackageInfo.LOGGER.log(DistcompLevel.TWO, "task " + l + " of " + JobImpl.this.workUnitTypeForPrinting() + " " + JobImpl.this.fNum + " has been created");
                return uuid;
            }
        });
    }

    protected void checkNumTasksBeforeRunning() throws JobStateException {
        int n = this.fStorage.countTasksByJobIDAndState(this.getID(), 0);
        if (n < 1) {
            this.cancelJobBeforeRunning("The job was cancelled because there were no tasks.");
        }
    }

    public int getMinimumTasksToDispatch() throws JobStateException {
        int n = this.fStorage.countTasksByJobID(this.getID());
        return Math.min(this.getMinWorkers(), n);
    }

    protected void cancelJobBeforeRunning(String string) throws JobStateException {
        this.cancel(string);
        throw new JobStateException("The job was cancelled before it could be run: " + string);
    }

    protected void checkTotalNumberOfWorkers(Worker[][] workerArray) throws JobStateException {
        int n = workerArray[0].length;
        int n2 = workerArray[1].length;
        int n3 = n + n2;
        if (this.fMinWorkers > n3) {
            this.cancelJobBeforeRunning("The job was cancelled because the cluster does not have enough workers to meet the minimum of the job's NumWorkersRange property ([" + this.fMinWorkers + " " + this.fMaxWorkers + "]).");
        }
    }

    protected Worker[] chooseIdleWorkersForQueuedJob(Worker[][] workerArray) {
        Worker[] workerArray2 = workerArray[0];
        if (workerArray2.length < this.fMinWorkers) {
            return null;
        }
        return workerArray2;
    }

    protected Worker[] chooseIdleWorkersForRunningJob(Worker[][] workerArray) {
        Worker[] workerArray2 = workerArray[0];
        if (workerArray2.length == 0) {
            return null;
        }
        return workerArray2;
    }

    protected void setWorkerSortStrategy(WorkerSortStrategy workerSortStrategy) {
        this.fWorkerSortStrategy = workerSortStrategy;
    }

    public void sortWorkers(Worker[] workerArray) {
        this.fWorkerSortStrategy.sort(workerArray);
    }

    @Override
    protected String getDefaultName() {
        return "Job" + this.fNum;
    }

    private void setInfoOfCreatedTask(Uuid uuid, TaskInfo taskInfo) throws MJSException {
        try {
            TaskImpl taskImpl = (TaskImpl)this.fStorage.readWorkUnit(uuid);
            taskImpl.setWorkUnitInfo(taskInfo);
        }
        catch (WorkUnitNotFoundException workUnitNotFoundException) {
            throw new TaskStateException("The task state cannot be set because it has been destroyed");
        }
    }

    private void setUsersOfCreatedTask(Uuid uuid) throws MJSException {
        TaskImpl taskImpl = (TaskImpl)this.fStorage.readWorkUnit(uuid);
        taskImpl.setAuthorisedUsers(this.getAuthorisedUsers());
    }

    private Worker[][] selectFromWorkersToUse(Worker[][] workerArray) {
        Worker[][] workerArray2;
        if (this.fWorkersToUse != null && this.fWorkersToUse.length > 0) {
            workerArray2 = new Worker[2][];
            Worker[] workerArray3 = workerArray[0];
            Worker[] workerArray4 = workerArray[1];
            workerArray2[0] = this.selectFromWorkersToUse(workerArray3);
            workerArray2[1] = this.selectFromWorkersToUse(workerArray4);
        } else {
            workerArray2 = workerArray;
        }
        return workerArray2;
    }

    private Worker[] selectFromWorkersToUse(Worker[] workerArray) {
        ArrayList<Uuid> arrayList = new ArrayList<Uuid>();
        arrayList.addAll(Arrays.asList(this.fWorkersToUse));
        ArrayList<WorkerProxy> arrayList2 = new ArrayList<WorkerProxy>();
        for (Worker worker : workerArray) {
            WorkerProxy workerProxy = (WorkerProxy)worker;
            if (!arrayList.contains(workerProxy.getID())) continue;
            arrayList2.add(workerProxy);
        }
        return arrayList2.toArray(new Worker[arrayList2.size()]);
    }

    private void addToJobQueue() {
        this.switchToQueuedState();
        this.fQueueNum = this.fStorage.nextJobQueueNum();
        JobCounter.instance().incQueuedJobs();
    }

    private void removeFromJobQueue() {
        this.fQueueNum = Long.MIN_VALUE;
        JobCounter.instance().decQueuedJobs();
    }

    private void startJobRunning() {
        this.switchToRunningState();
        WorkUnitTimeoutChecker.instance().addWorkUnit(this.getID(), this.fTimeout);
        JobCounter.instance().incRunningJobs();
        PackageInfo.LOGGER.log(DistcompLevel.ONE, this.workUnitTypeForPrinting() + " " + this.fNum + " has started running");
    }

    private void stopJobRunning() {
        WorkUnitTimeoutChecker.instance().removeWorkUnit(this.getID());
        JobCounter.instance().decRunningJobs();
    }

    private void finishJobAndUpdateStorage() {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                JobImpl.this.finishJob();
                return null;
            }
        });
    }

    private void finishJob() {
        if (this.fState == 1) {
            this.removeFromJobQueue();
        }
        if (this.fState == 2) {
            this.stopJobRunning();
        }
        this.switchToFinishedState();
        PackageInfo.LOGGER.log(DistcompLevel.ONE, this.workUnitTypeForPrinting() + " " + this.fNum + " has finished");
    }

    private void switchToQueuedState() {
        this.fState = 1;
        this.fSubmitTime = System.currentTimeMillis();
        this.recordEvent(1L);
        PackageInfo.LOGGER.log(DistcompLevel.ONE, this.workUnitTypeForPrinting() + " " + this.fNum + " has been queued");
    }

    protected void notifyJobRunnerOfNewTask() {
        int n = this.getState();
        if (n == 2) {
            JobRunner.instance().runAvailableTasks();
        }
    }

    private Uuid createTaskInStorage() {
        return this.fStorage.putTask(new TaskImpl(this.nextTaskSequenceNum(), this.getID(), this.getWorkUnitUserName()));
    }

    protected long nextTaskSequenceNum() {
        long l = this.fTaskSequenceNum++;
        return l;
    }

    @Override
    public void rerunOrCancel(String string) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "rerun: " + this.workUnitTypeForPrinting() + " " + this.fNum + " is being rerun or cancelled");
        try {
            Collection<WorkerTaskInfo> collection = this.rerunJob(string);
            for (WorkerTaskInfo workerTaskInfo : collection) {
                WorkerPool.instance().removeTaskFromWorker(workerTaskInfo);
            }
        }
        catch (AlreadyRerunningException alreadyRerunningException) {
        }
        catch (NoRerunsLeftException noRerunsLeftException) {
            this.cancel("Cannot rerun job because at least one of its tasks has no rerun attempts left (" + noRerunsLeftException.getMessage() + ").\n" + "Original cancel message:\n" + string + "\n");
        }
        catch (WorkUnitStateException workUnitStateException) {
            this.cancel("Cannot rerun job because it is in a wrong state (" + workUnitStateException.getMessage() + ").\nOriginal cancel message:\n" + string + "\n");
        }
        catch (MJSException mJSException) {
            this.cancel("Cannot rerun job (" + mJSException.getMessage() + ").\n" + "Original cancel message:\n" + string + "\n");
        }
    }

    protected Collection<WorkerTaskInfo> rerunTask(TaskImpl taskImpl, String string) throws MJSException {
        return this.rerunTask(taskImpl, string, true);
    }

    private Collection<WorkerTaskInfo> castToCollectionOfWorkerTaskinfos(Object object) {
        return (Collection)object;
    }

    private Collection<WorkerTaskInfo> rerunTask(final TaskImpl taskImpl, final String string, final boolean bl) throws MJSException {
        return this.castToCollectionOfWorkerTaskinfos(this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws WorkUnitStateException {
                taskImpl.checkTaskCanRerun();
                if (bl && JobImpl.this.fState != 2) {
                    throw new WorkUnitStateException(JobImpl.this.workUnitTypeForPrinting() + " is not in running state");
                }
                ArrayList<WorkerTaskInfo> arrayList = new ArrayList<WorkerTaskInfo>();
                arrayList.add(taskImpl.getWorkerTaskInfo());
                if (taskImpl.getState() == 2) {
                    taskImpl.setErrorIdentifier("distcomp:task:Cancelled");
                    taskImpl.setErrorMessage(string);
                }
                taskImpl.prepareToRerun();
                return arrayList;
            }
        }));
    }

    protected final Collection<WorkerTaskInfo> rerunJob(final String string) throws MJSException {
        return this.castToCollectionOfWorkerTaskinfos(this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws MJSException {
                Collection collection;
                JobImpl.this.checkJobCanRerun();
                JobImpl.this.switchJobFromRunningToPending();
                try {
                    collection = JobImpl.this.prepareAllTasksToRerun(string);
                }
                catch (WorkUnitStateException workUnitStateException) {
                    JobImpl.this.cancel("one of the tasks failed to rerun (" + workUnitStateException.getMessage() + ")");
                    return new ArrayList();
                }
                JobImpl.this.prepareToRerun();
                return collection;
            }
        }));
    }

    protected void checkJobCanRerun() throws WorkUnitStateException {
        if (this.fState <= 1) {
            throw new AlreadyRerunningException(this.workUnitTypeForPrinting() + " is already (or still) queued");
        }
        if (this.fState != 2) {
            throw new WorkUnitStateException(this.workUnitTypeForPrinting() + " is not in running state");
        }
    }

    private void switchJobFromRunningToPending() {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                JobImpl.this.stopJobRunning();
                JobImpl.this.setWorkUnitToPending();
                return null;
            }
        });
    }

    private Collection<WorkerTaskInfo> prepareAllTasksToRerun(String string) throws MJSException {
        ArrayList<WorkerTaskInfo> arrayList = new ArrayList<WorkerTaskInfo>();
        for (Uuid uuid : this.getTasks()) {
            TaskImpl taskImpl;
            try {
                taskImpl = (TaskImpl)this.fStorage.readWorkUnit(uuid);
            }
            catch (WorkUnitNotFoundException workUnitNotFoundException) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "rerun: a task of the rerunning " + this.workUnitTypeForPrinting() + " has been " + "destroyed (thus, it will not rerun)");
                continue;
            }
            arrayList.addAll(this.prepareTaskToRerun(taskImpl, string));
        }
        return arrayList;
    }

    protected Collection<WorkerTaskInfo> prepareTaskToRerun(TaskImpl taskImpl, String string) throws MJSException {
        try {
            return this.rerunTask(taskImpl, string, false);
        }
        catch (AlreadyRerunningException alreadyRerunningException) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "rerun: task " + taskImpl.getNum() + " is already being rerun");
            return new ArrayList<WorkerTaskInfo>();
        }
    }

    protected void prepareToRerun() {
        this.addToJobQueueForRerun();
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "rerun: " + this.workUnitTypeForPrinting() + " " + this.fNum + " has been successfully prepared to rerun");
    }

    private void addToJobQueueForRerun() {
        this.switchToQueuedStateForRerun();
        this.fQueueNum = this.fStorage.nextJobQueueNum();
        JobCounter.instance().incQueuedJobs();
    }

    private void switchToQueuedStateForRerun() {
        this.fState = 1;
        this.fSubmitTime = System.currentTimeMillis();
        PackageInfo.LOGGER.log(DistcompLevel.ONE, this.workUnitTypeForPrinting() + " " + this.fNum + " has been re-queued");
    }

    protected void resetTaskSequenceNum() {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException(){

            @Override
            public Object invoke() {
                JobImpl.this.fTaskSequenceNum = 2L;
                return null;
            }
        });
    }

    public NontransferableCredentials getCredentials() throws MJSException {
        return (NontransferableCredentials)this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation(){

            @Override
            public Object invoke() throws MJSException {
                if (JobImpl.this.fCredentials != null) {
                    return JobImpl.this.fCredentials.unpack(sSalt, JobImpl.this.fCryptoModule.getDecryptor());
                }
                return null;
            }
        });
    }

    static /* synthetic */ byte[] access$402(JobImpl jobImpl, byte[] byArray) {
        jobImpl.fProductList = byArray;
        return byArray;
    }

    static /* synthetic */ String[] access$902(JobImpl jobImpl, String[] stringArray) {
        jobImpl.fFileDepPathList = stringArray;
        return stringArray;
    }

    static /* synthetic */ String[] access$1002(JobImpl jobImpl, String[] stringArray) {
        jobImpl.fPathList = stringArray;
        return stringArray;
    }

    static /* synthetic */ Uuid[] access$2402(JobImpl jobImpl, Uuid[] uuidArray) {
        jobImpl.fWorkersToUse = uuidArray;
        return uuidArray;
    }
}

