/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.worker.matlab;

import com.mathworks.toolbox.distcomp.auth.SecurityModuleProvider;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialRole;
import com.mathworks.toolbox.distcomp.auth.credentials.EncryptedUserCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.PlainCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.WebLicenseCredentials;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerProxy;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.logging.SocketLogRecordReceiver;
import com.mathworks.toolbox.distcomp.process.CommandLine;
import com.mathworks.toolbox.distcomp.process.InvalidUserOrPasswordException;
import com.mathworks.toolbox.distcomp.util.NullOutputStream;
import com.mathworks.toolbox.distcomp.util.concurrent.ReentrantLock;
import com.mathworks.toolbox.distcomp.worker.InvalidCredentialsException;
import com.mathworks.toolbox.distcomp.worker.MatlabFailedToStartException;
import com.mathworks.toolbox.distcomp.worker.PersistentWorkerConfiguration;
import com.mathworks.toolbox.distcomp.worker.TaskEvaluator;
import com.mathworks.toolbox.distcomp.worker.TaskExecutionException;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.worker.WorkerImpl;
import com.mathworks.toolbox.distcomp.worker.WorkerProxy;
import com.mathworks.toolbox.distcomp.worker.matlab.CanEvaluateTask;
import com.mathworks.toolbox.distcomp.worker.matlab.CommandLineBuilder;
import com.mathworks.toolbox.distcomp.worker.matlab.CommandLineDecorator;
import com.mathworks.toolbox.distcomp.worker.matlab.FevalCompleteCallback;
import com.mathworks.toolbox.distcomp.worker.matlab.FevalProvider;
import com.mathworks.toolbox.distcomp.worker.matlab.ImmediateShutdownInitiator;
import com.mathworks.toolbox.distcomp.worker.matlab.MatlabCommandLineBuilder;
import com.mathworks.toolbox.distcomp.worker.matlab.MatlabLicenseErrorException;
import com.mathworks.toolbox.distcomp.worker.matlab.MatlabPrefAndLogDirectories;
import com.mathworks.toolbox.distcomp.worker.matlab.MatlabRunAsUserCommandLineDecorator;
import com.mathworks.toolbox.distcomp.worker.matlab.MatlabShutdownInitiator;
import com.mathworks.toolbox.distcomp.worker.matlab.MatlabTaskEvaluatorErrorCode;
import com.mathworks.toolbox.distcomp.worker.matlab.NativeIpcCommandLineDecorator;
import com.mathworks.toolbox.distcomp.worker.matlab.NativeIpcFevalProvider;
import com.mathworks.toolbox.distcomp.worker.matlab.NativeIpcPinger;
import com.mathworks.toolbox.distcomp.worker.matlab.PackageInfo;
import com.mathworks.toolbox.distcomp.worker.matlab.ProcessEndedListener;
import com.mathworks.toolbox.distcomp.worker.matlab.ProcessShepherd;
import com.mathworks.toolbox.distcomp.worker.matlab.ProcessShepherdImpl;
import com.mathworks.toolbox.distcomp.worker.matlab.ProcessTimeoutException;
import com.mathworks.toolbox.distcomp.worker.matlab.ScheduledShutdownInitiator;
import com.mathworks.toolbox.distcomp.worker.matlab.TaskCancellingFevalErrorHandler;
import com.mathworks.toolbox.distcomp.worker.matlab.TaskLicenseErrorException;
import com.mathworks.toolbox.distcomp.worker.matlab.WebLicensingCommandLineDecorator;
import com.mathworks.toolbox.distcomp.worker.matlab.WindowsFileAcl;
import com.mathworks.toolbox.distcomp.worker.matlab.WorkerLicenseErrorException;
import com.mathworks.toolbox.distcomp.worker.matlab.errors.ErrorCatcherFuture;
import com.mathworks.toolbox.distcomp.worker.matlab.errors.MatlabLicenseErrorCatcher;
import com.mathworks.toolbox.distcomp.workunit.JobAndTaskIdentifier;
import com.mathworks.util.PlatformInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.rmi.RemoteException;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.logging.Handler;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.TeeOutputStream;

public class MatlabTaskEvaluator
implements TaskEvaluator,
ProcessEndedListener {
    private static final int MATLAB_EXIT_TIMEOUT_SECS = 5;
    private static final Pattern START_PATTERN = Pattern.compile("=+BEGIN LICENSE MANAGER ERROR=+");
    private static final Pattern END_PATTERN = Pattern.compile("=+END LICENSE MANAGER ERROR=+");
    private final ProcessShepherd fMatlabShepherd;
    private final FevalProvider fFevalProvider;
    private final Worker fWorker;
    private final PersistentWorkerConfiguration fWorkerConfig;
    private final String fBaseIpcAddress = "MathWorks." + UUID.randomUUID().toString();
    private AtomicBoolean fMatlabJustStarted = new AtomicBoolean(false);
    private final CanEvaluateTask fCanEvaluateTask = new CanEvaluateTask();
    private AtomicBoolean fHandleErrors = new AtomicBoolean(false);
    private int fMatlabLogPort = -1;
    private OutputStream fMatlabOutputStream = null;
    private static final UserIdentity MDCE_USER_IDENTITY = new UserIdentity("the MDCE user");
    private static final UserCredentials MDCE_USER_CREDENTIALS = new UserCredentials(MDCE_USER_IDENTITY);
    private UserIdentity fCurrentUserIdentity = MDCE_USER_IDENTITY;
    private MatlabPrefAndLogDirectories fMatlabPrefAndLogDirectories;
    private final Certificate fCertificate;
    private MatlabShutdownInitiator fMatlabShutdownInitiator = null;
    private CommandLine fCurrentCommandLine = null;
    private Lock fMatlabStartLock = new ReentrantLock();
    private CommandLineBuilder fCommandLineBuilder = null;
    private ExecutorService fErrorCatcherExecutor;
    private ErrorCatcherFuture fCaughtError = null;

    public MatlabTaskEvaluator(ProcessShepherd processShepherd, FevalProvider fevalProvider, PersistentWorkerConfiguration persistentWorkerConfiguration) throws IOException, MatlabFailedToStartException {
        this(processShepherd, fevalProvider, null, persistentWorkerConfiguration);
    }

    public MatlabTaskEvaluator(ProcessShepherd processShepherd, FevalProvider fevalProvider, Worker worker, PersistentWorkerConfiguration persistentWorkerConfiguration) throws IOException, MatlabFailedToStartException {
        this.fMatlabShepherd = processShepherd;
        this.fFevalProvider = fevalProvider;
        this.fWorker = worker;
        this.fWorkerConfig = persistentWorkerConfiguration;
        this.fMatlabOutputStream = new NullOutputStream();
        this.fErrorCatcherExecutor = Executors.newSingleThreadExecutor();
        File file = this.fWorkerConfig.getTaskRootDirectory();
        this.fMatlabPrefAndLogDirectories = new MatlabPrefAndLogDirectories(file);
        this.fCertificate = null;
        this.fCommandLineBuilder = new MatlabCommandLineBuilder(this.fWorkerConfig, this.fMatlabPrefAndLogDirectories, this.fMatlabLogPort, this.fCertificate);
        this.fMatlabShutdownInitiator = !persistentWorkerConfiguration.getUseMatlabOnDemand() ? new ImmediateShutdownInitiator(this.fMatlabShepherd) : new ScheduledShutdownInitiator(this.fMatlabShepherd);
    }

    public MatlabTaskEvaluator(WorkerImpl workerImpl, PersistentWorkerConfiguration persistentWorkerConfiguration) throws MatlabFailedToStartException, WorkerLicenseErrorException, IOException, InvalidUserOrPasswordException, InterruptedException {
        NativeIpcPinger nativeIpcPinger = new NativeIpcPinger(this);
        MatlabTaskEvaluator matlabTaskEvaluator = this;
        this.fMatlabShepherd = new ProcessShepherdImpl(nativeIpcPinger, matlabTaskEvaluator);
        this.fFevalProvider = new NativeIpcFevalProvider(this);
        this.fWorker = workerImpl;
        this.fWorkerConfig = persistentWorkerConfiguration;
        this.fMatlabLogPort = this.startMatlabLogRedirection(this.fWorkerConfig.getMatlabHandler());
        this.fErrorCatcherExecutor = Executors.newSingleThreadExecutor();
        File file = this.fWorkerConfig.getTaskRootDirectory();
        this.fMatlabPrefAndLogDirectories = new MatlabPrefAndLogDirectories(file);
        this.fMatlabPrefAndLogDirectories.makeDirectories();
        if (this.isRunAsUser()) {
            this.setDirectoryPermissionsForRunAsUser();
        }
        this.fCertificate = workerImpl.getSharedSecretCertificate();
        this.fCommandLineBuilder = new MatlabCommandLineBuilder(this.fWorkerConfig, this.fMatlabPrefAndLogDirectories, this.fMatlabLogPort, this.fCertificate);
        if (this.fWorkerConfig.getUseMatlabOnDemand()) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Using MATLAB on-demand");
            this.fMatlabShutdownInitiator = new ScheduledShutdownInitiator(this.fMatlabShepherd);
        } else if (this.fWorkerConfig.requireWebLicensing()) {
            this.fMatlabShutdownInitiator = new ImmediateShutdownInitiator(this.fMatlabShepherd);
        } else {
            UserCredentials userCredentials = MDCE_USER_CREDENTIALS;
            CommandLine commandLine = this.makeCommandLine(userCredentials);
            this.fMatlabShutdownInitiator = new ImmediateShutdownInitiator(this.fMatlabShepherd);
            try {
                this.ensureMatlabIsRunning(userCredentials, commandLine);
            }
            catch (MatlabLicenseErrorException matlabLicenseErrorException) {
                String string = "MATLAB failed to start due to a license error";
                throw new WorkerLicenseErrorException(string, matlabLicenseErrorException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluateTask(JobManagerProxy jobManagerProxy, WorkerProxy workerProxy, JobAndTaskIdentifier jobAndTaskIdentifier, int n, boolean bl, boolean bl2, int n2, UserCredentials userCredentials) throws TaskExecutionException {
        EncryptedUserCredentials encryptedUserCredentials;
        assert (this.fFevalProvider != null) : "FevalProvider should not be null";
        assert (this.fMatlabShepherd != null) : "ProcessShepherd should not be null";
        assert (userCredentials.hasCredentialsForRole(CredentialRole.AUTH_TOKEN));
        assert (this.fMatlabShutdownInitiator != null) : "ShutdownInitiator should not be null";
        if (!this.canEvaluateTask()) {
            throw new TaskExecutionException("TaskEvaluator is already evaluating a task.");
        }
        this.fMatlabShutdownInitiator.cancelScheduledShutdown();
        this.fCanEvaluateTask.setCurrentJobAndTask(jobAndTaskIdentifier);
        this.fMatlabStartLock.lock();
        try {
            this.prepareForTaskEvaluation(bl2, userCredentials);
        }
        finally {
            this.fMatlabStartLock.unlock();
        }
        this.enableErrorHandling();
        boolean bl3 = this.hasMatlabJustStarted();
        this.setMatlabJustStarted(false);
        boolean bl4 = bl || bl3;
        try {
            encryptedUserCredentials = userCredentials.prepare(false, null, null);
        }
        catch (CredentialCreationException credentialCreationException) {
            throw new IllegalStateException("Failed to prepare credentials for distcomp_evaluate_task", credentialCreationException);
        }
        TaskCancellingFevalErrorHandler taskCancellingFevalErrorHandler = new TaskCancellingFevalErrorHandler(workerProxy, jobAndTaskIdentifier);
        Object[] objectArray = new Object[]{taskCancellingFevalErrorHandler, jobManagerProxy, workerProxy, jobAndTaskIdentifier, n, bl4, bl3, n2, encryptedUserCredentials};
        TaskFevalCompleteCallback taskFevalCompleteCallback = new TaskFevalCompleteCallback();
        this.fCanEvaluateTask.startTaskFeval();
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Calling distcomp_evaluate_task");
        this.fFevalProvider.asyncfeval("distcomp_evaluate_task", objectArray, taskFevalCompleteCallback);
    }

    private void prepareForTaskEvaluation(boolean bl, UserCredentials userCredentials) throws TaskExecutionException {
        CommandLine commandLine = this.makeCommandLine(userCredentials);
        UserIdentity userIdentity = userCredentials.getUserIdentity();
        if (this.isShutdownRequired(bl, userIdentity, commandLine)) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Restarting MATLAB before task feval");
            this.fMatlabShutdownInitiator.shutdownMatlabNow();
            if (userIdentity != this.getCurrentUserIdentity()) {
                MatlabTaskEvaluator.deleteDirectoryBeforeTaskExecution(this.fWorkerConfig.getWorkerDir());
                MatlabTaskEvaluator.deleteDirectoryBeforeTaskExecution(this.fWorkerConfig.getFileDependencyDir());
                try {
                    this.fMatlabPrefAndLogDirectories.cleanPrefDirectory();
                }
                catch (IOException iOException) {
                    throw new TaskExecutionException("Failed to clean MATLAB_PREFDIR directory", iOException);
                }
            }
        }
        try {
            this.fMatlabPrefAndLogDirectories.cleanLogDirectory();
        }
        catch (IOException iOException) {
            throw new TaskExecutionException("Failed to clean MATLAB_LOG_DIR directory", iOException);
        }
        try {
            this.ensureMatlabIsRunning(userCredentials, commandLine);
        }
        catch (MatlabFailedToStartException matlabFailedToStartException) {
            this.fMatlabShutdownInitiator.shutdownMatlabNow();
            throw new TaskExecutionException(matlabFailedToStartException);
        }
        catch (InvalidUserOrPasswordException invalidUserOrPasswordException) {
            this.fMatlabShutdownInitiator.shutdownMatlabNow();
            String string = userCredentials.getUserIdentity().getSimpleUsername();
            throw new InvalidCredentialsException("Failed to evaluate task as " + string + " because: " + invalidUserOrPasswordException.getMessage() + "\n\n" + "The user name or password you entered does not match the system credentials\n" + "on the cluster machines. To correct this, you can update the Username property\n" + "of the job manager, or use changePassword to change the password to the correct\n" + "system password. For information on this method, type help parallel.cluster.MJS/changePassword");
        }
        catch (MatlabLicenseErrorException matlabLicenseErrorException) {
            this.fMatlabShutdownInitiator.shutdownMatlabNow();
            throw new TaskLicenseErrorException(MatlabTaskEvaluatorErrorCode.MATLAB_LICENSE_ERROR, matlabLicenseErrorException);
        }
    }

    private void setDirectoryPermissionsForRunAsUser() throws IOException {
        MatlabTaskEvaluator.setWorldReadableAndWritable(this.fWorkerConfig.getTaskRootDirectory());
        MatlabTaskEvaluator.setWorldReadableAndWritable(this.fMatlabPrefAndLogDirectories.getLogDirectory());
        MatlabTaskEvaluator.setWorldReadableAndWritable(this.fMatlabPrefAndLogDirectories.getPrefDirectory());
    }

    private boolean isShutdownRequired(boolean bl, UserIdentity userIdentity, CommandLine commandLine) {
        if (!this.hasRunningMatlab()) {
            return false;
        }
        if (!this.getProcessIdentity(userIdentity).equals(this.getCurrentProcessIdentity())) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "MATLAB shutdown required because user changing from " + this.getCurrentUserIdentity() + " to " + userIdentity);
            return true;
        }
        if (bl && !this.hasMatlabJustStarted()) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "MATLAB shutdown required because restartWorker is true.");
            return true;
        }
        if (!commandLine.equals(this.fCurrentCommandLine)) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "MATLAB shutdown required because the command line has changed.");
            return true;
        }
        return false;
    }

    @Override
    public void addCanEvaluateTaskChangedListener(TaskEvaluator.CanEvaluateTaskChangedListener canEvaluateTaskChangedListener) {
        this.fCanEvaluateTask.addCanEvaluateTaskChangedListener(canEvaluateTaskChangedListener);
    }

    @Override
    public void removeCanEvaluateTaskChangedListener(TaskEvaluator.CanEvaluateTaskChangedListener canEvaluateTaskChangedListener) {
        this.fCanEvaluateTask.removeCanEvaluateTaskChangedListener(canEvaluateTaskChangedListener);
    }

    @Override
    public void processEnded(int n) {
        PackageInfo.LOGGER.log(DistcompLevel.ONE, "MATLAB ended with exit value: " + n);
        if (!this.fMatlabShutdownInitiator.isShutdownInProgress()) {
            this.fMatlabShutdownInitiator.cancelScheduledShutdown();
        }
        try {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Closing MATLAB output stream.");
            if (this.fMatlabOutputStream != null) {
                this.fMatlabOutputStream.close();
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "MATLAB output stream closed.");
            }
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.fine("Failed to close the MATLAB output file stream.");
        }
        File file = new File(this.fWorkerConfig.getLogDirectory());
        Set<File> set = this.fMatlabPrefAndLogDirectories.copyCrashDumpFilesTo(file);
        if (!set.isEmpty()) {
            PackageInfo.LOGGER.severe("Copied " + set.size() + " 'matlab_crash_dump' file(s) to " + file + "\n" + "These files indicate that MATLAB exited during task evaluation due to a SEGV.");
            this.handleError(MatlabTaskEvaluatorErrorCode.MATLAB_CRASHED_DURING_TASK, this.getWorkerHostName(), set.toString());
        } else {
            this.handleError(MatlabTaskEvaluatorErrorCode.MATLAB_EXITED_DURING_TASK, n);
        }
    }

    private void handleError(MatlabTaskEvaluatorErrorCode matlabTaskEvaluatorErrorCode, Object ... objectArray) {
        boolean bl = this.disableErrorHandling();
        if (bl) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Calling notifyTaskErrored with error code: " + (Object)((Object)matlabTaskEvaluatorErrorCode) + ", " + Arrays.deepToString(objectArray));
            try {
                String string = matlabTaskEvaluatorErrorCode.formatMessage(objectArray);
                this.fWorker.notifyTaskErrored(this.fCanEvaluateTask.getCurrentJobAndTask(), string);
            }
            catch (RemoteException remoteException) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to call notifyTaskErrored", remoteException);
                throw new RuntimeException(remoteException);
            }
        }
    }

    @Override
    public void taskFinished() {
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "MatlabTaskEvaluator:taskFinished");
        this.disableErrorHandling();
        this.fCanEvaluateTask.setCurrentJobAndTask(new JobAndTaskIdentifier());
        this.fMatlabShutdownInitiator.scheduleMatlabShutdown(this.fWorkerConfig.getIdleKillTimeoutInSeconds());
    }

    @Override
    public void cancelTask(JobAndTaskIdentifier jobAndTaskIdentifier) {
        PackageInfo.LOGGER.log(DistcompLevel.ONE, "Shutting down MATLAB because the task has been cancelled.");
        this.disableErrorHandling();
        this.fMatlabShutdownInitiator.shutdownMatlabNow();
        this.fCanEvaluateTask.setCurrentJobAndTask(new JobAndTaskIdentifier());
    }

    @Override
    public boolean canEvaluateTask() {
        return this.fCanEvaluateTask.canEvaluateTask();
    }

    @Override
    public void startMatlab() throws MatlabFailedToStartException {
        UserCredentials userCredentials = MDCE_USER_CREDENTIALS;
        try {
            CommandLine commandLine = this.makeCommandLine(userCredentials);
            this.startNewMatlab(userCredentials, commandLine);
        }
        catch (IOException iOException) {
            String string = this.getMatlabOutputFile();
            throw new MatlabFailedToStartException("MATLAB failed to start.", iOException, string);
        }
        catch (InvalidUserOrPasswordException invalidUserOrPasswordException) {
            throw new MatlabFailedToStartException("MATLAB failed to start due to invalid user credentials", invalidUserOrPasswordException);
        }
    }

    @Override
    public boolean hasRunningMatlab() {
        return this.isMatlabRunning();
    }

    @Override
    public void dispose() {
        this.fMatlabShutdownInitiator.shutdownMatlabNow();
        this.fErrorCatcherExecutor.shutdownNow();
        try {
            this.fMatlabOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.fMatlabPrefAndLogDirectories.deleteDirectories();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void ensureMatlabIsRunning(UserCredentials userCredentials, CommandLine commandLine) throws MatlabFailedToStartException, InvalidUserOrPasswordException, MatlabLicenseErrorException {
        try {
            this.startNewMatlab(userCredentials, commandLine);
        }
        catch (IOException iOException) {
            String string = this.getMatlabOutputFile();
            String string2 = "IOException during MATLAB start";
            throw new MatlabFailedToStartException(string2, iOException, string);
        }
        long l = this.fWorkerConfig.getMatlabStartupTimeoutMillis();
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        this.waitForProcessToStart(l, timeUnit);
    }

    private void waitForProcessToStart(long l, TimeUnit timeUnit) throws MatlabFailedToStartException, MatlabLicenseErrorException {
        try {
            this.fMatlabShepherd.waitForProcessToStopStarting(l, timeUnit);
            if (!this.isMatlabRunning()) {
                String string = this.fCaughtError.get();
                if (string.length() != 0) {
                    throw new MatlabLicenseErrorException(string);
                }
                String string2 = "MATLAB exited during startup";
                throw new MatlabFailedToStartException(string2, null, this.getMatlabOutputFile());
            }
        }
        catch (ProcessTimeoutException processTimeoutException) {
            String string = "Time out while waiting for MATLAB to start up";
            throw new MatlabFailedToStartException(string, processTimeoutException, this.getMatlabOutputFile());
        }
        catch (InterruptedException interruptedException) {
            String string = "Worker was interrupted while waiting for MATLAB to start.";
            throw new MatlabFailedToStartException(string, interruptedException, this.getMatlabOutputFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewMatlab(UserCredentials userCredentials, CommandLine commandLine) throws IOException, InvalidUserOrPasswordException {
        assert (userCredentials != null) : "Credentials can not be null";
        this.fMatlabStartLock.lock();
        try {
            if (!this.isMatlabShutdown()) {
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "Not starting MATLAB as another process has already started it and it is " + (Object)((Object)this.fMatlabShepherd.getState()));
                return;
            }
            UserIdentity userIdentity = this.getProcessIdentity(userCredentials.getUserIdentity());
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Starting MATLAB as " + userIdentity + " to execute tasks for " + userCredentials.getUserIdentity());
            this.fMatlabOutputStream = this.startNewOutputStream();
            commandLine.redirectErrorStream(true);
            commandLine.redirectOutput(this.fMatlabOutputStream);
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "About to write time stamp to matlab output file");
            this.writeTimeStampToMatlabOutputFile();
            this.fMatlabShepherd.start(commandLine);
            this.fCurrentCommandLine = commandLine;
            this.setCurrentUserIdentity(userCredentials.getUserIdentity());
            this.setMatlabJustStarted(true);
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Started MATLAB as " + userIdentity);
        }
        finally {
            this.fMatlabStartLock.unlock();
        }
    }

    private OutputStream startNewOutputStream() throws IOException {
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Starting new MATLAB output stream");
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
        MatlabLicenseErrorCatcher matlabLicenseErrorCatcher = new MatlabLicenseErrorCatcher(pipedInputStream, START_PATTERN, END_PATTERN);
        if (this.fCaughtError != null) {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Cancelling previous caught error future");
            this.fCaughtError.cancel(true);
        }
        this.fCaughtError = new ErrorCatcherFuture(this.fErrorCatcherExecutor.submit(matlabLicenseErrorCatcher));
        boolean bl = true;
        FileOutputStream fileOutputStream = new FileOutputStream(this.getMatlabOutputFile(), bl);
        return new TeeOutputStream((OutputStream)pipedOutputStream, (OutputStream)fileOutputStream);
    }

    private UserIdentity getProcessIdentity(UserIdentity userIdentity) {
        if (this.isRunAsUser()) {
            return userIdentity;
        }
        return MDCE_USER_IDENTITY;
    }

    private UserIdentity getCurrentProcessIdentity() {
        return this.getProcessIdentity(this.fCurrentUserIdentity);
    }

    private void writeTimeStampToMatlabOutputFile() throws IOException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
        String string = String.format("    Starting new MATLAB at %s    ", simpleDateFormat.format(new Date()));
        char[] cArray = new char[string.length()];
        Arrays.fill(cArray, '-');
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.fMatlabOutputStream));
        bufferedWriter.newLine();
        bufferedWriter.write(cArray);
        bufferedWriter.newLine();
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        bufferedWriter.write(cArray);
        bufferedWriter.newLine();
        bufferedWriter.flush();
    }

    private CommandLine makeCommandLine(UserCredentials userCredentials) {
        String string = this.getIpcAddressForUserIdentity(userCredentials.getUserIdentity());
        CommandLineDecorator commandLineDecorator = new NativeIpcCommandLineDecorator(this.fCommandLineBuilder, string);
        if (userCredentials.hasCredentialsForRole(CredentialRole.PASSWORD)) {
            PlainCredentials plainCredentials = (PlainCredentials)userCredentials.getCredentialsForRole(CredentialRole.PASSWORD);
            commandLineDecorator = new MatlabRunAsUserCommandLineDecorator(commandLineDecorator, this.fWorkerConfig, plainCredentials);
        }
        if (userCredentials.hasCredentialsForRole(CredentialRole.WEB_LICENSE_INFO)) {
            commandLineDecorator = new WebLicensingCommandLineDecorator(commandLineDecorator, (WebLicenseCredentials)userCredentials.getCredentialsForRole(CredentialRole.WEB_LICENSE_INFO));
        }
        return commandLineDecorator.getCommandLine();
    }

    private int startMatlabLogRedirection(Handler handler) throws IOException, InterruptedException {
        return SocketLogRecordReceiver.startSocketLogRecordReceiver(handler);
    }

    private void enableErrorHandling() {
        this.fHandleErrors.set(true);
    }

    private boolean disableErrorHandling() {
        return this.fHandleErrors.getAndSet(false);
    }

    private String getMatlabOutputFile() {
        return this.fWorkerConfig.getMatlabOutputFile();
    }

    private String getMatlabLogFile() {
        return this.fWorkerConfig.getMatlabLogFile();
    }

    private boolean isMatlabShutdown() {
        return this.fMatlabShepherd.getState() == ProcessShepherd.State.SHUTDOWN;
    }

    private boolean isMatlabRunning() {
        return this.fMatlabShepherd.getState() == ProcessShepherd.State.RUNNING;
    }

    private boolean isRunAsUser() {
        return SecurityModuleProvider.isRunAsUser(this.fWorkerConfig.getSecurityLevel());
    }

    private UserIdentity getCurrentUserIdentity() {
        return this.fCurrentUserIdentity;
    }

    private void setCurrentUserIdentity(UserIdentity userIdentity) {
        this.fCurrentUserIdentity = userIdentity;
    }

    private boolean hasMatlabJustStarted() {
        return this.fMatlabJustStarted.get();
    }

    private void setMatlabJustStarted(boolean bl) {
        this.fMatlabJustStarted.set(bl);
    }

    private String getIpcAddressForUserIdentity(UserIdentity userIdentity) {
        UserIdentity userIdentity2 = this.getProcessIdentity(userIdentity);
        if (userIdentity2 == MDCE_USER_IDENTITY) {
            return this.fBaseIpcAddress;
        }
        return this.fBaseIpcAddress + "." + userIdentity2.getSimpleUsername();
    }

    String getIpcAddressForCurrentUserIdentity() {
        UserIdentity userIdentity = this.getCurrentUserIdentity();
        return this.getIpcAddressForUserIdentity(userIdentity);
    }

    private String getWorkerHostName() {
        try {
            return this.fWorker.getHostName();
        }
        catch (RemoteException remoteException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to call fWorker.getHostName()", remoteException);
            throw new RuntimeException(remoteException);
        }
    }

    private static void setWorldReadableAndWritable(File file) throws IOException {
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Attempting to give everyone Read and Write access to " + file);
        boolean bl = true;
        boolean bl2 = false;
        if (!file.setWritable(bl, bl2)) {
            throw new IOException("Failed to make " + file + " world writable.");
        }
        boolean bl3 = true;
        if (!file.setReadable(bl3, bl2)) {
            throw new IOException("Failed to make " + file + " world readable.");
        }
        if (PlatformInfo.isWindows()) {
            WindowsFileAcl windowsFileAcl = new WindowsFileAcl(file);
            windowsFileAcl.modify("Authenticated Users", WindowsFileAcl.Permission.READWRITE);
        }
    }

    private static void deleteDirectoryBeforeTaskExecution(File file) throws TaskExecutionException {
        try {
            if (file.exists() && file.isDirectory()) {
                FileUtils.deleteDirectory((File)file);
            }
        }
        catch (IOException iOException) {
            throw new TaskExecutionException("Failed to delete " + file + " before task execution.", iOException);
        }
    }

    private class TaskFevalCompleteCallback
    implements FevalCompleteCallback {
        private String LOGID = "TaskFevalCompleteCallback: ";

        private TaskFevalCompleteCallback() {
        }

        @Override
        public void complete(boolean bl, Exception exception) {
            if (bl) {
                this.fevalCompletedNormally();
            } else if (this.isMATLABStillRunning()) {
                this.fevalCompletedErrorAndMATLABStillRunning(exception);
            } else {
                this.fevalCompletedErrorAndMATLABEnded();
            }
            MatlabTaskEvaluator.this.fCanEvaluateTask.finishTaskFeval();
        }

        private boolean isMATLABStillRunning() {
            try {
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, this.LOGID + "Waiting to see if this exception was caused by MATLAB exiting.");
                MatlabTaskEvaluator.this.fMatlabShepherd.waitForProcessToShutdown(5, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            return MatlabTaskEvaluator.this.isMatlabRunning();
        }

        private void fevalCompletedNormally() {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, this.LOGID + "Feval of distcomp_evaluate_task has completed successfully.");
        }

        private void fevalCompletedErrorAndMATLABStillRunning(Exception exception) {
            if (exception == null) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, this.LOGID + "Feval of distcomp_evaluate_task errored.");
                MatlabTaskEvaluator.this.handleError(MatlabTaskEvaluatorErrorCode.TASK_FEVAL_ERROR, new Object[]{MatlabTaskEvaluator.this.getWorkerHostName(), MatlabTaskEvaluator.this.getMatlabOutputFile()});
            } else {
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, this.LOGID + "MATLAB is still running.");
                MatlabTaskEvaluator.this.handleError(MatlabTaskEvaluatorErrorCode.TASK_FEVAL_EXCEPTION, new Object[]{exception.getLocalizedMessage()});
            }
        }

        private void fevalCompletedErrorAndMATLABEnded() {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, this.LOGID + "Feval of distcomp_evaluate_task errored because MATLAB exited.");
        }
    }
}

