/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.worker.matlab;

import com.mathworks.toolbox.distcomp.mjs.security.CertificateBase64Encoder;
import com.mathworks.toolbox.distcomp.nativedmatlab.ProcessManipulation;
import com.mathworks.toolbox.distcomp.process.CommandLine;
import com.mathworks.toolbox.distcomp.worker.PersistentWorkerConfiguration;
import com.mathworks.toolbox.distcomp.worker.matlab.CommandLineBuilder;
import com.mathworks.toolbox.distcomp.worker.matlab.MatlabPrefAndLogDirectories;
import com.mathworks.toolbox.distcomp.worker.matlab.PackageInfo;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Map;

class MatlabCommandLineBuilder
implements CommandLineBuilder {
    private final PersistentWorkerConfiguration fWorkerConfig;
    private final MatlabPrefAndLogDirectories fMatlabPrefAndLogDirectories;
    private final int fMatlabLogPort;
    private final Certificate fCertificate;
    private static final String MATLAB_PREF_DIR = "MATLAB_PREFDIR";
    private static final String MATLAB_LOG_DIR = "MATLAB_LOG_DIR";
    private static final String WORKER_LOG_LEVEL = "WORKER_LOG_LEVEL";
    private static final String WORKER_LOG_PORT = "WORKER_LOG_PORT";
    private static final String WORKER_CERTIFICATE = "WORKER_CERTIFICATE";
    private static final String WORKER_PROCESS_SID = "WORKER_PROCESS_OWNER_SID";

    MatlabCommandLineBuilder(PersistentWorkerConfiguration persistentWorkerConfiguration, MatlabPrefAndLogDirectories matlabPrefAndLogDirectories, int n, Certificate certificate) {
        this.fWorkerConfig = persistentWorkerConfiguration;
        this.fMatlabPrefAndLogDirectories = matlabPrefAndLogDirectories;
        this.fMatlabLogPort = n;
        this.fCertificate = certificate;
    }

    @Override
    public CommandLine getCommandLine() {
        Object object;
        int n;
        String[] stringArray;
        CommandLine commandLine = new CommandLine(this.fWorkerConfig.getMatlabExecutable());
        String[] stringArray2 = this.fWorkerConfig.getMatlabArguments();
        if (stringArray2 != null) {
            commandLine.command().addAll(Arrays.asList(stringArray2));
        }
        if ((stringArray = this.fWorkerConfig.getMatlabEnvironment()) != null) {
            for (n = 0; n < stringArray.length; n += 2) {
                object = stringArray[n];
                String string = stringArray[n + 1];
                commandLine.environment().put((String)object, string);
            }
        }
        MatlabCommandLineBuilder.setEnvironmentVariableIfNotAlreadySet(commandLine.environment(), MATLAB_LOG_DIR, this.fMatlabPrefAndLogDirectories.getLogDirectory().getPath());
        MatlabCommandLineBuilder.setEnvironmentVariableIfNotAlreadySet(commandLine.environment(), MATLAB_PREF_DIR, this.fMatlabPrefAndLogDirectories.getPrefDirectory().getPath());
        n = this.fWorkerConfig.getLogLevel();
        commandLine.environment().put(WORKER_LOG_LEVEL, String.valueOf(n));
        commandLine.environment().put(WORKER_LOG_PORT, String.valueOf(this.fMatlabLogPort));
        if (this.fCertificate != null) {
            object = new CertificateBase64Encoder();
            commandLine.environment().put(WORKER_CERTIFICATE, ((CertificateBase64Encoder)object).encode(this.fCertificate));
        }
        if (ProcessManipulation.getProcessOwnerSidAsString((StringBuilder)(object = new StringBuilder()))) {
            commandLine.environment().put(WORKER_PROCESS_SID, ((StringBuilder)object).toString());
        }
        return commandLine;
    }

    private static void setEnvironmentVariableIfNotAlreadySet(Map<String, String> map, String string, String string2) {
        if (!map.containsKey(string)) {
            map.put(string, string2);
            PackageInfo.LOGGER.fine("Setting " + string + " to " + string2);
        } else {
            PackageInfo.LOGGER.info("Using existing environment variable setting for " + string + ": " + map.get(string));
        }
    }
}

