/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class ObjectCountDownLatch<T> {
    private final HashSet<T> fObjects;
    private final int fCount;
    private final CountDownLatch fCompleteSignal;
    private boolean fComplete;

    public ObjectCountDownLatch(int n) {
        this.fCount = n;
        this.fComplete = false;
        this.fCompleteSignal = new CountDownLatch(n);
        this.fObjects = new HashSet(n, 1.0f);
    }

    public synchronized boolean complete() {
        return this.fComplete;
    }

    public synchronized int getCount() {
        if (this.fComplete) {
            return this.fCount;
        }
        return this.fObjects.size();
    }

    public synchronized void countDown(T t) throws IllegalArgumentException {
        if (this.fComplete) {
            return;
        }
        boolean bl = this.fObjects.add(t);
        if (!bl) {
            throw new IllegalArgumentException("Object already added to count");
        }
        if (this.fObjects.size() == this.fCount) {
            this.fComplete = true;
            this.fObjects.clear();
        }
        this.fCompleteSignal.countDown();
    }

    public boolean awaitInterruptibly(long l, TimeUnit timeUnit) throws InterruptedException {
        assert (l >= 0L) : "Wait time must be positive.";
        return this.fCompleteSignal.await(l, timeUnit);
    }

    public boolean await(long l, TimeUnit timeUnit) {
        assert (l >= 0L) : "Wait time must be positive.";
        l = timeUnit.toMillis(l);
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        while (l3 <= l) {
            try {
                return this.fCompleteSignal.await(l - l3, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                l3 = System.currentTimeMillis() - l2;
            }
        }
        return false;
    }

    public void awaitInterruptibly() throws InterruptedException {
        this.fCompleteSignal.await();
    }

    public void await() {
        while (true) {
            try {
                this.fCompleteSignal.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

