/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.client.ClientWorkUnitAccess;
import com.mathworks.toolbox.distcomp.nativedmatlab.ProcessManipulation;
import com.mathworks.toolbox.distcomp.util.PackageInfo;
import java.rmi.RemoteException;
import net.jini.id.Uuid;

public class CancelWatchdog
implements Runnable {
    private long fTimeoutMillis;
    private Thread fThread;
    private boolean fShouldActuallyCancel = true;
    private ExitMode fExitMode;

    private CancelWatchdog(int n) {
        this.fTimeoutMillis = n * 1000;
        this.fThread = new Thread(this);
    }

    public CancelWatchdog(int n, int n2) {
        this(n2);
        this.fExitMode = new HardExitExitMode(n);
        this.fThread.start();
    }

    public CancelWatchdog(ClientWorkUnitAccess clientWorkUnitAccess, Uuid[] uuidArray, String string, int n) {
        this(n);
        this.fExitMode = new JobCancelExitMode(clientWorkUnitAccess, uuidArray, string);
        this.fThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "CancelWatchdog started");
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() < l + this.fTimeoutMillis) {
            long l2 = l + this.fTimeoutMillis - System.currentTimeMillis();
            CancelWatchdog cancelWatchdog = this;
            synchronized (cancelWatchdog) {
                try {
                    this.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.fShouldActuallyCancel) {
                    PackageInfo.LOGGER.log(DistcompLevel.TWO, "CancelWatchdog received OK - no need to cancel");
                    return;
                }
            }
        }
        CancelWatchdog cancelWatchdog = this;
        synchronized (cancelWatchdog) {
            if (this.fShouldActuallyCancel) {
                PackageInfo.LOGGER.log(DistcompLevel.TWO, "CancelWatchdog about to call fExitMode.exit()");
                this.fExitMode.exit();
            }
        }
    }

    public synchronized void ok() {
        this.fShouldActuallyCancel = false;
        this.notifyAll();
    }

    private static class HardExitExitMode
    implements ExitMode {
        private int fExitCode = 1;

        private HardExitExitMode(int n) {
            this.fExitCode = n;
        }

        @Override
        public void exit() {
            System.exit(this.fExitCode);
        }
    }

    private static class JobCancelExitMode
    implements ExitMode {
        private ClientWorkUnitAccess fClientWorkUnitAccess;
        private Uuid[] fWorkIds;
        private String fMsg;

        private JobCancelExitMode(ClientWorkUnitAccess clientWorkUnitAccess, Uuid[] uuidArray, String string) {
            this.fClientWorkUnitAccess = clientWorkUnitAccess;
            this.fWorkIds = uuidArray;
            this.fMsg = string;
        }

        @Override
        public void exit() {
            String[] stringArray = new String[this.fWorkIds.length];
            for (int i = 0; i < this.fWorkIds.length; ++i) {
                stringArray[i] = this.fMsg;
            }
            try {
                PackageInfo.LOGGER.log(DistcompLevel.TWO, "JobCancelExitMode about to call rerunOrCancel");
                this.fClientWorkUnitAccess.rerunOrCancel(this.fWorkIds, stringArray);
            }
            catch (RemoteException remoteException) {
                ProcessManipulation.terminateMATLAB("Failed to cancel job. Cancellation because: " + this.fMsg, 1000L);
            }
            catch (MJSException mJSException) {
                ProcessManipulation.terminateMATLAB("Failed to cancel job. Cancellation because: " + this.fMsg, 1000L);
            }
        }
    }

    private static interface ExitMode {
        public void exit();
    }
}

