/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.widget;

import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.distcomp.ui.ClickAwayFocusListener;
import com.mathworks.toolbox.distcomp.ui.model.DefaultValue;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import com.mathworks.toolbox.distcomp.ui.widget.ConfigurablePropertyView;
import com.mathworks.toolbox.distcomp.ui.widget.GlassPaneTextContextMenu;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class StringView
extends ConfigurablePropertyView {
    private boolean fTrimWhiteSpaces;

    public StringView(Property property, String string) {
        this(property, true, string);
    }

    public StringView(Property property, boolean bl, String string) {
        super(property, StringView.createUI(property, bl), string, true);
        this.fTrimWhiteSpaces = bl;
    }

    private static JComponent createUI(final Property property, final boolean bl) {
        final MJTextField mJTextField = new MJTextField();
        int n = (int)mJTextField.getPreferredSize().getHeight();
        mJTextField.setMinimumSize(new Dimension(210, n));
        mJTextField.setMaximumSize(new Dimension(210, n));
        mJTextField.setSize(new Dimension(210, n));
        mJTextField.setPreferredSize(new Dimension(210, n));
        if (!property.isDefaultValue()) {
            mJTextField.setText((String)property.getValue());
        }
        mJTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringView.updatePropertyValue(property, mJTextField.getText(), bl);
                mJTextField.getParent().requestFocus();
            }
        });
        mJTextField.addFocusListener((FocusListener)new ClickAwayFocusListener((JComponent)mJTextField, new Runnable(){

            @Override
            public void run() {
                StringView.updatePropertyValue(property, mJTextField.getText(), bl);
            }
        }));
        mJTextField.addContextMenu((JPopupMenu)((Object)new GlassPaneTextContextMenu()));
        return mJTextField;
    }

    @Override
    void commitEdit() {
        Property property = this.getProperty();
        JTextField jTextField = (JTextField)this.getActualComponent();
        StringView.updatePropertyValue(property, jTextField.getText(), this.fTrimWhiteSpaces);
    }

    private static void updatePropertyValue(Property property, String string, boolean bl) {
        if (bl) {
            string = string.trim();
        }
        if (string.isEmpty()) {
            property.unsetValue();
        } else if (string.equals("''")) {
            property.setValue("");
        } else {
            property.setValue(string);
        }
    }

    @Override
    void updateUI(JComponent jComponent, Object object) {
        String string;
        if (object instanceof DefaultValue) {
            string = "";
        } else if (object.equals("")) {
            string = "''";
        } else {
            string = (String)object;
            if (this.fTrimWhiteSpaces) {
                string = string.trim();
            }
        }
        ((JTextComponent)jComponent).setText(string);
    }
}

