/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.distcomp.pmode.Session;
import com.mathworks.toolbox.distcomp.pmode.SessionCreatedEvent;
import com.mathworks.toolbox.distcomp.pmode.SessionCreatedListener;
import com.mathworks.toolbox.distcomp.pmode.SessionEndedEvent;
import com.mathworks.toolbox.distcomp.pmode.SessionListener;
import com.mathworks.toolbox.distcomp.ui.resources.icons.MatlabPoolIndicatorIcon;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MatlabPoolIndicator
implements SessionCreatedListener,
SessionListener {
    private static MatlabPoolIndicator sInstanceForMLDesktop;
    private MatlabPoolIndicatorUI fMatlabPoolIndicatorUI = new MatlabPoolIndicatorUI();

    public MatlabPoolIndicator() {
        Session.addSessionCreatedListener(this);
    }

    public void dispose() {
        Session.removeSessionCreatedListener(this);
    }

    public JComponent getMatlabPoolIndicatorUI() {
        return this.fMatlabPoolIndicatorUI;
    }

    public static void addStatus(JPanel jPanel) {
        if (sInstanceForMLDesktop == null) {
            sInstanceForMLDesktop = new MatlabPoolIndicator();
        }
        jPanel.add(sInstanceForMLDesktop.getMatlabPoolIndicatorUI());
    }

    private static void runOnEdtThread(final Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                }
            });
        }
    }

    @Override
    public void sessionCreated(final SessionCreatedEvent sessionCreatedEvent) {
        sessionCreatedEvent.getSession().addSessionListener(this);
        MatlabPoolIndicator.runOnEdtThread(new Runnable(){

            @Override
            public void run() {
                MatlabPoolIndicator.this.fMatlabPoolIndicatorUI.updateMatlabPoolOpened(sessionCreatedEvent.getSession().getPoolSize());
            }
        });
    }

    @Override
    public void sessionClosed(SessionEndedEvent sessionEndedEvent) {
        sessionEndedEvent.getSession().removeSessionListener(this);
        MatlabPoolIndicator.runOnEdtThread(new Runnable(){

            @Override
            public void run() {
                MatlabPoolIndicator.this.fMatlabPoolIndicatorUI.updateMatlabPoolClosed();
            }
        });
    }

    @Override
    public void sessionErrored(final SessionEndedEvent sessionEndedEvent) {
        sessionEndedEvent.getSession().removeSessionListener(this);
        MatlabPoolIndicator.runOnEdtThread(new Runnable(){

            @Override
            public void run() {
                MatlabPoolIndicator.this.fMatlabPoolIndicatorUI.updateMatlabPoolClosedDueToError(sessionEndedEvent.getErrorMsg().getLocalizedMessage());
            }
        });
    }

    public static class MatlabPoolIndicatorUI
    extends MJPanel {
        private JLabel iMatlabPoolLabel = new MJLabel();
        private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_ui");
        private static final int ZERO_LABS = 0;
        private AtomicReference<Status> fStatus;

        public MatlabPoolIndicatorUI() {
            this.add(this.iMatlabPoolLabel);
            this.fStatus = new AtomicReference<Status>(Status.CLOSE);
            this.iMatlabPoolLabel.setName("MatlabPoolIndicator.Label");
            this.setName("MatlabPoolIndicator.Panel");
        }

        private void updateMatlabPoolOpened(int n) {
            this.iMatlabPoolLabel.setIcon(MatlabPoolIndicatorIcon.OPEN.getIcon());
            this.iMatlabPoolLabel.setText(MessageFormat.format(sRes.getString("matlabpoolindicator.numlabs.label"), n));
            this.iMatlabPoolLabel.setToolTipText(MessageFormat.format(sRes.getString("matlabpoolindicator.open.label"), n));
            this.fStatus.set(Status.OPEN);
        }

        private void updateMatlabPoolClosed() {
            this.iMatlabPoolLabel.setIcon(MatlabPoolIndicatorIcon.CLOSE.getIcon());
            this.iMatlabPoolLabel.setText(MessageFormat.format(sRes.getString("matlabpoolindicator.numlabs.label"), 0));
            this.iMatlabPoolLabel.setToolTipText(sRes.getString("matlabpoolindicator.close.label"));
            this.fStatus.set(Status.CLOSE);
        }

        private void updateMatlabPoolClosedDueToError(String string) {
            this.iMatlabPoolLabel.setIcon(MatlabPoolIndicatorIcon.ERROR.getIcon());
            this.iMatlabPoolLabel.setText(MessageFormat.format(sRes.getString("matlabpoolindicator.numlabs.label"), 0));
            this.iMatlabPoolLabel.setToolTipText(MessageFormat.format(sRes.getString("matlabpoolindicator.error.label"), string));
            this.fStatus.set(Status.ERROR);
        }

        public JLabel getLabel() {
            return this.iMatlabPoolLabel;
        }

        public Status getStatus() {
            return this.fStatus.get();
        }

        public static enum Status {
            CLOSE,
            ERROR,
            OPEN;

        }
    }
}

