/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage.fileblobs;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.storage.DataNotFoundException;
import com.mathworks.toolbox.distcomp.storage.DataStorage;
import com.mathworks.toolbox.distcomp.storage.DataStorageException;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFile;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileAllocator;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileException;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileFactory;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileStorage;
import com.mathworks.toolbox.distcomp.storage.fileblobs.FilePathAllocator;
import com.mathworks.toolbox.distcomp.storage.fileblobs.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.jini.id.Uuid;

public class BlobFileDataStorage
implements DataStorage {
    private static final int MAX_FILES_PER_DIRECTORY = 50;
    private static final String BLOB_EXT = ".lob";
    private static final String ALLOCATOR_RESTORE_FILE = "allocatorRestoreFile";
    private BlobFileStorage fBlobFileStorage;
    private BlobFileAllocator fBlobFileAllocator;

    public BlobFileDataStorage(String string, BlobFileStorage blobFileStorage, BlobFileFactory blobFileFactory) {
        this.fBlobFileStorage = blobFileStorage;
        File file = new File(string);
        File file2 = new File(file, ALLOCATOR_RESTORE_FILE);
        FilePathAllocator filePathAllocator = FilePathAllocator.createFilePathAllocator(file2, file, 50);
        this.fBlobFileAllocator = new BlobFileAllocator(file, filePathAllocator, blobFileFactory);
    }

    @Override
    public void close() throws StorageException {
        this.fBlobFileStorage.close();
    }

    @Override
    public byte[] readData(Uuid uuid) throws DataStorageException {
        byte[] byArray;
        assert (uuid != null) : "cannot read null data";
        BlobFile blobFile = this.fBlobFileStorage.getBlobFile(uuid);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            blobFile.read(byteArrayOutputStream);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to read data from blob file: " + blobFile.getPath(), iOException);
            throw new DataStorageException("Unable to read data from blob file", iOException);
        }
        return byArray;
    }

    @Override
    public int readData(Uuid uuid, OutputStream outputStream, int n) throws DataStorageException {
        long l;
        assert (uuid != null) : "cannot read null data";
        BlobFile blobFile = this.fBlobFileStorage.getBlobFile(uuid);
        try {
            l = blobFile.read(outputStream, n);
        }
        catch (IOException iOException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to read data from blob file: " + blobFile.getPath(), iOException);
            throw new DataStorageException("Unable to read data from blob file", iOException);
        }
        return (int)l;
    }

    @Override
    public void putJobData(Uuid uuid, Uuid uuid2, InputStream inputStream, int n) throws DataStorageException {
        assert (uuid2 != null && inputStream != null) : "stream or data cannot be null";
        if (n == 0) {
            return;
        }
        BlobFile blobFile = this.putData(uuid2, inputStream, n);
        this.fBlobFileStorage.putBlobFileForJob(uuid, uuid2, blobFile);
    }

    @Override
    public void putTaskData(Uuid uuid, Uuid uuid2, Uuid uuid3, InputStream inputStream, int n) throws DataStorageException {
        assert (uuid3 != null && inputStream != null) : "stream or data cannot be null";
        if (n == 0) {
            return;
        }
        BlobFile blobFile = this.putData(uuid3, inputStream, n);
        this.fBlobFileStorage.putBlobFileForTask(uuid, uuid2, uuid3, blobFile);
    }

    private BlobFile putData(Uuid uuid, InputStream inputStream, int n) throws DataStorageException {
        BlobFile blobFile;
        try {
            blobFile = this.fBlobFileAllocator.create(uuid.toString() + BLOB_EXT);
        }
        catch (BlobFileException blobFileException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to create new blob file", blobFileException);
            throw new DataStorageException("Unable to create new blob file", blobFileException);
        }
        try {
            blobFile.append(inputStream, n);
        }
        catch (IOException iOException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to write data to blob file: " + blobFile.getPath(), iOException);
            throw new DataStorageException("Unable to write data to blob file", iOException);
        }
        catch (BlobFileException blobFileException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to write data to blob file: " + blobFile.getPath(), blobFileException);
            throw new DataStorageException("Unable to write data to blob file", blobFileException);
        }
        return blobFile;
    }

    @Override
    public void updateData(Uuid uuid, InputStream inputStream, int n) throws DataStorageException {
        assert (uuid != null && inputStream != null) : "stream or data cannot be null";
        BlobFile blobFile = this.fBlobFileStorage.getBlobFile(uuid);
        try {
            blobFile.write(inputStream, n);
        }
        catch (IOException iOException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to write data to blob file: " + blobFile.getPath(), iOException);
            throw new DataStorageException("Unable to stream data to blob file", iOException);
        }
        catch (BlobFileException blobFileException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to write data to blob file: " + blobFile.getPath(), blobFileException);
            throw new DataStorageException("Unable to stream data to blob file", blobFileException);
        }
        this.fBlobFileStorage.updateBlobFile(uuid, blobFile);
    }

    @Override
    public void appendToData(Uuid uuid, InputStream inputStream, int n) throws DataStorageException {
        if (uuid == null) {
            return;
        }
        BlobFile blobFile = this.fBlobFileStorage.getBlobFile(uuid);
        try {
            blobFile.append(inputStream, n);
        }
        catch (IOException iOException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to write data to blob file: " + blobFile.getPath(), iOException);
            throw new DataStorageException("Could not write data to blob file", iOException);
        }
        catch (BlobFileException blobFileException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to write data to blob file: " + blobFile.getPath(), blobFileException);
            throw new DataStorageException("Could not write data to blob file", blobFileException);
        }
        this.fBlobFileStorage.updateBlobFile(uuid, blobFile);
    }

    @Override
    public Uuid copyData(Uuid uuid) throws DataStorageException {
        BlobFile blobFile;
        assert (uuid != null) : "cannot copy null data";
        BlobFile blobFile2 = this.fBlobFileStorage.getBlobFile(uuid);
        Uuid uuid2 = this.fBlobFileStorage.copyBlobFile(uuid);
        try {
            blobFile = this.fBlobFileAllocator.copy(blobFile2, uuid2.toString() + BLOB_EXT);
        }
        catch (BlobFileException blobFileException) {
            this.fBlobFileStorage.removeBlobFile(uuid2);
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to copy data from blob file: " + blobFile2 + " to new blob file", blobFileException);
            throw new DataStorageException("Unable to copy data between blob files", blobFileException);
        }
        this.fBlobFileStorage.updateBlobFile(uuid2, blobFile);
        return uuid2;
    }

    @Override
    public void removeData(Uuid uuid) throws DataStorageException {
        BlobFile blobFile;
        assert (uuid != null) : "cannot remove null data";
        try {
            blobFile = this.fBlobFileStorage.getBlobFile(uuid);
        }
        catch (DataNotFoundException dataNotFoundException) {
            Log.LOGGER.log(DistcompLevel.FOUR, "Tried to delete a blob file that did not exist", dataNotFoundException);
            return;
        }
        try {
            this.fBlobFileAllocator.delete(blobFile);
        }
        catch (BlobFileException blobFileException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to delete blob file: " + blobFile.getPath(), blobFileException);
            throw new DataStorageException("Unable to delete blob file", blobFileException);
        }
        this.fBlobFileStorage.removeBlobFile(uuid);
    }

    @Override
    public void removeDataForJobAndTasks(Uuid uuid) throws DataStorageException {
        if (uuid == null) {
            return;
        }
        boolean bl = false;
        DataStorageException dataStorageException = null;
        List<Uuid> list = this.fBlobFileStorage.getDataForJobAndTasks(uuid);
        for (Uuid uuid2 : list) {
            try {
                this.removeData(uuid2);
            }
            catch (DataStorageException dataStorageException2) {
                bl = true;
                dataStorageException = dataStorageException2;
            }
        }
        if (bl) {
            throw new DataStorageException("Failed to delete all data for job", dataStorageException);
        }
    }
}

