/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.service;

import com.mathworks.toolbox.distcomp.mjs.security.SharedSecret;
import com.mathworks.toolbox.distcomp.service.PackageInfo;
import com.mathworks.toolbox.distcomp.service.RMISocketFactoryProvider;
import com.mathworks.toolbox.distcomp.service.SharedSecretRMIServerSocketFactory;
import com.mathworks.toolbox.distcomp.service.TrustedSecureRMIClientSocketFactory;
import com.mathworks.toolbox.distcomp.service.UntrustedSecureRMIClientSocketFactory;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.security.cert.Certificate;

public final class SecureRMISocketFactoryProvider
implements RMISocketFactoryProvider {
    private final boolean fClientTrusted;
    private final int fClientConnectTimeout;

    public SecureRMISocketFactoryProvider(boolean bl, int n) {
        this.fClientTrusted = bl;
        this.fClientConnectTimeout = n;
    }

    @Override
    public RMIClientSocketFactory getClientSocketFactory() {
        if (this.fClientTrusted) {
            PackageInfo.LOGGER.finest("Using TrustedSecureRMIClientSocketFactory");
            Certificate certificate = SharedSecret.getInstance().getSharedSecretCertificate();
            return new TrustedSecureRMIClientSocketFactory(certificate, this.fClientConnectTimeout);
        }
        PackageInfo.LOGGER.finest("Using UntrustedSecureRMIClientSocketFactory");
        return new UntrustedSecureRMIClientSocketFactory(this.fClientConnectTimeout);
    }

    @Override
    public RMIServerSocketFactory getServerSocketFactory() {
        return new SharedSecretRMIServerSocketFactory();
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        return this.fClientTrusted == ((SecureRMISocketFactoryProvider)object).fClientTrusted;
    }

    public int hashCode() {
        return Boolean.valueOf(this.fClientTrusted).hashCode();
    }
}

