/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ProtocolDispatchException;
import com.mathworks.toolbox.distcomp.remote.RemoteStreamException;
import com.mathworks.toolbox.distcomp.remote.ShellCommand;
import com.mathworks.toolbox.distcomp.remote.ShellFuture;
import com.mathworks.toolbox.distcomp.remote.spi.Lease;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchFutureHelper;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchLeasableSession;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchSessionLeaseSource;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.SignalingBufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

final class JSchShellFuture
implements ShellFuture,
Runnable {
    private final JSchFutureHelper fHelper;
    private final SignalingBufferedInputStream fStdOut;
    private final SignalingBufferedInputStream fStdErr;
    private final ShellCommand fCommand;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JSchShellFuture createJSchShellFuture(ShellCommand shellCommand, String string, ParameterMap parameterMap) throws DispatchException {
        String string2;
        List<String> list = shellCommand.getCommand();
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            string2 = iterator.next();
            stringBuilder.append(string2);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" ");
        }
        string2 = stringBuilder.toString();
        String string3 = string + " " + string2;
        boolean bl = false;
        Lease<JSchLeasableSession> lease = null;
        try {
            lease = JSchSessionLeaseSource.INSTANCE.getLease(string, parameterMap);
            JSchShellFuture jSchShellFuture = new JSchShellFuture(shellCommand, lease, string2, string3);
            JSchFutureHelper.startThread(jSchShellFuture, string3);
            bl = true;
            Logger.LOGGER.fine(string3 + ": started");
            JSchShellFuture jSchShellFuture2 = jSchShellFuture;
            return jSchShellFuture2;
        }
        finally {
            if (!bl && lease != null) {
                lease.release();
            }
        }
    }

    private JSchShellFuture(ShellCommand shellCommand, Lease<JSchLeasableSession> lease, String string, String string2) throws ProtocolDispatchException {
        this.fCommand = shellCommand;
        try {
            ChannelExec channelExec = JSchShellFuture.createChannelExec(lease.getLeasedConnection().getSession(), string, string2);
            this.fHelper = new JSchFutureHelper(lease, (Channel)channelExec, string2);
        }
        catch (JSchException jSchException) {
            throw new ProtocolDispatchException(jSchException);
        }
        this.fStdOut = new SignalingBufferedInputStream(this.fHelper.getLogIDString() + " out");
        this.fStdErr = new SignalingBufferedInputStream(this.fHelper.getLogIDString() + " err");
    }

    private static ChannelExec createChannelExec(Session session, String string, String string2) throws JSchException {
        ChannelExec channelExec = (ChannelExec)session.openChannel("exec");
        channelExec.setCommand(string);
        Logger.LOGGER.finest(string2 + " " + string);
        return channelExec;
    }

    @Override
    public void cancel() {
        try {
            this.fStdErr.close();
        }
        catch (IOException iOException) {
            Logger.LOGGER.log(Level.WARNING, this.fHelper.getLogIDString() + ": while closing a remote stderr", iOException);
        }
        try {
            this.fStdOut.close();
        }
        catch (IOException iOException) {
            Logger.LOGGER.log(Level.WARNING, this.fHelper.getLogIDString() + ": while closing a remote stdout", iOException);
        }
        this.fHelper.cancel();
    }

    @Override
    public boolean isRunning() {
        return this.fHelper.isRunning();
    }

    @Override
    public void awaitEnd() throws InterruptedException, FulfillmentException {
        this.fHelper.awaitEnd();
    }

    @Override
    public boolean isExitStatusOfRemoteCommand() {
        return this.fHelper.isExitStatusOfRemoteCommand();
    }

    @Override
    public int getExitStatus() throws InterruptedException, FulfillmentException {
        return this.fHelper.getExitStatus();
    }

    @Override
    public InputStream getErrorStream() throws RemoteStreamException {
        try {
            if (this.fStdErr.awaitInputStreamAvailable()) {
                return this.fStdErr;
            }
            throw new RemoteStreamException("Not available after waiting");
        }
        catch (InterruptedException interruptedException) {
            throw new RemoteStreamException("Interrupted before stream established", (Throwable)interruptedException);
        }
    }

    @Override
    public OutputStream getOutputStream() throws RemoteStreamException {
        try {
            if (this.fHelper.delayUntilConnected()) {
                return this.fHelper.getOutputStream();
            }
            throw new RemoteStreamException("Interrupted before stream established");
        }
        catch (IOException iOException) {
            throw new RemoteStreamException(iOException);
        }
    }

    @Override
    public InputStream getInputStream() throws RemoteStreamException {
        try {
            if (this.fStdOut.awaitInputStreamAvailable()) {
                return this.fStdOut;
            }
            throw new RemoteStreamException("Not available after waiting");
        }
        catch (InterruptedException interruptedException) {
            throw new RemoteStreamException("Interrupted before stream established", (Throwable)interruptedException);
        }
    }

    private void startStreamBuffers() throws IOException {
        this.fStdOut.setInputStreamAndStart(this.fHelper.getInputStream());
        ChannelExec channelExec = (ChannelExec)this.fHelper.getChannel();
        this.fStdErr.setInputStreamAndStart(channelExec.getErrStream());
    }

    private void waitForStreamsToReachEnd() throws InterruptedException {
        Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": Waiting for InputStream to end.");
        this.fStdOut.awaitReachedEndOfInput();
        Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": Finished waiting for InputStream to end.");
        Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": Waiting for ErrStream to end.");
        this.fStdErr.awaitReachedEndOfInput();
        Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": Finished waiting for ErrStream to end.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                try {
                    if (!this.fHelper.hasBeenCancelled()) {
                        this.fHelper.connectToChannel();
                        this.startStreamBuffers();
                        this.waitForStreamsToReachEnd();
                        this.fHelper.waitForChannelToClose();
                        Logger.LOGGER.fine(this.fHelper.getLogIDString() + ": completed ");
                    }
                }
                catch (InterruptedException interruptedException) {
                    Logger.LOGGER.log(Level.FINE, this.fHelper.getLogIDString() + ": interrupted", interruptedException);
                }
                catch (Exception exception) {
                    this.fHelper.handleException(exception);
                }
                finally {
                    this.fHelper.disconnectFromChannel();
                }
            }
            finally {
                this.fHelper.releaseLease();
            }
        }
        finally {
            this.fHelper.signalCompleted();
        }
    }
}

