/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi;

import com.mathworks.toolbox.distcomp.remote.spi.LeasableConnection;
import com.mathworks.toolbox.distcomp.remote.spi.LeaseMonitor;
import com.mathworks.toolbox.distcomp.remote.spi.LeaseSource;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Lease<T extends LeasableConnection> {
    private final LeaseMonitor<T> fLeaseMonitor;
    private final AtomicBoolean fIsLeased = new AtomicBoolean(true);

    public Lease(LeaseMonitor<T> leaseMonitor) {
        this.fLeaseMonitor = leaseMonitor;
    }

    public LeaseMonitor<T> getLeaseMonitor() {
        return this.fLeaseMonitor;
    }

    public T getLeasedConnection() {
        if (this.fIsLeased.get()) {
            return this.fLeaseMonitor.getLeasedConnection();
        }
        assert (false) : "Session requested from a released lease";
        return this.fLeaseMonitor.getLeasedConnection();
    }

    public void release() {
        this.fIsLeased.set(false);
        LeaseSource<T> leaseSource = this.fLeaseMonitor.getLeaseSource();
        if (leaseSource != null) {
            leaseSource.release(this);
        }
    }

    public boolean isLeased() {
        return this.fIsLeased.get();
    }
}

