/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.ClearNotificationCommand;
import com.mathworks.toolbox.distcomp.pmode.PathNotificationCommand;
import com.mathworks.toolbox.distcomp.pmode.shared.MCommand;
import com.mathworks.toolbox.distcomp.pmode.shared.OutputGroup;
import com.mathworks.toolbox.distcomp.util.PathNotificationGateway;

class PathNotificationListener
implements PathNotificationGateway.Listener {
    boolean fRegistered = false;
    OutputGroup fOutputGroup;

    PathNotificationListener(OutputGroup outputGroup) {
        this.fOutputGroup = outputGroup;
    }

    synchronized void register() {
        if (!this.fRegistered) {
            PathNotificationGateway.addListener(this);
            this.fRegistered = true;
        }
    }

    synchronized void unregister() {
        if (this.fRegistered) {
            PathNotificationGateway.removeListener(this);
            this.fRegistered = false;
        }
    }

    @Override
    public void addpath(String[] stringArray, String string) {
        PathNotificationCommand pathNotificationCommand = new PathNotificationCommand(PathNotificationCommand.PathNotificationType.ADDPATH, stringArray, string);
        this.sendCommand(pathNotificationCommand);
    }

    @Override
    public void rmpath(String[] stringArray) {
        PathNotificationCommand pathNotificationCommand = new PathNotificationCommand(PathNotificationCommand.PathNotificationType.RMPATH, stringArray);
        this.sendCommand(pathNotificationCommand);
    }

    @Override
    public void cd(String string) {
        PathNotificationCommand pathNotificationCommand = new PathNotificationCommand(PathNotificationCommand.PathNotificationType.CD, string);
        this.sendCommand(pathNotificationCommand);
    }

    @Override
    public void clear(String[] stringArray) {
        ClearNotificationCommand clearNotificationCommand = new ClearNotificationCommand(stringArray);
        this.sendCommand(clearNotificationCommand);
    }

    private void sendCommand(MCommand mCommand) {
        this.fOutputGroup.sendToAll(mCommand);
    }
}

