/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.distcomp.parallelui.IntSetPopup;
import com.mathworks.toolbox.distcomp.parallelui.OutputWindow;
import com.mathworks.toolbox.distcomp.parallelui.ParallelUI;
import com.mathworks.toolbox.distcomp.parallelui.Utilities;
import com.mathworks.toolbox.distcomp.pmode.Labs;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class OutputSelector
extends MJLabel {
    private final Labs fLabs;
    private OutputWindow fOutputWindow;
    private final OutputWindow.SourcesListener fListener;

    OutputSelector(Labs labs, OutputWindow outputWindow) {
        super(outputWindow == null ? "" : Utilities.labsToString(outputWindow.getSources(), Utilities.allLabs(labs)), Utilities.DOWN_ARROW_ICON, 10);
        this.fLabs = labs;
        this.fOutputWindow = outputWindow;
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.setHorizontalTextPosition(10);
        this.setToolTipText(ParallelUI.sRes.getString("tip.SelectDisplayedLabs"));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                final IntSetPopup intSetPopup = new IntSetPopup(1, OutputSelector.this.fLabs.getNumLabs(), ParallelUI.sRes.getString("label.ThisLab"), ParallelUI.sRes.getString("title.SelectTargetLabs"));
                if (OutputSelector.this.fOutputWindow != null) {
                    intSetPopup.setValue(OutputSelector.this.fOutputWindow.getSources());
                }
                intSetPopup.show((Component)((Object)OutputSelector.this), 0, OutputSelector.this.getHeight(), new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        if (OutputSelector.this.fOutputWindow != null) {
                            OutputSelector.this.fOutputWindow.setSources(intSetPopup.getValue());
                        }
                    }
                });
            }
        });
        this.fListener = new OutputWindow.SourcesListener(){

            @Override
            public void sourcesChanged(OutputWindow outputWindow) {
                OutputSelector.this.setText(Utilities.labsToString(outputWindow.getSources(), Utilities.allLabs(OutputSelector.this.fLabs)));
            }
        };
        if (this.fOutputWindow != null) {
            this.fOutputWindow.addSourcesListener(this.fListener);
        }
    }

    void setSelectorFor(OutputWindow outputWindow) {
        if (this.fOutputWindow != null) {
            this.fOutputWindow.removeSourcesListener(this.fListener);
        }
        this.fOutputWindow = outputWindow;
        if (this.fOutputWindow != null) {
            this.fOutputWindow.addSourcesListener(this.fListener);
            this.fListener.sourcesChanged(this.fOutputWindow);
        }
    }
}

