/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJDimensionPicker;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJTiledPane;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.toolbox.distcomp.parallelui.Actions;
import com.mathworks.toolbox.distcomp.parallelui.FireOnPressToggleButton;
import com.mathworks.toolbox.distcomp.parallelui.IntSet;
import com.mathworks.toolbox.distcomp.parallelui.IntSetPopup;
import com.mathworks.toolbox.distcomp.parallelui.MenuContributor;
import com.mathworks.toolbox.distcomp.parallelui.OutputCollection;
import com.mathworks.toolbox.distcomp.parallelui.OutputComponent;
import com.mathworks.toolbox.distcomp.parallelui.OutputSelector;
import com.mathworks.toolbox.distcomp.parallelui.OutputWindow;
import com.mathworks.toolbox.distcomp.parallelui.ParallelUI;
import com.mathworks.toolbox.distcomp.pmode.Labs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OutputOrganizer
extends JComponent
implements MJTiledPane.GridListener,
ContainerListener,
ChangeListener,
OutputWindow.SourcesListener,
Actions.Contributor,
OutputComponent {
    private Labs fLabs;
    private OutputCollection fOutputCollection;
    private Actions fActions;
    private TiledPane fTiledPane;
    private TabbedPane fTabbedPane;
    private JComponent fCurrentPane;
    private KeyListener fKeyRedirector;
    private boolean fShowCommandText = true;
    private boolean fIsSwitchingPanes;
    private IntSet fRemovedSources;
    private Component fFocusOwnerBeforePicker;
    private OutputSelector fSingleWindowSelector;
    private SelectTabCountAction fSelectTabCountAction = new SelectTabCountAction();
    private SelectTilingAction fSelectTilingAction = new SelectTilingAction();
    private MJAbstractAction fInterleaveOutputAction = new InterleaveOutputAction();
    private MJAbstractAction[] fArrangementActions = new MJAbstractAction[3];
    private static final String ARRANGEMENT_ATTRIBUTE = "Arrangement";
    private static final String TILED_VALUE = "Tiled";
    private static final String TABBED_VALUE = "Tabbed";
    private static final String TAB_COUNT_ATTRIBUTE = "TabCount";
    private static final String WINDOW_TAG = "Window";
    private static final String LABS_ATTRIBUTE = "Labs";

    public OutputOrganizer(Labs labs, OutputCollection outputCollection, Actions actions) {
        this.fLabs = labs;
        this.fOutputCollection = outputCollection;
        this.fActions = actions;
        this.fSingleWindowSelector = new OutputSelector(this.fLabs, null);
        this.fArrangementActions[0] = this.fSelectTabCountAction;
        this.fArrangementActions[1] = this.fSelectTilingAction;
        this.fArrangementActions[2] = this.fInterleaveOutputAction;
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        if (this.fLabs.getNumLabs() >= 4) {
            this.setTiling(new Dimension(2, 2));
        } else {
            this.setTiling(new Dimension(this.fLabs.getNumLabs(), 1));
        }
        actions.registerContribution(Actions.Type.TILE_OUTPUT, this);
        actions.registerContribution(Actions.Type.TAB_OUTPUT, this);
        actions.registerContribution(Actions.Type.SINGLE_OUTPUT, this);
        this.add((Component)this.createToolBar(), "North");
    }

    @Override
    public Action getAction(Actions.Type type) {
        switch (type) {
            case TILE_OUTPUT: {
                return this.fSelectTilingAction;
            }
            case TAB_OUTPUT: {
                return this.fSelectTabCountAction;
            }
            case SINGLE_OUTPUT: {
                return this.fInterleaveOutputAction;
            }
        }
        return null;
    }

    @Override
    public Component getActionFocusComponent() {
        return null;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        OutputWindowContainer outputWindowContainer = (OutputWindowContainer)((Object)this.fCurrentPane);
        if (outputWindowContainer != null) {
            for (int i = 0; i < outputWindowContainer.getWindowCount(); ++i) {
                outputWindowContainer.getWindow(i).setBackground(color);
            }
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        OutputWindowContainer outputWindowContainer = (OutputWindowContainer)((Object)this.fCurrentPane);
        if (outputWindowContainer != null) {
            for (int i = 0; i < outputWindowContainer.getWindowCount(); ++i) {
                outputWindowContainer.getWindow(i).setForeground(color);
            }
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        OutputWindowContainer outputWindowContainer = (OutputWindowContainer)((Object)this.fCurrentPane);
        if (outputWindowContainer != null) {
            for (int i = 0; i < outputWindowContainer.getWindowCount(); ++i) {
                outputWindowContainer.getWindow(i).setFont(font);
            }
        }
    }

    @Override
    public void setShowCommandText(boolean bl) {
        this.fShowCommandText = bl;
        OutputWindowContainer outputWindowContainer = (OutputWindowContainer)((Object)this.fCurrentPane);
        for (int i = 0; i < outputWindowContainer.getWindowCount(); ++i) {
            outputWindowContainer.getWindow(i).setShowCommandText(bl);
        }
    }

    @Override
    public boolean isShowingCommandText() {
        return this.fShowCommandText;
    }

    @Override
    public void showCorrespondingOutput(OutputCollection.CommandRecord commandRecord) {
        OutputWindowContainer outputWindowContainer = (OutputWindowContainer)((Object)this.fCurrentPane);
        for (int i = 0; i < outputWindowContainer.getWindowCount(); ++i) {
            OutputWindow outputWindow = outputWindowContainer.getWindow(i);
            if (!outputWindow.getSources().containsAny(commandRecord.getDestinations())) continue;
            outputWindow.showCorrespondingOutput(commandRecord);
        }
    }

    @Override
    public void clear() {
        OutputWindowContainer outputWindowContainer = (OutputWindowContainer)((Object)this.fCurrentPane);
        for (int i = 0; i < outputWindowContainer.getWindowCount(); ++i) {
            outputWindowContainer.getWindow(i).clear();
        }
    }

    @Override
    public void setKeyRedirector(KeyListener keyListener) {
        this.fKeyRedirector = keyListener;
        OutputWindowContainer outputWindowContainer = (OutputWindowContainer)((Object)this.fCurrentPane);
        for (int i = 0; i < outputWindowContainer.getWindowCount(); ++i) {
            outputWindowContainer.getWindow(i).setKeyRedirector(keyListener);
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    int getLeftInset() {
        OutputWindowContainer outputWindowContainer = (OutputWindowContainer)((Object)this.fCurrentPane);
        return outputWindowContainer.getWindow(0).getLeftInset();
    }

    void setTiling(Dimension dimension) {
        this.setTiling(dimension, null, null);
    }

    void setTiling(Dimension dimension, Object object, IntSet[] intSetArray) {
        List<OutputWindow> list = null;
        int n = 0;
        if (this.fCurrentPane instanceof MJTabbedPane) {
            list = this.removeCurrentPane();
            n = list.size();
        } else if (this.fTiledPane != null) {
            n = this.fTiledPane.getTileCount();
            list = new ArrayList<OutputWindow>(n);
            this.fIsSwitchingPanes = true;
            for (int i = 0; i < n; ++i) {
                list.add(this.fTiledPane.getWindow(i));
                this.fTiledPane.remove(i);
            }
            this.fIsSwitchingPanes = false;
        }
        if (this.fTiledPane == null) {
            this.fTiledPane = new TiledPane();
            this.fTiledPane.addContainerListener(this);
            this.fTiledPane.addGridListener(this);
        }
        if (this.fCurrentPane != this.fTiledPane) {
            this.add((Component)((Object)this.fTiledPane), "Center");
            this.fCurrentPane = this.fTiledPane;
        }
        Dimension dimension2 = this.fTiledPane.getGridSize();
        if (this.fTiledPane.getComponentCount() == 0) {
            dimension2.setSize(0, 0);
        }
        if (object != null || !dimension2.equals(dimension) || this.fTiledPane.getTileCount() != dimension2.height * dimension2.width) {
            int n2;
            int n3 = n2 = dimension2.width * dimension2.height;
            if (object != null) {
                n3 = MJTiledPane.getTileCountFromState((Object)object);
            } else if (dimension != null) {
                n3 = dimension.width * dimension.height;
            }
            if (object != null) {
                this.fTiledPane.restoreState(object);
            } else if (dimension != null) {
                this.fTiledPane.setGridSize(dimension);
            }
            for (int i = 0; i < n3; ++i) {
                if (!this.fTiledPane.isTileEmpty(i)) continue;
                OutputWindow outputWindow = null;
                if (list != null && list.size() > 0) {
                    outputWindow = list.get(0);
                    list.remove(0);
                } else {
                    outputWindow = this.createOutputWindow();
                }
                this.fTiledPane.add((Component)((Object)outputWindow), i);
            }
            if (intSetArray != null) {
                this.setWindowLabs(intSetArray);
            } else if (n3 != n) {
                this.dealLabs();
            }
            if (list != null) {
                for (OutputWindow outputWindow : list) {
                    outputWindow.setSources(new IntSet());
                }
            }
        }
        this.updateTitleBarVisibility();
        this.updateSingleWindowSelector();
        this.revalidate();
        this.repaint();
    }

    void setTabbing(int n, IntSet[] intSetArray) {
        int n2;
        List<OutputWindow> list = null;
        int n3 = 0;
        if (this.fCurrentPane instanceof MJTiledPane) {
            list = this.removeCurrentPane();
            n3 = list.size();
        } else if (this.fTabbedPane != null) {
            n3 = this.fTabbedPane.getTabCount();
        }
        if (this.fTabbedPane == null) {
            this.fTabbedPane = new TabbedPane();
            this.fTabbedPane.setTabPlacement(3);
            this.fTabbedPane.setTabLayoutPolicy(1);
            this.fTabbedPane.addChangeListener(this);
            this.fTabbedPane.addTabListener(new TabListener());
        }
        if (this.fCurrentPane != this.fTabbedPane) {
            this.add((Component)((Object)this.fTabbedPane), "Center");
            this.fCurrentPane = this.fTabbedPane;
        }
        if (n != (n2 = this.fTabbedPane.getTabCount())) {
            OutputWindow outputWindow;
            int n4;
            for (n4 = n2 - 1; n4 >= n; --n4) {
                this.fTabbedPane.remove(n4);
            }
            for (n4 = n2; n4 < n; ++n4) {
                outputWindow = null;
                if (list != null && list.size() > 0) {
                    outputWindow = list.get(0);
                    list.remove(0);
                } else {
                    outputWindow = this.createOutputWindow();
                }
                this.fTabbedPane.addTab("", (Component)((Object)outputWindow));
            }
            if (intSetArray != null) {
                this.setWindowLabs(intSetArray);
            } else if (n != n3) {
                this.dealLabs();
            } else {
                for (n4 = 0; n4 < this.fTabbedPane.getTabCount(); ++n4) {
                    outputWindow = (OutputWindow)((Object)this.fTabbedPane.getComponentAt(n4));
                    this.fTabbedPane.setTitleAt(n4, outputWindow.getSources().toString());
                }
            }
        }
        this.updateTitleBarVisibility();
        this.updateSingleWindowSelector();
        this.revalidate();
        this.repaint();
    }

    private OutputWindow createOutputWindow() {
        OutputWindow outputWindow = new OutputWindow(this.fLabs, this.fOutputCollection, this.fActions);
        if (this.getBackground() != null) {
            outputWindow.setBackground(this.getBackground());
        }
        if (this.getForeground() != null) {
            outputWindow.setForeground(this.getForeground());
        }
        if (this.getFont() != null) {
            outputWindow.setFont(this.getFont());
        }
        if (this.fKeyRedirector != null) {
            outputWindow.setKeyRedirector(this.fKeyRedirector);
        }
        outputWindow.setShowCommandText(this.fShowCommandText);
        outputWindow.addSourcesListener(this);
        return outputWindow;
    }

    private void dealLabs() {
        IntSet intSet;
        OutputWindow outputWindow;
        int n;
        OutputWindowContainer outputWindowContainer = (OutputWindowContainer)((Object)this.fCurrentPane);
        int n2 = outputWindowContainer.getWindowCount();
        for (n = 0; n < Math.min(this.fLabs.getNumLabs(), n2); ++n) {
            outputWindow = outputWindowContainer.getWindow(n);
            intSet = new IntSet(n + 1);
            outputWindow.setSources(intSet);
            if (this.fCurrentPane != this.fTabbedPane) continue;
            this.fTabbedPane.setTitleAt(n, Integer.toString(n + 1));
        }
        if (this.fLabs.getNumLabs() >= n2) {
            IntSet intSet2 = new IntSet();
            for (int i = 0; i < this.fLabs.getNumLabs() - n2 + 1; ++i) {
                intSet2.add(i + n2);
            }
            OutputWindow outputWindow2 = outputWindowContainer.getWindow(n2 - 1);
            outputWindow2.setSources(intSet2);
            if (this.fCurrentPane == this.fTabbedPane) {
                this.fTabbedPane.setTitleAt(n2 - 1, intSet2.toString());
            }
        } else if (this.fLabs.getNumLabs() < n2) {
            for (n = this.fLabs.getNumLabs(); n < n2; ++n) {
                outputWindow = outputWindowContainer.getWindow(n);
                intSet = new IntSet();
                outputWindow.setSources(intSet);
                if (this.fCurrentPane != this.fTabbedPane) continue;
                this.fTabbedPane.setTitleAt(n, "");
            }
        }
    }

    private void setWindowLabs(IntSet[] intSetArray) {
        OutputWindowContainer outputWindowContainer = (OutputWindowContainer)((Object)this.fCurrentPane);
        if (outputWindowContainer != null) {
            for (int i = 0; i < outputWindowContainer.getWindowCount(); ++i) {
                OutputWindow outputWindow = outputWindowContainer.getWindow(i);
                IntSet intSet = i < intSetArray.length ? intSetArray[i] : new IntSet();
                outputWindow.setSources(intSet);
                if (this.fCurrentPane != this.fTabbedPane) continue;
                this.fTabbedPane.setTitleAt(i, intSet.toString());
            }
        }
    }

    private List<OutputWindow> removeCurrentPane() {
        if (this.fCurrentPane == null) {
            return null;
        }
        this.fIsSwitchingPanes = true;
        OutputWindowContainer outputWindowContainer = (OutputWindowContainer)((Object)this.fCurrentPane);
        ArrayList<OutputWindow> arrayList = new ArrayList<OutputWindow>();
        for (int i = 0; i < outputWindowContainer.getWindowCount(); ++i) {
            arrayList.add(outputWindowContainer.getWindow(i));
        }
        this.fCurrentPane.removeAll();
        this.remove(this.fCurrentPane);
        this.fCurrentPane = null;
        this.fIsSwitchingPanes = false;
        return arrayList;
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        if (this.fIsSwitchingPanes) {
            return;
        }
        OutputWindow outputWindow = (OutputWindow)((Object)containerEvent.getChild());
        this.fRemovedSources = outputWindow.getSources();
        outputWindow.setSources(new IntSet());
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateSingleWindowSelector();
    }

    @Override
    public void sourcesChanged(OutputWindow outputWindow) {
        int n;
        if (this.fCurrentPane == this.fTabbedPane && this.fTabbedPane != null && (n = this.fTabbedPane.indexOfComponent((Component)((Object)outputWindow))) != -1) {
            this.fTabbedPane.setTitleAt(n, outputWindow.getSources().toString());
        }
    }

    public void gridSizeChanged(MJTiledPane mJTiledPane, Dimension dimension, Dimension dimension2) {
        this.updateTitleBarVisibility();
        this.updateSingleWindowSelector();
        this.updateArrangementActions();
    }

    public void tilesMerged(MJTiledPane mJTiledPane, int n, int n2) {
        int n3 = Math.min(n, n2);
        OutputWindow outputWindow = (OutputWindow)((Object)mJTiledPane.getComponentInTile(n3));
        if (this.fRemovedSources != null) {
            this.fRemovedSources.addAll(outputWindow.getSources());
            outputWindow.setSources(this.fRemovedSources);
            this.fRemovedSources = null;
        }
        this.updateTitleBarVisibility();
        this.updateSingleWindowSelector();
    }

    public void tileSplit(MJTiledPane mJTiledPane, int n, int n2) {
        OutputWindow outputWindow = (OutputWindow)((Object)this.fTiledPane.getComponentInTile(n));
        OutputWindow outputWindow2 = this.createOutputWindow();
        IntSet intSet = outputWindow.getSources();
        if (intSet.size() > 0) {
            int n3 = intSet.first();
            outputWindow.setSources(new IntSet(n3));
            intSet.remove(n3);
        }
        outputWindow2.setSources(intSet);
        for (n = 0; n < this.fTiledPane.getTileCount(); ++n) {
            if (!this.fTiledPane.isTileEmpty(n)) continue;
            this.fTiledPane.add((Component)((Object)outputWindow2), n);
        }
        this.updateTitleBarVisibility();
        this.updateSingleWindowSelector();
    }

    OutputSelector getSingleWindowSelector() {
        return this.fSingleWindowSelector;
    }

    private void updateTitleBarVisibility() {
        boolean bl = this.fCurrentPane == this.fTiledPane && this.fTiledPane.getTileCount() > 1;
        OutputWindowContainer outputWindowContainer = (OutputWindowContainer)((Object)this.fCurrentPane);
        for (int i = 0; i < outputWindowContainer.getWindowCount(); ++i) {
            OutputWindow outputWindow = outputWindowContainer.getWindow(i);
            if (outputWindow == null) continue;
            outputWindow.setTitleBarVisible(bl);
        }
        this.fSingleWindowSelector.setVisible(!bl);
    }

    private void updateSingleWindowSelector() {
        OutputWindow outputWindow = null;
        if (this.fCurrentPane == this.fTabbedPane) {
            outputWindow = (OutputWindow)((Object)this.fTabbedPane.getSelectedComponent());
        } else if (this.fCurrentPane == this.fTiledPane && this.fTiledPane.getTileCount() == 1) {
            outputWindow = (OutputWindow)((Object)this.fTiledPane.getComponentInTile(0));
        }
        this.fSingleWindowSelector.setSelectorFor(outputWindow);
    }

    private void updateArrangementActions() {
        ShowPickerAction showPickerAction = null;
        if (this.fCurrentPane == this.fTabbedPane) {
            showPickerAction = this.fSelectTabCountAction;
        } else {
            Dimension dimension = this.fTiledPane.getGridSize();
            showPickerAction = dimension.width == 1 && dimension.height == 1 ? this.fInterleaveOutputAction : this.fSelectTilingAction;
        }
        for (int i = 0; i < this.fArrangementActions.length; ++i) {
            this.fArrangementActions[i].setSelected(showPickerAction == this.fArrangementActions[i]);
        }
    }

    private MJDimensionPicker createDimensionPicker(final boolean bl) {
        MJDimensionPicker mJDimensionPicker;
        int n = this.fLabs.getNumLabs();
        int n2 = Math.min(4, n);
        if (bl) {
            mJDimensionPicker = new MJDimensionPicker(new Dimension(n2, 1));
            mJDimensionPicker.setSizeLimit(new Dimension(n, 1));
        } else {
            mJDimensionPicker = new MJDimensionPicker(new Dimension(n2, n2));
            mJDimensionPicker.setSizeLimit(new Dimension(n, n));
        }
        mJDimensionPicker.setOccupancy(this.fLabs.getNumLabs());
        mJDimensionPicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MJDimensionPicker mJDimensionPicker = (MJDimensionPicker)actionEvent.getSource();
                Dimension dimension = mJDimensionPicker.getSelectedSize();
                if (bl && dimension.width > 1) {
                    OutputOrganizer.this.setTabbing(dimension.width, null);
                } else {
                    OutputOrganizer.this.setTiling(dimension);
                }
                if (OutputOrganizer.this.fFocusOwnerBeforePicker != null) {
                    OutputOrganizer.this.fFocusOwnerBeforePicker.requestFocusInWindow();
                    OutputOrganizer.this.fFocusOwnerBeforePicker = null;
                }
            }
        });
        return mJDimensionPicker;
    }

    JMenu createTileMenu() {
        MJMenu mJMenu = new MJMenu((Action)((Object)this.fSelectTilingAction));
        mJMenu.addMenuListener((MenuListener)new PickerMenuListener(false));
        mJMenu.setName("TileCommandWindow");
        return mJMenu;
    }

    JMenu createTabMenu() {
        MJMenu mJMenu = new MJMenu((Action)((Object)this.fSelectTabCountAction));
        mJMenu.addMenuListener((MenuListener)new PickerMenuListener(true));
        mJMenu.setName("TileCommandWindow");
        return mJMenu;
    }

    private JToolBar createToolBar() {
        MJToolBar mJToolBar = new MJToolBar();
        mJToolBar.setFloatable(false);
        OutputSelector outputSelector = this.getSingleWindowSelector();
        mJToolBar.add((Component)((Object)outputSelector));
        mJToolBar.addSeparator();
        final Component component = mJToolBar.getComponent(mJToolBar.getComponentCount() - 1);
        component.setVisible(((Component)((Object)outputSelector)).isVisible());
        ((Component)((Object)outputSelector)).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                component.setVisible(true);
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                component.setVisible(false);
            }
        });
        mJToolBar.addToggle(this.fActions.getAction(Actions.Type.COMMANDS_IN_OUTPUT));
        mJToolBar.add(this.fActions.getAction(Actions.Type.CLEAR_ALL_OUTPUT));
        mJToolBar.add(Box.createHorizontalGlue());
        FireOnPressToggleButton fireOnPressToggleButton = new FireOnPressToggleButton(this.fActions.getAction(Actions.Type.TILE_OUTPUT));
        MJToolBar.configureButton((MJToggleButton)fireOnPressToggleButton);
        fireOnPressToggleButton.setFocusTraversable(true);
        mJToolBar.add((Component)((Object)fireOnPressToggleButton));
        fireOnPressToggleButton = new FireOnPressToggleButton(this.fActions.getAction(Actions.Type.TAB_OUTPUT));
        MJToolBar.configureButton((MJToggleButton)fireOnPressToggleButton);
        fireOnPressToggleButton.setFocusTraversable(true);
        mJToolBar.add((Component)((Object)fireOnPressToggleButton));
        fireOnPressToggleButton = new FireOnPressToggleButton(this.fActions.getAction(Actions.Type.SINGLE_OUTPUT));
        MJToolBar.configureButton((MJToggleButton)fireOnPressToggleButton);
        mJToolBar.add((Component)((Object)fireOnPressToggleButton));
        return mJToolBar;
    }

    void saveState(Document document, Element element) {
        Object object;
        if (this.fCurrentPane == this.fTabbedPane) {
            element.setAttribute(ARRANGEMENT_ATTRIBUTE, TABBED_VALUE);
            element.setAttribute(TAB_COUNT_ATTRIBUTE, Integer.toString(this.fTabbedPane.getTabCount()));
        } else if (this.fCurrentPane == this.fTiledPane) {
            element.setAttribute(ARRANGEMENT_ATTRIBUTE, TILED_VALUE);
            object = this.fTiledPane.getState();
            Element element2 = MJTiledPane.stateToXML((Object)object, (Document)document);
            element.appendChild(element2);
        }
        object = (OutputWindowContainer)((Object)this.fCurrentPane);
        if (object != null) {
            for (int i = 0; i < object.getWindowCount(); ++i) {
                IntSet intSet = object.getWindow(i).getSources();
                intSet.remove(0);
                Element element3 = document.createElement(WINDOW_TAG);
                element3.setAttribute(LABS_ATTRIBUTE, intSet.toString());
                element.appendChild(element3);
            }
        }
    }

    void restoreState(SimpleElement simpleElement) throws DataFormatException {
        Object object;
        SimpleElement simpleElement2;
        SimpleNodeList simpleNodeList = simpleElement.getChildrenByTagName(WINDOW_TAG);
        IntSet[] intSetArray = new IntSet[simpleNodeList.getLength()];
        for (int i = 0; i < intSetArray.length; ++i) {
            simpleElement2 = (SimpleElement)simpleNodeList.item(i);
            object = simpleElement2.getAttribute(LABS_ATTRIBUTE);
            try {
                intSetArray[i] = new IntSet((String)object);
                continue;
            }
            catch (Exception exception) {
                throw new DataFormatException("Invalid Labs: " + (String)object);
            }
        }
        String string = simpleElement.getAttribute(ARRANGEMENT_ATTRIBUTE);
        if (TABBED_VALUE.equals(string)) {
            string = simpleElement.getAttribute(TAB_COUNT_ATTRIBUTE);
            try {
                int n = Integer.parseInt(string);
                this.setTabbing(n, intSetArray);
            }
            catch (Exception exception) {
                throw new DataFormatException("Invalid TabCount: " + string);
            }
        } else if (TILED_VALUE.equals(string) && (simpleElement2 = simpleElement.getChildrenByTagName("Tiles")).getLength() > 0) {
            object = MJTiledPane.stateFromXML((SimpleElement)((SimpleElement)simpleElement2.item(0)));
            this.setTiling(null, object, intSetArray);
        }
        this.updateArrangementActions();
    }

    class TabListener
    extends MouseInputAdapter {
        TabListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        private void showContextMenu(MouseEvent mouseEvent) {
            int n = OutputOrganizer.this.fTabbedPane.indexFromMouse(mouseEvent);
            if (n == -1) {
                return;
            }
            final OutputWindow outputWindow = (OutputWindow)((Object)OutputOrganizer.this.fTabbedPane.getComponentAt(n));
            final IntSetPopup intSetPopup = new IntSetPopup(1, OutputOrganizer.this.fLabs.getNumLabs(), ParallelUI.sRes.getString("label.ThisLab"), ParallelUI.sRes.getString("title.SelectTargetLabs"));
            intSetPopup.setValue(outputWindow.getSources());
            intSetPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    outputWindow.setSources(intSetPopup.getValue());
                }
            });
        }
    }

    private class InterleaveOutputAction
    extends MJAbstractAction {
        public InterleaveOutputAction() {
            super(ParallelUI.sRes.getString("action.SingleOutputWindow"));
            this.setComponentName("InterleaveOutputs");
            this.setButtonOnlyIcon(new ImageIcon(OutputOrganizer.class.getResource("/com/mathworks/widgets/desk/resources/mdimax.gif")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OutputOrganizer.this.setTiling(new Dimension(1, 1));
        }
    }

    private class SelectTabCountAction
    extends ShowPickerAction {
        public SelectTabCountAction() {
            super(ParallelUI.sRes.getString("action.TabOutput"), true);
            this.setComponentName("TabOutputs");
            this.setButtonOnlyIcon(new ImageIcon(OutputOrganizer.class.getResource("resources/tabs.gif")));
        }
    }

    private class SelectTilingAction
    extends ShowPickerAction {
        public SelectTilingAction() {
            super(ParallelUI.sRes.getString("action.TileOutput"), false);
            this.setComponentName("TileOutputs");
            this.setButtonOnlyIcon(new ImageIcon(OutputOrganizer.class.getResource("/com/mathworks/widgets/desk/resources/tile.gif")));
        }
    }

    private class ShowPickerAction
    extends MJAbstractAction
    implements MenuListener {
        boolean iIsForTabs;
        MJDimensionPicker iPicker;
        Dimension iSize;

        ShowPickerAction(String string, boolean bl) {
            super(string);
            this.iIsForTabs = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = (Component)actionEvent.getSource();
            Window window = SwingUtilities.windowForComponent(component);
            OutputOrganizer.this.fFocusOwnerBeforePicker = window.getFocusOwner();
            MJDimensionPicker mJDimensionPicker = OutputOrganizer.this.createDimensionPicker(this.iIsForTabs);
            mJDimensionPicker.setAutoGrowEnabled(true);
            mJDimensionPicker.show(component, 0, component.getHeight());
            mJDimensionPicker.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    OutputOrganizer.this.updateArrangementActions();
                    if (OutputOrganizer.this.fFocusOwnerBeforePicker != null) {
                        OutputOrganizer.this.fFocusOwnerBeforePicker.requestFocusInWindow();
                        OutputOrganizer.this.fFocusOwnerBeforePicker = null;
                    }
                }
            });
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            if (this.iPicker == null) {
                this.iPicker = OutputOrganizer.this.createDimensionPicker(this.iIsForTabs);
                this.iPicker.setAutoGrowEnabled(true);
                this.iSize = this.iPicker.getPreferredSize();
                Insets insets = jMenu.getPopupMenu().getInsets();
                this.iSize.width += insets.left + insets.right;
                this.iSize.height += insets.top + insets.bottom;
                jMenu.add((Component)this.iPicker);
                this.iPicker.setInvokingMenu(jMenu);
            }
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            if (this.iPicker != null) {
                this.iPicker.setInvokingMenu(null);
                jMenu.remove((Component)this.iPicker);
                jMenu.getPopupMenu().setSize(this.iSize);
                this.iPicker = null;
            }
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
            this.menuDeselected(menuEvent);
        }
    }

    private static class TabbedPane
    extends MJTabbedPane
    implements OutputWindowContainer {
        private TabbedPane() {
        }

        @Override
        public int getWindowCount() {
            return this.getTabCount();
        }

        @Override
        public OutputWindow getWindow(int n) {
            return (OutputWindow)((Object)this.getComponentAt(n));
        }
    }

    private static class TiledPane
    extends MJTiledPane
    implements OutputWindowContainer,
    MenuContributor {
        TiledPane() {
            super(new Dimension(1, 1), 0, 5, 0);
        }

        @Override
        public int getWindowCount() {
            return this.getTileCount();
        }

        @Override
        public OutputWindow getWindow(int n) {
            return (OutputWindow)((Object)this.getComponentInTile(n));
        }

        @Override
        public void contributeToMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), (Component)((Object)this));
            this.getElementAt(point, 0, this.fElementData);
            if (jPopupMenu.getComponentCount() > 0) {
                jPopupMenu.addSeparator();
            }
            jPopupMenu.add(this.getSplitNorthSouthAction());
            jPopupMenu.add(this.getSplitEastWestAction());
            jPopupMenu.addPopupMenuListener(this.fPopupListener);
        }
    }

    private class PickerMenuListener
    implements MenuListener {
        boolean fForTabs;
        MJDimensionPicker fPicker;
        Dimension fSize;

        PickerMenuListener(boolean bl) {
            this.fForTabs = bl;
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            if (this.fPicker == null) {
                this.fPicker = OutputOrganizer.this.createDimensionPicker(this.fForTabs);
                this.fPicker.setAutoGrowEnabled(true);
                this.fSize = this.fPicker.getPreferredSize();
                Insets insets = jMenu.getPopupMenu().getInsets();
                this.fSize.width += insets.left + insets.right;
                this.fSize.height += insets.top + insets.bottom;
                jMenu.add((Component)this.fPicker);
                this.fPicker.setInvokingMenu(jMenu);
            }
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            if (this.fPicker != null) {
                this.fPicker.setInvokingMenu(null);
                jMenu.remove((Component)this.fPicker);
                jMenu.getPopupMenu().setSize(this.fSize);
                this.fPicker = null;
            }
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
            this.menuDeselected(menuEvent);
        }
    }

    private static interface OutputWindowContainer {
        public int getWindowCount();

        public OutputWindow getWindow(int var1);
    }
}

