/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.toolbox.distcomp.parallelui.ParallelUI;
import java.io.File;

public class OutputHyperLink {
    private LinkType fType;
    private String fTarget;
    private String fFilename;
    private int fLineNumber;
    private int fColumnNumber;
    private static final String MATLAB_LINK_START = "matlab:";
    private static final String ERROR_LINK_START = "error:";

    public OutputHyperLink(String string) {
        block9: {
            if (string.startsWith(MATLAB_LINK_START)) {
                this.fType = LinkType.MATLAB;
                this.fTarget = string.substring(MATLAB_LINK_START.length(), string.length());
            } else if (string.startsWith(ERROR_LINK_START)) {
                this.fType = LinkType.ERROR;
                this.fTarget = string.substring(ERROR_LINK_START.length(), string.length());
                int n = this.fTarget.indexOf(",");
                if (n == -1) {
                    this.fFilename = this.fTarget.trim();
                } else {
                    this.fFilename = this.fTarget.substring(0, n).trim();
                    try {
                        int n2 = this.fTarget.indexOf(",", n + 1);
                        if (n2 == -1) {
                            this.fLineNumber = new Integer(this.fTarget.substring(n + 1, this.fTarget.length()).trim());
                            break block9;
                        }
                        this.fLineNumber = new Integer(this.fTarget.substring(n + 1, n2).trim());
                        this.fColumnNumber = new Integer(this.fTarget.substring(n2 + 1, this.fTarget.length()).trim());
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.fType = LinkType.WEB;
                this.fTarget = string;
            }
        }
    }

    void follow() {
        switch (this.fType) {
            case MATLAB: {
                MLExecuteServices.consoleEval((String)this.fTarget);
                break;
            }
            case ERROR: {
                File file = new File(this.fFilename);
                if (!file.exists()) break;
                Editor editor = MLEditorServices.getEditorApplication().openEditor(file);
                editor.bringToFront();
                editor.goToLine(this.fLineNumber, this.fColumnNumber);
                break;
            }
            case WEB: {
                MLExecuteServices.consoleEval((String)("web('" + this.fTarget + "')"));
            }
        }
    }

    String getTip() {
        switch (this.fType) {
            case MATLAB: {
                return MATLAB_LINK_START + this.fTarget;
            }
            case ERROR: {
                return ParallelUI.sRes.getString("tip.ClickToOpenInEditor");
            }
            case WEB: {
                return this.fTarget;
            }
        }
        return "";
    }

    public String getTarget() {
        return this.fTarget;
    }

    public LinkType getLinkType() {
        return this.fType;
    }

    public static enum LinkType {
        MATLAB,
        ERROR,
        WEB;

    }
}

