/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.mathworks.mlwidgets.tabcompletion.TabCompletionAction;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionInterface;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionResult;
import com.mathworks.mwswing.AppearanceFocusDispatcher;
import com.mathworks.mwswing.AppearanceFocusEvent;
import com.mathworks.mwswing.AppearanceFocusListener;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.binding.Context;
import com.mathworks.mwswing.text.TextContextMenu;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.toolbox.distcomp.parallelui.Actions;
import com.mathworks.toolbox.distcomp.parallelui.CommandHistoryTable;
import com.mathworks.toolbox.distcomp.parallelui.ParallelCommandWindow;
import com.mathworks.toolbox.distcomp.parallelui.ParallelUI;
import com.mathworks.toolbox.distcomp.parallelui.Utilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.action.AbstractCopyAction;
import com.mathworks.widgets.action.AbstractCutAction;
import com.mathworks.widgets.action.AbstractPasteAction;
import com.mathworks.widgets.text.mcode.MKit;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.im.InputContext;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;

class CommandInputPane
extends SyntaxTextPane
implements Actions.Contributor {
    private ParallelCommandWindow fCommandWindow;
    private CommandHistoryTable fHistoryTable;
    private String fPartialCommand;
    private boolean fIsNavigatingHistory;
    private boolean fTabCompletionEnabled;
    private Action fCutAction;
    private Action fCopyAction;
    private TabCompletionAction fTabAction;
    private ActionListener fDefaultTabAction;
    private static final String CLEAR_ACTION_KEY = "clear-command";
    private static final String PREVIOUS_COMMAND_ACTION_KEY = "previous-command";
    private static final String NEXT_COMMAND_ACTION_KEY = "next-command";
    private static final String COMPLETE_COMMAND_ACTION_KEY = "complete-command";
    private static final String EVALUATE_SELECTION_ACTION_KEY = "evaluate-selection";

    CommandInputPane(ParallelCommandWindow parallelCommandWindow, CommandHistoryTable commandHistoryTable, Actions actions) {
        this.fCommandWindow = parallelCommandWindow;
        this.fHistoryTable = commandHistoryTable;
        this.registerEditorKit(MLanguage.INSTANCE.getMimeType(), (EditorKit)((Object)new SyntaxKitClass()));
        this.setContentType(MLanguage.INSTANCE.getMimeType());
        this.setShowLineNumbers(false, false);
        this.setContextMenuEnabled(true, false);
        this.setSyntaxHighlightingEnabled(MLanguage.INSTANCE, true);
        this.setBorder(BorderFactory.createEmptyBorder());
        InputMap inputMap = this.getInputMap(0);
        InputMap inputMap2 = new InputMap();
        inputMap2.put(KeyStroke.getKeyStroke(27, 0), CLEAR_ACTION_KEY);
        inputMap2.put(KeyStroke.getKeyStroke(85, 2), CLEAR_ACTION_KEY);
        inputMap2.put(KeyStroke.getKeyStroke(80, 2), PREVIOUS_COMMAND_ACTION_KEY);
        inputMap2.put(KeyStroke.getKeyStroke(78, 2), NEXT_COMMAND_ACTION_KEY);
        inputMap2.put(KeyStroke.getKeyStroke(65, 2), "caret-begin-line");
        inputMap2.put(KeyStroke.getKeyStroke(69, 2), "caret-end-line");
        inputMap2.put(Utilities.getEvalStroke(), EVALUATE_SELECTION_ACTION_KEY);
        if (PlatformInfo.isUnix()) {
            inputMap2.put(KeyStroke.getKeyStroke(88, 2), "cut-to-clipboard");
            inputMap2.put(KeyStroke.getKeyStroke(67, 2), "copy-command-selection");
            inputMap2.put(KeyStroke.getKeyStroke(86, 2), "paste-from-clipboard");
        }
        inputMap2.setParent(inputMap);
        this.setInputMap(0, inputMap2);
        this.getActionMap().put(CLEAR_ACTION_KEY, (Action)((Object)new ClearAction()));
        this.getActionMap().put(PREVIOUS_COMMAND_ACTION_KEY, (Action)((Object)new PreviousCommandAction()));
        this.getActionMap().put(NEXT_COMMAND_ACTION_KEY, (Action)((Object)new NextCommandAction()));
        this.getActionMap().put("copy-to-clipboard", (Action)((Object)new CopyCommandSelectionAction()));
        this.getActionMap().put("copy-command-selection", (Action)((Object)new CopyCommandSelectionAction()));
        this.getActionMap().put(EVALUATE_SELECTION_ACTION_KEY, (Action)((Object)new EvaluateSelectionAction()));
        this.addKeyListener(new KeyHandler());
        this.setTabCompletionEnabled(ParallelUI.isTabCompletionEnabled());
        this.fHistoryTable.setSelectionAppearanceReflectsFocus(false);
        AppearanceFocusDispatcher appearanceFocusDispatcher = new AppearanceFocusDispatcher();
        appearanceFocusDispatcher.addAppearanceFocusListener((AppearanceFocusListener)new HistoryAppearanceFocusListener());
        this.addFocusListener((FocusListener)appearanceFocusDispatcher);
        SelectionMediator selectionMediator = new SelectionMediator();
        this.fHistoryTable.getSelectionModel().addListSelectionListener(selectionMediator);
        this.addCaretListener(selectionMediator);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.documentChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.documentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.documentChanged();
            }

            private void documentChanged() {
                if (!CommandInputPane.this.fIsNavigatingHistory) {
                    CommandInputPane.this.fPartialCommand = null;
                    CommandInputPane.this.fHistoryTable.clearSelection();
                }
            }
        });
        actions.registerContribution(Actions.Type.CUT, this);
        actions.registerContribution(Actions.Type.COPY, this);
        actions.registerContribution(Actions.Type.PASTE, this);
        actions.registerContribution(Actions.Type.SELECT_ALL, this);
    }

    boolean isTabCompletionEnabled() {
        return this.fTabCompletionEnabled;
    }

    private void setTabCompletionEnabled(boolean bl) {
        if (this.fTabCompletionEnabled != bl) {
            this.fTabCompletionEnabled = bl;
            if (bl) {
                if (this.fTabAction == null) {
                    this.fTabAction = new TabCompletionAction((TabCompletionInterface)new LocalTabInterface());
                }
                if (this.fDefaultTabAction == null) {
                    this.fDefaultTabAction = this.getActionForKeyStroke(KeyStroke.getKeyStroke(9, 0));
                }
                this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), COMPLETE_COMMAND_ACTION_KEY);
                this.getActionMap().put(COMPLETE_COMMAND_ACTION_KEY, (Action)this.fTabAction);
            }
        }
    }

    public MJPopupMenu getContextMenu() {
        return TextContextMenu.getSharedInstance();
    }

    void suspend() {
        this.setText("");
        this.setEnabled(false);
    }

    void resume() {
        this.setEnabled(true);
    }

    @Override
    public Action getAction(Actions.Type type) {
        switch (type) {
            case CUT: {
                if (this.fCutAction == null) {
                    this.fCutAction = new CutAction();
                }
                return this.fCutAction;
            }
            case COPY: {
                if (this.fCopyAction == null) {
                    this.fCopyAction = new CopyAction();
                }
                return this.fCopyAction;
            }
            case PASTE: {
                return new PasteAction();
            }
            case SELECT_ALL: {
                return new SelectAllAction();
            }
        }
        return null;
    }

    @Override
    public Component getActionFocusComponent() {
        return this;
    }

    private void evaluate() {
        if (this.fHistoryTable.getSelectedRowCount() > 0) {
            this.fHistoryTable.evaluateSelectedCommands();
        } else {
            try {
                String[] stringArray = new String[this.getNumLines()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = this.getLineTextNoEOL(i);
                }
                this.fCommandWindow.evaluate(stringArray);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        this.clear();
    }

    private void evaluateSelection() {
        if (this.fHistoryTable.getSelectedRowCount() > 0) {
            this.fHistoryTable.evaluateSelectedCommands();
        } else {
            try {
                int n;
                int n2 = this.getSelectionStart();
                int n3 = this.getSelectionEnd();
                if (n2 == n3) {
                    return;
                }
                int n4 = this.getLineFromPos(n2);
                int n5 = this.getLineFromPos(n3);
                int n6 = n5 - n4 + 1;
                String[] stringArray = new String[n6];
                stringArray[0] = this.getText(n2, this.getLineEndNoEOL(n4) - n2);
                for (n = 1; n < n6 - 1; ++n) {
                    stringArray[n] = this.getLineTextNoEOL(n4 + n);
                }
                if (n6 > 1) {
                    n = this.getLineStart(n5);
                    stringArray[n6 - 1] = this.getText(n, n3 - n);
                }
                this.fCommandWindow.evaluate(stringArray);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    private void addToBuffer() {
        if (this.fHistoryTable.getSelectedRowCount() > 1) {
            this.setText(this.fHistoryTable.getSelectedString());
        } else {
            try {
                Document document = this.getDocument();
                int n = this.getCaretPosition();
                int n2 = this.getLineFromPos(n);
                if (n2 == this.getNumLines() - 1) {
                    n = document.getLength();
                }
                document.insertString(n, "\n", null);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    void clear() {
        this.clearCommandText();
        this.fHistoryTable.clearSelection();
    }

    void clearCommandText() {
        this.setText("");
        this.fPartialCommand = null;
    }

    private void selectPrevious() {
        int n;
        if (this.fHistoryTable.getRowCount() == 0) {
            return;
        }
        this.fIsNavigatingHistory = true;
        if (this.fPartialCommand == null) {
            this.fPartialCommand = this.getText();
        }
        if ((n = this.fHistoryTable.rowOfPreviousMatch(this.fPartialCommand, false)) == -1) {
            if (this.fPartialCommand.length() > 0) {
                this.setText(this.fPartialCommand);
            }
        } else {
            this.setText(this.fHistoryTable.getCommand(n));
            this.fHistoryTable.setRowSelectionInterval(n, n);
            this.fHistoryTable.scrollRectToVisible(this.fHistoryTable.getCellRect(n, 0, true));
        }
        this.fIsNavigatingHistory = false;
    }

    private void selectNext() {
        int n;
        if (this.fHistoryTable.getRowCount() == 0) {
            return;
        }
        this.fIsNavigatingHistory = true;
        if (this.fPartialCommand == null) {
            this.fPartialCommand = this.getText();
        }
        if ((n = this.fHistoryTable.rowOfNextMatch(this.fPartialCommand, false)) == -1) {
            if (this.fPartialCommand.length() > 0) {
                this.setText(this.fPartialCommand);
            } else {
                this.setText("");
            }
            this.fHistoryTable.clearSelection();
        } else {
            this.setText(this.fHistoryTable.getCommand(n));
            this.fHistoryTable.setRowSelectionInterval(n, n);
            this.fHistoryTable.scrollRectToVisible(this.fHistoryTable.getCellRect(n, 0, true));
        }
        this.fIsNavigatingHistory = false;
    }

    private void extendToPrevious() {
        if (this.fHistoryTable.getRowCount() == 0) {
            return;
        }
        this.fIsNavigatingHistory = true;
        if (this.fPartialCommand == null) {
            this.fPartialCommand = this.getText();
        }
        int n = this.fHistoryTable.getRowCount();
        int n2 = this.fHistoryTable.getSelectedRowCount();
        int n3 = this.fHistoryTable.getLastEvaluateCount();
        if (this.fPartialCommand.length() == 0 && n2 == 0 && n3 > 1 && n3 <= this.fHistoryTable.getRowCount()) {
            this.fHistoryTable.setRowSelectionInterval(n - n3, n - 1);
            this.fHistoryTable.scrollRectToVisible(this.fHistoryTable.getCellRect(n - n3, 0, true));
        } else {
            int n4 = this.fHistoryTable.rowOfPreviousMatch(this.fPartialCommand, true);
            if (n4 != -1) {
                if (n2 > 0) {
                    this.fHistoryTable.addRowSelectionInterval(n4, this.fHistoryTable.getSelectionModel().getMinSelectionIndex() - 1);
                } else {
                    this.fHistoryTable.setRowSelectionInterval(n4, n - 1);
                }
                this.setText(this.fHistoryTable.getCommand(n4));
                this.fHistoryTable.scrollRectToVisible(this.fHistoryTable.getCellRect(n4, 0, true));
            }
        }
        this.fIsNavigatingHistory = false;
    }

    private void extendToNext() {
        int n;
        if (this.fHistoryTable.getRowCount() == 0) {
            return;
        }
        this.fIsNavigatingHistory = true;
        if (this.fPartialCommand == null) {
            this.fPartialCommand = this.getText();
        }
        if ((n = this.fHistoryTable.rowOfNextMatch(this.fPartialCommand, true)) != -1) {
            this.fHistoryTable.addRowSelectionInterval(this.fHistoryTable.getSelectionModel().getMaxSelectionIndex() + 1, n);
            this.fHistoryTable.scrollRectToVisible(this.fHistoryTable.getCellRect(n, 0, true));
        } else if (this.fPartialCommand == null || this.fPartialCommand.length() == 0 && this.fHistoryTable.getSelectedRowCount() > 0) {
            int n2 = this.fHistoryTable.getSelectedRow();
            this.fHistoryTable.removeRowSelectionInterval(n2, n2);
        }
        this.fIsNavigatingHistory = false;
    }

    private class LocalTabInterface
    implements TabCompletionInterface {
        private LocalTabInterface() {
        }

        public JTextComponent getComponent() {
            return CommandInputPane.this;
        }

        public int getTabCompletionStartOffset() {
            return 0;
        }

        public JScrollPane getScrollPane() {
            return null;
        }

        public void processKey(KeyEvent keyEvent) {
            CommandInputPane.this.processKeyEvent(keyEvent);
        }

        public boolean isTabCompletionEnabled() {
            return CommandInputPane.this.fTabCompletionEnabled;
        }

        public ActionListener getDefaultInsertTabAction() {
            return CommandInputPane.this.fDefaultTabAction;
        }

        public boolean isComposing() {
            boolean bl = false;
            InputContext inputContext = this.getComponent().getInputContext();
            if (inputContext != null) {
                try {
                    bl = inputContext.isCompositionEnabled();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            return bl;
        }

        public void tabCompletionStarted() {
        }

        public List<TabCompletionResult> getAdditionalTabCompletions(int n, String string) {
            return Collections.emptyList();
        }

        public Context getKeybindingContext() {
            return MatlabKeyBindings.getManager().getContext("CommandWindow");
        }
    }

    public static class SyntaxKitClass
    extends MKit {
        public String getContentType() {
            return MLanguage.INSTANCE.getMimeType();
        }
    }

    private class SelectionMediator
    implements CaretListener,
    ListSelectionListener {
        private SelectionMediator() {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            boolean bl;
            if (caretEvent.getDot() != caretEvent.getMark()) {
                CommandInputPane.this.fHistoryTable.clearSelection();
                bl = true;
            } else {
                boolean bl2 = bl = CommandInputPane.this.fHistoryTable.getSelectedRowCount() > 0;
            }
            if (CommandInputPane.this.fCutAction != null) {
                CommandInputPane.this.fCutAction.setEnabled(bl);
            }
            if (CommandInputPane.this.fCopyAction != null) {
                CommandInputPane.this.fCopyAction.setEnabled(bl);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl;
            if (CommandInputPane.this.fHistoryTable.getSelectedRowCount() > 0) {
                CommandInputPane.this.getCaret().setDot(CommandInputPane.this.getCaret().getMark());
                bl = true;
            } else {
                boolean bl2 = bl = CommandInputPane.this.getSelectionStart() != CommandInputPane.this.getSelectionEnd();
            }
            if (CommandInputPane.this.fCutAction != null) {
                CommandInputPane.this.fCutAction.setEnabled(bl);
            }
            if (CommandInputPane.this.fCopyAction != null) {
                CommandInputPane.this.fCopyAction.setEnabled(bl);
            }
        }
    }

    private class HistoryAppearanceFocusListener
    implements AppearanceFocusListener {
        private HistoryAppearanceFocusListener() {
        }

        public void appearanceFocusLost(AppearanceFocusEvent appearanceFocusEvent) {
            CommandInputPane.this.fHistoryTable.useUnfocusedSelectionColors();
        }

        public void appearanceFocusGained(AppearanceFocusEvent appearanceFocusEvent) {
            CommandInputPane.this.fHistoryTable.useFocusedSelectionColors();
        }
    }

    private class KeyHandler
    implements KeyListener {
        boolean iForwardSubsequent;
        boolean iConsumeSubsequent;

        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.iForwardSubsequent = false;
            this.iConsumeSubsequent = false;
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getModifiers();
            if (n == 10) {
                if (n2 == 0) {
                    CommandInputPane.this.evaluate();
                } else if (n2 == 1) {
                    CommandInputPane.this.addToBuffer();
                } else {
                    return;
                }
                keyEvent.consume();
                this.iConsumeSubsequent = true;
                return;
            }
            if (n == 27) {
                CommandInputPane.this.clear();
                keyEvent.consume();
                this.iConsumeSubsequent = true;
                return;
            }
            if (n == 65 && n2 == 2 && CommandInputPane.this.getNumLines() == 1 && CommandInputPane.this.getCaretPosition() == 0) {
                CommandInputPane.this.fHistoryTable.selectAll();
                keyEvent.consume();
                this.iConsumeSubsequent = true;
                return;
            }
            if (CommandInputPane.this.fHistoryTable.getRowCount() == 0 || CommandInputPane.this.getNumLines() > 1) {
                return;
            }
            if (n == 38) {
                if (n2 == 0) {
                    CommandInputPane.this.selectPrevious();
                } else if (n2 == 1) {
                    CommandInputPane.this.extendToPrevious();
                } else {
                    return;
                }
                keyEvent.consume();
                this.iConsumeSubsequent = true;
                return;
            }
            if (n == 40) {
                if (n2 == 0) {
                    CommandInputPane.this.selectNext();
                } else if (n2 == 1) {
                    CommandInputPane.this.extendToNext();
                } else {
                    return;
                }
                keyEvent.consume();
                this.iConsumeSubsequent = true;
                return;
            }
            if (!(n != 33 && n != 34 || n2 != 0 && n2 != 1)) {
                CommandInputPane.this.setText("");
                CommandInputPane.this.fHistoryTable.dispatchEvent(keyEvent);
                keyEvent.consume();
                this.iForwardSubsequent = true;
                return;
            }
            if (n2 == 0 || n2 == 1) {
                if (n == 36 && CommandInputPane.this.getCaretPosition() == 0) {
                    CommandInputPane.this.setText("");
                    if (n2 == 0) {
                        CommandInputPane.this.fHistoryTable.setRowSelectionInterval(0, 0);
                    } else {
                        int n3 = CommandInputPane.this.fHistoryTable.getSelectionModel().getMinSelectionIndex();
                        if (n3 > 0) {
                            CommandInputPane.this.fHistoryTable.addRowSelectionInterval(0, n3);
                        }
                    }
                    CommandInputPane.this.fHistoryTable.scrollToTop();
                    keyEvent.consume();
                    this.iConsumeSubsequent = true;
                } else if (n == 35 && CommandInputPane.this.getCaretPosition() == CommandInputPane.this.getDocument().getLength()) {
                    int n4 = CommandInputPane.this.fHistoryTable.getRowCount();
                    if (n2 == 0) {
                        CommandInputPane.this.fHistoryTable.setRowSelectionInterval(n4 - 1, n4 - 1);
                    } else {
                        int n5 = CommandInputPane.this.fHistoryTable.getSelectionModel().getMaxSelectionIndex();
                        if (n5 < n4 - 1) {
                            CommandInputPane.this.fHistoryTable.addRowSelectionInterval(n5, n4 - 1);
                        }
                    }
                    CommandInputPane.this.fHistoryTable.scrollToBottom();
                    keyEvent.consume();
                    this.iConsumeSubsequent = true;
                }
            }
            if (n == 127 && n2 == 0 && CommandInputPane.this.getCaretPosition() == CommandInputPane.this.getDocument().getLength() && CommandInputPane.this.fHistoryTable.getSelectedRowCount() > 0) {
                CommandInputPane.this.fHistoryTable.deleteSelectedCommands();
                CommandInputPane.this.setText("");
                keyEvent.consume();
                this.iConsumeSubsequent = true;
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (this.iConsumeSubsequent) {
                keyEvent.consume();
            } else if (this.iForwardSubsequent) {
                CommandInputPane.this.fHistoryTable.dispatchEvent(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (this.iConsumeSubsequent) {
                keyEvent.consume();
            } else if (this.iForwardSubsequent) {
                CommandInputPane.this.fHistoryTable.dispatchEvent(keyEvent);
            }
        }
    }

    private class EvaluateSelectionAction
    extends MJAbstractAction {
        private EvaluateSelectionAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CommandInputPane.this.evaluateSelection();
        }
    }

    private class NextCommandAction
    extends MJAbstractAction {
        private NextCommandAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CommandInputPane.this.selectNext();
        }
    }

    private class PreviousCommandAction
    extends MJAbstractAction {
        private PreviousCommandAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CommandInputPane.this.selectPrevious();
        }
    }

    private class ClearAction
    extends MJAbstractAction {
        private ClearAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CommandInputPane.this.clear();
        }
    }

    private class CopyCommandSelectionAction
    extends MJAbstractAction
    implements CaretListener {
        CopyCommandSelectionAction() {
            this.caretUpdate(null);
            CommandInputPane.this.addCaretListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CommandInputPane.this.copy();
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            this.setEnabled(CommandInputPane.this.getSelectionStart() != CommandInputPane.this.getSelectionEnd());
        }
    }

    private class SelectAllAction
    extends MJAbstractAction {
        private SelectAllAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (CommandInputPane.this.getDocument().getLength() > 0) {
                CommandInputPane.this.selectAll();
            } else {
                CommandInputPane.this.fHistoryTable.selectAll();
            }
        }
    }

    private class PasteAction
    extends AbstractPasteAction {
        PasteAction() {
            super(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CommandInputPane.this.paste();
        }
    }

    private class CopyAction
    extends AbstractCopyAction {
        CopyAction() {
            this.clearKeyBinding();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (CommandInputPane.this.getSelectionStart() != CommandInputPane.this.getSelectionEnd()) {
                CommandInputPane.this.copy();
            } else if (CommandInputPane.this.fHistoryTable.getSelectedRowCount() > 0) {
                CommandInputPane.this.fHistoryTable.copySelectedCommands();
            }
        }
    }

    private class CutAction
    extends AbstractCutAction {
        private CutAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (CommandInputPane.this.getSelectionStart() != CommandInputPane.this.getSelectionEnd()) {
                CommandInputPane.this.cut();
            } else if (CommandInputPane.this.fHistoryTable.getSelectedRowCount() > 0) {
                CommandInputPane.this.fHistoryTable.cutSelectedCommands();
            }
        }
    }
}

