/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.datastore;

import com.mathworks.toolbox.distcomp.mjs.datastore.LargeData;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class ByteBufferItem
implements LargeData {
    protected transient ByteBufferHandle fBufferHandle;

    public ByteBufferItem(ByteBuffer byteBuffer) {
        this.fBufferHandle = ByteBufferHandle.wrap(byteBuffer);
    }

    public ByteBufferItem(int n) {
        this.fBufferHandle = ByteBufferHandle.allocateDirect(n);
    }

    public synchronized ByteBuffer getData() {
        return this.fBufferHandle.get().asReadOnlyBuffer();
    }

    @Override
    public synchronized int getNumBytes() {
        return this.fBufferHandle.get().limit();
    }

    public synchronized void rewind() {
        this.fBufferHandle.get().rewind();
    }

    public synchronized void delete() {
        this.fBufferHandle.get().clear();
        this.fBufferHandle.get().limit(0);
        this.fBufferHandle.free();
    }

    public synchronized byte[] getData(int n) {
        int n2 = this.fBufferHandle.get().remaining();
        int n3 = Math.min(n2, n);
        byte[] byArray = new byte[n3];
        this.fBufferHandle.get().get(byArray);
        return byArray;
    }

    public synchronized void putData(byte[] byArray) throws BufferOverflowException {
        if (byArray != null) {
            this.fBufferHandle.get().put(byArray);
        }
    }
}

