/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.cwo;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.mjs.cwo.Log;
import com.mathworks.toolbox.distcomp.mjs.cwo.TaskCWOStreamIdentifier;
import com.mathworks.toolbox.distcomp.mjs.cwo.TaskInputStreamHandler;
import com.mathworks.toolbox.distcomp.mjs.cwo.WriteFailedException;
import com.mathworks.toolbox.distcomp.mjs.cwo.WriteRequestor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CWOInputStreamHandler
implements TaskInputStreamHandler {
    private final Map<TaskCWOStreamIdentifier, InputStream> fActiveStreams = new HashMap<TaskCWOStreamIdentifier, InputStream>();
    private final Map<TaskCWOStreamIdentifier, InputStream> fInactiveStreams = new HashMap<TaskCWOStreamIdentifier, InputStream>();
    private final Collection<TaskCWOStreamIdentifier> fFinishedStreams = new HashSet<TaskCWOStreamIdentifier>();
    private final Map<TaskCWOStreamIdentifier, InputStream> fPendingRegistrations = new HashMap<TaskCWOStreamIdentifier, InputStream>();
    private final Collection<TaskCWOStreamIdentifier> fPendingUnregistrations = new HashSet<TaskCWOStreamIdentifier>();
    private final Collection<TaskCWOStreamIdentifier> fPendingNotifications = new HashSet<TaskCWOStreamIdentifier>();
    private final int fMaxBytesToTransfer;
    private final byte[] fReadBuffer;
    private final WriteRequestor fWriteRequestor;
    private final Lock fLock = new ReentrantLock();
    private final Condition fHasPendingNotifications = this.fLock.newCondition();
    private final Condition fStreamRemoved = this.fLock.newCondition();

    public CWOInputStreamHandler(WriteRequestor writeRequestor, int n) {
        this.fWriteRequestor = writeRequestor;
        this.fMaxBytesToTransfer = n;
        this.fReadBuffer = new byte[this.fMaxBytesToTransfer];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerStreamForTask(TaskCWOStreamIdentifier taskCWOStreamIdentifier, InputStream inputStream) {
        Log.LOGGER.fine("Registering input stream with CWOInputStreamHandler for task: " + taskCWOStreamIdentifier);
        this.fLock.lock();
        try {
            this.fPendingRegistrations.put(taskCWOStreamIdentifier, inputStream);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterStreamForTask(TaskCWOStreamIdentifier taskCWOStreamIdentifier) {
        Log.LOGGER.fine("Unregistering input stream with CWOInputStreamHandler for task: " + taskCWOStreamIdentifier);
        this.fLock.lock();
        try {
            this.fPendingUnregistrations.add(taskCWOStreamIdentifier);
            this.fHasPendingNotifications.signalAll();
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForBytes() throws InterruptedException {
        this.fLock.lock();
        try {
            while (this.fPendingNotifications.isEmpty() && this.fFinishedStreams.isEmpty() && this.fActiveStreams.isEmpty()) {
                Log.LOGGER.log(DistcompLevel.FOUR, "Waiting for notifications of new bytes");
                this.fHasPendingNotifications.await();
                Log.LOGGER.log(DistcompLevel.FOUR, "Notified of new bytes");
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public boolean shutdown(long l) throws InterruptedException {
        return this.waitForStreamsToFinish(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForStreamsToFinish(long l) throws InterruptedException {
        this.fLock.lock();
        try {
            boolean bl = false;
            while (!(this.fFinishedStreams.isEmpty() && this.fActiveStreams.isEmpty() && this.fInactiveStreams.isEmpty())) {
                Log.LOGGER.log(DistcompLevel.FIVE, "Waiting for streams to finish. Current finished: " + this.fFinishedStreams.size() + ", current active: " + this.fActiveStreams.size() + ", current inactive: " + this.fInactiveStreams.size());
                bl = this.fStreamRemoved.await(l, TimeUnit.MILLISECONDS);
                if (bl) continue;
                boolean bl2 = bl;
                return bl2;
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void readAvailableBytesFromStreams() throws IOException {
        this.applyPendingStateChanges();
        HashSet<TaskCWOStreamIdentifier> hashSet = new HashSet<TaskCWOStreamIdentifier>();
        ArrayList<TaskCWOStreamIdentifier> arrayList = new ArrayList<TaskCWOStreamIdentifier>();
        for (Map.Entry<TaskCWOStreamIdentifier, InputStream> entry : this.fActiveStreams.entrySet()) {
            int n;
            InputStream inputStream = entry.getValue();
            TaskCWOStreamIdentifier taskCWOStreamIdentifier = entry.getKey();
            try {
                n = inputStream.read(this.fReadBuffer);
            }
            catch (IOException iOException) {
                Log.LOGGER.log(DistcompLevel.ONE, "IOException reading from remote stream", iOException);
                arrayList.add(taskCWOStreamIdentifier);
                hashSet.add(taskCWOStreamIdentifier);
                continue;
            }
            if (n > 0) {
                Log.LOGGER.finer(n + " bytes read from " + entry);
                if (n < this.fMaxBytesToTransfer) {
                    this.writeBytes(taskCWOStreamIdentifier, Arrays.copyOfRange(this.fReadBuffer, 0, n));
                } else {
                    this.writeBytes(taskCWOStreamIdentifier, Arrays.copyOf(this.fReadBuffer, n));
                }
            }
            if (n >= this.fMaxBytesToTransfer) continue;
            Log.LOGGER.log(DistcompLevel.SIX, "Read fewer bytes than requested setting task " + taskCWOStreamIdentifier + " inactive");
            arrayList.add(taskCWOStreamIdentifier);
        }
        this.handleFinishedAndInactiveStreams(arrayList, hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyBytesAvailable(TaskCWOStreamIdentifier taskCWOStreamIdentifier) {
        this.fLock.lock();
        try {
            Log.LOGGER.log(DistcompLevel.SIX, "Received a notification for " + taskCWOStreamIdentifier);
            this.fPendingNotifications.add(taskCWOStreamIdentifier);
            this.fHasPendingNotifications.signalAll();
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFinishedAndInactiveStreams(Iterable<TaskCWOStreamIdentifier> iterable, Iterable<TaskCWOStreamIdentifier> iterable2) {
        this.fLock.lock();
        try {
            this.makeStreamsInactive(iterable);
            this.removeInactiveFinishedStreams(iterable2);
        }
        finally {
            this.fLock.unlock();
        }
    }

    private void makeStreamsInactive(Iterable<TaskCWOStreamIdentifier> iterable) {
        for (TaskCWOStreamIdentifier taskCWOStreamIdentifier : iterable) {
            assert (!this.fInactiveStreams.containsKey(taskCWOStreamIdentifier)) : "Read from an already inactive stream";
            if (this.fInactiveStreams.containsKey(taskCWOStreamIdentifier)) {
                Log.LOGGER.log(DistcompLevel.ONE, "Read from an already inactive stream: " + taskCWOStreamIdentifier);
            }
            if (!this.fPendingNotifications.contains(taskCWOStreamIdentifier)) {
                Log.LOGGER.log(DistcompLevel.SIX, "No pending notifications for task " + taskCWOStreamIdentifier + " -- marking inactive");
                this.fInactiveStreams.put(taskCWOStreamIdentifier, this.fActiveStreams.remove(taskCWOStreamIdentifier));
                continue;
            }
            Log.LOGGER.log(DistcompLevel.SIX, "Had pending notification for task " + taskCWOStreamIdentifier + " -- not marking inactive");
        }
    }

    private void removeInactiveFinishedStreams(Iterable<TaskCWOStreamIdentifier> iterable) {
        for (TaskCWOStreamIdentifier taskCWOStreamIdentifier : iterable) {
            InputStream inputStream = this.fInactiveStreams.remove(taskCWOStreamIdentifier);
            if (inputStream == null) continue;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                Log.LOGGER.log(DistcompLevel.FOUR, "Failed to close stream due to an IOException: ", iOException);
            }
            Log.LOGGER.log(DistcompLevel.FOUR, "Removing finished stream for: " + taskCWOStreamIdentifier);
            this.fFinishedStreams.remove(taskCWOStreamIdentifier);
            this.fStreamRemoved.signalAll();
        }
    }

    private void writeBytes(TaskCWOStreamIdentifier taskCWOStreamIdentifier, byte[] byArray) {
        try {
            this.fWriteRequestor.write(taskCWOStreamIdentifier.getTaskUuid(), byArray);
        }
        catch (WriteFailedException writeFailedException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to write bytes for: " + taskCWOStreamIdentifier, writeFailedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPendingStateChanges() {
        this.fLock.lock();
        try {
            this.processRegistrations();
            this.handleNotifications();
        }
        finally {
            this.fLock.unlock();
        }
    }

    private void handleNotifications() {
        for (TaskCWOStreamIdentifier taskCWOStreamIdentifier : this.fPendingNotifications) {
            Log.LOGGER.log(DistcompLevel.SIX, "Processing notification for " + taskCWOStreamIdentifier);
            if (this.fInactiveStreams.containsKey(taskCWOStreamIdentifier)) {
                Log.LOGGER.log(DistcompLevel.SIX, taskCWOStreamIdentifier + " was inactive -- making active");
                this.fActiveStreams.put(taskCWOStreamIdentifier, this.fInactiveStreams.remove(taskCWOStreamIdentifier));
                continue;
            }
            if (this.fActiveStreams.containsKey(taskCWOStreamIdentifier)) {
                Log.LOGGER.log(DistcompLevel.SIX, taskCWOStreamIdentifier + " was already active");
                continue;
            }
            Log.LOGGER.log(DistcompLevel.ONE, "Inconsistent state in CWOInputStreamHandler, lost reference to: " + taskCWOStreamIdentifier);
        }
        this.fPendingNotifications.clear();
    }

    private void processRegistrations() {
        for (Map.Entry<TaskCWOStreamIdentifier, InputStream> object : this.fPendingRegistrations.entrySet()) {
            this.fInactiveStreams.put(object.getKey(), object.getValue());
        }
        this.fPendingRegistrations.clear();
        for (TaskCWOStreamIdentifier taskCWOStreamIdentifier : this.fPendingUnregistrations) {
            this.fFinishedStreams.add(taskCWOStreamIdentifier);
        }
        this.fPendingUnregistrations.clear();
    }
}

