/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.logging;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public final class SocketLogRecordHandler
extends Handler {
    private final Socket fSocket;
    private final ObjectOutputStream fObjectOutputStream;

    private SocketLogRecordHandler(Socket socket) throws IOException {
        this.fSocket = socket;
        this.fObjectOutputStream = new ObjectOutputStream(new BufferedOutputStream(this.fSocket.getOutputStream()));
    }

    private SocketLogRecordHandler(String string, int n) throws IOException {
        this(new Socket(string, n));
    }

    public SocketLogRecordHandler(int n) throws IOException {
        this("localhost", n);
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        try {
            this.fObjectOutputStream.writeObject(logRecord);
        }
        catch (Exception exception) {
            this.reportError(logRecord.getMessage(), exception, 1);
        }
        this.flush();
    }

    @Override
    public void flush() {
        try {
            this.fObjectOutputStream.flush();
            this.fObjectOutputStream.reset();
        }
        catch (Exception exception) {
            this.reportError(null, exception, 2);
        }
    }

    @Override
    public void close() throws SecurityException {
        try {
            this.fSocket.close();
        }
        catch (Exception exception) {
            this.reportError(null, exception, 3);
        }
    }

    public String toString() {
        return "SocketStreamHandler{fSocket=" + this.fSocket + '}';
    }
}

