/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.toolbox.distcomp.auth.AuthorisationModule;
import com.mathworks.toolbox.distcomp.jobmanager.TaskDispatcher;
import com.mathworks.toolbox.distcomp.jobmanager.permissions.PermissionChecker;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.pml.ParallelJobImpl;
import com.mathworks.toolbox.distcomp.service.ExporterFactory;
import com.mathworks.toolbox.distcomp.storage.JobManagerStorage;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import net.jini.id.Uuid;

public class TaskDispatcherForParallelJobs
extends TaskDispatcher {
    private static TaskDispatcherForParallelJobs sTaskDispatcherForParallelJobs = null;

    private TaskDispatcherForParallelJobs(JobManagerStorage jobManagerStorage, AuthorisationModule authorisationModule, ExporterFactory exporterFactory, PermissionChecker permissionChecker) {
        super(jobManagerStorage, authorisationModule, exporterFactory, permissionChecker);
    }

    static void init(JobManagerStorage jobManagerStorage, AuthorisationModule authorisationModule, ExporterFactory exporterFactory, PermissionChecker permissionChecker) {
        if (sTaskDispatcherForParallelJobs == null) {
            sTaskDispatcherForParallelJobs = new TaskDispatcherForParallelJobs(jobManagerStorage, authorisationModule, exporterFactory, permissionChecker);
        }
    }

    static void clear() {
        sTaskDispatcherForParallelJobs = null;
    }

    public static TaskDispatcherForParallelJobs instance() {
        return sTaskDispatcherForParallelJobs;
    }

    @Override
    protected int dispatchTasks(Uuid uuid, int n, boolean bl, Uuid[] uuidArray, int n2) {
        return this.dispatchTasksOfParallelJobs(uuid, n, bl, uuidArray, n2);
    }

    private int dispatchTasksOfParallelJobs(Uuid uuid, int n, boolean bl, Uuid[] uuidArray, int n2) {
        ParallelJobImpl parallelJobImpl;
        try {
            parallelJobImpl = (ParallelJobImpl)this.fStorage.readWorkUnit(uuid);
        }
        catch (WorkUnitNotFoundException workUnitNotFoundException) {
            return 0;
        }
        ArrayList<Uuid> arrayList = new ArrayList<Uuid>(Arrays.asList(uuidArray));
        int n3 = this.dispatchTasks(uuid, n, bl, arrayList, n2);
        if (n3 != 1) {
            return 0;
        }
        int n4 = Math.min(arrayList.size(), n2 -= n3);
        try {
            parallelJobImpl.createCopiesOfTask(n4);
        }
        catch (MJSException mJSException) {
            parallelJobImpl.setNumLabs(n3);
            return n3;
        }
        int n5 = this.dispatchTasks(uuid, n, bl, arrayList, n2);
        parallelJobImpl.destroyPendingTasks();
        int n6 = n3 + n5;
        parallelJobImpl.setNumLabs(n6);
        return n6;
    }
}

