/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.cwo;

import com.mathworks.toolbox.distcomp.cwo.WriterStackException;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import org.apache.commons.io.output.NullWriter;

public class WriterStack
extends Writer {
    private LinkedList<Writer> fWriters = new LinkedList();
    private Writer fCurrentWriter;

    public WriterStack() {
        NullWriter nullWriter = new NullWriter();
        this.fWriters.add((Writer)nullWriter);
        this.fCurrentWriter = nullWriter;
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.fCurrentWriter.write(n);
    }

    @Override
    public synchronized void write(char[] cArray) throws IOException {
        this.fCurrentWriter.write(cArray);
    }

    @Override
    public synchronized void write(char[] cArray, int n, int n2) throws IOException {
        this.fCurrentWriter.write(cArray, n, n2);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.fCurrentWriter.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.fCurrentWriter.close();
    }

    public synchronized void pushWriter(Writer writer) {
        this.fWriters.addFirst(writer);
        this.fCurrentWriter = writer;
    }

    public synchronized void popWriter() throws WriterStackException {
        if (this.fWriters.size() <= 1) {
            throw new WriterStackException("Cannot pop writer, no writers left on stack");
        }
        this.fWriters.removeFirst();
        this.fCurrentWriter = this.fWriters.getFirst();
    }

    public synchronized String toString() {
        return this.fCurrentWriter.toString();
    }
}

