/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.servicerequest;

import com.mathworks.toolbox.distcomp.control.ConfigRunner;
import com.mathworks.toolbox.distcomp.control.ControlJobmanager;
import com.mathworks.toolbox.distcomp.control.ControlStartStopProcess;
import com.mathworks.toolbox.distcomp.control.servicerequest.ControlServiceRequest;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceAction;

public final class JobManagerServiceRequest
extends ControlServiceRequest {
    private static final String sServiceConfigFile = "start-jobmanager.config";
    private String fLookupHosts;
    private boolean fRegisterAdminUser = true;
    private char[] fAdminPassword;
    private int fLookupPort;

    private JobManagerServiceRequest(String string, Host host, ServiceAction serviceAction, int n) {
        super(string, host, serviceAction);
        this.fLookupPort = n;
        this.useMulticast(false);
    }

    public static JobManagerServiceRequest createStartRequest(String string, Host host, int n) {
        return new JobManagerServiceRequest(string, host, ServiceAction.START, n);
    }

    public static JobManagerServiceRequest createResumeRequest(String string, Host host, int n) {
        return new JobManagerServiceRequest(string, host, ServiceAction.RESUME, n);
    }

    public static JobManagerServiceRequest createStopRequest(String string, Host host, int n) {
        return new JobManagerServiceRequest(string, host, ServiceAction.STOP, n);
    }

    public static JobManagerServiceRequest createDestroyRequest(String string, Host host, int n) {
        return new JobManagerServiceRequest(string, host, ServiceAction.DESTROY, n);
    }

    public static JobManagerServiceRequest createHardRestartRequest(String string, Host host, int n) {
        return new JobManagerServiceRequest(string, host, ServiceAction.HARD_RESTART, n);
    }

    public static JobManagerServiceRequest createSoftRestartRequest(String string, Host host, int n) {
        return new JobManagerServiceRequest(string, host, ServiceAction.SOFT_RESTART, n);
    }

    public void useMulticast(boolean bl) {
        if (this.getAction() != ServiceAction.START) {
            return;
        }
        this.fLookupHosts = bl ? "USE_MULTICAST" : "JOB_MANAGER_LOOKUP_NOT_SPECIFIED";
    }

    @Override
    public ControlStartStopProcess getControlCommand(boolean bl, ConfigRunner configRunner) {
        ControlJobmanager controlJobmanager = new ControlJobmanager(configRunner, bl, sServiceConfigFile, this.getServiceName(), this.getHost(), this.fLookupPort);
        controlJobmanager.registerAdminUser(this.fRegisterAdminUser);
        controlJobmanager.setAdminPassword(this.fAdminPassword);
        controlJobmanager.setGraphical(true);
        if (bl) {
            controlJobmanager.setLookupHosts(this.fLookupHosts);
        }
        return controlJobmanager;
    }

    public void registerAdminUser(boolean bl) {
        this.fRegisterAdminUser = bl;
    }

    public void setAdminPassword(char[] cArray) {
        this.fAdminPassword = cArray;
    }
}

