/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.io;

import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.Log;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.io.StreamSegment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class StreamSegmentOutputStream
extends OutputStream {
    private static final int DEFAULT_MAX_BYTES = 8192;
    private final String fStreamName;
    private final int fMaxBufferSize;
    private final StreamSegmentSink fSink;
    private boolean fClosed = false;
    private ByteArrayOutputStream fByteArrayOutputStream;
    private long fSequenceNumber = 0L;

    public StreamSegmentOutputStream(String string, int n, StreamSegmentSink streamSegmentSink) {
        this.fStreamName = string;
        this.fMaxBufferSize = n;
        this.fSink = streamSegmentSink;
        this.fByteArrayOutputStream = new ByteArrayOutputStream(n);
    }

    public StreamSegmentOutputStream(String string, StreamSegmentSink streamSegmentSink) {
        this(string, 8192, streamSegmentSink);
    }

    private synchronized void checkClosed() throws IOException {
        if (this.fClosed) {
            throw new IOException(this + " is closed.");
        }
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.checkClosed();
        this.fByteArrayOutputStream.write(n);
        this.flushIfNeeded();
    }

    private synchronized void flushIfNeeded() throws IOException {
        if (this.fByteArrayOutputStream.size() >= this.fMaxBufferSize) {
            this.flush();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.checkClosed();
        super.flush();
        this.flush(false);
    }

    private synchronized void flush(boolean bl) {
        Log.LOGGER.finest("flush(" + bl + ") with " + this.fByteArrayOutputStream.size());
        StreamSegment streamSegment = new StreamSegment(this.fStreamName, this.fSequenceNumber, this.fByteArrayOutputStream.toByteArray(), bl);
        this.fSink.putStreamSegment(streamSegment);
        ++this.fSequenceNumber;
        if (!bl) {
            this.fByteArrayOutputStream = new ByteArrayOutputStream(this.fMaxBufferSize);
        }
        Log.LOGGER.finest("flushed(" + bl + ") with " + this.fByteArrayOutputStream.size());
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        this.checkClosed();
        this.flush(true);
        this.fClosed = true;
        Log.LOGGER.finest("closed " + this.fStreamName);
    }

    public static interface StreamSegmentSink {
        public void putStreamSegment(StreamSegment var1);
    }
}

