/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.store;

import com.mathworks.services.Prefs;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.RememberChoice;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.auth.credentials.store.MultiUserCredentialStore;
import com.mathworks.toolbox.distcomp.auth.credentials.store.NoCredentialsException;
import com.mathworks.toolbox.distcomp.auth.credentials.store.PackageInfo;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MultiUserPersistentCredentialStore
extends MultiUserCredentialStore<AuthenticationToken> {
    private static Object sClassLock = new Object();
    private transient FileLock fLock;
    private transient RandomAccessFile fLockFile;
    private File fStoreFile;
    private Map<UserIdentity, AuthenticationToken> fStoreOnDisk;

    public MultiUserPersistentCredentialStore(String string) throws IOException {
        this(string, MultiUserPersistentCredentialStore.getOrCreateDefaultCredentialDir());
    }

    public MultiUserPersistentCredentialStore(String string, File file) throws IOException {
        File file2 = new File(file, ".lock_" + string);
        file2.deleteOnExit();
        this.fStoreFile = new File(file, string);
        this.fLockFile = new RandomAccessFile(file2, "rw");
        this.fStoreOnDisk = new HashMap<UserIdentity, AuthenticationToken>();
        this.initialiseFromFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseFromFile() {
        Object object = sClassLock;
        synchronized (object) {
            if (this.fStoreFile.exists()) {
                this.lockDown();
                this.recover();
                this.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllCredentials() {
        super.removeAllCredentials();
        this.fStoreOnDisk.clear();
        Object object = sClassLock;
        synchronized (object) {
            this.lockDown();
            this.snapshot();
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsUser(UserIdentity userIdentity) {
        Object object = sClassLock;
        synchronized (object) {
            this.lockDown();
            this.recover();
            this.releaseLock();
        }
        return super.containsUser(userIdentity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthenticationToken getCredentials(UserIdentity userIdentity) throws NoCredentialsException {
        Object object = sClassLock;
        synchronized (object) {
            this.lockDown();
            this.recover();
            this.releaseLock();
        }
        return (AuthenticationToken)super.getCredentials(userIdentity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putCredentials(AuthenticationToken authenticationToken, RememberChoice rememberChoice) {
        if (authenticationToken == null) {
            return;
        }
        Object object = sClassLock;
        synchronized (object) {
            this.lockDown();
            this.recover();
            super.putCredentials(authenticationToken, rememberChoice);
            if (rememberChoice == RememberChoice.ALWAYS) {
                this.fStoreOnDisk.put(authenticationToken.getUserIdentity(), authenticationToken);
            }
            this.snapshot();
            this.releaseLock();
        }
    }

    @Override
    public void putCredentials(AuthenticationToken authenticationToken) {
        this.putCredentials(authenticationToken, RememberChoice.ALWAYS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthenticationToken removeUser(UserIdentity userIdentity) {
        AuthenticationToken authenticationToken;
        Object object = sClassLock;
        synchronized (object) {
            this.lockDown();
            this.recover();
            authenticationToken = (AuthenticationToken)super.removeUser(userIdentity);
            this.fStoreOnDisk.remove(userIdentity);
            this.snapshot();
            this.releaseLock();
        }
        return authenticationToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<AuthenticationToken> getAllCredentials() {
        Object object = sClassLock;
        synchronized (object) {
            this.lockDown();
            this.recover();
            this.releaseLock();
        }
        return super.getAllCredentials();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CredentialStore.Memento<AuthenticationToken> createMemento() {
        Object object = sClassLock;
        synchronized (object) {
            this.lockDown();
            this.recover();
            this.releaseLock();
        }
        return new PersistentMultiUserCredentialStoreMemento(super.createMemento(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreFromMemento(CredentialStore.Memento<AuthenticationToken> memento) {
        Object object = sClassLock;
        synchronized (object) {
            this.lockDown();
            this.recover();
            if (memento instanceof PersistentMultiUserCredentialStoreMemento) {
                PersistentMultiUserCredentialStoreMemento persistentMultiUserCredentialStoreMemento = (PersistentMultiUserCredentialStoreMemento)memento;
                super.restoreFromMemento(persistentMultiUserCredentialStoreMemento.fSuperClassMemento);
                persistentMultiUserCredentialStoreMemento.restore(this);
            }
            this.snapshot();
            this.releaseLock();
        }
    }

    private static File getOrCreateDefaultCredentialDir() throws IOException {
        File file = new File(Prefs.getPropertyDirectory());
        if (!file.exists()) {
            throw new IOException("The Matlab prefs dir \"" + file + "\" does not exist.");
        }
        File file2 = new File(file.getParentFile(), "jobmanager_credentials");
        if (!file2.exists() && !file2.mkdir()) {
            throw new IOException("Could not create directory \"" + file2 + "\".");
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover() {
        BufferedReader bufferedReader = null;
        try {
            Object object;
            Object object2 = this.fStoreOnDisk.keySet().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                super.removeUser((UserIdentity)object);
            }
            this.fStoreOnDisk.clear();
            bufferedReader = new BufferedReader(new FileReader(this.fStoreFile));
            while ((object2 = bufferedReader.readLine()) != null) {
                try {
                    object = AuthenticationToken.deserializeFromString((String)object2);
                    super.putCredentials(object);
                    this.fStoreOnDisk.put(((AuthenticationToken)object).getUserIdentity(), (AuthenticationToken)object);
                }
                catch (CredentialCreationException credentialCreationException) {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Unable to parse token in line: " + (String)object2 + "\nCause: " + credentialCreationException.getCause());
                }
            }
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Unable to read authentication tokens from file: " + this.fStoreFile + "\nCause: " + iOException.getCause());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snapshot() {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(this.fStoreFile));
            for (AuthenticationToken authenticationToken : this.fStoreOnDisk.values()) {
                bufferedWriter.write(authenticationToken.serializeToString());
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Unable to write authentication tokens to file: " + this.fStoreFile + "\nCause: " + iOException.getCause());
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void lockDown() {
        if (this.fLock == null || !this.fLock.isValid()) {
            try {
                this.fLock = this.fLockFile.getChannel().lock();
            }
            catch (IOException iOException) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Unable to lock file: " + this.fLockFile + "\nCause: " + iOException.getCause());
            }
        }
    }

    private void releaseLock() {
        if (this.fLock != null && this.fLock.isValid()) {
            try {
                this.fLock.release();
            }
            catch (IOException iOException) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Unable to unlock file: " + this.fLockFile + "\nCause: " + iOException.getCause());
            }
        }
    }

    private static class PersistentMultiUserCredentialStoreMemento
    implements CredentialStore.Memento<AuthenticationToken> {
        private CredentialStore.Memento<AuthenticationToken> fSuperClassMemento;
        private HashMap<UserIdentity, AuthenticationToken> fStoreOnDiskMemento;

        public PersistentMultiUserCredentialStoreMemento(CredentialStore.Memento<AuthenticationToken> memento, MultiUserPersistentCredentialStore multiUserPersistentCredentialStore) {
            this.fSuperClassMemento = memento;
            this.fStoreOnDiskMemento = new HashMap();
            this.fStoreOnDiskMemento.putAll(multiUserPersistentCredentialStore.fStoreOnDisk);
        }

        public void restore(MultiUserPersistentCredentialStore multiUserPersistentCredentialStore) {
            multiUserPersistentCredentialStore.fStoreOnDisk.clear();
            multiUserPersistentCredentialStore.fStoreOnDisk.putAll(this.fStoreOnDiskMemento);
        }
    }
}

