/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials;

import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.EncryptedObject;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.EncryptedPlainCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.NontransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;

public class PlainCredentials
implements NontransferableCredentials {
    private UserIdentity fUserIdentity;
    private Erasable fPlainPassword;

    public PlainCredentials(UserIdentity userIdentity, Erasable erasable) {
        this.fUserIdentity = userIdentity;
        this.fPlainPassword = erasable;
    }

    protected PlainCredentials(PlainCredentials plainCredentials) {
        this(plainCredentials.fUserIdentity, plainCredentials.fPlainPassword);
    }

    @Override
    public UserIdentity getUserIdentity() {
        return this.fUserIdentity;
    }

    public Erasable getPassword() {
        return this.fPlainPassword.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationToken createAuthenticationToken(CryptoModule.Hasher hasher) {
        Erasable erasable = this.getPassword();
        try {
            Erasable erasable2 = hasher.createHash(erasable);
            AuthenticationToken authenticationToken = new AuthenticationToken(this.fUserIdentity, erasable2);
            return authenticationToken;
        }
        finally {
            erasable.erase();
        }
    }

    @Override
    public void erase() {
        this.fPlainPassword.erase();
    }

    @Override
    public EncryptedPlainCredentials prepare(boolean bl, byte[] byArray, CryptoModule.Encryptor encryptor) throws CredentialCreationException {
        if (!bl) {
            return new EncryptedPlainCredentials(this.fUserIdentity, this.fPlainPassword);
        }
        try {
            EncryptedObject encryptedObject = encryptor.encryptWithSalt(this.fPlainPassword, byArray);
            return new EncryptedPlainCredentials(this.fUserIdentity, encryptedObject, byArray);
        }
        catch (CryptoException cryptoException) {
            throw new CredentialCreationException("Could not encrypt credentials", this.fUserIdentity, cryptoException);
        }
    }
}

