/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra.internal;

import com.mathworks.toolbox.distcomp.admincenter.testing.infra.internal.CommandSet;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.internal.CustomCommand;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.internal.CustomCommandSet;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.internal.SystemCommandSet;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.ParsingException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public class FileParser {
    private HashMap<String, Vector<CustomCommand>> fCommandMap = new HashMap();

    public FileParser(String string) {
        if (string != null) {
            this.parseFile(string);
        }
    }

    public CommandSet createCommandSet(String string) {
        Serializable serializable;
        if (this.fCommandMap.containsKey(string)) {
            serializable = new CustomCommandSet(this.fCommandMap.get(string));
            System.out.println(string + " " + serializable);
        } else {
            serializable = new SystemCommandSet();
        }
        return serializable;
    }

    private void parseFile(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                try {
                    ++n;
                    this.parseLine(string2);
                }
                catch (ParsingException parsingException) {
                    System.out.println("Parse error in file " + string + " line " + n + ": " + parsingException.toString());
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Cannot read from file " + string);
        }
    }

    private void parseLine(String string) throws ParsingException {
        if (string.trim().length() == 0 || string.trim().indexOf("//") == 0) {
            return;
        }
        int n = string.indexOf(58);
        int n2 = string.indexOf(40, n);
        int n3 = string.indexOf(41, n2);
        int n4 = string.indexOf("->", n3);
        if (n < 0 || n2 < n || n3 < n2 || n4 < n3) {
            throw new ParsingException("Malformed line: " + string);
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1, n2).trim();
        String[] stringArray = string.substring(n2 + 1, n3).split(",");
        String string4 = string.substring(n4 + 2).trim();
        CustomCommand customCommand = new CustomCommand(string3, string4);
        for (String string5 : stringArray) {
            if (string5.trim().length() <= 0) continue;
            String[] stringArray2 = string5.split("=", 2);
            if (stringArray2.length < 2) {
                throw new ParsingException("malformed argument " + string5);
            }
            customCommand.set(stringArray2[0].trim(), stringArray2[1].trim());
        }
        if (!this.fCommandMap.containsKey(string2)) {
            this.fCommandMap.put(string2, new Vector());
        }
        for (CustomCommand customCommand2 : this.fCommandMap.get(string2)) {
            if (!customCommand2.containsArguments(customCommand)) continue;
            throw new ParsingException("duplicate custom command");
        }
        this.fCommandMap.get(string2).add(customCommand);
    }
}

